/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.policyset.admin.commands.util;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.authorizer.AdminAuthorizer;
import com.ibm.websphere.management.authorizer.AdminAuthorizerFactory;
import com.ibm.websphere.management.cmdframework.CommandValidationException;
import com.ibm.ws.policyset.admin.PolicyConstants;
import com.ibm.ws.policyset.admin.commands.util.CommonUtil;
import com.ibm.ws.policyset.admin.commands.util.CommonWorkSpaceHelper;
import com.ibm.ws.policyset.admin.commands.util.PolicyControlCommandUtil;
import com.ibm.ws.policyset.admin.exceptions.NoItemFoundException;
import com.ibm.ws.sm.workspace.RepositoryContext;
import com.ibm.ws.sm.workspace.WorkSpace;
import com.ibm.ws.sm.workspace.WorkSpaceException;
import com.ibm.ws.sm.workspace.WorkSpaceManagerFactory;
import com.ibm.ws.sm.workspace.metadata.RepositoryContextType;
import com.ibm.ws.sm.workspace.metadata.RepositoryMetaData;
import java.io.File;
import java.security.AccessControlException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.ResourceBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PolicyControlWorkSpaceHelper {
    private static TraceComponent tc = Tr.register(PolicyControlWorkSpaceHelper.class, "policyset.admin", "com.ibm.ws.policyset.admin.resources.policySetAdmin");
    private static ResourceBundle resourceBundle = ResourceBundle.getBundle("com.ibm.ws.policyset.admin.resources.policySetAdmin", CommonUtil.getLocale());
    public static final String APP_REPOSITORY_TYPE = "deployments";
    private static AdminAuthorizer myAdminAuthorizer = null;

    public static RepositoryContext getAppRepositoryContext(Session session, String appName) throws WorkSpaceException, CommandValidationException {
        WorkSpace workspace;
        Collection col;
        Iterator contextIt;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getAppRepositoryContext session=" + session.getUserName() + ", appName=" + appName);
        }
        if ((contextIt = (col = (workspace = WorkSpaceManagerFactory.getManager().getWorkSpace(session.getUserName())).getRootContext().findContext(APP_REPOSITORY_TYPE, appName)).iterator()).hasNext()) {
            PolicyControlWorkSpaceHelper.validateMonitorAuthorization((RepositoryContext)col.iterator().next());
            return (RepositoryContext)contextIt.next();
        }
        throw new CommandValidationException(PolicyControlCommandUtil.getFormattedMessage(resourceBundle, "CWPST0062E", new Object[]{appName}, "The {0} application is not found."));
    }

    public static String getWSPolicyServiceControlFile(Session session, String appName) throws WorkSpaceException, CommandValidationException {
        String methodName = "getWSPolicyServiceControlFile";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getWSPolicyServiceControlFile", new Object[]{session, appName});
        }
        RepositoryContext appRepContext = PolicyControlWorkSpaceHelper.getAppRepositoryContext(session, appName);
        String expectedFileName = PolicyConstants.POLICY_CONTROL_DIR + File.separator + "wsPolicyServiceControl.xml";
        String fullPath = PolicyControlWorkSpaceHelper.getControlFile(appRepContext, expectedFileName);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getWSPolicyServiceControlFile", fullPath);
        }
        return fullPath;
    }

    public static String createWSPolicyServiceControlFile(Session session, String appName) throws WorkSpaceException, CommandValidationException {
        String methodName = "createWSPolicyServiceControlFile";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createWSPolicyServiceControlFile", new Object[]{session, appName});
        }
        RepositoryContext appRepContext = PolicyControlWorkSpaceHelper.getAppRepositoryContext(session, appName);
        String expectedFileName = PolicyConstants.POLICY_CONTROL_DIR + File.separator + "wsPolicyServiceControl.xml";
        String fullPath = PolicyControlWorkSpaceHelper.createControlFile(appRepContext, expectedFileName, PolicyConstants.SERVICE_CONTROL, appName);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createWSPolicyServiceControlFile", fullPath);
        }
        return fullPath;
    }

    public static boolean updateWSPolicyServiceControlFile(Session session, String appName) throws WorkSpaceException, CommandValidationException {
        String methodName = "updateWSPolicyServiceControlFile";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "updateWSPolicyServiceControlFile", new Object[]{session, appName});
        }
        RepositoryContext appRepContext = PolicyControlWorkSpaceHelper.getAppRepositoryContext(session, appName);
        String expectedFileName = PolicyConstants.POLICY_CONTROL_DIR + File.separator + "wsPolicyServiceControl.xml";
        expectedFileName = expectedFileName.replace(File.separatorChar, '/');
        boolean update = PolicyControlWorkSpaceHelper.updateControlFile(appRepContext, expectedFileName, PolicyConstants.SERVICE_CONTROL, appName);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "updateWSPolicyServiceControlFile", update);
        }
        return update;
    }

    public static boolean deleteWSPolicyServiceControlFile(Session session, String appName) throws WorkSpaceException, CommandValidationException {
        String methodName = "deleteWSPolicyServiceControlFile";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "deleteWSPolicyServiceControlFile", new Object[]{session, appName});
        }
        RepositoryContext appRepContext = PolicyControlWorkSpaceHelper.getAppRepositoryContext(session, appName);
        String expectedFileName = PolicyConstants.POLICY_CONTROL_DIR + File.separator + "wsPolicyServiceControl.xml";
        expectedFileName = expectedFileName.replace(File.separatorChar, '/');
        boolean delete = PolicyControlWorkSpaceHelper.deleteControlFile(appRepContext, expectedFileName, PolicyConstants.SERVICE_CONTROL, appName);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "deleteWSPolicyServiceControlFile", delete);
        }
        return delete;
    }

    public static String getWSPolicyClientControlFile(Session session, String appName) throws WorkSpaceException, CommandValidationException {
        String methodName = "getWSPolicyClientControlFile";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getWSPolicyClientControlFile", new Object[]{session, appName});
        }
        RepositoryContext appRepContext = PolicyControlWorkSpaceHelper.getAppRepositoryContext(session, appName);
        String expectedFileName = PolicyConstants.POLICY_CONTROL_DIR + File.separator + "wsPolicyClientControl.xml";
        String fullPath = PolicyControlWorkSpaceHelper.getControlFile(appRepContext, expectedFileName);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getWSPolicyClientControlFile", fullPath);
        }
        return fullPath;
    }

    public static String createWSPolicyClientControlFile(Session session, String appName) throws WorkSpaceException, CommandValidationException {
        String methodName = "createWSPolicyClientControlFile";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createWSPolicyClientControlFile", new Object[]{session, appName});
        }
        RepositoryContext appRepContext = PolicyControlWorkSpaceHelper.getAppRepositoryContext(session, appName);
        String expectedFileName = PolicyConstants.POLICY_CONTROL_DIR + File.separator + "wsPolicyClientControl.xml";
        String fullPath = PolicyControlWorkSpaceHelper.createControlFile(appRepContext, expectedFileName, PolicyConstants.CLIENT_CONTROL, appName);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createWSPolicyClientControlFile", fullPath);
        }
        return fullPath;
    }

    public static boolean updateWSPolicyClientControlFile(Session session, String appName) throws WorkSpaceException, CommandValidationException {
        String methodName = "updateWSPolicyClientControlFile";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "updateWSPolicyClientControlFile", new Object[]{session, appName});
        }
        RepositoryContext appRepContext = PolicyControlWorkSpaceHelper.getAppRepositoryContext(session, appName);
        String expectedFileName = PolicyConstants.POLICY_CONTROL_DIR + File.separator + "wsPolicyClientControl.xml";
        expectedFileName = expectedFileName.replace(File.separatorChar, '/');
        boolean update = PolicyControlWorkSpaceHelper.updateControlFile(appRepContext, expectedFileName, PolicyConstants.CLIENT_CONTROL, appName);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "updateWSPolicyClientControlFile", update);
        }
        return update;
    }

    public static boolean deleteWSPolicyClientControlFile(Session session, String appName) throws WorkSpaceException, CommandValidationException {
        String methodName = "deleteWSPolicyClientControlFile";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "deleteWSPolicyClientControlFile", new Object[]{session, appName});
        }
        RepositoryContext appRepContext = PolicyControlWorkSpaceHelper.getAppRepositoryContext(session, appName);
        String expectedFileName = PolicyConstants.POLICY_CONTROL_DIR + File.separator + "wsPolicyClientControl.xml";
        expectedFileName = expectedFileName.replace(File.separatorChar, '/');
        boolean delete = PolicyControlWorkSpaceHelper.deleteControlFile(appRepContext, expectedFileName, PolicyConstants.CLIENT_CONTROL, appName);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "deleteWSPolicyClientControlFile", delete);
        }
        return delete;
    }

    public static List<String> listWSPolicyControlFiles(Session session, String controlType) throws WorkSpaceException, NoItemFoundException {
        Properties p = new Properties();
        p.setProperty("application", "*");
        return PolicyControlWorkSpaceHelper.listWSPolicyControlFiles(session, controlType, p);
    }

    public static List<String> listWSPolicyControlFiles(Session session, String controlType, Properties searchPattern) throws WorkSpaceException, NoItemFoundException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "listWSPolicyControlFiles, controlType=" + controlType + ", searchPattern=" + searchPattern);
        }
        ArrayList<String> retList = new ArrayList<String>();
        if (controlType.equals(PolicyConstants.SERVICE_CONTROL) || controlType.equals(PolicyConstants.CLIENT_CONTROL)) {
            WorkSpace workspace = WorkSpaceManagerFactory.getManager().getWorkSpace(session.getUserName());
            RepositoryMetaData metaData = workspace.getMetaData();
            RepositoryContextType contextType = metaData.getContextType(APP_REPOSITORY_TYPE);
            Collection col = workspace.findContext(contextType);
            Iterator contextIt = col.iterator();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "listWSPolicyControlFiles: find app repcontexts: " + col.size());
            }
            String fileName = null;
            String appSearchPattern = searchPattern.getProperty("application");
            while (contextIt.hasNext()) {
                fileName = PolicyControlWorkSpaceHelper.getControlFileInApp((RepositoryContext)contextIt.next(), controlType, appSearchPattern);
                if (fileName == null) continue;
                retList.add(fileName);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "listWSPolicyControlFiles, retList=" + retList + ", retList.size()=" + retList.size());
        }
        return retList;
    }

    private static String getControlFile(RepositoryContext repContext, String expectedFileName) throws WorkSpaceException {
        String methodName = "getControlFile";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getControlFile", new Object[]{repContext, expectedFileName});
        }
        String fileName = null;
        if (repContext.isAvailable(expectedFileName)) {
            if (!repContext.isExtracted(expectedFileName)) {
                repContext.extract(expectedFileName, false);
            }
            fileName = PolicyControlWorkSpaceHelper.getFullPath(repContext, expectedFileName);
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Returning null, cannot find file: " + expectedFileName);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getControlFile", fileName);
        }
        return fileName;
    }

    private static String createControlFile(RepositoryContext repContext, String expectedFileName, String controlType, String appName) throws WorkSpaceException, CommandValidationException {
        String methodName = "createControlFile";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createControlFile", new Object[]{repContext, expectedFileName, controlType, appName});
        }
        String fileName = null;
        if (repContext.isAvailable(expectedFileName)) {
            String controlFile = "wsPolicyServiceControl.xml";
            if (controlType.equals(PolicyConstants.CLIENT_CONTROL)) {
                controlFile = "wsPolicyClientControl.xml";
            }
            throw new CommandValidationException(PolicyControlCommandUtil.getFormattedMessage(resourceBundle, "CWPST0138E", new Object[]{controlFile, appName}, "A duplicate {0} file was found in application: {1}"));
        }
        repContext.getOutputStream(expectedFileName);
        repContext.notifyChanged(0, expectedFileName);
        fileName = PolicyControlWorkSpaceHelper.getFullPath(repContext, expectedFileName);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createControlFile", fileName);
        }
        return fileName;
    }

    private static boolean updateControlFile(RepositoryContext repContext, String expectedFileName, String controlType, String appName) throws WorkSpaceException, CommandValidationException {
        String methodName = "updateControlFile";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "updateControlFile", new Object[]{repContext, expectedFileName, controlType, appName});
        }
        boolean update = false;
        if (!repContext.isAvailable(expectedFileName = expectedFileName.replace(File.separatorChar, '/'))) {
            String controlFile = "wsPolicyServiceControl.xml";
            if (controlType.equals(PolicyConstants.CLIENT_CONTROL)) {
                controlFile = "wsPolicyClientControl.xml";
            }
            throw new CommandValidationException(PolicyControlCommandUtil.getFormattedMessage(resourceBundle, "CWPST0137E", new Object[]{controlFile, appName}, "The {0} control file could not be found for application: {1}"));
        }
        repContext.notifyChanged(1, expectedFileName);
        update = true;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "updateControlFile", update);
        }
        return update;
    }

    private static boolean deleteControlFile(RepositoryContext repContext, String expectedFileName, String controlType, String appName) throws WorkSpaceException, CommandValidationException {
        String methodName = "deleteControlFile";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "deleteControlFile", new Object[]{repContext, expectedFileName, controlType, appName});
        }
        boolean delete = false;
        if (repContext.isAvailable(expectedFileName = expectedFileName.replace(File.separatorChar, '/'))) {
            if (!repContext.isExtracted(expectedFileName)) {
                repContext.extract(expectedFileName, false);
            }
        } else {
            String controlFile = "wsPolicyServiceControl.xml";
            if (controlType.equals(PolicyConstants.CLIENT_CONTROL)) {
                controlFile = "wsPolicyClientControl.xml";
            }
            throw new CommandValidationException(PolicyControlCommandUtil.getFormattedMessage(resourceBundle, "CWPST0137E", new Object[]{controlFile, appName}, "The {0} control file could not be found for application: {1}"));
        }
        repContext.notifyChanged(2, expectedFileName);
        delete = true;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "deleteControlFile", delete);
        }
        return delete;
    }

    private static String getControlFileInApp(RepositoryContext appRepContext, String controlType, String appSearchPattern) throws WorkSpaceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getControlFileInApp, controlType=" + controlType + ", appSearchPattern=" + appSearchPattern);
        }
        CommonWorkSpaceHelper.validateMonitorAuthorization(appRepContext);
        String path = appRepContext.getPath();
        int index = path.lastIndexOf(File.separatorChar);
        String appName = path.substring(index + 1);
        boolean matched = PolicyControlWorkSpaceHelper.matchAppName(appName, appSearchPattern);
        boolean trDebug = tc.isDebugEnabled();
        if (trDebug) {
            Tr.debug(tc, "getControlFileInApp, appSearchPattern=" + appSearchPattern + ", appName=" + appName + ", match=" + matched);
        }
        if (!matched) {
            return null;
        }
        String expectedFileName = null;
        expectedFileName = controlType.equals(PolicyConstants.SERVICE_CONTROL) ? PolicyConstants.POLICY_CONTROL_DIR + File.separator + "wsPolicyServiceControl.xml" : PolicyConstants.POLICY_CONTROL_DIR + File.separator + "wsPolicyClientControl.xml";
        if (appRepContext.isAvailable(expectedFileName = expectedFileName.replace(File.separatorChar, '/'))) {
            if (!appRepContext.isExtracted(expectedFileName)) {
                appRepContext.extract(expectedFileName, false);
            }
            String fullPath = PolicyControlWorkSpaceHelper.getFullPath(appRepContext, expectedFileName);
            fullPath = fullPath.replace('/', File.separatorChar);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getControlFileInApp, fullPath=" + fullPath);
            }
            return fullPath;
        }
        return null;
    }

    private static boolean matchAppName(String appName, String appSearchPattern) {
        if (appSearchPattern == null || appSearchPattern.equals("*")) {
            return true;
        }
        if (appSearchPattern.endsWith("*")) {
            String prefix = appSearchPattern.substring(0, appSearchPattern.length() - 1);
            return appName.startsWith(prefix);
        }
        return appName.equals(appSearchPattern);
    }

    private static String getFullPath(RepositoryContext repContext, String fileURI) {
        StringBuffer buf = new StringBuffer(repContext.getPath());
        buf.append(File.separator).append(fileURI);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getFullPath, buf.toString()=" + buf.toString());
        }
        return buf.toString();
    }

    public static void validateMonitorAuthorization(RepositoryContext context) {
        String methodName = "validateMonitorAuthorization";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validateMonitorAuthorization", context);
        }
        PolicyControlWorkSpaceHelper.validateAuthorization(context.toString(), "monitor");
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validateMonitorAuthorization");
        }
    }

    public static void validateConfiguratorAuthorization(RepositoryContext context) {
        String methodName = "validateConfiguratorAuthorization";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validateConfiguratorAuthorization", context);
        }
        PolicyControlWorkSpaceHelper.validateAuthorization(context.toString(), "configurator");
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validateConfiguratorAuthorization");
        }
    }

    private static void validateAuthorization(String resource, String role) {
        String methodName = "validateAuthorization";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validateAuthorization", new Object[]{resource, role});
        }
        if (PolicyControlWorkSpaceHelper.getAdminAuthorizer() != null && !PolicyControlWorkSpaceHelper.getAdminAuthorizer().checkAccess(resource, role)) {
            throw new AccessControlException(PolicyControlCommandUtil.getFormattedMessage(resourceBundle, "CWPST0120E", new Object[]{resource, role}, "Access denied for resource {0}, {1} authority required."));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validateAuthorization");
        }
    }

    private static AdminAuthorizer getAdminAuthorizer() {
        String methodName = "getAdminAuthorizer";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getAdminAuthorizer");
        }
        if (myAdminAuthorizer != null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getAdminAuthorizer", myAdminAuthorizer);
            }
            return myAdminAuthorizer;
        }
        myAdminAuthorizer = AdminAuthorizerFactory.getAdminAuthorizer();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getAdminAuthorizer", myAdminAuthorizer);
        }
        return myAdminAuthorizer;
    }
}

