/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.policyset.admin.commands.util;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.AdminService;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.authorizer.AdminAuthorizer;
import com.ibm.websphere.management.authorizer.AdminAuthorizerFactory;
import com.ibm.ws.policyset.admin.PolicyConstants;
import com.ibm.ws.policyset.admin.commands.util.CommonUtil;
import com.ibm.ws.policyset.admin.exceptions.NoItemFoundException;
import com.ibm.ws.sm.workspace.RepositoryContext;
import com.ibm.ws.sm.workspace.WorkSpace;
import com.ibm.ws.sm.workspace.WorkSpaceException;
import com.ibm.ws.sm.workspace.WorkSpaceManagerFactory;
import com.ibm.ws.sm.workspace.metadata.RepositoryContextType;
import com.ibm.ws.sm.workspace.metadata.RepositoryMetaData;
import com.ibm.ws.sm.workspace.metadata.RepositoryMetaDataFactory;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.security.AccessControlException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.ResourceBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommonWorkSpaceHelper
implements PolicyConstants {
    private static TraceComponent tc = Tr.register(CommonWorkSpaceHelper.class, "policyset.admin", "com.ibm.ws.policyset.admin.resources.policySetAdmin");
    private static ResourceBundle resourceBundle = ResourceBundle.getBundle("com.ibm.ws.policyset.admin.resources.policySetAdmin", CommonUtil.getLocale());
    public static final String APP_REPOSITORY_TYPE = "deployments";
    public static final String CELL_REPOSITORY_TYPE = "cells";
    public static final String NODE_REPOSITORY_TYPE = "nodes";
    public static final String SERVER_REPOSITORY_TYPE = "servers";
    private static final String BUSES_REPOSITORY_TYPE = "buses";
    private static final String TEMPLATES_REPOSITORY_TYPE = "templates";
    private static AdminAuthorizer myAdminAuthorizer = null;
    private static String myCellName = null;

    public static String getCellRepositoryPath(Session session) throws WorkSpaceException, NoItemFoundException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getCellRepositoryPath");
        }
        RepositoryContext repContext = CommonWorkSpaceHelper.getCellRepositoryContext(session);
        String filePath = repContext.getPath();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getCellRepositoryPath, filePath=" + filePath);
        }
        return filePath;
    }

    public static RepositoryContext getCellRepositoryContext(Session session) throws WorkSpaceException, NoItemFoundException {
        RepositoryMetaData metaData;
        RepositoryContextType contextType;
        WorkSpace workspace;
        Collection col;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getCellRepositoryContext, session user=" + session.getUserName() + ", id=" + session.getSessionId());
        }
        if ((col = (workspace = WorkSpaceManagerFactory.getManager().getWorkSpace(session.getUserName())).findContext(contextType = (metaData = workspace.getMetaData()).getContextType(CELL_REPOSITORY_TYPE))).size() == 0) {
            Tr.error(tc, "CWPST0008E");
            throw new NoItemFoundException(CommonUtil.getFormattedMessage(resourceBundle, "CWPST0008E", new Object[0], "Cannot find cell repository context"));
        }
        if (col.size() > 1) {
            Tr.error(tc, "CWPST0009E");
            if (tc.isDebugEnabled()) {
                Iterator it = col.iterator();
                while (it.hasNext()) {
                    Tr.debug(tc, "getCellRepositoryContext, find cell context " + ((RepositoryContext)it.next()).getPath());
                }
            }
            CommonWorkSpaceHelper.validateMonitorAuthorization((RepositoryContext)col.iterator().next());
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getCellRepositoryContext, find multiple cell repository context");
            }
            return (RepositoryContext)col.iterator().next();
        }
        CommonWorkSpaceHelper.validateMonitorAuthorization((RepositoryContext)col.iterator().next());
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getCellRepositoryContext, find cell repository context");
        }
        return (RepositoryContext)col.iterator().next();
    }

    public static RepositoryContext getTemplatesRepositoryContext(Session session) throws WorkSpaceException, NoItemFoundException {
        String methodName = "getTemplatesRepositoryContext";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getTemplatesRepositoryContext", "session user=" + session.getUserName() + ", id=" + session.getSessionId());
        }
        WorkSpace workspace = WorkSpaceManagerFactory.getManager().getWorkSpace(session.getUserName());
        RepositoryMetaData metaData = workspace.getMetaData();
        RepositoryContextType contextType = metaData.getContextType(TEMPLATES_REPOSITORY_TYPE);
        Collection col = workspace.findContext(contextType);
        for (RepositoryContext templatesContext : col) {
            if (!templatesContext.toString().endsWith(TEMPLATES_REPOSITORY_TYPE)) continue;
            CommonWorkSpaceHelper.validateMonitorAuthorization(templatesContext);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getTemplatesRepositoryContext", templatesContext);
            }
            return templatesContext;
        }
        throw new NoItemFoundException(CommonUtil.getFormattedMessage(resourceBundle, "CWPST0123E", new Object[0], "The templates repository context was not found."));
    }

    public static RepositoryContext getAppRepositoryContext(Session session, String appName) throws WorkSpaceException, NoItemFoundException {
        WorkSpace workspace;
        Collection col;
        Iterator contextIt;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getAppRepositoryContext session=" + session.getUserName() + ", appName=" + appName);
        }
        if ((contextIt = (col = (workspace = WorkSpaceManagerFactory.getManager().getWorkSpace(session.getUserName())).getRootContext().findContext(APP_REPOSITORY_TYPE, appName)).iterator()).hasNext()) {
            CommonWorkSpaceHelper.validateMonitorAuthorization((RepositoryContext)col.iterator().next());
            return (RepositoryContext)contextIt.next();
        }
        throw new NoItemFoundException(CommonUtil.getFormattedMessage(resourceBundle, "CWPST0062E", new Object[]{appName}, "Application is not found: {0}"));
    }

    public static RepositoryContext getServerRepositoryContext(Session session, String nodeName, String serverName) throws WorkSpaceException, NoItemFoundException {
        RepositoryContext cellContext;
        Collection nodeCol;
        Iterator nodeIt;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getServerRepositoryContext session=" + session.getUserName() + ", node=" + nodeName + ", server=" + serverName);
        }
        if ((nodeIt = (nodeCol = (cellContext = CommonWorkSpaceHelper.getCellRepositoryContext(session)).findContext(NODE_REPOSITORY_TYPE, nodeName)).iterator()).hasNext()) {
            RepositoryContext nodeContext;
            Collection serverCol;
            Iterator serverIt;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "getServerRepositoryContext find node context for " + nodeName);
            }
            if ((serverIt = (serverCol = (nodeContext = (RepositoryContext)nodeIt.next()).findContext(SERVER_REPOSITORY_TYPE, serverName)).iterator()).hasNext()) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "getServerRepositoryContext find server context for " + serverName);
                }
                return (RepositoryContext)serverIt.next();
            }
            throw new NoItemFoundException(CommonUtil.getFormattedMessage(resourceBundle, "CWPST0096E", new Object[]{serverName}, "Server is not found: {0}"));
        }
        throw new NoItemFoundException(CommonUtil.getFormattedMessage(resourceBundle, "CWPST0095E", new Object[]{nodeName}, "Node is not found: {0}"));
    }

    public static RepositoryContext getBusesRepositoryContext(Session session, String busName) throws WorkSpaceException, NoItemFoundException {
        RepositoryContext cellRepContext;
        Collection busCol;
        Iterator i$;
        String methodName = "getBusesRepositoryContext";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getBusesRepositoryContext", new Object[]{session, busName});
        }
        if ((i$ = (busCol = (cellRepContext = CommonWorkSpaceHelper.getCellRepositoryContext(session)).findContext(BUSES_REPOSITORY_TYPE, busName)).iterator()).hasNext()) {
            RepositoryContext busContext = (RepositoryContext)i$.next();
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getBusesRepositoryContext", busContext);
            }
            return busContext;
        }
        throw new NoItemFoundException(CommonUtil.getFormattedMessage(resourceBundle, "CWPST0118E", new Object[]{busName}, "The {0} bus is not found."));
    }

    public static boolean copyFile(String srcFile, String dstFile) throws IOException {
        int c;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "copyFile, srcFile=" + srcFile + ", dstFile=" + dstFile);
        }
        FileReader in = new FileReader(srcFile);
        FileWriter out = new FileWriter(dstFile);
        while ((c = in.read()) != -1) {
            out.write(c);
        }
        in.close();
        out.close();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "copyFile");
        }
        return true;
    }

    public static void writeFile(String outfilename) throws IOException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "writeFile, outfilename=" + outfilename);
        }
        BufferedWriter out = new BufferedWriter(new FileWriter(outfilename));
        out.write("provider");
        out.close();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "writeFile");
        }
    }

    public static String getPolicySetFileName(String policySet) {
        StringBuffer buf = new StringBuffer();
        buf.append("PolicySets").append(File.separator).append(policySet).append(File.separator).append("policySet.xml");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getPolicySetFileName, buf.toString()=" + buf.toString());
        }
        return buf.toString();
    }

    public static String getPolicySetFilePrefix(String policySet, boolean toLowerCase) {
        StringBuffer buf = new StringBuffer();
        buf.append("PolicySets").append(File.separator).append(policySet).append(File.separator);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getPolicySetFilePrefix, prefix=" + buf.toString() + ", toLowerCase=" + toLowerCase);
        }
        if (toLowerCase) {
            return buf.toString().toLowerCase();
        }
        return buf.toString();
    }

    public static String getFullPath(RepositoryContext repContext, String fileURI) {
        StringBuffer buf = new StringBuffer(repContext.getPath());
        buf.append(File.separator).append(fileURI);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getFullPath, buf.toString()=" + buf.toString());
        }
        return buf.toString();
    }

    public static String getLastDirName(String filePath) {
        int index = filePath.lastIndexOf(File.separatorChar);
        String str1 = filePath.substring(0, index);
        index = str1.lastIndexOf(File.separatorChar);
        String dirName = str1.substring(index + 1);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getLastDirName, filePath=" + filePath + ", str1=" + str1 + ", dirName=" + dirName);
        }
        return dirName;
    }

    public static void validateMonitorAuthorization(RepositoryContext context) {
        String methodName = "validateMonitorAuthorization";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validateMonitorAuthorization", context);
        }
        CommonWorkSpaceHelper.validateAuthorization(context.toString(), "monitor");
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validateMonitorAuthorization");
        }
    }

    public static void validateCellLevelAdminAuthorization() throws NoItemFoundException {
        String methodName = "validateCellLevelAdminAuthorization";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validateCellLevelAdminAuthorization");
        }
        String resource = "cells/" + CommonWorkSpaceHelper.getCellName() + "/";
        CommonWorkSpaceHelper.validateAuthorization(resource, "administrator");
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validateCellLevelAdminAuthorization");
        }
    }

    public static void validateAttachmentAuthorization(String attachmentType, String resourceName) throws NoItemFoundException {
        String methodName = "validateAttachmentAuthorization";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validateAttachmentAuthorization", new Object[]{attachmentType, resourceName});
        }
        String resource = "cells/" + CommonWorkSpaceHelper.getCellName() + "/";
        resource = attachmentType.equals("WSNClient") ? resource + BUSES_REPOSITORY_TYPE + "/" + resourceName : (attachmentType.equals("system/trust") ? resource + "sts/policy" : resource + APP_REPOSITORY_TYPE + "/" + resourceName);
        CommonWorkSpaceHelper.validateAuthorization(resource, "configurator");
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validateAttachmentAuthorization");
        }
    }

    public static void validateBindingAuthorization(boolean writeAccess, int bindingLevel, String attachmentType, Properties bindingLocation) throws NoItemFoundException {
        String methodName = "validateBindingAuthorization";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validateBindingAuthorization", new Object[]{writeAccess, bindingLevel, attachmentType, bindingLocation});
        }
        String resource = "cells/" + CommonWorkSpaceHelper.getCellName() + "/";
        if (bindingLevel != 1) {
            if (bindingLevel == 2) {
                String nodeName = bindingLocation.getProperty("node");
                String serverName = bindingLocation.getProperty("server");
                resource = "nodes/" + nodeName + "/" + SERVER_REPOSITORY_TYPE + "/" + serverName;
            } else {
                resource = attachmentType.equals("WSNClient") ? resource + BUSES_REPOSITORY_TYPE + "/" + bindingLocation.getProperty("bus") : (attachmentType.equals("system/trust") ? resource + "sts/policy" : resource + APP_REPOSITORY_TYPE + "/" + bindingLocation.getProperty("application"));
            }
        }
        if (writeAccess) {
            CommonWorkSpaceHelper.validateAuthorization(resource, "administrator");
        } else {
            CommonWorkSpaceHelper.validateAuthorization(resource, "configurator");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validateBindingAuthorization");
        }
    }

    protected static List<String> listApplications(Session session) throws WorkSpaceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "CommonWorkSpaceHelper.listApplications");
        }
        WorkSpace workspace = WorkSpaceManagerFactory.getManager().getWorkSpace(session.getUserName());
        RepositoryMetaData metaData = workspace.getMetaData();
        RepositoryContextType contextType = metaData.getContextType(APP_REPOSITORY_TYPE);
        Iterator contextIt = workspace.findContext(contextType).iterator();
        RepositoryContext repContext = null;
        ArrayList<String> retList = new ArrayList<String>();
        boolean trDebug = tc.isDebugEnabled();
        while (contextIt.hasNext()) {
            repContext = (RepositoryContext)contextIt.next();
            retList.add(repContext.getName());
            if (!trDebug) continue;
            Tr.debug(tc, "CommonWorkSpaceHelper.listApplications: appName=" + repContext.getName());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "CommonWorkSpaceHelper.listApplications, retList size=" + retList.size());
        }
        return retList;
    }

    protected static List<Properties> listWSNServices(Session session) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "CommonWorkSpaceHelper.listWSNServices");
        }
        RepositoryContext cellRepContext = CommonWorkSpaceHelper.getCellRepositoryContext(session);
        RepositoryContextType busesRepContextType = RepositoryMetaDataFactory.getRepositoryMetaData().getContextType(BUSES_REPOSITORY_TYPE);
        List busesRepositoryContexts = cellRepContext.getChildren(busesRepContextType);
        ArrayList<Properties> retList = new ArrayList<Properties>();
        Properties wsnProps = null;
        for (RepositoryContext busRepContext : busesRepositoryContexts) {
            RepositoryContextType wsnRepContextType = RepositoryMetaDataFactory.getRepositoryMetaData().getContextType("wsn");
            List wsnRepositoryContexts = busRepContext.getChildren(wsnRepContextType);
            for (RepositoryContext wsnRepContext : wsnRepositoryContexts) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "busContext " + busRepContext.getName() + ", wsnRepContext: " + wsnRepContext.getName());
                }
                wsnProps = new Properties();
                wsnProps.setProperty("bus", busRepContext.getName());
                wsnProps.setProperty("WSNService", wsnRepContext.getName());
                retList.add(wsnProps);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "CommonWorkSpaceHelper.listWSNServices, retList size=" + retList.size());
        }
        return retList;
    }

    private static void validateAuthorization(String resource, String role) {
        String methodName = "validateAuthorization";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validateAuthorization", new Object[]{resource, role});
        }
        if (CommonWorkSpaceHelper.getAdminAuthorizer() != null && !CommonWorkSpaceHelper.getAdminAuthorizer().checkAccess(resource, role)) {
            throw new AccessControlException(CommonUtil.getFormattedMessage(resourceBundle, "CWPST0120E", new Object[]{resource, role}, "Access denied for resource {0}, {1} authority required."));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validateAuthorization");
        }
    }

    private static AdminAuthorizer getAdminAuthorizer() {
        String methodName = "getAdminAuthorizer";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getAdminAuthorizer");
        }
        if (myAdminAuthorizer != null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getAdminAuthorizer", myAdminAuthorizer);
            }
            return myAdminAuthorizer;
        }
        myAdminAuthorizer = AdminAuthorizerFactory.getAdminAuthorizer();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getAdminAuthorizer", myAdminAuthorizer);
        }
        return myAdminAuthorizer;
    }

    private static String getCellName() throws NoItemFoundException {
        String methodName = "getCellName";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getCellName");
        }
        if (myCellName != null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getCellName", myCellName);
            }
            return myCellName;
        }
        AdminService adminService = AdminServiceFactory.getAdminService();
        if (adminService != null) {
            myCellName = adminService.getCellName();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getCellName", myCellName);
        }
        return myCellName;
    }
}

