/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.policyset.admin.commands;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.CommandLoadException;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.CommandValidationException;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commandmetadata.CommandMetadata;
import com.ibm.websphere.management.cmdframework.provider.AbstractAdminCommand;
import com.ibm.websphere.management.cmdframework.provider.CommandResultImpl;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.policyset.admin.PolicySetAttachmentHelper;
import com.ibm.ws.policyset.admin.PolicySetAttachmentHelperFactory;
import com.ibm.ws.policyset.admin.commands.util.CommonUtil;
import com.ibm.ws.policyset.admin.commands.util.CommonWorkSpaceHelper;
import com.ibm.ws.policyset.admin.commands.util.PolicySetAttachmentCommandUtil;
import com.ibm.ws.policyset.admin.commands.util.PolicySetAttachmentWorkSpaceHelper;
import java.io.FileNotFoundException;
import java.util.List;
import java.util.Properties;
import java.util.ResourceBundle;

public class UpdatePolicySetAttachment
extends AbstractAdminCommand {
    private static TraceComponent tc = Tr.register(UpdatePolicySetAttachment.class, "policyset.admin", "com.ibm.ws.policyset.admin.resources.policySetAdmin");
    private ResourceBundle resourceBundle = null;
    public static final String POLICY_ATTACHMENT_NOT_FOUND_MSG = "Policy attachment file is not found: ";
    public static final String CLIENT_POLICY_ATTACHMENT_NOT_FOUND_MSG = "Client policy attachment file is not found: ";
    public static final String TRUST_POLICY_ATTACHMENT_NOT_FOUND_MSG = "System/trust policy attachment file is not found";
    public static final String WSN_CLIENT_POLICY_ATTACHMENT_NOT_FOUND_MSG = "WSN client policy attachment file is not found: ";
    private static final String FFDC_ID_1 = "FFDC-1";
    private static final String FFDC_ID_2 = "FFDC-2";
    private static final String FFDC_ID_3 = "FFDC-3";
    protected String className = this.getClass().getName();
    private Session session = null;

    public UpdatePolicySetAttachment(CommandMetadata inMetadata) throws CommandNotFoundException {
        super(inMetadata);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "constructor inMetadata=" + inMetadata);
        }
    }

    public UpdatePolicySetAttachment(CommandData commandData) throws CommandNotFoundException, CommandLoadException {
        super(commandData);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "constructor commandData=" + commandData);
        }
    }

    private void validate(Session session, String applicationName, String attachmentId, String[] resources, String attachmentType, String attachmentFile, boolean dynamicClient, Properties attachmentProperties) throws CommandValidationException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validate");
        }
        try {
            if (!dynamicClient) {
                if (attachmentType.equals("system/trust")) {
                    StringBuffer resourcesInvalid = new StringBuffer("");
                    resourcesInvalid = PolicySetAttachmentCommandUtil.validateTrustResources(session, resources);
                    if (resourcesInvalid.length() > 0) {
                        throw new CommandValidationException(CommonUtil.getFormattedMessage(this.resourceBundle, "CWPST0011E", new Object[]{resourcesInvalid.toString()}, "The following list of resources are invalid: {0}"));
                    }
                } else {
                    PolicySetAttachmentHelper helper = PolicySetAttachmentHelperFactory.createHelper(attachmentFile);
                    helper.setLocale(this.getLocale());
                    String policySet = helper.getPolicySetForAttachment(attachmentId);
                    StringBuffer resourcesNotFound = new StringBuffer("");
                    resourcesNotFound = PolicySetAttachmentCommandUtil.validateResourcesForApplication(session, applicationName, resources, attachmentType, policySet, attachmentProperties);
                    if (resourcesNotFound.length() > 0) {
                        throw new CommandValidationException(CommonUtil.getFormattedMessage(this.resourceBundle, "CWPST0011E", new Object[]{resourcesNotFound.toString()}, "The following list of resources are invalid: {0}"));
                    }
                }
                StringBuffer resourcesAttached = new StringBuffer("");
                resourcesAttached = PolicySetAttachmentCommandUtil.validateResourcesNotAttached(attachmentType, attachmentFile, resources, attachmentId, false);
                if (resourcesAttached.length() > 0) {
                    if (attachmentType.equals("WSNClient")) {
                        throw new CommandValidationException(CommonUtil.getFormattedMessage(this.resourceBundle, "CWPST0112E", new Object[]{resourcesAttached.toString()}, "The following list of resources are already attached to the WSN service: {0}"));
                    }
                    throw new CommandValidationException(CommonUtil.getFormattedMessage(this.resourceBundle, "CWPST0013E", new Object[]{resourcesAttached.toString()}, "The following list of resources are already attached to the application: {0}"));
                }
            }
        }
        catch (CommandValidationException e) {
            FFDCFilter.processException(e, this.className, FFDC_ID_1);
            throw e;
        }
        catch (Throwable t) {
            FFDCFilter.processException(t, this.className, FFDC_ID_2);
            throw new CommandValidationException(t, CommonUtil.getFormattedMessage(this.resourceBundle, "CWPST0006E", null, "Unexpected exception during command validation."));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validate");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void execute() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "execute");
        }
        CommandResultImpl result = new CommandResultImpl();
        this.setCommandResult(result);
        result.reset();
        try {
            super.validate();
            this.resourceBundle = ResourceBundle.getBundle("com.ibm.ws.policyset.admin.resources.policySetAdmin", this.getLocale());
            String applicationName = (String)this.getParameter("applicationName");
            String attachmentId = (String)this.getParameter("attachmentId");
            String[] resources = (String[])this.getParameter("resources");
            String attachmentType = (String)this.getParameter("attachmentType");
            Boolean isDynamicClient = (Boolean)this.getParameter("dynamicClient");
            Properties attachmentProperties = (Properties)this.getParameter("attachmentProperties");
            this.session = this.getConfigSession();
            int rc = 0;
            if (attachmentType == null) {
                attachmentType = "application";
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "parameters: ", new Object[]{applicationName, attachmentId, resources, attachmentType, isDynamicClient});
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "UpdatePolicySetAttachment, Locale is " + this.getLocale().getDisplayName());
            }
            CommonUtil.setLocale(this.getLocale());
            boolean dynamicClient = false;
            if (isDynamicClient != null && (dynamicClient = isDynamicClient.booleanValue()) && !attachmentType.equals("client")) {
                throw new IllegalArgumentException(CommonUtil.getFormattedMessage(this.resourceBundle, "CWPST0036E", new Object[0], "Dynamic client only allowed when attachment type is client"));
            }
            String busName = null;
            String serviceName = null;
            String systemType = null;
            if (attachmentProperties != null) {
                busName = attachmentProperties.getProperty("bus");
                serviceName = attachmentProperties.getProperty("WSNService");
                if (busName == null && serviceName != null || busName != null && serviceName == null) {
                    throw new IllegalArgumentException(CommonUtil.getFormattedMessage(this.resourceBundle, "CWPST0030E", new Object[]{"bus", "WSNService"}, "The {0} input argument must also be specified with the {1} input argument."));
                }
                if (busName != null && serviceName != null) {
                    if (!attachmentType.equals("client")) {
                        throw new IllegalArgumentException(CommonUtil.getFormattedMessage(this.resourceBundle, "CWPST0110E", new Object[]{"bus", "WSNService", "attachmentProperties"}, "The client attachment type is required when {0} and {1} are specified for the {2} parameter"));
                    }
                    attachmentType = "WSNClient";
                }
                if ((systemType = attachmentProperties.getProperty("systemType")) != null) {
                    if (attachmentType.equals("client") || attachmentType.equals("WSNClient")) {
                        throw new IllegalArgumentException(CommonUtil.getFormattedMessage(this.resourceBundle, "CWPST0146E", new Object[]{"attachmentProperties", systemType}, "The application or provider attachment type is required when the systemType property in the {0} parameter is: {1}"));
                    }
                    if (!systemType.equals("trustService")) throw new IllegalArgumentException(CommonUtil.getFormattedMessage(this.resourceBundle, "CWPST0147E", new Object[]{"systemType"}, "The {0} property does not contain a valid value"));
                    attachmentType = "system/trust";
                }
            } else if (applicationName == null && (attachmentType.equals("application") || attachmentType.equals("client") || attachmentType.equals("provider"))) {
                throw new IllegalArgumentException(CommonUtil.getFormattedMessage(this.resourceBundle, "CWPST0034E", new Object[]{attachmentType}, "The application name is required when attachment type is {0} and the attachmentProperties parameter is not specified"));
            }
            if (attachmentType.equals("provider")) {
                attachmentType = "application";
            }
            String resourceName = applicationName;
            if (attachmentType.equals("WSNClient")) {
                resourceName = busName;
            }
            CommonWorkSpaceHelper.validateAttachmentAuthorization(attachmentType, resourceName);
            String attachmentFile = null;
            String errorMsg = null;
            String messageCode = null;
            if (attachmentType.equals("application")) {
                attachmentFile = PolicySetAttachmentWorkSpaceHelper.getPolicySetAttachmentFile(this.session, applicationName);
                errorMsg = POLICY_ATTACHMENT_NOT_FOUND_MSG;
                messageCode = "CWPST0031E";
            } else if (attachmentType.equals("system/trust")) {
                attachmentFile = PolicySetAttachmentWorkSpaceHelper.getTrustAttachmentFile(this.session);
                errorMsg = TRUST_POLICY_ATTACHMENT_NOT_FOUND_MSG;
                messageCode = "CWPST0033E";
            } else if (attachmentType.equals("client")) {
                attachmentFile = PolicySetAttachmentWorkSpaceHelper.getClientAttachmentFile(this.session, applicationName);
                errorMsg = CLIENT_POLICY_ATTACHMENT_NOT_FOUND_MSG;
                messageCode = "CWPST0032E";
            } else {
                if (!attachmentType.equals("WSNClient")) throw new IllegalArgumentException(CommonUtil.getFormattedMessage(this.resourceBundle, "CWPST0035E", new Object[]{attachmentType}, "Invalid attachment type: {0}"));
                attachmentFile = PolicySetAttachmentWorkSpaceHelper.getWSNClientAttachmentFile(this.session, busName, serviceName);
                errorMsg = WSN_CLIENT_POLICY_ATTACHMENT_NOT_FOUND_MSG;
                messageCode = "CWPST0108E";
            }
            if (attachmentFile != null) {
                this.validate(this.session, applicationName, attachmentId, resources, attachmentType, attachmentFile, dynamicClient, attachmentProperties);
                PolicySetAttachmentHelper helper = PolicySetAttachmentHelperFactory.createHelper(attachmentFile);
                helper.setLocale(this.getLocale());
                if (attachmentType.equals("application")) {
                    List<String> psrs = helper.getPolicySetResources(attachmentId, "id");
                    for (int i = 0; i < resources.length; ++i) {
                        psrs.remove(resources[i]);
                    }
                    PolicySetAttachmentWorkSpaceHelper.removeWSPolicy(this.session, applicationName, psrs);
                }
                rc = helper.updatePolicySetAttachment(attachmentId, resources, 1);
                if (helper.isResourceListEmpty(attachmentId)) {
                    rc = helper.deleteAttachment(attachmentId);
                }
            } else {
                if (!attachmentType.equals("WSNClient")) throw new FileNotFoundException(CommonUtil.getFormattedMessage(this.resourceBundle, messageCode, new Object[]{applicationName}, errorMsg));
                throw new FileNotFoundException(CommonUtil.getFormattedMessage(this.resourceBundle, messageCode, new Object[]{busName, serviceName}, errorMsg));
            }
            if (attachmentType.equals("application")) {
                PolicySetAttachmentWorkSpaceHelper.updatePolicySetAttachmentFile(this.session, applicationName);
            } else if (attachmentType.equals("system/trust")) {
                PolicySetAttachmentWorkSpaceHelper.updateTrustAttachmentFile(this.session);
            } else if (attachmentType.equals("client")) {
                PolicySetAttachmentWorkSpaceHelper.updateClientAttachmentFile(this.session, applicationName);
            } else if (attachmentType.equals("WSNClient")) {
                PolicySetAttachmentWorkSpaceHelper.updateWSNClientAttachmentFile(this.session, busName, serviceName);
            }
            if (rc == 0) {
                result.setResult(Boolean.TRUE);
            } else {
                result.setResult(Boolean.FALSE);
            }
        }
        catch (Exception cse) {
            FFDCFilter.processException(cse, this.className + ".execute", FFDC_ID_3);
            Tr.error(tc, "CWPST0007E", new Object[]{cse.toString()});
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception caught - " + cse);
            }
            result.setException(cse);
        }
        if (!tc.isEntryEnabled()) return;
        Tr.exit(tc, "execute end");
    }
}

