/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.policyset.admin.commands;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.CommandLoadException;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commandmetadata.CommandMetadata;
import com.ibm.websphere.management.cmdframework.provider.AbstractAdminCommand;
import com.ibm.websphere.management.cmdframework.provider.CommandResultImpl;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.policyset.admin.PolicySetHelper;
import com.ibm.ws.policyset.admin.PolicySetHelperFactory;
import com.ibm.ws.policyset.admin.commands.util.CommonUtil;
import com.ibm.ws.policyset.admin.commands.util.PolicySetAttachmentCommandUtil;
import com.ibm.ws.policyset.admin.commands.util.PolicySetWorkSpaceHelper;
import java.util.Properties;

public class TransferAttachmentsForPolicySet
extends AbstractAdminCommand {
    private static TraceComponent tc = Tr.register(TransferAttachmentsForPolicySet.class, "policyset.admin", "com.ibm.ws.policyset.admin.resources.policySetAdmin");
    private static final String FFDC_ID_1 = "FFDC-1";
    protected String className = this.getClass().getName();
    private Session session = null;

    public TransferAttachmentsForPolicySet(CommandMetadata inMetadata) throws CommandNotFoundException {
        super(inMetadata);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "constructor inMetadata=" + inMetadata);
        }
    }

    public TransferAttachmentsForPolicySet(CommandData commandData) throws CommandNotFoundException, CommandLoadException {
        super(commandData);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "constructor commandData=" + commandData);
        }
    }

    public void execute() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "execute");
        }
        CommandResultImpl result = new CommandResultImpl();
        this.setCommandResult(result);
        result.reset();
        try {
            super.validate();
            String sourcePolicysetName = (String)this.getParameter("sourcePolicySet");
            String destPolicysetName = (String)this.getParameter("destinationPolicySet");
            String applicationName = (String)this.getParameter("applicationName");
            Properties attachmentProperties = (Properties)this.getParameter("attachmentProperties");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "parameters: ", new Object[]{sourcePolicysetName, destPolicysetName, applicationName, attachmentProperties});
            }
            this.session = this.getConfigSession();
            int rc = 0;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "TransferAttachmentsForPolicySet, Locale is " + this.getLocale().getDisplayName());
            }
            CommonUtil.setLocale(this.getLocale());
            String pathName = PolicySetWorkSpaceHelper.getPolicySetFile(this.session, destPolicysetName, false);
            PolicySetHelper psHelper = PolicySetHelperFactory.createHelper(pathName);
            psHelper.setLocale(this.getLocale());
            String policySetType = psHelper.getPolicySetType();
            rc = PolicySetAttachmentCommandUtil.transferAttachments(this.session, sourcePolicysetName, destPolicysetName, applicationName, policySetType, attachmentProperties);
            if (rc == 0) {
                result.setResult(Boolean.TRUE);
            } else {
                result.setResult(Boolean.FALSE);
            }
        }
        catch (Exception cse) {
            FFDCFilter.processException(cse, this.className + ".execute", FFDC_ID_1);
            Tr.error(tc, "CWPST0007E", new Object[]{cse.toString()});
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception caught - " + cse);
            }
            result.setException(cse);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "execute end");
        }
    }
}

