/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.policyset.admin.commands;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.CommandLoadException;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.CommandValidationException;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commandmetadata.CommandMetadata;
import com.ibm.websphere.management.cmdframework.provider.AbstractAdminCommand;
import com.ibm.websphere.management.cmdframework.provider.CommandResultImpl;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.policyset.admin.PolicySetHelper;
import com.ibm.ws.policyset.admin.PolicySetHelperFactory;
import com.ibm.ws.policyset.admin.PolicyTypeClassLoader;
import com.ibm.ws.policyset.admin.PolicyTypeProvider;
import com.ibm.ws.policyset.admin.commands.util.CommonUtil;
import com.ibm.ws.policyset.admin.commands.util.CommonWorkSpaceHelper;
import com.ibm.ws.policyset.admin.commands.util.PolicySetWorkSpaceHelper;
import com.ibm.ws.policyset.admin.commands.util.PolicyTypeWorkSpaceHelper;
import com.ibm.ws.policyset.admin.commands.util.ValidationManager;
import java.util.HashMap;
import java.util.Properties;
import java.util.ResourceBundle;

public class SetPolicyType
extends AbstractAdminCommand {
    private static TraceComponent tc = Tr.register(SetPolicyType.class, "policyset.admin", "com.ibm.ws.policyset.admin.resources.policySetAdmin");
    private ResourceBundle resourceBundle = null;
    private static final String FFDC_ID_1 = "FFDC-1";
    private String className = this.getClass().getName();

    public SetPolicyType(CommandMetadata metadata) throws CommandNotFoundException {
        super(metadata);
    }

    public SetPolicyType(CommandData commandData) throws CommandNotFoundException, CommandLoadException {
        super(commandData);
    }

    public void execute() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "execute");
        }
        CommandResultImpl result = new CommandResultImpl();
        this.setCommandResult(result);
        result.reset();
        Session session = this.getConfigSession();
        int rc = 0;
        try {
            super.validate();
            String policySetName = (String)this.getParameter("policySet");
            String policyType = (String)this.getParameter("policyType");
            Properties updatedValues = (Properties)this.getParameter("attributes");
            Boolean replaceAttributes = (Boolean)this.getParameter("replace");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "parameters: ", new Object[]{policySetName, policyType, updatedValues, replaceAttributes});
            }
            boolean replace = false;
            if (replaceAttributes != null) {
                replace = replaceAttributes;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "SetPolicyType, Locale is " + this.getLocale().getDisplayName());
            }
            CommonUtil.setLocale(this.getLocale());
            CommonWorkSpaceHelper.validateCellLevelAdminAuthorization();
            rc = this.setPolicyType(session, policySetName, policyType, updatedValues, replace);
            if (rc == 0) {
                result.setResult(Boolean.TRUE);
            } else {
                result.setResult(Boolean.FALSE);
            }
        }
        catch (Throwable t) {
            FFDCFilter.processException(t, this.className, FFDC_ID_1);
            result.setException(t);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "execute");
        }
    }

    private int setPolicyType(Session session, String policySetName, String policyType, Properties updatedValues, boolean replace) throws Exception {
        ValidationManager validationMgr;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setPolicyType, policySetName=" + policySetName + ", policyType=" + policyType + ", updatedValues=" + updatedValues + ", replace=" + replace);
        }
        this.resourceBundle = ResourceBundle.getBundle("com.ibm.ws.policyset.admin.resources.policySetAdmin", CommonUtil.getLocale());
        int rc = 0;
        String pathname = PolicySetWorkSpaceHelper.getPolicySetFile(session, policySetName, false);
        PolicySetHelper psHelper = PolicySetHelperFactory.createHelper(pathname);
        psHelper.setLocale(CommonUtil.getLocale());
        if (psHelper.isDefaultPolicySet()) {
            throw new CommandValidationException(CommonUtil.getFormattedMessage(this.resourceBundle, "CWPST0004E", new Object[]{policySetName}, "A default policy set cannot be edited: {0}"));
        }
        rc = psHelper.setPolicyType(policyType, updatedValues);
        boolean callPolicyProvider = false;
        boolean updatePolicySetFile = false;
        if (!updatedValues.isEmpty()) {
            if (updatedValues.containsKey("provides")) {
                updatedValues.remove("provides");
                updatePolicySetFile = true;
            }
            if (updatedValues.containsKey("enabled")) {
                updatedValues.remove("enabled");
                updatePolicySetFile = true;
            }
            if (updatedValues.containsKey("type")) {
                updatedValues.remove("type");
                updatePolicySetFile = true;
            }
            if (updatedValues.containsKey("description")) {
                updatedValues.remove("description");
            }
            if (!updatedValues.isEmpty()) {
                callPolicyProvider = true;
            }
        }
        boolean policyTypeSuccess = true;
        if (callPolicyProvider) {
            HashMap<String, String> context;
            String version = null;
            Properties policySetProps = psHelper.getPolicySet();
            if (policySetProps != null && policySetProps.contains("version")) {
                version = policySetProps.getProperty("version");
            }
            String typePathName = PolicyTypeWorkSpaceHelper.getPolicyTypeFile(session, policySetName, policyType, false);
            PolicyTypeProvider policyTypeProvider = PolicyTypeClassLoader.getPolicyTypeProvider(policyType);
            if (policyTypeProvider != null) {
                context = new HashMap<String, String>();
                if (version != null) {
                    context.put("version", version);
                }
            } else {
                throw new ClassNotFoundException(CommonUtil.getFormattedMessage(this.resourceBundle, "CWPST0042E", new Object[]{policyType}, "PolicyTypeProvider class not found for Policy type: {0}"));
            }
            policyTypeSuccess = policyTypeProvider.setAttributes(typePathName, updatedValues, replace, context);
            if (!policyTypeSuccess) {
                throw new Exception(CommonUtil.getFormattedMessage(this.resourceBundle, "CWPST0044E", new Object[]{policyType}, "Error in setting attributes for Policy type: {0}"));
            }
        }
        if (updatePolicySetFile) {
            PolicySetWorkSpaceHelper.updatePolicySetFile(session, policySetName);
        }
        if (callPolicyProvider) {
            PolicyTypeWorkSpaceHelper.updatePolicyTypeFile(session, policySetName, policyType);
        }
        if ((validationMgr = ValidationManager.getManager(session)) != null) {
            validationMgr.markForValidation(policySetName);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setPolicyType, rc=" + rc);
        }
        return rc;
    }
}

