/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.policyset.admin.commands;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.CommandLoadException;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.CommandValidationException;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commandmetadata.CommandMetadata;
import com.ibm.websphere.management.cmdframework.provider.AbstractAdminCommand;
import com.ibm.websphere.management.cmdframework.provider.CommandResultImpl;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.policyset.admin.BindingDefinitionHelper;
import com.ibm.ws.policyset.admin.BindingDefinitionHelperFactory;
import com.ibm.ws.policyset.admin.DefaultBindingsHelper;
import com.ibm.ws.policyset.admin.DefaultBindingsHelperFactory;
import com.ibm.ws.policyset.admin.commands.util.CommonUtil;
import com.ibm.ws.policyset.admin.commands.util.CommonWorkSpaceHelper;
import com.ibm.ws.policyset.admin.commands.util.PolicySetBindingCommandUtil;
import com.ibm.ws.policyset.admin.commands.util.PolicySetBindingWorkSpaceHelper;
import java.util.List;
import java.util.Properties;
import java.util.ResourceBundle;

public class SetDefaultBindings
extends AbstractAdminCommand {
    private static TraceComponent tc = Tr.register(SetDefaultBindings.class, "policyset.admin", "com.ibm.ws.policyset.admin.resources.policySetAdmin");
    private ResourceBundle resourceBundle = null;
    private static final String FFDC_ID_1 = "FFDC-1";
    private String className = this.getClass().getName();

    public SetDefaultBindings(CommandMetadata metadata) throws CommandNotFoundException {
        super(metadata);
    }

    public SetDefaultBindings(CommandData commandData) throws CommandNotFoundException, CommandLoadException {
        super(commandData);
    }

    private void validate(Session session, Properties defaultBindings, Properties bindingLocation, String domainName, boolean forDomain) throws CommandValidationException, Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validate");
        }
        String pathName = null;
        if (defaultBindings != null && !defaultBindings.isEmpty()) {
            List domainList;
            String clientValue;
            String providerValue = defaultBindings.getProperty("provider");
            if (providerValue != null && !providerValue.equals("")) {
                pathName = PolicySetBindingWorkSpaceHelper.getNamedBindingDefinitionFile(session, providerValue);
                if (pathName == null) {
                    throw new CommandValidationException(CommonUtil.getFormattedMessage(this.resourceBundle, "CWPST0053E", new Object[]{providerValue}, "The {0} binding was not found"));
                }
                BindingDefinitionHelper bindingHelper = BindingDefinitionHelperFactory.createHelper(pathName);
                bindingHelper.setLocale(CommonUtil.getLocale());
                String type = bindingHelper.getBindingType();
                if (!"provider".equals(type)) {
                    throw new CommandValidationException(CommonUtil.getFormattedMessage(this.resourceBundle, "CWPST0124E", new Object[]{providerValue}, "The {0} binding is not valid for the specified type"));
                }
            }
            if ((clientValue = defaultBindings.getProperty("client")) != null && !clientValue.equals("")) {
                pathName = PolicySetBindingWorkSpaceHelper.getNamedBindingDefinitionFile(session, clientValue);
                if (pathName == null) {
                    throw new CommandValidationException(CommonUtil.getFormattedMessage(this.resourceBundle, "CWPST0053E", new Object[]{clientValue}, "The {0} binding was not found"));
                }
                BindingDefinitionHelper bindingHelper = BindingDefinitionHelperFactory.createHelper(pathName);
                bindingHelper.setLocale(CommonUtil.getLocale());
                String type = bindingHelper.getBindingType();
                if (!"client".equals(type)) {
                    throw new CommandValidationException(CommonUtil.getFormattedMessage(this.resourceBundle, "CWPST0124E", new Object[]{clientValue}, "The {0} binding is not valid for the specified type"));
                }
            }
            if (forDomain && (clientValue != null && !clientValue.equals("") || providerValue != null && !providerValue.equals("")) && !(domainList = PolicySetBindingCommandUtil.getValidDomains(session)).contains(domainName)) {
                throw new CommandValidationException(CommonUtil.getFormattedMessage(this.resourceBundle, "CWPST0152E", new Object[]{domainName}, "The {0} domain name is not valid"));
            }
        } else {
            throw new CommandValidationException(CommonUtil.getFormattedMessage(this.resourceBundle, "CWPST0069E", new Object[]{"defaultBindings"}, "The {0} input parameter is missing or not valid"));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validate");
        }
    }

    public void execute() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "execute");
        }
        CommandResultImpl result = new CommandResultImpl();
        this.setCommandResult(result);
        result.reset();
        Session session = this.getConfigSession();
        String node = null;
        String server = null;
        boolean forDomain = true;
        boolean newFile = false;
        try {
            super.validate();
            this.resourceBundle = ResourceBundle.getBundle("com.ibm.ws.policyset.admin.resources.policySetAdmin", this.getLocale());
            int rc = 0;
            Properties defaultBindings = (Properties)this.getParameter("defaultBindings");
            Properties bindingLocation = (Properties)this.getParameter("bindingLocation");
            String domainName = (String)this.getParameter("domainName");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "parameters: ", new Object[]{defaultBindings, bindingLocation, domainName});
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "SetDefaultBindings, Locale is " + this.getLocale().getDisplayName());
            }
            CommonUtil.setLocale(this.getLocale());
            CommonWorkSpaceHelper.validateCellLevelAdminAuthorization();
            if (domainName != null && bindingLocation != null) {
                throw new IllegalArgumentException(CommonUtil.getFormattedMessage(this.resourceBundle, "CWPST0131E", new Object[]{"domainName", "bindingLocation"}, "The {1} parameter cannot be used if the {0} parameter is specified"));
            }
            if (bindingLocation != null && !bindingLocation.isEmpty()) {
                if (!bindingLocation.containsKey("node") || !bindingLocation.containsKey("server")) {
                    throw new IllegalArgumentException(CommonUtil.getFormattedMessage(this.resourceBundle, "CWPST0047E", new Object[0], "A required property was not found for the bindingLocation parameter"));
                }
                node = bindingLocation.getProperty("node");
                server = bindingLocation.getProperty("server");
                forDomain = false;
                String warningMsg = CommonUtil.getFormattedMessage(this.resourceBundle, "CWPST0143W", new Object[0], "The bindingLocation properties of node and server are deprecated");
                result.addWarnings(warningMsg);
            } else if (domainName == null) {
                domainName = "global";
            }
            this.validate(session, defaultBindings, bindingLocation, domainName, forDomain);
            String bindingsFile = PolicySetBindingWorkSpaceHelper.getDefaultBindingsFile(session);
            if (bindingsFile == null) {
                bindingsFile = PolicySetBindingWorkSpaceHelper.createDefaultBindingsFile(session);
                newFile = true;
            }
            DefaultBindingsHelper helper = DefaultBindingsHelperFactory.createHelper(bindingsFile);
            helper.setLocale(this.getLocale());
            if (newFile) {
                helper.createDefaultBindings();
            }
            rc = forDomain ? helper.setDomainDefaults(domainName, defaultBindings) : helper.setServerDefaults(server, node, defaultBindings);
            if (!newFile) {
                PolicySetBindingWorkSpaceHelper.updateDefaultBindingsFile(session);
            }
            if (rc == 0) {
                result.setResult(Boolean.TRUE);
            } else {
                result.setResult(Boolean.FALSE);
            }
        }
        catch (Throwable t) {
            FFDCFilter.processException(t, this.className, FFDC_ID_1);
            result.setException(t);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "execute");
        }
    }
}

