/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.policyset.admin.commands;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.CommandValidationException;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commandmetadata.CommandMetadata;
import com.ibm.websphere.management.cmdframework.provider.AbstractAdminCommand;
import com.ibm.websphere.management.cmdframework.provider.CommandResultImpl;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.policyset.admin.PolicyConstants;
import com.ibm.ws.policyset.admin.PolicySetAttachmentHelper;
import com.ibm.ws.policyset.admin.PolicySetAttachmentHelperFactory;
import com.ibm.ws.policyset.admin.commands.util.CommonUtil;
import com.ibm.ws.policyset.admin.commands.util.PolicyControlCommandUtil;
import com.ibm.ws.policyset.admin.commands.util.PolicyControlWorkSpaceHelper;
import com.ibm.ws.policyset.admin.commands.util.PolicySetAttachmentWorkSpaceHelper;
import com.ibm.ws.policyset.admin.commands.util.PolicySetBindingCommandUtil;
import com.ibm.ws.wspolicy.admin.client.WSPolicyClientControlHelper;
import com.ibm.ws.wspolicy.admin.client.WSPolicyClientControlHelperFactory;
import java.io.FileNotFoundException;
import java.util.List;
import java.util.Properties;
import java.util.ResourceBundle;

public class SetClientDynamicPolicyControl
extends AbstractAdminCommand {
    private static TraceComponent tc = Tr.register(SetClientDynamicPolicyControl.class, "policyset.admin", "com.ibm.ws.policyset.admin.resources.policySetAdmin");
    private ResourceBundle resourceBundle = null;
    private String className = this.getClass().getName();
    private Session session = null;
    private String existingAttachmentID = null;

    public SetClientDynamicPolicyControl(CommandMetadata inMetadata) throws CommandNotFoundException {
        super(inMetadata);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "SetClientDynamicPolicyControl", inMetadata);
        }
    }

    public SetClientDynamicPolicyControl(CommandData inCommandData) throws CommandNotFoundException {
        super(inCommandData);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "SetClientDynamicPolicyControl", inCommandData);
        }
    }

    public void validateResourceNotAttached(Session session, String applicationName, String resource, PolicySetAttachmentHelper psAttachmentHelper) throws Exception {
        String attachmentFile;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "validateResourceNotAttached", new Object[]{session, applicationName, resource});
        }
        if ((attachmentFile = PolicySetAttachmentWorkSpaceHelper.getClientAttachmentFile(session, applicationName)) != null) {
            this.existingAttachmentID = psAttachmentHelper.getIdForPolicySetAttachment(resource);
            if (this.existingAttachmentID != null) {
                List<String> existingResources = psAttachmentHelper.getPolicySetResources(this.existingAttachmentID, "id");
                if (existingResources != null && existingResources.size() > 1) {
                    throw new CommandValidationException(CommonUtil.getFormattedMessage(this.resourceBundle, "CWPST0144E", new Object[0], "Multiple resources are not valid when WSPolicy is enabled."));
                }
            } else {
                this.existingAttachmentID = psAttachmentHelper.getIdForProviderPolicySetAttachment(resource);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "validateResourceNotAttached");
        }
    }

    public void execute() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "execute", new Object[]{this});
        }
        CommandResultImpl result = new CommandResultImpl();
        this.setCommandResult(result);
        result.reset();
        String applicationName = null;
        boolean createdFile = false;
        boolean createdAttachmentFile = false;
        try {
            boolean resourceFound;
            super.validate();
            this.resourceBundle = ResourceBundle.getBundle("com.ibm.ws.policyset.admin.resources.policySetAdmin", this.getLocale());
            applicationName = (String)this.getParameter("applicationName");
            String resource = (String)this.getParameter("resource");
            String acquireMethod = (String)this.getParameter(PolicyConstants.ACQUIRE_PROVIDER_POLICY_METHOD);
            Properties httpGetProperties = (Properties)this.getParameter(PolicyConstants.HTTP_GET_PROPERTIES);
            Properties wsMexProperties = (Properties)this.getParameter(PolicyConstants.WSMEX_PROPERTIES);
            Boolean removeB = (Boolean)this.getParameter("remove");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "parameters: ", new Object[]{applicationName, resource, acquireMethod, httpGetProperties, wsMexProperties, removeB});
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "SetClientDynamicPolicyControl, Locale is " + this.getLocale().getDisplayName());
            }
            PolicyControlCommandUtil.setLocale(this.getLocale());
            this.session = this.getConfigSession();
            PolicyControlWorkSpaceHelper.validateConfiguratorAuthorization(PolicyControlWorkSpaceHelper.getAppRepositoryContext(this.session, applicationName));
            if (resource != null && !(resourceFound = PolicyControlCommandUtil.validateResourceForApplication(this.session, applicationName, resource, PolicyConstants.CLIENT_CONTROL))) {
                throw new CommandValidationException(CommonUtil.getFormattedMessage(this.resourceBundle, "CWPST0011E", new Object[]{resource}, "The following list of resources are invalid: {0}"));
            }
            boolean remove = false;
            if (removeB != null) {
                remove = removeB;
            }
            PolicySetAttachmentHelper psAttachmentHelper = null;
            if (remove || acquireMethod != null) {
                String attachmentFile = PolicySetAttachmentWorkSpaceHelper.getClientAttachmentFile(this.session, applicationName);
                if (attachmentFile == null) {
                    if (remove) {
                        throw new FileNotFoundException(CommonUtil.getFormattedMessage(this.resourceBundle, "CWPST0032E", new Object[]{applicationName}, "Client policy attachment file is not found: {0}"));
                    }
                    attachmentFile = PolicySetAttachmentWorkSpaceHelper.createClientAttachmentFile(this.session, applicationName);
                    createdAttachmentFile = true;
                }
                psAttachmentHelper = PolicySetAttachmentHelperFactory.createHelper(attachmentFile);
                psAttachmentHelper.setLocale(this.getLocale());
            }
            boolean success = true;
            if (remove) {
                success = this.removeControlSettings(applicationName, resource, psAttachmentHelper);
            } else {
                if (acquireMethod == null) {
                    throw new CommandValidationException(PolicyControlCommandUtil.getFormattedMessage(this.resourceBundle, "CWPST0069E", new Object[]{PolicyConstants.ACQUIRE_PROVIDER_POLICY_METHOD}, "The {0} input parameter is missing or not valid."));
                }
                if (acquireMethod.equals(PolicyConstants.HTTP_GET) || acquireMethod.equals(PolicyConstants.WSMEX)) {
                    if (acquireMethod.equals(PolicyConstants.HTTP_GET) && httpGetProperties != null && httpGetProperties.getProperty(PolicyConstants.HTTP_GET_TARGET_URI) != null && resource.equals("WebService:/")) {
                        throw new CommandValidationException(PolicyControlCommandUtil.getFormattedMessage(this.resourceBundle, "CWPST0153E", new Object[]{PolicyConstants.HTTP_GET_TARGET_URI}, "The {0} parameter can not be specified at application level."));
                    }
                } else {
                    throw new CommandValidationException(PolicyControlCommandUtil.getFormattedMessage(this.resourceBundle, "CWPST0136E", new Object[0], "Either httpGet or wsMex must be specified."));
                }
                if (createdAttachmentFile) {
                    psAttachmentHelper.createPolicySetAttachment();
                }
                this.validateResourceNotAttached(this.session, applicationName, resource, psAttachmentHelper);
                String controlFile = PolicyControlWorkSpaceHelper.getWSPolicyClientControlFile(this.session, applicationName);
                if (controlFile == null) {
                    controlFile = PolicyControlWorkSpaceHelper.createWSPolicyClientControlFile(this.session, applicationName);
                    createdFile = true;
                }
                String policySetAttachmentFile = PolicySetAttachmentWorkSpaceHelper.getClientAttachmentFile(this.session, applicationName);
                WSPolicyClientControlHelper helper = WSPolicyClientControlHelperFactory.createHelper(controlFile, policySetAttachmentFile);
                if (createdFile) {
                    helper.createWSPolicyClientControl();
                }
                if (acquireMethod.equals(PolicyConstants.HTTP_GET)) {
                    String httpGetTargetURI = null;
                    if (httpGetProperties != null) {
                        httpGetTargetURI = httpGetProperties.getProperty(PolicyConstants.HTTP_GET_TARGET_URI);
                    }
                    helper.addWSPolicyClientControlReferenceHTTPGET(resource, httpGetTargetURI, true);
                } else if (acquireMethod.equals(PolicyConstants.WSMEX)) {
                    String wsMexPolicySetName = null;
                    String wsMexPolicySetBinding = null;
                    if (wsMexProperties != null) {
                        wsMexPolicySetName = wsMexProperties.getProperty(PolicyConstants.WS_MEX_POLICY_SET_NAME);
                        if (wsMexPolicySetName != null) {
                            PolicyControlCommandUtil.validateWSMexPolicySet(this.session, wsMexPolicySetName);
                        }
                        if ((wsMexPolicySetBinding = wsMexProperties.getProperty(PolicyConstants.WS_MEX_POLICY_SET_BINDING)) != null) {
                            PolicySetBindingCommandUtil.isClientNamedBinding(this.session, wsMexPolicySetBinding);
                        }
                    }
                    helper.addWSPolicyClientControlReferenceWSMex11(resource, wsMexPolicySetName, wsMexPolicySetBinding, true);
                }
                success = PolicyControlWorkSpaceHelper.updateWSPolicyClientControlFile(this.session, applicationName);
                if (this.existingAttachmentID != null) {
                    psAttachmentHelper.addProviderPolicySetToAttachment(this.existingAttachmentID);
                    Properties bindingProps = psAttachmentHelper.getBindingReference(this.existingAttachmentID);
                    if (bindingProps.get("name") != null && bindingProps.get("scope") == null) {
                        psAttachmentHelper.setBindingReference(this.existingAttachmentID, null, null);
                    }
                } else {
                    psAttachmentHelper.attachProviderPolicySet("client", resource);
                }
                PolicySetAttachmentWorkSpaceHelper.updateClientAttachmentFile(this.session, applicationName);
            }
            result.setResult(success);
        }
        catch (Exception e) {
            FFDCFilter.processException(e, this.className + ".execute", "199");
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "execute", e);
            }
            try {
                if (createdFile) {
                    PolicyControlWorkSpaceHelper.deleteWSPolicyClientControlFile(this.session, applicationName);
                }
                if (createdAttachmentFile) {
                    PolicySetAttachmentWorkSpaceHelper.deleteClientAttachmentFile(this.session, applicationName);
                }
            }
            catch (Throwable th) {
                // empty catch block
            }
            result.setException(e);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "execute");
        }
    }

    private boolean removeControlSettings(String applicationName, String resource, PolicySetAttachmentHelper psAttachmentHelper) throws Exception {
        boolean attachmentEmpty;
        String methodName = "removeControlSettings";
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "removeControlSettings", new Object[]{applicationName, resource, this});
        }
        boolean success = false;
        String controlFile = PolicyControlWorkSpaceHelper.getWSPolicyClientControlFile(this.session, applicationName);
        if (controlFile == null) {
            throw new CommandValidationException(PolicyControlCommandUtil.getFormattedMessage(this.resourceBundle, "CWPST0137E", new Object[]{"wsPolicyClientControl.xml", applicationName}, "The {0} control file could not be found for application: {1}"));
        }
        String policySetAttachmentFile = PolicySetAttachmentWorkSpaceHelper.getClientAttachmentFile(this.session, applicationName);
        WSPolicyClientControlHelper helper = WSPolicyClientControlHelperFactory.createHelper(controlFile, policySetAttachmentFile);
        if (helper.getWSPolicyClientControlReference(resource) == null) {
            throw new CommandValidationException(PolicyControlCommandUtil.getFormattedMessage(this.resourceBundle, "CWPST0141E", new Object[]{resource}, "The following resource does not contain any WSPolicy settings: {0}"));
        }
        helper.removeWSPolicyClientControlReference(resource);
        List<Properties> referenceProperties = helper.getWSPolicyClientControlReferencesProperties();
        success = referenceProperties == null || referenceProperties.size() == 0 ? PolicyControlWorkSpaceHelper.deleteWSPolicyClientControlFile(this.session, applicationName) : PolicyControlWorkSpaceHelper.updateWSPolicyClientControlFile(this.session, applicationName);
        String attachmentId = psAttachmentHelper.getIdForProviderPolicySetAttachment(resource);
        psAttachmentHelper.removeProviderPolicySetFromAttachment(attachmentId);
        if (psAttachmentHelper.getIdForPolicySetAttachment(resource) == null) {
            psAttachmentHelper.deleteAttachment(attachmentId);
        }
        if (attachmentEmpty = psAttachmentHelper.isAttachmentListEmpty()) {
            PolicySetAttachmentWorkSpaceHelper.deleteClientAttachmentFile(this.session, applicationName);
        } else {
            PolicySetAttachmentWorkSpaceHelper.updateClientAttachmentFile(this.session, applicationName);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "removeControlSettings", success);
        }
        return success;
    }
}

