/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.policyset.admin.commands;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.CommandLoadException;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commandmetadata.CommandMetadata;
import com.ibm.websphere.management.cmdframework.provider.AbstractAdminCommand;
import com.ibm.websphere.management.cmdframework.provider.CommandResultImpl;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.policyset.admin.PolicySetHelper;
import com.ibm.ws.policyset.admin.PolicySetHelperFactory;
import com.ibm.ws.policyset.admin.commands.util.CommonUtil;
import com.ibm.ws.policyset.admin.commands.util.PolicySetWorkSpaceHelper;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;

public class ListPolicySets
extends AbstractAdminCommand {
    private static TraceComponent tc = Tr.register(ListPolicySets.class, "policyset.admin", "com.ibm.ws.policyset.admin.resources.policySetAdmin");
    private static final String FFDC_ID_1 = "FFDC-1";
    private static final String FFDC_ID_2 = "FFDC-2";
    protected String SOURCE_FILE = this.getClass().getName();
    private Session session = null;

    public ListPolicySets(CommandMetadata inMetadata) throws CommandNotFoundException {
        super(inMetadata);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "constructor inMetadata=" + inMetadata);
        }
    }

    public ListPolicySets(CommandData commandData) throws CommandNotFoundException, CommandLoadException {
        super(commandData);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "constructor commandData=" + commandData);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "execute");
        }
        CommandResultImpl result = new CommandResultImpl();
        this.setCommandResult(result);
        result.reset();
        try {
            super.validate();
            this.session = this.getConfigSession();
            String policySetType = (String)this.getParameter("policySetType");
            Boolean fromDefaultRepositoryB = (Boolean)this.getParameter("fromDefaultRepository");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "parameters: ", new Object[]{policySetType, fromDefaultRepositoryB});
            }
            if (policySetType == null) {
                policySetType = "application";
            }
            boolean fromDefaultRepository = false;
            if (fromDefaultRepositoryB != null) {
                fromDefaultRepository = fromDefaultRepositoryB;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "ListPolicySets, Locale is " + this.getLocale().getDisplayName());
            }
            CommonUtil.setLocale(this.getLocale());
            List<String> resultList = null;
            resultList = fromDefaultRepository ? PolicySetWorkSpaceHelper.listPolicySets(this.session, true) : PolicySetWorkSpaceHelper.listPolicySets(this.session, false);
            ArrayList<String> updatedResultList = new ArrayList<String>();
            for (int i = 0; i < resultList.size(); ++i) {
                String filename = resultList.get(i);
                Properties props = null;
                try {
                    PolicySetHelper psHelper = PolicySetHelperFactory.createHelper(filename);
                    psHelper.setLocale(this.getLocale());
                    props = psHelper.getPolicySet();
                    if (!policySetType.equals(props.getProperty("type"))) continue;
                    updatedResultList.add(ListPolicySets.getLastDirName(filename));
                    continue;
                }
                catch (Exception e) {
                    FFDCFilter.processException(e, this.SOURCE_FILE + ".execute", FFDC_ID_2);
                    Tr.error(tc, "CWPST0007E", new Object[]{e.toString()});
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "Exception caught - " + e);
                }
            }
            result.setResult(updatedResultList);
        }
        catch (Exception cse) {
            FFDCFilter.processException(cse, this.SOURCE_FILE + ".execute", FFDC_ID_1);
            Tr.error(tc, "CWPST0007E", new Object[]{cse.toString()});
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception caught - " + cse);
            }
            result.setException(cse);
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "finally");
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "execute end");
        }
    }

    private static String getLastDirName(String filePath) {
        int index = filePath.lastIndexOf(File.separatorChar);
        String str1 = filePath.substring(0, index);
        index = str1.lastIndexOf(File.separatorChar);
        String dirName = str1.substring(index + 1);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getLastDirName, filePath=" + filePath + ", str1=" + str1 + ", dir=" + dirName);
        }
        return dirName;
    }
}

