/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.policyset.admin.commands;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.CommandLoadException;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commandmetadata.CommandMetadata;
import com.ibm.websphere.management.cmdframework.provider.AbstractAdminCommand;
import com.ibm.websphere.management.cmdframework.provider.CommandResultImpl;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.policyset.admin.PolicySetAttachmentHelper;
import com.ibm.ws.policyset.admin.PolicySetAttachmentHelperFactory;
import com.ibm.ws.policyset.admin.commands.util.CommonUtil;
import com.ibm.ws.policyset.admin.commands.util.PolicySetAttachmentWorkSpaceHelper;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;

public class ListAttachmentsForPolicySet
extends AbstractAdminCommand {
    private static TraceComponent tc = Tr.register(ListAttachmentsForPolicySet.class, "policyset.admin", "com.ibm.ws.policyset.admin.resources.policySetAdmin");
    private ResourceBundle resourceBundle = null;
    private static final String FFDC_ID_1 = "FFDC-1";
    protected String className = this.getClass().getName();
    private Session session = null;

    public ListAttachmentsForPolicySet(CommandMetadata inMetadata) throws CommandNotFoundException {
        super(inMetadata);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "constructor inMetadata=" + inMetadata);
        }
    }

    public ListAttachmentsForPolicySet(CommandData commandData) throws CommandNotFoundException, CommandLoadException {
        super(commandData);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "constructor commandData=" + commandData);
        }
    }

    public void execute() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "execute");
        }
        CommandResultImpl result = new CommandResultImpl();
        this.setCommandResult(result);
        result.reset();
        ArrayList<String> attachmentList = new ArrayList<String>();
        try {
            super.validate();
            this.session = this.getConfigSession();
            this.resourceBundle = ResourceBundle.getBundle("com.ibm.ws.policyset.admin.resources.policySetAdmin", this.getLocale());
            String policysetName = (String)this.getParameter("policySet");
            String attachmentType = (String)this.getParameter("attachmentType");
            if (attachmentType == null) {
                attachmentType = "all";
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "parameters: ", new Object[]{policysetName, attachmentType});
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "ListAttachmentsForPolicySet, Locale is " + this.getLocale().getDisplayName());
            }
            CommonUtil.setLocale(this.getLocale());
            if (attachmentType.equals("provider")) {
                attachmentType = "application";
            }
            if (!(attachmentType.equals("application") || attachmentType.equals("client") || attachmentType.equals("all"))) {
                throw new IllegalArgumentException(CommonUtil.getFormattedMessage(this.resourceBundle, "CWPST0035E", new Object[]{attachmentType}, "Invalid attachment type: {0}"));
            }
            List<Object> applicationList = new ArrayList();
            List<Object> clientList = new ArrayList();
            if (attachmentType.equals("application") || attachmentType.equals("all")) {
                applicationList = PolicySetAttachmentWorkSpaceHelper.listPolicySetAttachmentFiles(this.session, "application");
            }
            if (attachmentType.equals("client") || attachmentType.equals("all")) {
                clientList = PolicySetAttachmentWorkSpaceHelper.listPolicySetAttachmentFiles(this.session, "client");
            }
            applicationList.addAll(clientList);
            if (applicationList != null && !applicationList.isEmpty()) {
                for (int i = 0; i < applicationList.size(); ++i) {
                    String appName;
                    String appFilePath = (String)applicationList.get(i);
                    PolicySetAttachmentHelper helper = PolicySetAttachmentHelperFactory.createHelper(appFilePath);
                    helper.setLocale(this.getLocale());
                    if (!helper.isAttachedToPolicySet(policysetName)) continue;
                    String dirName = null;
                    if (appFilePath.contains("policyAttachments.xml")) {
                        dirName = appFilePath.substring(0, appFilePath.indexOf("policyAttachments.xml") - 1);
                    } else if (appFilePath.contains("clientPolicyAttachments.xml")) {
                        dirName = appFilePath.substring(0, appFilePath.indexOf("clientPolicyAttachments.xml") - 1);
                    }
                    if (dirName == null || (appName = (dirName = dirName.substring(0, dirName.lastIndexOf(File.separator))).substring(dirName.lastIndexOf(File.separator) + 1)) == null || attachmentList.contains(appName)) continue;
                    attachmentList.add(appName);
                }
                result.setResult(attachmentList);
            }
        }
        catch (Throwable t) {
            FFDCFilter.processException(t, this.className + ".execute()", FFDC_ID_1);
            result.setException(t);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "execute end");
        }
    }
}

