/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.policyset.admin.commands;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.CommandLoadException;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.CommandValidationException;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commandmetadata.CommandMetadata;
import com.ibm.websphere.management.cmdframework.provider.AbstractAdminCommand;
import com.ibm.websphere.management.cmdframework.provider.CommandResultImpl;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.policyset.admin.BindingDefinitionHelper;
import com.ibm.ws.policyset.admin.BindingDefinitionHelperFactory;
import com.ibm.ws.policyset.admin.commands.util.CommonUtil;
import com.ibm.ws.policyset.admin.commands.util.CommonWorkSpaceHelper;
import com.ibm.ws.policyset.admin.commands.util.PolicySetBindingCommandUtil;
import com.ibm.ws.policyset.admin.commands.util.PolicySetBindingWorkSpaceHelper;
import com.ibm.ws.policyset.admin.commands.util.PolicySetWorkSpaceHelper;
import com.ibm.ws.policyset.admin.commands.util.PolicyTypeWorkSpaceHelper;
import com.ibm.ws.policyset.admin.exceptions.DuplicateItemFoundException;
import com.ibm.ws.policyset.admin.exceptions.NoItemFoundException;
import com.ibm.ws.sm.workspace.WorkSpaceException;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;

public class ImportBinding
extends AbstractAdminCommand {
    private static TraceComponent tc = Tr.register(ImportBinding.class, "policyset.admin", "com.ibm.ws.policyset.admin.resources.policySetAdmin");
    private ResourceBundle resourceBundle = null;
    private static final String FFDC_ID_1 = "FFDC-1";
    private static final String FFDC_ID_2 = "FFDC-2";
    private static final String FFDC_ID_3 = "FFDC-3";
    private String className = this.getClass().getName();

    public ImportBinding(CommandMetadata metadata) throws CommandNotFoundException {
        super(metadata);
    }

    public ImportBinding(CommandData commandData) throws CommandNotFoundException, CommandLoadException {
        super(commandData);
    }

    private String validate(Session session, String importFile) throws CommandValidationException, WorkSpaceException, NoItemFoundException, Exception {
        File fullPath;
        String methodName = "validate";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validate", new Object[]{session, importFile});
        }
        if ((fullPath = new File(importFile)).exists()) {
            if (fullPath.isDirectory()) {
                throw new CommandValidationException(CommonUtil.getFormattedMessage(this.resourceBundle, "CWPST0104E", new Object[]{importFile}, "The {0} file name is a directory."));
            }
        } else {
            throw new CommandValidationException(CommonUtil.getFormattedMessage(this.resourceBundle, "CWPST0020E", new Object[]{importFile}, "The following directory path does not exist: {0}"));
        }
        List fileList = this.getZipFileList(importFile);
        if (fileList.size() < 1) {
            throw new CommandValidationException(CommonUtil.getFormattedMessage(this.resourceBundle, "CWPST0098E", new Object[]{importFile}, "The {0} zip file does not contain any files."));
        }
        Iterator fileListIt = fileList.iterator();
        String currentBindingName = "";
        while (fileListIt.hasNext()) {
            String fileName = fileListIt.next().toString();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "validate, fileName=" + fileName);
            }
            int s1 = fileName.indexOf("\\");
            int s2 = fileName.indexOf("/");
            String pathDelimiter = "";
            if (s1 > 0) {
                pathDelimiter = "\\";
            } else if (s2 > 0) {
                pathDelimiter = "/";
            } else {
                throw new CommandValidationException(CommonUtil.getFormattedMessage(this.resourceBundle, "CWPST0099E", new Object[]{importFile}, "The {0} zip file contains entries that have no directory path information."));
            }
            StringTokenizer fileTok = new StringTokenizer(fileName, pathDelimiter);
            int tokCnt = fileTok.countTokens();
            if (tokCnt > 5) {
                throw new CommandValidationException(CommonUtil.getFormattedMessage(this.resourceBundle, "CWPST0100E", new Object[]{importFile}, "The {0} zip file contains directory entries that are not valid."));
            }
            int tokenPointer = 0;
            String currentToken = "";
            while (fileTok.hasMoreTokens()) {
                ++tokenPointer;
                currentToken = fileTok.nextToken();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "validate, currentToken=" + currentToken);
                }
                if (tokenPointer == 1) {
                    this.validateToken1(currentToken, importFile);
                    continue;
                }
                if (tokenPointer == 2) {
                    currentBindingName = this.validateToken2(session, currentToken, currentBindingName, importFile);
                    continue;
                }
                if (tokenPointer == 3) {
                    this.validateToken3(currentToken, importFile);
                    continue;
                }
                if (tokenPointer == 4) {
                    this.validateToken4(session, currentToken, importFile);
                    continue;
                }
                if (tokenPointer != 5) continue;
                this.validateToken5(currentToken, importFile);
            }
        }
        if (currentBindingName.equals("")) {
            throw new CommandValidationException(CommonUtil.getFormattedMessage(this.resourceBundle, "CWPST0127E", new Object[]{importFile}, "The {0} zip file does not contain a binding."));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validate", currentBindingName);
        }
        return currentBindingName;
    }

    private void validateToken1(String currentToken, String importFile) throws CommandValidationException {
        String methodName = "validateToken1";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validateToken1", new Object[]{currentToken, importFile});
        }
        if (!currentToken.equals("bindings")) {
            throw new CommandValidationException(CommonUtil.getFormattedMessage(this.resourceBundle, "CWPST0100E", new Object[]{importFile}, "The {0} zip file contains directory entries that are not valid."));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validateToken1");
        }
    }

    private String validateToken2(Session session, String currentToken, String currentBindingName, String importFile) throws CommandValidationException, WorkSpaceException, NoItemFoundException {
        String methodName = "validateToken2";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validateToken2", new Object[]{session, currentToken, currentBindingName, importFile});
        }
        if (currentBindingName.equals("")) {
            currentBindingName = currentToken;
            boolean bindingFound = PolicySetBindingWorkSpaceHelper.doesNamedBindingExist(session, currentBindingName);
            if (bindingFound) {
                throw new CommandValidationException(CommonUtil.getFormattedMessage(this.resourceBundle, "CWPST0129E", new Object[]{importFile, currentBindingName}, "The {0} zip file contains the {1} binding that exists on this system."));
            }
        } else if (!currentToken.equals(currentBindingName)) {
            throw new CommandValidationException(CommonUtil.getFormattedMessage(this.resourceBundle, "CWPST0128E", new Object[]{importFile, currentBindingName}, "The {0} zip file contains more than one binding."));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validateToken2", currentBindingName);
        }
        return currentBindingName;
    }

    private void validateToken3(String currentToken, String importFile) throws CommandValidationException {
        String methodName = "validateToken3";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validateToken3", new Object[]{currentToken, importFile});
        }
        if (!currentToken.equals("PolicyTypes") && !currentToken.equals("bindingDefinition.xml")) {
            throw new CommandValidationException(CommonUtil.getFormattedMessage(this.resourceBundle, "CWPST0100E", new Object[]{importFile}, "The {0} zip file contains directory entries that are not valid."));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validateToken3");
        }
    }

    private void validateToken4(Session session, String currentToken, String importFile) throws CommandValidationException, WorkSpaceException, NoItemFoundException {
        String methodName = "validateToken4";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validateToken4", new Object[]{session, currentToken, importFile});
        }
        String policyTypeName = currentToken;
        List<String> allPolicyTypes = PolicyTypeWorkSpaceHelper.listDefaultPolicyTypes(session);
        Iterator<String> allPolicyTypesIt = allPolicyTypes.iterator();
        boolean policyTypeFound = false;
        while (allPolicyTypesIt.hasNext() && !policyTypeFound) {
            String currentPolicyType = allPolicyTypesIt.next().toString();
            if (!policyTypeName.equals(currentPolicyType)) continue;
            policyTypeFound = true;
        }
        if (!policyTypeFound) {
            throw new CommandValidationException(CommonUtil.getFormattedMessage(this.resourceBundle, "CWPST0103E", new Object[]{importFile, policyTypeName}, "The {0} zip file contains a {1} policy that is not valid on this system."));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validateToken4");
        }
    }

    private void validateToken5(String currentToken, String importFile) throws CommandValidationException {
        String methodName = "validateToken5";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validateToken5", new Object[]{currentToken, importFile});
        }
        if (!currentToken.equals("bindings.xml")) {
            throw new CommandValidationException(CommonUtil.getFormattedMessage(this.resourceBundle, "CWPST0100E", new Object[]{importFile}, "The {0} zip file contains directory entries that are not valid."));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validateToken5");
        }
    }

    public void execute() {
        boolean createdNewImportFile;
        String importFile;
        block21: {
            String methodName = "execute";
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "execute");
            }
            CommandResultImpl result = new CommandResultImpl();
            this.setCommandResult(result);
            result.reset();
            Session session = this.getConfigSession();
            importFile = null;
            String bindingName = null;
            String verifyBindingType = null;
            createdNewImportFile = false;
            try {
                List domainList;
                super.validate();
                this.resourceBundle = ResourceBundle.getBundle("com.ibm.ws.policyset.admin.resources.policySetAdmin", this.getLocale());
                importFile = (String)this.getParameter("importFile");
                bindingName = (String)this.getParameter("bindingName");
                String domainName = (String)this.getParameter("domainName");
                verifyBindingType = (String)this.getParameter("verifyBindingType");
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "parameters: ", new Object[]{importFile, bindingName, domainName, verifyBindingType});
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "ImportBinding, Locale is " + this.getLocale().getDisplayName());
                }
                CommonUtil.setLocale(this.getLocale());
                CommonWorkSpaceHelper.validateCellLevelAdminAuthorization();
                if (bindingName != null && PolicySetBindingWorkSpaceHelper.doesNamedBindingExist(session, bindingName)) {
                    throw new DuplicateItemFoundException(CommonUtil.getFormattedMessage(this.resourceBundle, "CWPST0126E", new Object[]{bindingName}, "Duplicate binding is found: {0}"));
                }
                boolean setNewName = false;
                if (bindingName != null) {
                    setNewName = true;
                }
                if (domainName != null && !(domainList = PolicySetBindingCommandUtil.getValidDomains(session)).contains(domainName)) {
                    throw new CommandValidationException(CommonUtil.getFormattedMessage(this.resourceBundle, "CWPST0152E", new Object[]{domainName}, "The {0} domain name is not valid"));
                }
                boolean importStatus = false;
                if (bindingName != null) {
                    importFile = this.createNewImportFile(session, importFile, bindingName);
                    createdNewImportFile = true;
                }
                bindingName = this.validate(session, importFile);
                if (!setNewName && PolicySetBindingWorkSpaceHelper.doesNamedBindingExist(session, bindingName)) {
                    throw new DuplicateItemFoundException(CommonUtil.getFormattedMessage(this.resourceBundle, "CWPST0126E", new Object[]{bindingName}, "Duplicate binding is found: {0}"));
                }
                String filePath = CommonWorkSpaceHelper.getCellRepositoryPath(session);
                importStatus = this.importFiles(session, filePath, importFile);
                try {
                    String newBindingFile = PolicySetBindingWorkSpaceHelper.getNamedBindingDefinitionFile(session, bindingName);
                    BindingDefinitionHelper bindingHelper = BindingDefinitionHelperFactory.createHelper(newBindingFile);
                    bindingHelper.setLocale(CommonUtil.getLocale());
                    String bindingType = bindingHelper.getBindingType();
                    if (verifyBindingType != null && !verifyBindingType.equals(bindingType)) {
                        throw new CommandValidationException(CommonUtil.getFormattedMessage(this.resourceBundle, "CWPST0158E", new Object[]{bindingType, verifyBindingType}, "The imported binding type of {0} does not match the specified binding type of {1}"));
                    }
                    if (domainName != null) {
                        bindingHelper.setDomain(domainName);
                        PolicySetBindingWorkSpaceHelper.updateNamedBindingDefinitionFile(session, bindingName);
                    }
                    if (importStatus) {
                        result.setResult(Boolean.TRUE);
                        break block21;
                    }
                    result.setResult(Boolean.FALSE);
                }
                catch (Throwable t) {
                    FFDCFilter.processException(t, this.className, FFDC_ID_3);
                    try {
                        PolicySetBindingWorkSpaceHelper.deleteNamedBinding(session, bindingName);
                    }
                    catch (Throwable th) {
                        // empty catch block
                    }
                    result.setException(t);
                }
            }
            catch (Throwable t) {
                FFDCFilter.processException(t, this.className, FFDC_ID_1);
                result.setException(t);
            }
        }
        if (createdNewImportFile) {
            try {
                new File(importFile).delete();
            }
            catch (Throwable t) {
                FFDCFilter.processException(t, this.className, FFDC_ID_2);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "execute");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String createNewImportFile(Session session, String importFile, String newBindingName) throws IOException, WorkSpaceException, NoItemFoundException {
        String methodName = "createNewImportFile";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createNewImportFile", new Object[]{session, importFile, newBindingName});
        }
        String path = CommonWorkSpaceHelper.getCellRepositoryPath(session);
        String tempImportFileName = path + "/" + System.currentTimeMillis();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "tempImportFileName: " + tempImportFileName);
        }
        FileInputStream fis = null;
        FileOutputStream fos = null;
        ZipInputStream zis = null;
        ZipOutputStream zos = null;
        try {
            fis = new FileInputStream(importFile);
            zis = new ZipInputStream(fis);
            fos = new FileOutputStream(tempImportFileName);
            zos = new ZipOutputStream(fos);
            ZipEntry ze = null;
            while ((ze = zis.getNextEntry()) != null) {
                if (ze.isDirectory()) continue;
                String entry = ze.getName();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "entry: " + entry);
                }
                String slash = null;
                slash = entry.indexOf("/") != -1 ? "/" : "\\";
                int firstSlash = entry.indexOf(slash);
                int secondSlash = entry.indexOf(slash, firstSlash + 1);
                entry = entry.substring(0, firstSlash + 1) + newBindingName + entry.substring(secondSlash);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "writing entry: " + entry);
                }
                ZipEntry newEntry = new ZipEntry(entry);
                zos.putNextEntry(newEntry);
                int bytes = 0;
                byte[] buffer = new byte[1024];
                while ((bytes = zis.read(buffer, 0, buffer.length)) > 0) {
                    zos.write(buffer, 0, bytes);
                }
                zis.closeEntry();
                zos.closeEntry();
            }
        }
        finally {
            if (zis != null) {
                zis.close();
            }
            if (fis != null) {
                fis.close();
            }
            if (zos != null) {
                zos.close();
            }
            if (fos != null) {
                fos.close();
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createNewImportFile", tempImportFileName);
        }
        return tempImportFileName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean importFiles(Session session, String filePath, String importFile) throws IOException, WorkSpaceException, NoItemFoundException {
        String methodName = "importFiles";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "importFiles", new Object[]{session, filePath, importFile});
        }
        boolean importStatus = false;
        ZipFile zipFile = null;
        String zipFullName = "";
        try {
            zipFile = new ZipFile(importFile);
            Enumeration<? extends ZipEntry> entries = zipFile.entries();
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                if (entry.isDirectory()) continue;
                zipFullName = entry.toString();
                String outFileName = PolicySetWorkSpaceHelper.getImportFileName(session, zipFullName, filePath);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "importFiles, zipFullName=" + zipFullName + " , outFileName=" + outFileName);
                }
                InputStream is = null;
                FilterOutputStream bos = null;
                FileOutputStream fos = null;
                try {
                    int len;
                    is = zipFile.getInputStream(entry);
                    fos = new FileOutputStream(outFileName);
                    bos = new BufferedOutputStream(fos);
                    byte[] buffer = new byte[1024];
                    while ((len = is.read(buffer)) >= 0) {
                        ((BufferedOutputStream)bos).write(buffer, 0, len);
                    }
                }
                finally {
                    if (is != null) {
                        is.close();
                    }
                    if (bos != null) {
                        bos.close();
                    }
                    if (fos == null) continue;
                    fos.close();
                }
            }
        }
        finally {
            zipFile.close();
        }
        importStatus = true;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "importFiles", importStatus);
        }
        return importStatus;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List getZipFileList(String importFile) throws IOException {
        String methodName = "getZipFileList";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getZipFileList", importFile);
        }
        ArrayList<String> fileList = new ArrayList<String>();
        fileList.clear();
        ZipFile zfile = null;
        try {
            zfile = new ZipFile(importFile);
            Enumeration<? extends ZipEntry> entries = zfile.entries();
            while (entries.hasMoreElements()) {
                String zfileEntryName = entries.nextElement().getName();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "getZipFileList, zfileEntryName=" + zfileEntryName);
                }
                fileList.add(zfileEntryName);
            }
        }
        finally {
            if (zfile != null) {
                zfile.close();
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getZipFileList", fileList);
        }
        return fileList;
    }
}

