/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.policyset.admin.commands;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.CommandLoadException;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commandmetadata.CommandMetadata;
import com.ibm.websphere.management.cmdframework.provider.AbstractAdminCommand;
import com.ibm.websphere.management.cmdframework.provider.CommandResultImpl;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.policyset.admin.commands.util.CommonUtil;
import com.ibm.ws.policyset.admin.commands.util.PolicySetBindingCommandUtil;
import java.util.Properties;
import java.util.ResourceBundle;

public class GetRequiredBindingVersion
extends AbstractAdminCommand {
    private static TraceComponent tc = Tr.register(GetRequiredBindingVersion.class, "policyset.admin", "com.ibm.ws.policyset.admin.resources.policySetAdmin");
    private ResourceBundle resourceBundle = null;
    private static final String FFDC_ID_1 = "FFDC-1";
    private String className = this.getClass().getName();

    public GetRequiredBindingVersion(CommandMetadata metadata) throws CommandNotFoundException {
        super(metadata);
    }

    public GetRequiredBindingVersion(CommandData commandData) throws CommandNotFoundException, CommandLoadException {
        super(commandData);
    }

    public void execute() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "execute");
        }
        CommandResultImpl result = new CommandResultImpl();
        this.setCommandResult(result);
        result.reset();
        Session session = this.getConfigSession();
        String version = null;
        try {
            super.validate();
            this.resourceBundle = ResourceBundle.getBundle("com.ibm.ws.policyset.admin.resources.policySetAdmin", this.getLocale());
            Properties assetProps = (Properties)this.getParameter("assetProps");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "parameters: ", new Object[]{assetProps});
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "GetRequiredBindingVersion, Locale is " + this.getLocale().getDisplayName());
            }
            CommonUtil.setLocale(this.getLocale());
            if (assetProps != null && !assetProps.isEmpty()) {
                if (!assetProps.containsKey("application")) {
                    throw new IllegalArgumentException(CommonUtil.getFormattedMessage(this.resourceBundle, "CWPST0114E", new Object[]{"assetProps"}, "The {0} parameter did not contain valid values"));
                }
            } else {
                throw new IllegalArgumentException(CommonUtil.getFormattedMessage(this.resourceBundle, "CWPST0069E", new Object[]{"assetProps"}, "The {0} input parameter is missing or not validr"));
            }
            version = PolicySetBindingCommandUtil.getRequiredBindingVersion(session, assetProps);
            result.setResult(version);
        }
        catch (Throwable t) {
            FFDCFilter.processException(t, this.className, FFDC_ID_1);
            result.setException(t);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "execute");
        }
    }
}

