/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.policyset.admin.commands;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.CommandLoadException;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commandmetadata.CommandMetadata;
import com.ibm.websphere.management.cmdframework.provider.AbstractAdminCommand;
import com.ibm.websphere.management.cmdframework.provider.CommandResultImpl;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.policyset.admin.PolicySetHelper;
import com.ibm.ws.policyset.admin.PolicySetHelperFactory;
import com.ibm.ws.policyset.admin.commands.util.CommonUtil;
import com.ibm.ws.policyset.admin.commands.util.PolicySetWorkSpaceHelper;
import java.util.Properties;

public class GetPolicySet
extends AbstractAdminCommand {
    private static TraceComponent tc = Tr.register(GetPolicySet.class, "policyset.admin", "com.ibm.ws.policyset.admin.resources.policySetAdmin");
    private static final String FFDC_ID_1 = "FFDC-1";
    private String className = this.getClass().getName();

    public GetPolicySet(CommandMetadata metadata) throws CommandNotFoundException {
        super(metadata);
    }

    public GetPolicySet(CommandData commandData) throws CommandNotFoundException, CommandLoadException {
        super(commandData);
    }

    public void execute() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "execute");
        }
        CommandResultImpl result = new CommandResultImpl();
        this.setCommandResult(result);
        result.reset();
        Session session = this.getConfigSession();
        try {
            super.validate();
            String policySetName = (String)this.getParameter("policySet");
            Boolean fromDefaultRepositoryB = (Boolean)this.getParameter("fromDefaultRepository");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "parameters: ", new Object[]{policySetName, fromDefaultRepositoryB});
            }
            boolean fromDefaultRepository = false;
            if (fromDefaultRepositoryB != null) {
                fromDefaultRepository = fromDefaultRepositoryB;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "GetPolicySet, Locale is " + this.getLocale().getDisplayName());
            }
            CommonUtil.setLocale(this.getLocale());
            String pathname = PolicySetWorkSpaceHelper.getPolicySetFile(session, policySetName, fromDefaultRepository);
            PolicySetHelper psHelper = PolicySetHelperFactory.createHelper(pathname);
            psHelper.setLocale(this.getLocale());
            Properties props = psHelper.getPolicySet();
            result.setResult(props);
        }
        catch (Throwable t) {
            FFDCFilter.processException(t, this.className, FFDC_ID_1);
            result.setException(t);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "execute");
        }
    }
}

