/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.policyset.admin.commands;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.CommandLoadException;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commandmetadata.CommandMetadata;
import com.ibm.websphere.management.cmdframework.provider.AbstractAdminCommand;
import com.ibm.websphere.management.cmdframework.provider.CommandResultImpl;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.policyset.admin.DefaultBindingsHelper;
import com.ibm.ws.policyset.admin.DefaultBindingsHelperFactory;
import com.ibm.ws.policyset.admin.commands.util.CommonUtil;
import com.ibm.ws.policyset.admin.commands.util.PolicySetBindingWorkSpaceHelper;
import java.util.Properties;
import java.util.ResourceBundle;

public class GetDefaultBindings
extends AbstractAdminCommand {
    private static TraceComponent tc = Tr.register(GetDefaultBindings.class, "policyset.admin", "com.ibm.ws.policyset.admin.resources.policySetAdmin");
    private ResourceBundle resourceBundle = null;
    private static final String FFDC_ID_1 = "FFDC-1";
    private String className = this.getClass().getName();

    public GetDefaultBindings(CommandMetadata metadata) throws CommandNotFoundException {
        super(metadata);
    }

    public GetDefaultBindings(CommandData commandData) throws CommandNotFoundException, CommandLoadException {
        super(commandData);
    }

    public void execute() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "execute");
        }
        CommandResultImpl result = new CommandResultImpl();
        this.setCommandResult(result);
        result.reset();
        Session session = this.getConfigSession();
        String node = null;
        String server = null;
        boolean forDomain = true;
        try {
            super.validate();
            this.resourceBundle = ResourceBundle.getBundle("com.ibm.ws.policyset.admin.resources.policySetAdmin", this.getLocale());
            Properties bindingLocation = (Properties)this.getParameter("bindingLocation");
            String domainName = (String)this.getParameter("domainName");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "parameters: ", new Object[]{bindingLocation, domainName});
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "GetDefaultBindings, Locale is " + this.getLocale().getDisplayName());
            }
            CommonUtil.setLocale(this.getLocale());
            if (domainName != null && bindingLocation != null) {
                throw new IllegalArgumentException(CommonUtil.getFormattedMessage(this.resourceBundle, "CWPST0131E", new Object[]{"domainName", "bindingLocation"}, "The {1} parameter cannot be used if the {0} parameter is specified"));
            }
            if (bindingLocation != null && !bindingLocation.isEmpty()) {
                if (!bindingLocation.containsKey("node") || !bindingLocation.containsKey("server")) {
                    throw new IllegalArgumentException(CommonUtil.getFormattedMessage(this.resourceBundle, "CWPST0047E", new Object[0], "A required property was not found for the bindingLocation parameter"));
                }
                node = bindingLocation.getProperty("node");
                server = bindingLocation.getProperty("server");
                forDomain = false;
                String warningMsg = CommonUtil.getFormattedMessage(this.resourceBundle, "CWPST0143W", new Object[0], "The bindingLocation properties of node and server are deprecated");
                result.addWarnings(warningMsg);
            } else if (domainName == null) {
                domainName = "global";
            }
            Properties bindingProps = new Properties();
            String bindingsFile = PolicySetBindingWorkSpaceHelper.getDefaultBindingsFile(session);
            if (bindingsFile != null) {
                DefaultBindingsHelper helper = DefaultBindingsHelperFactory.createHelper(bindingsFile);
                helper.setLocale(this.getLocale());
                bindingProps = forDomain ? helper.getDomainDefaults(domainName) : helper.getServerDefaults(server, node);
            }
            result.setResult(bindingProps);
        }
        catch (Throwable t) {
            FFDCFilter.processException(t, this.className, FFDC_ID_1);
            result.setException(t);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "execute");
        }
    }
}

