/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.policyset.admin.commands;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.CommandLoadException;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commandmetadata.CommandMetadata;
import com.ibm.websphere.management.cmdframework.provider.AbstractAdminCommand;
import com.ibm.websphere.management.cmdframework.provider.CommandResultImpl;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.policyset.admin.PolicySetAttachmentHelper;
import com.ibm.ws.policyset.admin.PolicySetAttachmentHelperFactory;
import com.ibm.ws.policyset.admin.PolicySetHelper;
import com.ibm.ws.policyset.admin.PolicySetHelperFactory;
import com.ibm.ws.policyset.admin.commands.util.CommonUtil;
import com.ibm.ws.policyset.admin.commands.util.CommonWorkSpaceHelper;
import com.ibm.ws.policyset.admin.commands.util.PolicySetAttachmentCommandUtil;
import com.ibm.ws.policyset.admin.commands.util.PolicySetAttachmentWorkSpaceHelper;
import com.ibm.ws.policyset.admin.commands.util.PolicySetWorkSpaceHelper;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.ResourceBundle;

public class DeleteAttachmentsForPolicySet
extends AbstractAdminCommand {
    private static TraceComponent tc = Tr.register(DeleteAttachmentsForPolicySet.class, "policyset.admin", "com.ibm.ws.policyset.admin.resources.policySetAdmin");
    private static final String FFDC_ID_1 = "FFDC-1";
    private ResourceBundle resourceBundle = null;
    private String className = this.getClass().getName();

    public DeleteAttachmentsForPolicySet(CommandMetadata metadata) throws CommandNotFoundException {
        super(metadata);
    }

    public DeleteAttachmentsForPolicySet(CommandData commandData) throws CommandNotFoundException, CommandLoadException {
        super(commandData);
    }

    public void execute() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "execute");
        }
        CommandResultImpl result = new CommandResultImpl();
        this.setCommandResult(result);
        result.reset();
        Session session = this.getConfigSession();
        try {
            super.validate();
            this.resourceBundle = ResourceBundle.getBundle("com.ibm.ws.policyset.admin.resources.policySetAdmin", this.getLocale());
            String policySetName = (String)this.getParameter("policySet");
            String applicationName = (String)this.getParameter("applicationName");
            Properties attachmentProperties = (Properties)this.getParameter("attachmentProperties");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "parameters: ", new Object[]{policySetName, applicationName, attachmentProperties});
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "DeleteAttachmentsForPolicySet, Locale is " + this.getLocale().getDisplayName());
            }
            CommonUtil.setLocale(this.getLocale());
            String psPathname = PolicySetWorkSpaceHelper.getPolicySetFile(session, policySetName, false);
            PolicySetHelper helper = PolicySetHelperFactory.createHelper(psPathname);
            helper.setLocale(this.getLocale());
            String policySetType = helper.getPolicySetType();
            int rc = 0;
            int master_rc = 0;
            String pathname = null;
            if (policySetType.equals("system/trust") || policySetType.equals("system")) {
                CommonWorkSpaceHelper.validateAttachmentAuthorization("system/trust", null);
                pathname = PolicySetAttachmentWorkSpaceHelper.getTrustAttachmentFile(session);
                master_rc = this.deleteAttachmentsFromFile(session, pathname, policySetName, policySetType);
                PolicySetAttachmentCommandUtil.removePolicySetFromMexAttachments(session, policySetName, null, applicationName);
            } else if (policySetType.equals("application")) {
                String resourceName;
                PolicySetAttachmentHelper attachmentHelper;
                List<Object> serviceAppFilenames = new ArrayList();
                List<Object> clientAppFilenames = new ArrayList();
                List<Object> wsnClientFilenames = new ArrayList();
                if (applicationName != null) {
                    Properties p = new Properties();
                    p.setProperty("application", applicationName);
                    serviceAppFilenames = PolicySetAttachmentWorkSpaceHelper.listPolicySetAttachmentFiles(session, "application", p);
                    clientAppFilenames = PolicySetAttachmentWorkSpaceHelper.listPolicySetAttachmentFiles(session, "client", p);
                    if (serviceAppFilenames.isEmpty() && clientAppFilenames.isEmpty()) {
                        throw new FileNotFoundException(CommonUtil.getFormattedMessage(this.resourceBundle, "CWPST0041E", new Object[]{applicationName}, "Policy attachment file is not found for application: {0}"));
                    }
                }
                if (attachmentProperties != null) {
                    boolean validValues = false;
                    String string = attachmentProperties.getProperty("bus");
                    String wsnService = attachmentProperties.getProperty("WSNService");
                    if (string != null && wsnService != null) {
                        validValues = true;
                        Properties p = new Properties();
                        p.setProperty("bus", string);
                        p.setProperty("WSNService", wsnService);
                        wsnClientFilenames = PolicySetAttachmentWorkSpaceHelper.listPolicySetAttachmentFiles(session, "WSNClient", p);
                        if (wsnClientFilenames.isEmpty()) {
                            throw new FileNotFoundException(CommonUtil.getFormattedMessage(this.resourceBundle, "CWPST0108E", new Object[]{string, wsnService}, "The policy attachment file is not found for bus: {0} WSN service: {1}."));
                        }
                    }
                    if (!validValues) {
                        throw new IllegalArgumentException(CommonUtil.getFormattedMessage(this.resourceBundle, "CWPST0114E", new Object[]{"attachmentProperties"}, "The {0} parameter did not contain valid values."));
                    }
                }
                if (applicationName == null && attachmentProperties == null) {
                    serviceAppFilenames = PolicySetAttachmentWorkSpaceHelper.listPolicySetAttachmentFiles(session, "application");
                    clientAppFilenames = PolicySetAttachmentWorkSpaceHelper.listPolicySetAttachmentFiles(session, "client");
                    wsnClientFilenames = PolicySetAttachmentWorkSpaceHelper.listPolicySetAttachmentFiles(session, "WSNClient");
                }
                for (String string : serviceAppFilenames) {
                    attachmentHelper = PolicySetAttachmentHelperFactory.createHelper(string);
                    attachmentHelper.setLocale(CommonUtil.getLocale());
                    if (!attachmentHelper.isAttachedToPolicySet(policySetName)) continue;
                    resourceName = PolicySetAttachmentCommandUtil.getResourceFromAttachmentFile(string, "application");
                    CommonWorkSpaceHelper.validateAttachmentAuthorization("application", resourceName);
                }
                for (String string : clientAppFilenames) {
                    attachmentHelper = PolicySetAttachmentHelperFactory.createHelper(string);
                    attachmentHelper.setLocale(CommonUtil.getLocale());
                    if (!attachmentHelper.isAttachedToPolicySet(policySetName)) continue;
                    resourceName = PolicySetAttachmentCommandUtil.getResourceFromAttachmentFile(string, "client");
                    CommonWorkSpaceHelper.validateAttachmentAuthorization("client", resourceName);
                }
                for (String string : wsnClientFilenames) {
                    attachmentHelper = PolicySetAttachmentHelperFactory.createHelper(string);
                    attachmentHelper.setLocale(CommonUtil.getLocale());
                    if (!attachmentHelper.isAttachedToPolicySet(policySetName)) continue;
                    resourceName = PolicySetAttachmentCommandUtil.getResourceFromAttachmentFile(string, "WSNClient");
                    CommonWorkSpaceHelper.validateAttachmentAuthorization("WSNClient", resourceName);
                }
                for (String string : serviceAppFilenames) {
                    rc = this.deleteAttachmentsFromFile(session, string, policySetName, "application");
                    master_rc += rc;
                }
                for (String string : clientAppFilenames) {
                    rc = this.deleteAttachmentsFromFile(session, string, policySetName, "client");
                    master_rc += rc;
                }
                for (String string : wsnClientFilenames) {
                    rc = this.deleteAttachmentsFromFile(session, string, policySetName, "WSNClient");
                    master_rc += rc;
                }
            }
            if (master_rc == 0) {
                result.setResult(Boolean.TRUE);
            } else {
                result.setResult(Boolean.FALSE);
            }
        }
        catch (Throwable t) {
            FFDCFilter.processException(t, this.className + ".execute()", FFDC_ID_1);
            result.setException(t);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "execute");
        }
    }

    private int deleteAttachmentsFromFile(Session session, String pathname, String policySetName, String attachmentType) throws Exception {
        int rc = 0;
        PolicySetAttachmentHelper psHelper = PolicySetAttachmentHelperFactory.createHelper(pathname);
        psHelper.setLocale(this.getLocale());
        boolean isAttached = psHelper.isAttachedToPolicySet(policySetName);
        if (isAttached) {
            String applicationName = null;
            if ((attachmentType.equals("application") || attachmentType.equals("client")) && (applicationName = this.getApplicationName(pathname, attachmentType)) == null) {
                throw new Exception(CommonUtil.getFormattedMessage(this.resourceBundle, "CWPST0040E", new Object[0], "Error in finding application name in file path"));
            }
            String busName = null;
            String serviceName = null;
            if (attachmentType.equals("WSNClient")) {
                Properties wsnBusService = PolicySetAttachmentCommandUtil.getWSNClientBusServiceName(pathname);
                if (wsnBusService != null) {
                    busName = wsnBusService.getProperty("bus");
                    serviceName = wsnBusService.getProperty("WSNService");
                }
                if (busName == null || serviceName == null) {
                    throw new Exception(CommonUtil.getFormattedMessage(this.resourceBundle, "CWPST0113E", new Object[0], "The system could not find the WSN service in the file path."));
                }
            }
            if (attachmentType.equals("application")) {
                List<String> psrs = psHelper.getPolicySetResources(policySetName, "name");
                PolicySetAttachmentWorkSpaceHelper.removeWSPolicy(session, applicationName, psrs);
            }
            rc = psHelper.detachPolicySet(policySetName);
            boolean attachmentEmpty = psHelper.isAttachmentListEmpty();
            if (attachmentType.equals("system/trust") || attachmentType.equals("system")) {
                if (attachmentEmpty) {
                    PolicySetAttachmentWorkSpaceHelper.deleteTrustAttachmentFile(session);
                } else {
                    PolicySetAttachmentWorkSpaceHelper.updateTrustAttachmentFile(session);
                }
            } else if (attachmentType.equals("application")) {
                if (attachmentEmpty) {
                    PolicySetAttachmentWorkSpaceHelper.deletePolicySetAttachmentFile(session, applicationName);
                } else {
                    PolicySetAttachmentWorkSpaceHelper.updatePolicySetAttachmentFile(session, applicationName);
                }
            } else if (attachmentType.equals("client")) {
                if (attachmentEmpty) {
                    PolicySetAttachmentWorkSpaceHelper.deleteClientAttachmentFile(session, applicationName);
                } else {
                    PolicySetAttachmentWorkSpaceHelper.updateClientAttachmentFile(session, applicationName);
                }
            } else if (attachmentType.equals("WSNClient")) {
                if (attachmentEmpty) {
                    PolicySetAttachmentWorkSpaceHelper.deleteWSNClientAttachmentFile(session, busName, serviceName);
                } else {
                    PolicySetAttachmentWorkSpaceHelper.updateWSNClientAttachmentFile(session, busName, serviceName);
                }
            }
        }
        return rc;
    }

    private String getApplicationName(String pathname, String policySetType) {
        String applicationName = null;
        String dirName = null;
        if (pathname.contains("policyAttachments.xml")) {
            dirName = pathname.substring(0, pathname.indexOf("policyAttachments.xml") - 1);
        } else if (pathname.contains("clientPolicyAttachments.xml")) {
            dirName = pathname.substring(0, pathname.indexOf("clientPolicyAttachments.xml") - 1);
        }
        if (dirName != null) {
            dirName = dirName.substring(0, dirName.lastIndexOf(File.separator));
            applicationName = dirName.substring(dirName.lastIndexOf(File.separator) + 1);
        }
        return applicationName;
    }
}

