/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.policyset.admin.commands;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.CommandLoadException;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.CommandValidationException;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commandmetadata.CommandMetadata;
import com.ibm.websphere.management.cmdframework.provider.AbstractAdminCommand;
import com.ibm.websphere.management.cmdframework.provider.CommandResultImpl;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.policyset.admin.PolicySetAttachmentHelper;
import com.ibm.ws.policyset.admin.PolicySetAttachmentHelperFactory;
import com.ibm.ws.policyset.admin.commands.util.CommonUtil;
import com.ibm.ws.policyset.admin.commands.util.CommonWorkSpaceHelper;
import com.ibm.ws.policyset.admin.commands.util.PolicySetAttachmentCommandUtil;
import com.ibm.ws.policyset.admin.commands.util.PolicySetAttachmentWorkSpaceHelper;
import com.ibm.ws.policyset.admin.commands.util.PolicySetWorkSpaceHelper;
import java.util.Properties;
import java.util.ResourceBundle;

public class CreatePolicySetAttachment
extends AbstractAdminCommand {
    private static TraceComponent tc = Tr.register(CreatePolicySetAttachment.class, "policyset.admin", "com.ibm.ws.policyset.admin.resources.policySetAdmin");
    private ResourceBundle resourceBundle = null;
    private static final String FFDC_ID_1 = "FFDC-1";
    private static final String FFDC_ID_2 = "FFDC-2";
    private static final String FFDC_ID_3 = "FFDC-3";
    private String className = this.getClass().getName();
    private String existingAttachmentID = null;

    public CreatePolicySetAttachment(CommandMetadata metadata) throws CommandNotFoundException {
        super(metadata);
    }

    public CreatePolicySetAttachment(CommandData commandData) throws CommandNotFoundException, CommandLoadException {
        super(commandData);
    }

    private void validate(Session session, String applicationName, String policySetName, String[] policySetResources, String attachmentType, String attachmentFile, boolean dynamicClient, Properties attachmentProperties, PolicySetAttachmentHelper psAttachmentHelper) throws CommandValidationException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validate");
        }
        try {
            PolicySetWorkSpaceHelper.getPolicySetFile(session, policySetName, false);
            if (!dynamicClient) {
                if (attachmentType.equals("system/trust")) {
                    StringBuffer resourcesInvalid = new StringBuffer("");
                    resourcesInvalid = PolicySetAttachmentCommandUtil.validateTrustResources(session, policySetResources);
                    if (resourcesInvalid.length() > 0) {
                        throw new CommandValidationException(CommonUtil.getFormattedMessage(this.resourceBundle, "CWPST0011E", new Object[]{resourcesInvalid.toString()}, "The following list of resources are invalid: {0}"));
                    }
                } else {
                    StringBuffer resourcesNotFound = new StringBuffer("");
                    resourcesNotFound = PolicySetAttachmentCommandUtil.validateResourcesForApplication(session, applicationName, policySetResources, attachmentType, policySetName, attachmentProperties);
                    if (resourcesNotFound.length() > 0) {
                        throw new CommandValidationException(CommonUtil.getFormattedMessage(this.resourceBundle, "CWPST0011E", new Object[]{resourcesNotFound.toString()}, "The following list of resources are invalid: {0}"));
                    }
                }
                StringBuffer resourcesAttached = new StringBuffer("");
                resourcesAttached = PolicySetAttachmentCommandUtil.validateResourcesNotAttached(attachmentType, attachmentFile, policySetResources, null, false);
                if (resourcesAttached.length() > 0) {
                    if (policySetResources.length != 1 || psAttachmentHelper.getIdForPolicySetAttachment(policySetResources[0]) != null) {
                        if (attachmentType.equals("WSNClient")) {
                            throw new CommandValidationException(CommonUtil.getFormattedMessage(this.resourceBundle, "CWPST0112E", new Object[]{resourcesAttached.toString()}, "The following list of resources are already attached to the WSN service: {0}"));
                        }
                        throw new CommandValidationException(CommonUtil.getFormattedMessage(this.resourceBundle, "CWPST0013E", new Object[]{resourcesAttached.toString()}, "The following list of resources are already attached to the application: {0}"));
                    }
                    this.existingAttachmentID = psAttachmentHelper.getIdForProviderPolicySetAttachment(policySetResources[0]);
                }
            }
        }
        catch (CommandValidationException e) {
            FFDCFilter.processException(e, this.className, FFDC_ID_1);
            throw e;
        }
        catch (Throwable t) {
            FFDCFilter.processException(t, this.className, FFDC_ID_2);
            throw new CommandValidationException(t, CommonUtil.getFormattedMessage(this.resourceBundle, "CWPST0006E", null, "Unexpected exception during command validation."));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validate");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void execute() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "execute");
        }
        CommandResultImpl result = new CommandResultImpl();
        this.setCommandResult(result);
        result.reset();
        Session session = this.getConfigSession();
        String applicationName = null;
        String attachmentType = null;
        boolean newfile = false;
        String busName = null;
        String serviceName = null;
        try {
            super.validate();
            this.resourceBundle = ResourceBundle.getBundle("com.ibm.ws.policyset.admin.resources.policySetAdmin", this.getLocale());
            applicationName = (String)this.getParameter("applicationName");
            String policySetName = (String)this.getParameter("policySet");
            String[] policySetResources = (String[])this.getParameter("resources");
            attachmentType = (String)this.getParameter("attachmentType");
            Boolean isDynamicClient = (Boolean)this.getParameter("dynamicClient");
            Properties attachmentProperties = (Properties)this.getParameter("attachmentProperties");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "parameters: ", new Object[]{applicationName, policySetName, policySetResources, attachmentType, isDynamicClient, attachmentProperties});
            }
            if (attachmentType == null) {
                attachmentType = "application";
            }
            boolean dynamicClient = false;
            if (isDynamicClient != null && (dynamicClient = isDynamicClient.booleanValue()) && !attachmentType.equals("client")) {
                throw new IllegalArgumentException(CommonUtil.getFormattedMessage(this.resourceBundle, "CWPST0036E", new Object[0], "Dynamic client only allowed when attachment type is client"));
            }
            String systemType = null;
            if (attachmentProperties != null) {
                busName = attachmentProperties.getProperty("bus");
                serviceName = attachmentProperties.getProperty("WSNService");
                if (busName == null && serviceName != null || busName != null && serviceName == null) {
                    throw new IllegalArgumentException(CommonUtil.getFormattedMessage(this.resourceBundle, "CWPST0030E", new Object[]{"bus", "WSNService"}, "The {0} input argument must also be specified with the {1} input argument."));
                }
                if (busName != null && serviceName != null) {
                    if (!attachmentType.equals("client")) {
                        throw new IllegalArgumentException(CommonUtil.getFormattedMessage(this.resourceBundle, "CWPST0110E", new Object[]{"bus", "WSNService", "attachmentProperties"}, "The client attachment type is required when {0} and {1} are specified for the {2} parameter"));
                    }
                    attachmentType = "WSNClient";
                }
                if ((systemType = attachmentProperties.getProperty("systemType")) != null) {
                    if (attachmentType.equals("client") || attachmentType.equals("WSNClient")) {
                        throw new IllegalArgumentException(CommonUtil.getFormattedMessage(this.resourceBundle, "CWPST0146E", new Object[]{"attachmentProperties", systemType}, "The application or provider attachment type is required when the systemType property in the {0} parameter is: {1}"));
                    }
                    if (!systemType.equals("trustService")) throw new IllegalArgumentException(CommonUtil.getFormattedMessage(this.resourceBundle, "CWPST0147E", new Object[]{"systemType"}, "The {0} property does not contain a valid value"));
                    attachmentType = "system/trust";
                }
            } else if (applicationName == null && (attachmentType.equals("application") || attachmentType.equals("client") || attachmentType.equals("provider"))) {
                throw new IllegalArgumentException(CommonUtil.getFormattedMessage(this.resourceBundle, "CWPST0034E", new Object[]{attachmentType}, "The application name is required when attachment type is {0} and the attachmentProperties parameter is not specified"));
            }
            if (attachmentType.equals("provider")) {
                attachmentType = "application";
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "CreatePolicySetAttachment, Locale is " + this.getLocale().getDisplayName());
            }
            CommonUtil.setLocale(this.getLocale());
            String resourceName = applicationName;
            if (attachmentType.equals("WSNClient")) {
                resourceName = busName;
            }
            CommonWorkSpaceHelper.validateAttachmentAuthorization(attachmentType, resourceName);
            String pathname = null;
            if (attachmentType.equals("application")) {
                pathname = PolicySetAttachmentWorkSpaceHelper.getPolicySetAttachmentFile(session, applicationName);
                if (pathname == null) {
                    pathname = PolicySetAttachmentWorkSpaceHelper.createPolicySetAttachmentFile(session, applicationName);
                    newfile = true;
                }
            } else if (attachmentType.equals("system/trust")) {
                pathname = PolicySetAttachmentWorkSpaceHelper.getTrustAttachmentFile(session);
                if (pathname == null) {
                    pathname = PolicySetAttachmentWorkSpaceHelper.createTrustAttachmentFile(session);
                    newfile = true;
                }
            } else if (attachmentType.equals("client")) {
                pathname = PolicySetAttachmentWorkSpaceHelper.getClientAttachmentFile(session, applicationName);
                if (pathname == null) {
                    pathname = PolicySetAttachmentWorkSpaceHelper.createClientAttachmentFile(session, applicationName);
                    newfile = true;
                }
            } else {
                if (!attachmentType.equals("WSNClient")) throw new IllegalArgumentException(CommonUtil.getFormattedMessage(this.resourceBundle, "CWPST0035E", new Object[]{attachmentType}, "Invalid attachment type: {0}"));
                pathname = PolicySetAttachmentWorkSpaceHelper.getWSNClientAttachmentFile(session, busName, serviceName);
                if (pathname == null) {
                    pathname = PolicySetAttachmentWorkSpaceHelper.createWSNClientAttachmentFile(session, busName, serviceName);
                    newfile = true;
                }
            }
            PolicySetAttachmentHelper psHelper = PolicySetAttachmentHelperFactory.createHelper(pathname);
            psHelper.setLocale(this.getLocale());
            if (newfile) {
                psHelper.createPolicySetAttachment();
            }
            String policySetID = null;
            if (pathname == null) throw new Exception(CommonUtil.getFormattedMessage(this.resourceBundle, "CWPST0038E", new Object[0], "Error in creating Policy Set Attachment file"));
            this.validate(session, applicationName, policySetName, policySetResources, attachmentType, pathname, dynamicClient, attachmentProperties, psHelper);
            if (this.existingAttachmentID == null) {
                policySetID = psHelper.attachPolicySet(policySetName, attachmentType, policySetResources);
            } else {
                psHelper.addPolicySetToAttachment(this.existingAttachmentID, policySetName);
                policySetID = this.existingAttachmentID;
            }
            if (!newfile) {
                if (attachmentType.equals("application")) {
                    PolicySetAttachmentWorkSpaceHelper.updatePolicySetAttachmentFile(session, applicationName);
                } else if (attachmentType.equals("system/trust")) {
                    PolicySetAttachmentWorkSpaceHelper.updateTrustAttachmentFile(session);
                } else if (attachmentType.equals("client")) {
                    PolicySetAttachmentWorkSpaceHelper.updateClientAttachmentFile(session, applicationName);
                } else if (attachmentType.equals("WSNClient")) {
                    PolicySetAttachmentWorkSpaceHelper.updateWSNClientAttachmentFile(session, busName, serviceName);
                }
            }
            if (policySetID == null) {
                throw new Exception(CommonUtil.getFormattedMessage(this.resourceBundle, "CWPST0039E", new Object[0], "Error in retrieving Policy Set ID, value is null"));
            }
            result.setResult(policySetID);
        }
        catch (Throwable t) {
            FFDCFilter.processException(t, this.className + ".execute()", FFDC_ID_3);
            try {
                if (newfile) {
                    if (attachmentType.equals("application")) {
                        PolicySetAttachmentWorkSpaceHelper.deletePolicySetAttachmentFile(session, applicationName);
                    } else if (attachmentType.equals("system/trust")) {
                        PolicySetAttachmentWorkSpaceHelper.deleteTrustAttachmentFile(session);
                    } else if (attachmentType.equals("client")) {
                        PolicySetAttachmentWorkSpaceHelper.deleteClientAttachmentFile(session, applicationName);
                    } else if (attachmentType.equals("WSNClient")) {
                        PolicySetAttachmentWorkSpaceHelper.deleteWSNClientAttachmentFile(session, busName, serviceName);
                    }
                }
            }
            catch (Throwable th) {
                // empty catch block
            }
            result.setException(t);
        }
        if (!tc.isEntryEnabled()) return;
        Tr.exit(tc, "execute");
    }
}

