/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.policyset.admin.commands;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.CommandLoadException;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.CommandValidationException;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commandmetadata.CommandMetadata;
import com.ibm.websphere.management.cmdframework.provider.AbstractAdminCommand;
import com.ibm.websphere.management.cmdframework.provider.CommandResultImpl;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.policyset.admin.PolicySetHelper;
import com.ibm.ws.policyset.admin.PolicySetHelperFactory;
import com.ibm.ws.policyset.admin.commands.util.CommonUtil;
import com.ibm.ws.policyset.admin.commands.util.CommonWorkSpaceHelper;
import com.ibm.ws.policyset.admin.commands.util.PolicySetAttachmentCommandUtil;
import com.ibm.ws.policyset.admin.commands.util.PolicySetCommandUtil;
import com.ibm.ws.policyset.admin.commands.util.PolicySetWorkSpaceHelper;
import com.ibm.ws.policyset.admin.exceptions.NoItemFoundException;
import com.ibm.ws.sm.workspace.WorkSpaceException;
import java.util.List;
import java.util.Properties;
import java.util.ResourceBundle;

public class CopyPolicySet
extends AbstractAdminCommand {
    private static TraceComponent tc = Tr.register(CopyPolicySet.class, "policyset.admin", "com.ibm.ws.policyset.admin.resources.policySetAdmin");
    private ResourceBundle resourceBundle = null;
    private static final String FFDC_ID_1 = "FFDC-1";
    private String className = this.getClass().getName();

    public CopyPolicySet(CommandMetadata metadata) throws CommandNotFoundException {
        super(metadata);
    }

    public CopyPolicySet(CommandData commandData) throws CommandNotFoundException, CommandLoadException {
        super(commandData);
    }

    private List validate(Session session, String sourcePolicySetName, String newPolicySetName) throws CommandValidationException, WorkSpaceException, NoItemFoundException, Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validate");
        }
        PolicySetCommandUtil.validatePolicySetName(newPolicySetName);
        List<String> fileList = PolicySetWorkSpaceHelper.getPolicySetDirectoryFiles(session, sourcePolicySetName, false);
        if (fileList.size() < 1) {
            throw new CommandValidationException(CommonUtil.getFormattedMessage(this.resourceBundle, "CWPST0021E", new Object[]{sourcePolicySetName}, "The following policySet does not contain any files: {0}"));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validate");
        }
        return fileList;
    }

    public void execute() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "execute");
        }
        CommandResultImpl result = new CommandResultImpl();
        this.setCommandResult(result);
        result.reset();
        Session session = this.getConfigSession();
        try {
            super.validate();
            this.resourceBundle = ResourceBundle.getBundle("com.ibm.ws.policyset.admin.resources.policySetAdmin", this.getLocale());
            boolean transfer = false;
            String sourcePolicySetName = (String)this.getParameter("sourcePolicySet");
            String newPolicySetName = (String)this.getParameter("newPolicySet");
            String policySetDescription = (String)this.getParameter("newDescription");
            Boolean transferAttachments = (Boolean)this.getParameter("transferAttachments");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "parameters: ", new Object[]{sourcePolicySetName, newPolicySetName, policySetDescription, transferAttachments});
            }
            if (transferAttachments != null) {
                transfer = transferAttachments;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "CopyPolicySet, Locale is " + this.getLocale().getDisplayName());
            }
            CommonUtil.setLocale(this.getLocale());
            CommonWorkSpaceHelper.validateCellLevelAdminAuthorization();
            List fileList = this.validate(session, sourcePolicySetName, newPolicySetName);
            String filePath = CommonWorkSpaceHelper.getCellRepositoryPath(session);
            String newPolicySetFilePath = PolicySetWorkSpaceHelper.createPolicySet(session, newPolicySetName);
            boolean copyStatus = PolicySetWorkSpaceHelper.copyPolicySetFiles(session, fileList, filePath, sourcePolicySetName, newPolicySetName);
            Properties updatedValues = new Properties();
            updatedValues.setProperty("name", newPolicySetName);
            if (policySetDescription != null) {
                updatedValues.setProperty("description", policySetDescription);
            }
            updatedValues.setProperty("default", "false");
            int rc = 0;
            PolicySetHelper helper = PolicySetHelperFactory.createHelper(newPolicySetFilePath);
            helper.setLocale(this.getLocale());
            rc = helper.updatePolicySet(updatedValues, true);
            PolicySetWorkSpaceHelper.updatePolicySetFile(session, newPolicySetName);
            int transfer_rc = 0;
            if (transfer) {
                String policySetType = helper.getPolicySetType();
                transfer_rc = PolicySetAttachmentCommandUtil.transferAttachments(session, sourcePolicySetName, newPolicySetName, null, policySetType, null);
            }
            if (copyStatus && rc == 0 && transfer_rc == 0) {
                result.setResult(Boolean.TRUE);
            } else {
                result.setResult(Boolean.FALSE);
            }
        }
        catch (Throwable t) {
            FFDCFilter.processException(t, this.className, FFDC_ID_1);
            result.setException(t);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "execute");
        }
    }
}

