/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.pmi.server.modules;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.pmi.server.PmiAbstractModule;
import com.ibm.websphere.pmi.server.SpdLong;
import com.ibm.ws.pmi.server.PmiCallback;
import com.ibm.ws.pmi.server.modules.CachePerfModule;
import com.ibm.wsspi.pmi.stat.SPICountStatistic;

class TemplateModule
extends PmiAbstractModule {
    private static final long serialVersionUID = -2115703405193604011L;
    public static final String moduleID = "cacheModule";
    private static final int defaultLevel = 0;
    String template = null;
    protected SPICountStatistic hitsInMemory = null;
    protected SPICountStatistic hitsOnDisk = null;
    protected SPICountStatistic explicitInvalidations = null;
    protected SPICountStatistic lruInvalidations = null;
    protected SPICountStatistic timeoutInvalidations = null;
    protected SPICountStatistic entries = null;
    protected SPICountStatistic hitsRemote = null;
    protected SPICountStatistic misses = null;
    protected SPICountStatistic requestsFromClient = null;
    protected SPICountStatistic requestsFromJVM = null;
    protected SPICountStatistic explicitInvalidationsFromMemory = null;
    protected SPICountStatistic explicitInvalidationsFromDisk = null;
    protected SPICountStatistic explicitInvalidationsNoOp = null;
    protected SPICountStatistic explicitInvalidationsLocal = null;
    protected SPICountStatistic explicitInvalidationsRemote = null;
    protected SPICountStatistic remoteCreations = null;
    private static TraceComponent tc = Tr.register(CachePerfModule.class, null, "com.ibm.ws.pmi.properties.PMIMessages");
    String cacheType;

    public TemplateModule(String cacheName, String cacheType, String template) {
        this(cacheName, cacheType, template, null);
    }

    public TemplateModule(String cacheName, String cacheType, String template, PmiCallback callback) {
        super(moduleID, cacheName);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "new TemplateModule " + this + ", template=" + template);
        }
        this.submoduleName = "cacheModule.template";
        this.subinstanceName = template;
        this.type = 16;
        this.template = template;
        this.cacheType = cacheType;
        this.registerModule(this);
    }

    public String[] getPath() {
        return new String[]{moduleID, this.cacheType, this.instanceName, this.submoduleName, this.subinstanceName};
    }

    protected boolean longCreated(SpdLong data) {
        switch (data.getId()) {
            case 21: {
                this.hitsInMemory = (SPICountStatistic)((Object)data.getStatistic());
                return true;
            }
            case 22: {
                this.hitsOnDisk = (SPICountStatistic)((Object)data.getStatistic());
                return true;
            }
            case 27: {
                this.hitsRemote = (SPICountStatistic)((Object)data.getStatistic());
                return true;
            }
            case 26: {
                this.entries = (SPICountStatistic)((Object)data.getStatistic());
                return true;
            }
            case 23: {
                this.explicitInvalidations = (SPICountStatistic)((Object)data.getStatistic());
                return true;
            }
            case 24: {
                this.lruInvalidations = (SPICountStatistic)((Object)data.getStatistic());
                return true;
            }
            case 25: {
                this.timeoutInvalidations = (SPICountStatistic)((Object)data.getStatistic());
                return true;
            }
            case 28: {
                this.misses = (SPICountStatistic)((Object)data.getStatistic());
                return true;
            }
            case 29: {
                this.requestsFromClient = (SPICountStatistic)((Object)data.getStatistic());
                return true;
            }
            case 30: {
                this.requestsFromJVM = (SPICountStatistic)((Object)data.getStatistic());
                return true;
            }
            case 31: {
                this.explicitInvalidationsFromMemory = (SPICountStatistic)((Object)data.getStatistic());
                return true;
            }
            case 32: {
                this.explicitInvalidationsFromDisk = (SPICountStatistic)((Object)data.getStatistic());
                return true;
            }
            case 33: {
                this.explicitInvalidationsNoOp = (SPICountStatistic)((Object)data.getStatistic());
                return true;
            }
            case 34: {
                this.explicitInvalidationsLocal = (SPICountStatistic)((Object)data.getStatistic());
                return true;
            }
            case 35: {
                this.explicitInvalidationsRemote = (SPICountStatistic)((Object)data.getStatistic());
                return true;
            }
            case 36: {
                this.remoteCreations = (SPICountStatistic)((Object)data.getStatistic());
                return true;
            }
        }
        Tr.warning(tc, "PMI0008W", "cacheModule, dataID=" + data.getId());
        return false;
    }

    public String getModuleID() {
        return moduleID;
    }

    public int getDefaultLevel() {
        return 0;
    }
}

