/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.pmi.server.modules;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.pmi.ConnPoolPerf;
import com.ibm.websphere.pmi.PmiDataInfo;
import com.ibm.websphere.pmi.server.PmiAbstractModule;
import com.ibm.websphere.pmi.server.SpdData;
import com.ibm.websphere.pmi.server.SpdLoad;
import com.ibm.websphere.pmi.server.SpdLoadExternalValue;
import com.ibm.websphere.pmi.server.SpdLong;
import com.ibm.websphere.pmi.server.SpdStat;
import com.ibm.ws.pmi.server.DataDescriptor;
import com.ibm.ws.pmi.server.PmiRegistry;
import com.ibm.ws.pmi.server.data.SpdLoadExternal;
import com.ibm.ws.pmi.server.modules.ResourcePmiModule;
import com.ibm.ws.pmi.stat.BoundedRangeStatisticImpl;
import com.ibm.ws.pmi.stat.JDBCConnectionPoolStatsImpl;
import com.ibm.ws.pmi.stat.RangeStatisticImpl;
import com.ibm.ws.pmi.stat.StatsImpl;
import com.ibm.wsspi.pmi.stat.SPICountStatistic;
import com.ibm.wsspi.pmi.stat.SPIRangeStatistic;
import com.ibm.wsspi.pmi.stat.SPIStatistic;
import com.ibm.wsspi.pmi.stat.SPITimeStatistic;
import java.util.ArrayList;
import javax.management.ObjectName;

public class ConnPoolModule
extends PmiAbstractModule
implements ConnPoolPerf {
    private static final long serialVersionUID = 5202950542276992704L;
    private static final TraceComponent tc = Tr.register(ConnPoolModule.class, null, "com.ibm.ws.pmi.properties.PMIMessages");
    public static final String moduleID = "connectionPoolModule";
    private static final int defaultLevel = 0;
    private SPICountStatistic numCreates = null;
    private SPICountStatistic numDestroys = null;
    private SPICountStatistic numAllocates = null;
    private SPICountStatistic numReturns = null;
    private BoundedRangeStatisticImpl poolSize = null;
    private BoundedRangeStatisticImpl freePoolSize = null;
    private SPIRangeStatistic concurrentWaiters = null;
    private SPITimeStatistic avgWaitTime = null;
    private SPITimeStatistic avgUseTime = null;
    private SPICountStatistic faults = null;
    private SPICountStatistic prepStmtDiscards = null;
    private SPIRangeStatistic percentMaxed = null;
    public static final int NUM_CREATES = 1;
    public static final int NUM_DESTROYS = 2;
    public static final int NUM_ALLOCATES = 3;
    public static final int NUM_RETURNS = 4;
    public static final int POOL_SIZE = 5;
    public static final int FREE_POOL_SIZE = 6;
    public static final int CONCURRENT_WAITERS = 7;
    public static final int FAULTS = 8;
    public static final int PERCENT_USED = 9;
    public static final int PERCENT_MAXED = 10;
    public static final int AVG_USE_TIME = 12;
    public static final int AVG_WAIT_TIME = 13;
    public static final int NUM_MANAGED_CONNECTIONS = 14;
    public static final int NUM_CONNECTIONS = 15;
    public static final int PREPSTMT_DISCARDS = 21;
    ObjectName providerOName = null;
    ObjectName dsOName = null;
    String pName = null;
    private int localMaxPoolSize = 0;

    public ConnPoolModule(String dataSourceName, ObjectName providerObjectName, ObjectName factoryObjectName) {
        super(moduleID, dataSourceName);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "ConnPoolModule " + dataSourceName);
        }
        if (providerObjectName == null) {
            this.pName = "unknown";
        } else {
            DataDescriptor dd;
            this.pName = providerObjectName.getKeyProperty("name");
            if (this.pName == null) {
                this.pName = "undefined";
            }
            if (PmiRegistry.findPmiModule(dd = new DataDescriptor(new String[]{moduleID, this.pName})) == null) {
                new ResourcePmiModule(moduleID, this.pName, providerObjectName);
            }
        }
        this.providerOName = providerObjectName;
        this.dsOName = factoryObjectName;
        this.categoryName = "pool";
        this.registerModule(this);
    }

    public String[] getPath() {
        if (this.pName != null) {
            String pName = this.providerOName.getKeyProperty("name");
            return new String[]{moduleID, pName, this.instanceName};
        }
        Tr.warning(tc, "PMI9999E", "getPath: Provider ObjectName is null");
        return new String[]{moduleID, this.instanceName};
    }

    protected SpdData createOneData(PmiDataInfo info) {
        int dataId = info.getId();
        if (dataId == 9) {
            return new SpdLoadExternal(dataId, new PercentUsedData(dataId));
        }
        return super.createOneData(info);
    }

    protected boolean longCreated(SpdLong data) {
        switch (data.getId()) {
            case 1: {
                this.numCreates = (SPICountStatistic)((Object)data.getStatistic());
                return true;
            }
            case 2: {
                this.numDestroys = (SPICountStatistic)((Object)data.getStatistic());
                return true;
            }
            case 3: {
                this.numAllocates = (SPICountStatistic)((Object)data.getStatistic());
                return true;
            }
            case 4: {
                this.numReturns = (SPICountStatistic)((Object)data.getStatistic());
                return true;
            }
            case 8: {
                this.faults = (SPICountStatistic)((Object)data.getStatistic());
                return true;
            }
            case 21: {
                this.prepStmtDiscards = (SPICountStatistic)((Object)data.getStatistic());
                return true;
            }
            case 14: {
                return true;
            }
            case 15: {
                return true;
            }
        }
        return false;
    }

    protected boolean statCreated(SpdStat data) {
        switch (data.getId()) {
            case 13: {
                this.avgWaitTime = (SPITimeStatistic)((Object)data.getStatistic());
                return true;
            }
            case 12: {
                this.avgUseTime = (SPITimeStatistic)((Object)data.getStatistic());
                return true;
            }
        }
        return false;
    }

    protected boolean loadCreated(SpdLoad data) {
        switch (data.getId()) {
            case 5: {
                this.poolSize = (BoundedRangeStatisticImpl)data.getStatistic();
                return true;
            }
            case 6: {
                this.freePoolSize = (BoundedRangeStatisticImpl)data.getStatistic();
                return true;
            }
            case 7: {
                this.concurrentWaiters = (SPIRangeStatistic)((Object)data.getStatistic());
                return true;
            }
            case 10: {
                this.percentMaxed = (SPIRangeStatistic)((Object)data.getStatistic());
                return true;
            }
        }
        return false;
    }

    public String getModuleID() {
        return moduleID;
    }

    public int getDefaultLevel() {
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connectionCreated(int connectionCount) {
        if (this.numCreates != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "connectionCreated: connectionCount = " + connectionCount + ", dataSourceName = " + this.getName());
            }
            this.numCreates.increment();
        }
        if (this.poolSize != null && this.freePoolSize != null) {
            long curTime = System.currentTimeMillis();
            BoundedRangeStatisticImpl boundedRangeStatisticImpl = this.poolSize;
            synchronized (boundedRangeStatisticImpl) {
                this.poolSize.incrementWithoutSync(curTime, 1L);
                this.freePoolSize.incrementWithoutSync(curTime, 1L);
            }
        } else {
            if (this.poolSize != null) {
                this.poolSize.increment();
            }
            if (this.freePoolSize != null) {
                this.freePoolSize.increment();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connectionDestroyed(int connectionCount) {
        if (this.numDestroys != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "connectionDestroyed: connectionCount = " + connectionCount + ", dataSourceName = " + this.getName());
            }
            this.numDestroys.increment();
        }
        if (this.poolSize != null && this.freePoolSize != null) {
            long curTime = System.currentTimeMillis();
            BoundedRangeStatisticImpl boundedRangeStatisticImpl = this.poolSize;
            synchronized (boundedRangeStatisticImpl) {
                this.poolSize.decrementWithoutSync(curTime, 1L);
                this.freePoolSize.decrementWithoutSync(curTime, 1L);
            }
        } else {
            if (this.poolSize != null) {
                this.poolSize.decrement();
            }
            if (this.freePoolSize != null) {
                this.freePoolSize.decrement();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connectionAllocated(int maxPoolSize, int numConnectionsInUse) {
        this.localMaxPoolSize = maxPoolSize;
        if (this.numAllocates != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "connectionAllocated: maxPoolSize = " + maxPoolSize + ", numConnectionsInUse = " + numConnectionsInUse + ", dataSourceName = " + this.getName());
            }
            this.numAllocates.increment();
        }
        if (this.freePoolSize != null && this.percentMaxed != null) {
            long curTime = System.currentTimeMillis();
            BoundedRangeStatisticImpl boundedRangeStatisticImpl = this.freePoolSize;
            synchronized (boundedRangeStatisticImpl) {
                this.freePoolSize.decrementWithoutSync(curTime, 1L);
                if (numConnectionsInUse >= maxPoolSize) {
                    this.percentMaxed.set(curTime, 100L);
                }
            }
        } else {
            if (this.freePoolSize != null) {
                this.freePoolSize.decrement();
            }
            if (this.percentMaxed != null && numConnectionsInUse >= maxPoolSize) {
                this.percentMaxed.set(System.currentTimeMillis(), 100L);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connectionFreed(int maxPoolSize, int numConnectionsInUse) {
        this.localMaxPoolSize = maxPoolSize;
        if (this.numReturns != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "connectionFreed: maxPoolSize = " + maxPoolSize + ", numConnectionsInUse = " + numConnectionsInUse + ", dataSourceName = " + this.getName());
            }
            this.numReturns.increment();
        }
        if (this.freePoolSize != null && this.percentMaxed != null) {
            long curTime = System.currentTimeMillis();
            BoundedRangeStatisticImpl boundedRangeStatisticImpl = this.freePoolSize;
            synchronized (boundedRangeStatisticImpl) {
                this.freePoolSize.incrementWithoutSync(curTime, 1L);
                if (numConnectionsInUse < maxPoolSize) {
                    this.percentMaxed.set(curTime, 0L);
                }
            }
        } else {
            if (this.freePoolSize != null) {
                this.freePoolSize.increment();
            }
            if (this.percentMaxed != null && numConnectionsInUse < maxPoolSize) {
                this.percentMaxed.set(System.currentTimeMillis(), 0L);
            }
        }
    }

    public void beginWaitForConnection() {
        if (this.concurrentWaiters != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "beginWaitForConnection: dataSourceName = " + this.getName());
            }
            this.concurrentWaiters.increment();
        }
    }

    public void endWaitForConnection(long waitTime) {
        if (this.concurrentWaiters != null) {
            this.concurrentWaiters.decrement();
        }
        if (this.avgWaitTime != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "endWaitForConnection: waitTime = " + waitTime + ", dataSourceName = " + this.getName());
            }
            this.avgWaitTime.add(waitTime * 1L);
        }
    }

    public void endUseConnection(long useTime) {
        if (this.avgUseTime != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "endUseConnection: useTime = " + useTime + ", dataSourceName = " + this.getName());
            }
            this.avgUseTime.add(useTime * 1L);
        }
    }

    public void connectionWaitTimeout() {
        if (this.concurrentWaiters != null) {
            this.concurrentWaiters.decrement();
        }
        if (this.faults != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "connectionWaitTimeout: dataSourceName = " + this.getName());
            }
            this.faults.increment();
        }
    }

    public void preparedStmtCacheDiscard() {
        if (this.prepStmtDiscards != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "preparedStmtCacheDiscard: dataSourceName = " + this.getName());
            }
            this.prepStmtDiscards.increment();
        }
    }

    public void setConfigData(String name, long minSize, long maxSize) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "setConfigData, min=" + minSize + ", max=" + maxSize + ", ds=" + this.getName());
        }
        if (name.equalsIgnoreCase("PoolSize")) {
            if (this.poolSize != null) {
                this.poolSize.setLowerBound(0L);
                this.poolSize.setUpperBound(maxSize);
            }
            if (this.freePoolSize != null) {
                this.freePoolSize.setLowerBound(0L);
                this.freePoolSize.setUpperBound(maxSize);
            }
        } else {
            Tr.warning(tc, "PMI0019W", name);
        }
        if (tc.isDebugEnabled()) {
            Tr.exit(tc, "setConfigData");
        }
    }

    public StatsImpl getStats(ArrayList dataMembers, ArrayList subStats) {
        JDBCConnectionPoolStatsImpl stat = new JDBCConnectionPoolStatsImpl(this.name, this.type, this.currentLevel, dataMembers, subStats);
        stat.setJdbcDataSource(this.dsOName);
        return stat;
    }

    public ObjectName getMyMBean() {
        return this.dsOName;
    }

    protected void initializeMe(int newLevel) {
        if (this.currentLevel >= 7 || newLevel < 7) {
            return;
        }
        long connectionInUse = 0L;
        long connectionInPool = 0L;
        if (this.poolSize != null) {
            connectionInPool = this.poolSize.getCurrent();
        }
        long freeConnectionInPool = 0L;
        if (this.freePoolSize != null) {
            freeConnectionInPool = this.freePoolSize.getCurrent();
        }
        if (freeConnectionInPool < 0L) {
            this.freePoolSize.setLastValue(0L);
            connectionInUse = connectionInPool;
        } else {
            connectionInUse = connectionInPool - freeConnectionInPool;
        }
        long numWaiters = 0L;
        if (this.concurrentWaiters != null) {
            numWaiters = this.concurrentWaiters.getCurrent();
        }
        if (numWaiters < 0L) {
            this.concurrentWaiters.setLastValue(0L);
        }
        if (this.localMaxPoolSize > 0 && this.percentMaxed != null && connectionInUse >= (long)this.localMaxPoolSize) {
            this.percentMaxed.set(100L);
        }
    }

    class PercentUsedData
    implements SpdLoadExternalValue {
        private SPIRangeStatistic percentUsedValue = null;

        public PercentUsedData(int dataId) {
            this.percentUsedValue = new RangeStatisticImpl(dataId);
        }

        public SPIStatistic getLoadValue() {
            return this.percentUsedValue;
        }

        public void updateStatistic() {
            if (ConnPoolModule.this.poolSize == null || ConnPoolModule.this.freePoolSize == null || this.percentUsedValue == null) {
                return;
            }
            if (ConnPoolModule.this.localMaxPoolSize == 0) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "WARNING: PercentUsedData localMaxPoolSize is 0");
                }
                this.percentUsedValue.set(0L, 0L, 0L, 0.0, this.percentUsedValue.getStartTime(), ConnPoolModule.this.poolSize.getLastSampleTime());
            } else {
                long current = (ConnPoolModule.this.poolSize.getCurrent() - ConnPoolModule.this.freePoolSize.getCurrent()) * 100L / (long)ConnPoolModule.this.localMaxPoolSize;
                long curTime = ConnPoolModule.this.poolSize.updateIntegral();
                ConnPoolModule.this.poolSize.setLastSampleTime(curTime);
                ConnPoolModule.this.freePoolSize.updateIntegral(curTime);
                ConnPoolModule.this.freePoolSize.setLastSampleTime(curTime);
                double integral = (ConnPoolModule.this.poolSize.getIntegral() - ConnPoolModule.this.freePoolSize.getIntegral()) * 100.0 / (double)ConnPoolModule.this.localMaxPoolSize;
                long lastSampleTime = ConnPoolModule.this.poolSize.getLastSampleTime();
                long low = ((long)ConnPoolModule.this.localMaxPoolSize - ConnPoolModule.this.freePoolSize.getHighWaterMark()) * 100L / (long)ConnPoolModule.this.localMaxPoolSize;
                long high = ((long)ConnPoolModule.this.localMaxPoolSize - ConnPoolModule.this.freePoolSize.getLowWaterMark()) * 100L / (long)ConnPoolModule.this.localMaxPoolSize;
                this.percentUsedValue.set(low, high, current, (long)integral, this.percentUsedValue.getStartTime(), ConnPoolModule.this.poolSize.getLastSampleTime());
            }
        }
    }
}

