/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.pmi.server.data;

import com.ibm.websphere.pmi.PmiModuleConfig;
import com.ibm.websphere.pmi.server.SpdData;
import com.ibm.websphere.pmi.server.SpdLong;
import com.ibm.ws.pmi.server.PmiUtil;
import com.ibm.ws.pmi.server.data.SpdGroupBase;
import com.ibm.ws.pmi.server.data.SpdLongImpl;
import com.ibm.ws.pmi.stat.StatisticImpl;

public class SpdLongAggregate
extends SpdGroupBase {
    private static final long serialVersionUID = 7179411407858462031L;
    SpdLong myValue = null;

    public SpdLongAggregate(PmiModuleConfig moduleConfig, String name) {
        super(moduleConfig, name);
        this.myValue = new SpdLongImpl(this.dataId);
    }

    public SpdLongAggregate(int dataId) {
        super(dataId);
        this.myValue = new SpdLongImpl(dataId);
    }

    public boolean add(SpdData data) {
        if (data == null) {
            return false;
        }
        if (data instanceof SpdLong) {
            return super.add(data);
        }
        return false;
    }

    public boolean remove(SpdData data) {
        if (data == null) {
            return false;
        }
        if (data instanceof SpdLong) {
            return super.remove(data);
        }
        return false;
    }

    public void reset(boolean resetAll) {
    }

    public StatisticImpl getStatistic() {
        StatisticImpl aggStat = this.getSpdLong().getStatistic();
        aggStat.setLastSampleTime(PmiUtil.currentTime());
        return aggStat;
    }

    private SpdLong getSpdLong() {
        this.myValue.reset(false);
        for (int i = 0; i < this.members.size(); ++i) {
            Object member = this.members.get(i);
            if (member == null) continue;
            if (member instanceof SpdLong) {
                this.myValue.combine((SpdLong)member);
                continue;
            }
            this.myValue.combine(((SpdLongAggregate)member).getSpdLong());
        }
        return this.myValue;
    }

    public void updateAggregate() {
        this.myValue.reset(false);
        for (int i = 0; i < this.members.size(); ++i) {
            Object member = this.members.get(i);
            if (member == null) continue;
            if (member instanceof SpdLong) {
                this.myValue.combine((SpdLong)member);
                continue;
            }
            this.myValue.combine(((SpdLongAggregate)member).getSpdLong());
        }
    }
}

