/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.pmi.server.data;

import com.ibm.websphere.pmi.PmiModuleConfig;
import com.ibm.websphere.pmi.server.SpdLoad;
import com.ibm.ws.pmi.server.data.SpdDataImpl;
import com.ibm.ws.pmi.stat.BoundedRangeStatisticImpl;
import com.ibm.ws.pmi.stat.RangeStatisticImpl;
import com.ibm.ws.pmi.stat.StatisticImpl;

public class SpdLoadImpl
extends SpdDataImpl
implements SpdLoad {
    private static final long serialVersionUID = -1296441240799172895L;
    public RangeStatisticImpl stat = null;

    public SpdLoadImpl(PmiModuleConfig moduleConfig, String name) {
        super(moduleConfig, name);
        this.stat = new BoundedRangeStatisticImpl(this.dataId);
    }

    public SpdLoadImpl(int dataId) {
        super(dataId);
        this.stat = new BoundedRangeStatisticImpl(dataId);
    }

    public SpdLoadImpl(int type, int dataId) {
        super(dataId);
        this.stat = type == 7 ? new RangeStatisticImpl(dataId) : new BoundedRangeStatisticImpl(dataId);
    }

    public void add(double val) {
        this.stat.set((long)val);
    }

    public void increment(double incVal) {
        this.stat.increment((long)incVal);
    }

    public void increment() {
        this.stat.increment();
    }

    public void decrement(double incVal) {
        this.stat.decrement((long)incVal);
    }

    public void decrement() {
        this.stat.decrement();
    }

    public void setConfig(long minSize, long maxSize) {
        if (this.stat instanceof BoundedRangeStatisticImpl) {
            ((BoundedRangeStatisticImpl)this.stat).setLowerBound(minSize);
            ((BoundedRangeStatisticImpl)this.stat).setUpperBound(maxSize);
        }
    }

    public void reset(boolean resetAll) {
        this.stat.reset(resetAll);
    }

    public StatisticImpl getStatistic() {
        if (this.enabled) {
            long curTime = this.stat.updateIntegral();
            this.stat.setLastSampleTime(curTime);
            return this.stat;
        }
        return this.stat;
    }

    public long getCurrent() {
        return this.stat.getCurrent();
    }

    public void combine(SpdLoad other) {
        if (other == null) {
            return;
        }
        if (this.stat.isEnabled() && other.isEnabled()) {
            this.stat.combine(other.getStatistic());
        }
    }

    public void cleanup() {
        this.stat.cleanup();
    }

    public void enable(int level) {
        super.enable(level);
        this.stat.enable(level);
    }

    public void disable() {
        super.disable();
        this.stat.disable();
    }

    public boolean isEnabled() {
        return this.stat.isEnabled();
    }
}

