/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.pmi.server;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.AdminClient;
import com.ibm.websphere.management.AdminService;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceFactory;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.websphere.management.configservice.ConfigServiceProxy;
import com.ibm.websphere.management.repository.ConfigRepository;
import com.ibm.websphere.management.repository.client.ConfigRepositoryClientFactory;
import com.ibm.websphere.models.config.pmiservice.PMIModule;
import com.ibm.websphere.models.config.pmiservice.impl.PmiserviceFactoryImpl;
import com.ibm.websphere.pmi.PmiConstants;
import com.ibm.websphere.pmi.PmiDataInfo;
import com.ibm.websphere.pmi.PmiModuleConfig;
import com.ibm.websphere.pmi.server.PmiAbstractModule;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.pmi.component.PMIImpl;
import com.ibm.ws.pmi.server.ModuleItem;
import com.ibm.ws.pmi.server.PerfLevelDescriptor;
import com.ibm.ws.pmi.server.PmiRegistry;
import com.ibm.ws.pmi.server.PmiUtil;
import com.ibm.ws.pmi.server.RtPMIModule;
import com.ibm.ws.pmi.stat.StatsConfigHelper;
import com.ibm.ws.runtime.service.ConfigRoot;
import com.ibm.ws.runtime.service.Repository;
import com.ibm.wsspi.runtime.config.ConfigObject;
import com.ibm.wsspi.runtime.service.WsServiceRegistry;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.ObjectName;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.resource.Resource;

public class PmiConfigManager
implements PmiConstants {
    private static TraceComponent tc = Tr.register(PmiConfigManager.class, null, "com.ibm.ws.pmi.properties.PMIMessages");
    private static final int NOT_OLD_SPEC = -9999;
    private static PMIModule serverPMIModule;
    private static ConfigObject rcsConfigObject;
    private static ConfigRepository _cfgRepo;
    private static Repository cfgService;

    public static void init(PMIModule m) {
        serverPMIModule = m;
    }

    public static void initRCSSpec(ConfigObject conObj) {
        rcsConfigObject = conObj;
    }

    public static void initSpec(Resource r) {
        serverPMIModule = (PMIModule)r.getContents().get(0);
    }

    public static void initSpec(String v5Spec) {
        serverPMIModule = PmiConfigManager.createPMIModule("pmi", "", "", "");
        PerfLevelDescriptor[] pld = PmiUtil.getPerfLevelSpecsFromString(v5Spec);
        if (pld != null) {
            for (int i = 0; i < pld.length; ++i) {
                PmiConfigManager.updateSpec(pld[i].getPath(), pld[i].getWCCMType(), pld[i].getLevel(), false, false);
            }
        }
    }

    public static boolean isInitialized() {
        return PmiConfigManager.getRCSConfigObject() != null;
    }

    public static ConfigObject getRCSConfigObject() {
        return rcsConfigObject;
    }

    public static PMIModule getServerPMIModule() {
        if (serverPMIModule == null) {
            try {
                cfgService = WsServiceRegistry.getService(PmiConfigManager.class, Repository.class);
                ConfigRoot configRoot = cfgService.getConfigRoot();
                Resource resource = configRoot.getResource(4, "pmi-config.xml");
                PmiConfigManager.initSpec(resource);
            }
            catch (Exception e) {
                FFDCFilter.processException(e, "com.ibm.ws.pmi.server.PmiConfigManager.getServerPMIModule()", "75");
                Tr.warning(tc, "PMI9999E", e);
            }
        }
        return serverPMIModule;
    }

    public static int[][] getSpec(String[] path) {
        if (PmiConfigManager.getRCSConfigObject() == null) {
            return null;
        }
        List l = PmiConfigManager.getRCSModule(path, true);
        ConfigObject found = null;
        if (l.size() <= 0) {
            return null;
        }
        found = (ConfigObject)l.get(0);
        int oldSpec = PmiConfigManager.getOldSpec(found);
        int[] level = null;
        int[] enable = null;
        int[] enableSync = new int[]{};
        if (oldSpec == -9999) {
            enable = PmiConfigManager.parseSpecStr(found.getString("enable", null));
        } else {
            level = new int[]{oldSpec};
        }
        return new int[][]{level, enable, enableSync};
    }

    public static void updateSpec(String[] path, String type, int[] enabled, int[] enabledSync, boolean recursive, boolean createWildCard) {
        List l = PmiConfigManager.getModule(path, false);
        boolean foundWildCard = false;
        PMIModule mod = null;
        String enableStr = PmiConfigManager.buildSpecStr(enabled);
        String enableSyncStr = PmiConfigManager.buildSpecStr(enabledSync);
        if (l.size() > 0) {
            for (int i = 0; i < l.size(); ++i) {
                mod = (PMIModule)l.get(i);
                PmiConfigManager.updateSpec(mod, type, enableStr, enableSyncStr, recursive);
                if (!mod.getModuleName().equals("*")) continue;
                foundWildCard = true;
            }
        } else {
            if (path == null || path.length == 0) {
                return;
            }
            mod = PmiConfigManager.createPMIModule(path[path.length - 1], type, enableStr, enableSyncStr);
            PmiConfigManager.insertModule(mod, path);
            if (mod.getModuleName().equals("*")) {
                foundWildCard = true;
            }
        }
        if (createWildCard && path[path.length - 1].equals("*") && !foundWildCard) {
            PMIModule star = PmiConfigManager.createPMIModule("*", type, enableStr, enableSyncStr);
            PmiConfigManager.insertModule(star, path);
        }
    }

    public static void updateSpec(String[] path, String type, int newLevel, boolean recursive, boolean createWildCard) {
        List l = PmiConfigManager.getModule(path, false);
        boolean foundWildCard = false;
        PMIModule mod = null;
        String enableStr = PmiConfigManager.getLevelString(newLevel);
        String enableSyncStr = "";
        if (l.size() > 0) {
            for (int i = 0; i < l.size(); ++i) {
                mod = (PMIModule)l.get(i);
                PmiConfigManager.updateSpec(mod, type, newLevel, recursive);
                if (!mod.getModuleName().equals("*")) continue;
                foundWildCard = true;
            }
        } else {
            if (path == null || path.length == 0) {
                return;
            }
            mod = PmiConfigManager.createPMIModule(path[path.length - 1], type, enableStr, enableSyncStr);
            PmiConfigManager.insertModule(mod, path);
        }
        if (createWildCard && path[path.length - 1].equals("*") && !foundWildCard) {
            PMIModule star = PmiConfigManager.createPMIModule("*", type, enableStr, enableSyncStr);
            PmiConfigManager.insertModule(star, path);
        }
    }

    public static boolean saveSpec() {
        if (tc.isDebugEnabled()) {
            Tr.entry(tc, "saveSpec");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "processing customized PMI settings");
        }
        if (PmiConfigManager.getServerPMIModule() == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "loading PMI settings from pmi-config.xml");
            }
            if (!PMIImpl.initSpecFromPmiConfigDocument()) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "pmi-config.xml not found");
                }
                serverPMIModule = PmiConfigManager.createPMIModule("pmi", "", "", "");
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "updating config with current runtime spec");
        }
        ModuleItem root = PmiRegistry.findModuleItem(new String[]{"pmi"});
        PmiConfigManager.updateWithRuntimeSpec(root);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "COMPRESSING DISABLED.");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "persisting config in pmi-config.xml");
        }
        PmiConfigManager.persistConfig();
        if (tc.isDebugEnabled()) {
            Tr.exit(tc, "saveSpec");
        }
        return true;
    }

    public static List getModule(String[] path, boolean applyWildCard) {
        if (path.length > 0 && path[0].equals(PmiConfigManager.getServerPMIModule().getModuleName())) {
            return PmiConfigManager.getModule(path, PmiConfigManager.getServerPMIModule(), 1, applyWildCard);
        }
        return PmiConfigManager.getModule(path, PmiConfigManager.getServerPMIModule(), 0, applyWildCard);
    }

    public static List getModule(String[] path, PMIModule start, int pathIndex, boolean applyWildCard) {
        ArrayList<PMIModule> toReturn = new ArrayList<PMIModule>();
        if (pathIndex == path.length) {
            toReturn.add(start);
            return toReturn;
        }
        EList children = start.getPmimodules();
        int iStar = -1;
        for (int i = 0; i < children.size(); ++i) {
            String compare = ((PMIModule)children.get(i)).getModuleName();
            if (path[pathIndex].equals("*") || compare.equals(path[pathIndex])) {
                toReturn.addAll(PmiConfigManager.getModule(path, (PMIModule)children.get(i), pathIndex + 1, applyWildCard));
            }
            if (!compare.equals("*")) continue;
            iStar = i;
        }
        if (applyWildCard && iStar != -1) {
            toReturn.addAll(PmiConfigManager.getModule(path, (PMIModule)children.get(iStar), pathIndex + 1, applyWildCard));
        }
        return toReturn;
    }

    public static List getRCSModule(String[] path, boolean applyWildCard) {
        if (path.length > 0 && path[0].equals(PmiConfigManager.getRCSConfigObject().getString("moduleName", null))) {
            return PmiConfigManager.getRCSModule(path, PmiConfigManager.getRCSConfigObject(), 1, applyWildCard);
        }
        return PmiConfigManager.getRCSModule(path, PmiConfigManager.getRCSConfigObject(), 0, applyWildCard);
    }

    public static List getRCSModule(String[] path, ConfigObject start, int pathIndex, boolean applyWildCard) {
        ArrayList<ConfigObject> toReturn = new ArrayList<ConfigObject>();
        if (pathIndex == path.length) {
            toReturn.add(start);
            return toReturn;
        }
        List children = start.getObjectList("pmimodules");
        int iStar = -1;
        for (int i = 0; i < children.size(); ++i) {
            String compare = ((ConfigObject)children.get(i)).getString("moduleName", null);
            if (path[pathIndex].equals("*") || compare.equals(path[pathIndex])) {
                toReturn.addAll(PmiConfigManager.getRCSModule(path, (ConfigObject)children.get(i), pathIndex + 1, applyWildCard));
            }
            if (!compare.equals("*")) continue;
            iStar = i;
        }
        if (applyWildCard && iStar != -1) {
            toReturn.addAll(PmiConfigManager.getRCSModule(path, (ConfigObject)children.get(iStar), pathIndex + 1, applyWildCard));
        }
        return toReturn;
    }

    private static void updateSpec(PMIModule mod, String type, String enabled, String enabledSync, boolean recursive) {
        mod.setEnable(enabled);
        if (mod.getType() == null) {
            mod.setType(type);
        }
        if (recursive) {
            EList l = mod.getPmimodules();
            for (int i = 0; i < l.size(); ++i) {
                PmiConfigManager.updateSpec((PMIModule)l.get(i), type, enabled, enabledSync, recursive);
            }
        }
    }

    public static String getLevelString(int level) {
        switch (level) {
            case 0: {
                return "N";
            }
            case 1: {
                return "L";
            }
            case 3: {
                return "M";
            }
            case 7: {
                return "H";
            }
            case 15: {
                return "X";
            }
        }
        return "";
    }

    public static int getLevel(String level) {
        if (level == null) {
            return -1;
        }
        if (level.equals("low")) {
            return 1;
        }
        if (level.equals("none")) {
            return 0;
        }
        if (level.equals("medium")) {
            return 3;
        }
        if (level.equals("high")) {
            return 7;
        }
        if (level.equals("maximum")) {
            return 15;
        }
        return -1;
    }

    public static boolean isV5Spec(String level) {
        if (level == null || level.length() == 0) {
            return false;
        }
        return level.length() == 1 && (level.equals("X") || level.equals("H") || level.equals("M") || level.equals("L") || level.equals("N"));
    }

    private static void updateSpec(PMIModule mod, String type, int newLevel, boolean recursive) {
        String toSet = PmiConfigManager.getLevelString(newLevel);
        mod.setEnable(toSet);
        if (mod.getType() == null) {
            mod.setType(type);
        }
        if (recursive) {
            EList l = mod.getPmimodules();
            for (int i = 0; i < l.size(); ++i) {
                PmiConfigManager.updateSpec((PMIModule)l.get(i), type, newLevel, recursive);
            }
        }
    }

    public static boolean isBeanMethodDisabled() {
        return false;
    }

    public static int[] parseSpecStr(String in) {
        if (in == null) {
            return new int[0];
        }
        in = in.replaceAll(" ", "");
        if ((in = in.trim()).length() == 0) {
            return new int[0];
        }
        String[] tokens = in.split(",");
        int[] toReturn = new int[tokens.length];
        for (int i = 0; i < tokens.length; ++i) {
            tokens[i] = tokens[i].trim();
            try {
                toReturn[i] = Integer.parseInt(tokens[i]);
                continue;
            }
            catch (NumberFormatException e) {
                toReturn[i] = tokens[i].equals("*") && i == 0 ? -3 : -1;
            }
        }
        return toReturn;
    }

    public static int[] parseSpecStr(String modType, String in) {
        if (PmiConfigManager.isV5Spec(in)) {
            PmiModuleConfig cfg = StatsConfigHelper.getStatsConfig(modType);
            if (cfg != null) {
                PmiDataInfo[] d = cfg.listLevelData(PmiConfigManager.getLevel(in));
                int sz = d.length;
                int[] e = new int[sz];
                for (int i = 0; i < sz; ++i) {
                    e[i] = d[i].getId();
                }
                return e;
            }
            return new int[0];
        }
        return PmiConfigManager.parseSpecStr(in);
    }

    private static int getOldSpec(PMIModule m) {
        String enable = m.getEnable();
        if (enable.length() == 1) {
            char spec = enable.charAt(0);
            switch (spec) {
                case 'N': {
                    return 0;
                }
                case 'L': {
                    return 1;
                }
                case 'M': {
                    return 3;
                }
                case 'H': {
                    return 7;
                }
                case 'X': {
                    return 15;
                }
            }
            return -9999;
        }
        return -9999;
    }

    private static int getOldSpec(ConfigObject m) {
        String enable = m.getString("enable", null);
        if (enable.length() == 1) {
            char spec = enable.charAt(0);
            switch (spec) {
                case 'N': {
                    return 0;
                }
                case 'L': {
                    return 1;
                }
                case 'M': {
                    return 3;
                }
                case 'H': {
                    return 7;
                }
                case 'X': {
                    return 15;
                }
            }
            return -9999;
        }
        return -9999;
    }

    public static String buildSpecStr(int[] spec) {
        if (spec.length == 1 && spec[0] == -3) {
            return "*";
        }
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < spec.length; ++i) {
            buf.append(spec[i]);
            if (i == spec.length - 1) continue;
            buf.append(",");
        }
        return buf.toString();
    }

    private static void insertModule(PMIModule toInsert, String[] path) {
        if (path.length > 0 && path[0].equals(PmiConfigManager.getServerPMIModule().getModuleName())) {
            PmiConfigManager.insertModule(toInsert, path, 1, PmiConfigManager.getServerPMIModule());
        } else {
            PmiConfigManager.insertModule(toInsert, path, 0, PmiConfigManager.getServerPMIModule());
        }
    }

    private static void insertModule(PMIModule toInsert, String[] path, int pathIndex, PMIModule parent) {
        List existingList;
        if (pathIndex == path.length - 1 && (existingList = PmiConfigManager.hasChild(parent, path[pathIndex], false)).size() == 0) {
            parent.getPmimodules().add(toInsert);
            return;
        }
        List foundList = PmiConfigManager.hasChild(parent, path[pathIndex], true);
        PMIModule found = null;
        if (foundList.size() == 0) {
            String[] tmp = new String[pathIndex + 1];
            for (int i = 0; i < tmp.length; ++i) {
                tmp[i] = path[i];
            }
            String _type = null;
            if (PmiRegistry.isDisabled()) {
                _type = new PerfLevelDescriptor(tmp, 0).getWCCMType();
            } else {
                ModuleItem mi = PmiRegistry.findModuleItem(tmp);
                if (mi != null && mi.getInstance() != null) {
                    _type = mi.getInstance().getWCCMStatsType();
                }
            }
            if (_type == null) {
                _type = parent.getType();
            }
            found = PmiConfigManager.createPMIModule(path[pathIndex], _type, "", "");
            parent.getPmimodules().add(found);
            PmiConfigManager.insertModule(toInsert, path, pathIndex + 1, found);
        } else {
            for (int i = 0; i < foundList.size(); ++i) {
                found = (PMIModule)foundList.get(i);
                if (i > 0) {
                    toInsert = PmiConfigManager.createPMIModule(toInsert.getModuleName(), toInsert.getType(), toInsert.getEnable(), "");
                }
                PmiConfigManager.insertModule(toInsert, path, pathIndex + 1, found);
            }
        }
    }

    private static PMIModule createPMIModule(String name, String type, String enable, String enableSync) {
        PMIModule aModule = PmiserviceFactoryImpl.eINSTANCE.createPMIModule();
        aModule.setModuleName(name);
        aModule.setType(type);
        aModule.setEnable(enable);
        return aModule;
    }

    public static String[] parsePath(String path) {
        StringTokenizer p = new StringTokenizer(path, ">");
        String[] ret = new String[p.countTokens()];
        int i = 0;
        while (p.hasMoreTokens()) {
            ret[i++] = p.nextToken();
        }
        return ret;
    }

    public static void printSpecTree() {
        System.out.println("**** fine grained spec ****");
        PmiConfigManager._print(PmiConfigManager.getRCSConfigObject(), 1);
        System.out.println();
    }

    public static void printSpecTree(PMIModule m) {
        System.out.println("[PmiConfigManager] printing spec");
        PmiConfigManager._print(m, 1);
        System.out.println();
    }

    public static void printSpecTree(ConfigObject m) {
        System.out.println("[PmiConfigManager] printing spec");
        PmiConfigManager._print(m, 1);
        System.out.println();
    }

    private static void _print(PMIModule root, int x) {
        if (root == null) {
            return;
        }
        StringBuffer b = new StringBuffer();
        for (int i = 0; i < x; ++i) {
            b.append("  ");
        }
        b.append("moduleName=").append(root.getModuleName());
        b.append("; type=").append(root.getType());
        b.append("; enable=").append(root.getEnable());
        System.out.println(b.toString());
        EList list = root.getPmimodules();
        if (list == null) {
            return;
        }
        int sz = list.size();
        ++x;
        for (int k = 0; k < sz; ++k) {
            PmiConfigManager._print((PMIModule)list.get(k), x);
        }
    }

    private static void _print(ConfigObject root, int x) {
        if (root == null) {
            return;
        }
        StringBuffer b = new StringBuffer();
        for (int i = 0; i < x; ++i) {
            b.append("  ");
        }
        b.append("moduleName=").append(root.getString("moduleName", null));
        b.append("; type=").append(root.getString("type", null));
        b.append("; enable=").append(root.getString("enable", null));
        System.out.println(b.toString());
        List list = root.getObjectList("pmimodules");
        if (list == null) {
            return;
        }
        int sz = list.size();
        ++x;
        for (int k = 0; k < sz; ++k) {
            PmiConfigManager._print((ConfigObject)list.get(k), x);
        }
    }

    private static List hasChild(PMIModule parent, String childName, boolean applyWildCard) {
        EList children = parent.getPmimodules();
        if (applyWildCard && childName.equals("*")) {
            return children;
        }
        ArrayList toReturn = new ArrayList();
        for (int i = 0; i < children.size(); ++i) {
            String compare = ((PMIModule)children.get(i)).getModuleName();
            if (!compare.equals(childName)) continue;
            toReturn.add(children.get(i));
            return toReturn;
        }
        return toReturn;
    }

    private static void clear(PMIModule mod) {
        mod.setEnable("");
        EList l = mod.getPmimodules();
        if (l.size() == 0) {
            return;
        }
        for (int i = 0; i < l.size(); ++i) {
            PmiConfigManager.clear((PMIModule)l.get(i));
        }
    }

    public static void removeModules(String[] path, boolean applyWildcard) {
        List list = PmiConfigManager.getModule(path, applyWildcard);
        for (int i = 0; i < list.size(); ++i) {
            PMIModule toRemove = (PMIModule)list.get(i);
            PMIModule parent = (PMIModule)toRemove.eContainer();
            if (!parent.getPmimodules().contains(toRemove)) continue;
            parent.getPmimodules().remove(toRemove);
        }
    }

    public static synchronized ConfigRepository getCfgRepo() {
        if (_cfgRepo != null) {
            return _cfgRepo;
        }
        try {
            Properties rProps = new Properties();
            rProps.setProperty("location", "local");
            _cfgRepo = ConfigRepositoryClientFactory.getConfigRepositoryClient(rProps);
            return _cfgRepo;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static RtPMIModule convertToRt(PMIModule mod) {
        RtPMIModule toReturn = new RtPMIModule();
        toReturn.setModuleName(mod.getModuleName());
        toReturn.setType(mod.getType());
        toReturn.setEnable(mod.getEnable());
        ArrayList<RtPMIModule> l = new ArrayList<RtPMIModule>();
        for (int i = 0; i < mod.getPmimodules().size(); ++i) {
            l.add(PmiConfigManager.convertToRt((PMIModule)mod.getPmimodules().get(i)));
        }
        toReturn.setPmimodules(l);
        return toReturn;
    }

    public static RtPMIModule getRuntimePMISpec() {
        ModuleItem root = PmiRegistry.findModuleItem(new String[]{"pmi"});
        if (root != null) {
            return PmiConfigManager.createRtSpec(root);
        }
        return null;
    }

    public static boolean isValidStatisticSet(String statisticSet) {
        return statisticSet.equals("none") || statisticSet.equals("basic") || statisticSet.equals("extended") || statisticSet.equals("all");
    }

    private static void updateWithRuntimeSpec(ModuleItem mi) {
        ModuleItem[] child;
        if (mi != null && (child = mi.children()) != null) {
            for (int i = 0; i < child.length; ++i) {
                PmiAbstractModule instance = (PmiAbstractModule)child[i].getInstance();
                if (instance == null) continue;
                if (instance.getInstrumentationLevel() == -2) {
                    PmiConfigManager.updateSpec(instance.getPath(), instance.getWCCMStatsType(), instance.getEnabled(), instance.getEnabledSync(), false, false);
                } else {
                    PmiConfigManager.updateSpec(instance.getPath(), instance.getWCCMStatsType(), instance.getInstrumentationLevel(), false, false);
                }
                PmiConfigManager.updateWithRuntimeSpec(child[i]);
            }
        }
    }

    private static RtPMIModule createRtSpec(ModuleItem mi) {
        RtPMIModule toReturn = new RtPMIModule();
        PmiAbstractModule inst = (PmiAbstractModule)mi.getInstance();
        if (inst == null) {
            toReturn.setModuleName("pmi");
            toReturn.setType("");
            toReturn.setEnable("");
            toReturn.setEnableSync("");
        } else {
            toReturn.setModuleName(inst.getName());
            toReturn.setType(inst.getWCCMStatsType());
            toReturn.setEnable(PmiConfigManager.buildSpecStr(inst.getEnabled()));
            toReturn.setEnableSync("");
        }
        ArrayList<RtPMIModule> l = new ArrayList<RtPMIModule>();
        ModuleItem[] child = mi.children();
        if (child != null) {
            for (int i = 0; i < child.length; ++i) {
                l.add(PmiConfigManager.createRtSpec(child[i]));
            }
        }
        toReturn.setPmimodules(l);
        return toReturn;
    }

    private static void compress(PMIModule m) {
        EList children = m.getPmimodules();
        if (children != null) {
            int sz = children.size();
            for (int i = sz - 1; i >= 0; --i) {
                EList l;
                PMIModule child = (PMIModule)children.get(i);
                if (child.getPmimodules() != null) {
                    PmiConfigManager.compress(child);
                }
                if (m.getModuleName().equals("pmi") || (l = child.getPmimodules()) == null || l.size() != 0 || !m.getEnable().equals(child.getEnable())) continue;
                children.remove(i);
            }
        }
    }

    private static void compress(ConfigObject m) {
        List children = m.getObjectList("pmimodules");
        if (children != null) {
            int sz = children.size();
            for (int i = sz - 1; i >= 0; --i) {
                List l;
                ConfigObject child = (ConfigObject)children.get(i);
                if (child.getObjectList("pmimodules") != null) {
                    PmiConfigManager.compress(child);
                }
                if (m.getString("moduleName", null).equals("pmi") || (l = child.getObjectList("pmimodules")) == null || l.size() != 0 || !m.getString("enable", "").equals(child.getString("enable", null))) continue;
                children.remove(i);
            }
        }
    }

    private boolean isCompressable(PMIModule m) {
        return false;
    }

    private boolean isCompressable(ConfigObject m) {
        return false;
    }

    private static void persistConfig() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "persistConfig");
        }
        ConfigService cs = null;
        AdminService localAS = AdminServiceFactory.getAdminService();
        if (localAS.getProcessType().equals("UnManagedProcess")) {
            cs = ConfigServiceFactory.getConfigService();
        } else {
            try {
                AdminClient dmgrAC = localAS.getDeploymentManagerAdminClient();
                cs = new ConfigServiceProxy(dmgrAC);
            }
            catch (Exception e) {
                Tr.warning(tc, "PMI9999E", e);
            }
        }
        if (cs != null) {
            try {
                ObjectName serverON;
                ObjectName[] thisServer;
                Session session = new Session("PmiConfigManger", false);
                ObjectName nodeON = ConfigServiceHelper.createObjectName(null, "Node", localAS.getNodeName());
                ObjectName[] thisNode = cs.queryConfigObjects(session, null, nodeON, null);
                if (thisNode != null && thisNode.length == 1 && (thisServer = cs.queryConfigObjects(session, thisNode[0], serverON = ConfigServiceHelper.createObjectName(null, "Server", localAS.getProcessName()), null)) != null && thisServer.length == 1) {
                    AttributeList attrList;
                    ObjectName pmiON;
                    ObjectName[] thisPMI;
                    if (PMIImpl.isSpecUpdated() && (thisPMI = cs.queryConfigObjects(session, thisServer[0], pmiON = ConfigServiceHelper.createObjectName(null, "PMIService", null), null)) != null && thisPMI.length == 1) {
                        attrList = new AttributeList();
                        attrList.add(new Attribute("initialSpecLevel", ""));
                        attrList.add(new Attribute("synchronizedUpdate", new Boolean(PMIImpl.getSynchronizedUpdate())));
                        attrList.add(new Attribute("statisticSet", PMIImpl.getStatisticSet()));
                        cs.setAttributes(session, thisPMI[0], attrList);
                    }
                    if ((thisPMI = cs.queryConfigObjects(session, thisServer[0], pmiON = ConfigServiceHelper.createObjectName(null, "PMIModule", null), null)) != null && thisPMI.length == 1) {
                        cs.deleteConfigData(session, thisPMI[0]);
                        attrList = new AttributeList();
                        attrList.add(new Attribute("moduleName", "pmi"));
                        attrList.add(new Attribute("type", ""));
                        attrList.add(new Attribute("enable", ""));
                        ObjectName newlyCreated = cs.createConfigData(session, thisServer[0], "PMIModule", "PMIModule", attrList);
                        int sz = PmiConfigManager.getServerPMIModule().getPmimodules().size();
                        for (int i = 0; i < sz; ++i) {
                            PmiConfigManager.persistOnePmiModule((PMIModule)PmiConfigManager.getServerPMIModule().getPmimodules().get(i), session, cs, newlyCreated);
                        }
                    }
                    cs.save(session, false);
                    cs.discard(session);
                }
            }
            catch (Exception e) {
                Tr.warning(tc, "PMI0027W", e);
            }
        } else {
            Tr.warning(tc, "PMI0028W");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "persistConfig");
        }
    }

    private static void persistOnePmiModule(PMIModule mod, Session sess, ConfigService p, ObjectName parent) throws Exception {
        AttributeList l = new AttributeList();
        l.add(new Attribute("moduleName", mod.getModuleName()));
        l.add(new Attribute("type", mod.getType()));
        l.add(new Attribute("enable", mod.getEnable()));
        ObjectName newlyCreated = p.createConfigData(sess, parent, "pmimodules", "PMIModule", l);
        for (int i = 0; i < mod.getPmimodules().size(); ++i) {
            PmiConfigManager.persistOnePmiModule((PMIModule)mod.getPmimodules().get(i), sess, p, newlyCreated);
        }
    }

    public static void updateSpec(String spec) {
        if (spec == null) {
            return;
        }
        StringTokenizer psr1 = new StringTokenizer(spec, ":");
        while (psr1.hasMoreTokens()) {
            int[] enable;
            String[] path;
            StringTokenizer psr2 = new StringTokenizer(psr1.nextToken(), "=");
            try {
                path = PmiConfigManager.parsePath(psr2.nextToken());
            }
            catch (Exception e) {
                continue;
            }
            try {
                enable = PmiConfigManager.parseSpecStr(psr2.nextToken());
            }
            catch (Exception e) {
                enable = new int[]{};
            }
            PmiConfigManager.updateSpec(path, null, enable, new int[0], false, false);
        }
    }

    public static void updateSpec(PMIModule parent, String[] path) {
        int[] enable;
        String[] newpath;
        if (path == null || path.length == 0) {
            newpath = new String[1];
        } else {
            newpath = new String[path.length + 1];
            for (int i = 0; i < path.length; ++i) {
                newpath[i] = path[i];
            }
        }
        newpath[newpath.length - 1] = parent.getModuleName();
        try {
            enable = PmiConfigManager.parseSpecStr(parent.getEnable());
        }
        catch (Exception e) {
            enable = new int[]{};
        }
        PmiConfigManager.updateSpec(newpath, parent.getType(), enable, new int[0], false, false);
        EList children = parent.getPmimodules();
        for (int i = 0; i < children.size(); ++i) {
            PMIModule child = (PMIModule)children.get(i);
            PmiConfigManager.updateSpec(child, newpath);
        }
    }
}

