/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.pmi.preprocessor;

import com.ibm.websphere.pmi.PmiModuleConfig;
import com.ibm.ws.pmi.preprocessor.PmiModuleConfigLookupPrinterJetHelper;
import com.ibm.ws.pmi.server.ModuleConfigParser;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Properties;

public class PmiModuleConfigLookupPrinter {
    private static char SEPARATOR = (char)47;
    private static String GEN_CLASS_SUFFIX = "_StatsTemplateLookup";
    private static String GEN_CLASS_LOCATION = "com/ibm/ws/pmi/preprocess";
    private static String GEN_CLASS_PACKAGE = "com.ibm.ws.pmi.preprocess";
    private static String TMP_DIR_LOCATION = "_pmitemp";
    private static String className;
    private static String classLoc;
    private static String txtFileLoc;

    public static void main(String[] args) {
        try {
            if (args == null || args.length < 2) {
                System.out.println("PmiModuleConfigLookupPrinter input arguments missing.");
                return;
            }
            className = args[0];
            className = className.replace('.', '_');
            className = className + GEN_CLASS_SUFFIX;
            txtFileLoc = args[1];
            System.out.println("Parsing templates..");
            PmiModuleConfig[] cfg = PmiModuleConfigLookupPrinter.parse();
            System.out.println("...complete");
            PmiModuleConfigLookupPrinterJetHelper printer = new PmiModuleConfigLookupPrinterJetHelper();
            ArrayList<Object> list = new ArrayList<Object>(3);
            int ix = className.lastIndexOf(46);
            if (ix == -1) {
                list.add(0, className);
                classLoc = GEN_CLASS_LOCATION;
                list.add(1, GEN_CLASS_PACKAGE);
            } else {
                list.add(0, className.substring(ix, className.length()));
                classLoc = className.substring(0, ix).replace('.', '/');
                list.add(1, classLoc);
            }
            list.add(2, cfg);
            System.out.println("Generating " + classLoc + SEPARATOR + className + ".java..");
            PmiModuleConfigLookupPrinter.writeFile(TMP_DIR_LOCATION + SEPARATOR + classLoc + SEPARATOR + className + ".java", printer.generate(list));
            System.out.println("...complete");
        }
        catch (Exception e) {
            System.out.println("Exception while generating " + classLoc + SEPARATOR + className + ".java");
            e.printStackTrace();
        }
    }

    public static PmiModuleConfig[] parse() throws Exception {
        String propsFile = PmiModuleConfigLookupPrinter.consolidateSeperators(txtFileLoc);
        Properties p = new Properties();
        p.load(new FileInputStream(propsFile));
        System.out.println(p.size() + " templates listed in " + txtFileLoc);
        PmiModuleConfig[] toReturn = new PmiModuleConfig[p.size()];
        ModuleConfigParser parser = new ModuleConfigParser();
        Iterator<Object> it = p.keySet().iterator();
        int count = 0;
        while (it.hasNext()) {
            String fileName = (String)it.next();
            if (fileName == null) continue;
            fileName = PmiModuleConfigLookupPrinter.consolidateSeperators(fileName);
            String dtdVal = p.getProperty(fileName);
            try {
                toReturn[count] = dtdVal != null && dtdVal.equals("NoDTDValidate") ? parser.loadDescriptor(fileName, false, true) : parser.loadDescriptor(fileName, true, true);
                if (toReturn[count] != null) {
                    System.out.println("  " + fileName);
                } else {
                    System.out.println("Unable to locate " + fileName);
                }
            }
            catch (Exception e) {
                System.out.println("Exception while parsing " + fileName + ": " + e.getMessage());
            }
            ++count;
        }
        return toReturn;
    }

    private static String getSrcDirectory() {
        StringBuffer buf = new StringBuffer();
        buf.append("src");
        buf.append(SEPARATOR);
        buf.append(PmiModuleConfigLookupPrinter.getPackage());
        return buf.toString();
    }

    private static String getPackage() {
        StringBuffer buf = new StringBuffer();
        buf.append("com");
        buf.append(SEPARATOR);
        buf.append("ibm");
        buf.append(SEPARATOR);
        buf.append("ws");
        buf.append(SEPARATOR);
        buf.append("pmi");
        buf.append(SEPARATOR);
        buf.append("template");
        buf.append(SEPARATOR);
        return buf.toString();
    }

    private static void writeFile(String fileName, String contents) throws Exception {
        File f = new File(fileName);
        if (!f.exists()) {
            String fullPath = f.getAbsolutePath();
            int i = fullPath.lastIndexOf(File.separatorChar);
            if (i > -1) {
                fullPath = fullPath.substring(0, i);
            }
            new File(fullPath).mkdirs();
        }
        FileWriter fos = new FileWriter(f);
        int clen = contents.length();
        int totalSize = 0;
        int blockSize = 10000;
        if (clen < blockSize) {
            blockSize = clen;
        }
        do {
            fos.write(contents, totalSize, blockSize);
            fos.flush();
            if ((totalSize += blockSize) < clen) {
                if (clen - totalSize >= blockSize) continue;
                blockSize = clen - totalSize;
                continue;
            }
            blockSize = 0;
        } while (blockSize > 0);
    }

    private static String consolidateSeperators(String path) {
        if (path == null) {
            return null;
        }
        if (path.lastIndexOf(92) > -1) {
            path = path.replaceAll("\\\\", "/");
        }
        return path;
    }

    public static String escape(String input) {
        if (input == null) {
            return null;
        }
        input = input.replaceAll("\\\\", "\\\\\\\\");
        input = input.replaceAll("\\\"", "\\\\\"");
        return input;
    }
}

