/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.pmi.factory;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.pmi.PerfModules;
import com.ibm.websphere.pmi.PmiModuleConfig;
import com.ibm.websphere.pmi.server.PmiAbstractModule;
import com.ibm.websphere.pmi.server.SpdDouble;
import com.ibm.websphere.pmi.server.SpdLoad;
import com.ibm.websphere.pmi.server.SpdLong;
import com.ibm.websphere.pmi.server.SpdStat;
import com.ibm.websphere.pmi.stat.MBeanStatDescriptor;
import com.ibm.ws.pmi.factory.StatsFactoryUtil;
import com.ibm.ws.pmi.factory.StatsGroupImpl;
import com.ibm.ws.pmi.server.ModuleItem;
import com.ibm.ws.pmi.server.PmiRegistry;
import com.ibm.ws.pmi.stat.StatisticImpl;
import com.ibm.ws.pmi.stat.StatsImpl;
import com.ibm.wsspi.pmi.factory.StatisticActions;
import com.ibm.wsspi.pmi.factory.StatsFactoryException;
import com.ibm.wsspi.pmi.factory.StatsGroup;
import com.ibm.wsspi.pmi.factory.StatsInstance;
import com.ibm.wsspi.pmi.stat.SPIStatistic;
import java.util.ArrayList;
import javax.management.ObjectName;

public class StatsInstanceImpl
extends PmiAbstractModule
implements StatsInstance {
    private static final long serialVersionUID = 7571693856735644184L;
    private static final TraceNLS nls = TraceNLS.getTraceNLS("com.ibm.ws.pmi.properties.PMIMessages");
    private static final TraceComponent tc = Tr.register(StatsInstanceImpl.class, null, "com.ibm.ws.pmi.properties.PMIMessages");
    private String[] _path;
    private String _moduleID;
    private String _cInstanceName;
    private boolean _bHasMBean;
    private StatisticImpl[] _stats;
    private int _statCount = 0;

    protected StatsInstanceImpl(String name, PmiModuleConfig config2, StatisticActions sal) {
        super(config2, null, sal);
        this.type = 13;
        this._moduleID = config2.getUID();
        this._cInstanceName = name;
        this._path = new String[]{this._cInstanceName};
        this._stats = new StatisticImpl[config2.getNumData()];
    }

    protected StatsInstanceImpl(String name, PmiModuleConfig config2, String[] path, StatisticActions sal) {
        super(config2, name, sal);
        this.type = 14;
        this._moduleID = config2.getUID();
        this._cInstanceName = name;
        this._path = path;
        this._stats = new StatisticImpl[config2.getNumData()];
    }

    private void _register(ObjectName userProvidedMBeanObjectName, boolean bCreateDefaultMBean) throws StatsFactoryException {
        MBeanStatDescriptor msd = StatsFactoryUtil.createMBean(this, this._cInstanceName, userProvidedMBeanObjectName, bCreateDefaultMBean);
        this._bHasMBean = msd != null;
        StatsFactoryUtil.registerModule(this, msd);
    }

    public static StatsInstanceImpl createInstance(String name, String configXmlPath, ObjectName userProvidedMBeanObjectName, boolean bCreateDefaultMBean, StatisticActions actionLsnr) throws StatsFactoryException {
        PmiModuleConfig cfg = PerfModules.getConfigFromXMLFile(configXmlPath);
        if (cfg == null) {
            Tr.warning(tc, "PMI0102W", configXmlPath);
            throw new StatsFactoryException(nls.getFormattedMessage("PMI0102W", new Object[]{configXmlPath}, "Unable to read custom PMI module configuration: {0}") + ". " + PerfModules.getParseExceptionMsg());
        }
        StatsInstanceImpl instance = new StatsInstanceImpl(name, cfg, actionLsnr);
        instance._register(userProvidedMBeanObjectName, bCreateDefaultMBean);
        return instance;
    }

    public static StatsInstanceImpl createGroupInstance(String name, StatsGroup igroup, ObjectName userProvidedMBeanObjectName, boolean bCreateDefaultMBean, StatisticActions actionLsnr) throws StatsFactoryException {
        StatsGroupImpl group = (StatsGroupImpl)igroup;
        String[] parentPath = group.getPath();
        String[] path = new String[parentPath.length + 1];
        for (int i = 0; i < parentPath.length; ++i) {
            path[i] = parentPath[i];
        }
        path[parentPath.length] = name;
        StatsInstanceImpl instance = new StatsInstanceImpl(name, group.getModuleConfig(), path, actionLsnr);
        instance._register(userProvidedMBeanObjectName, bCreateDefaultMBean);
        return instance;
    }

    public static StatsInstanceImpl createGroupInstance(String name, StatsGroup igroup, String configXmlPath, ObjectName userProvidedMBeanObjectName, boolean bCreateDefaultMBean, StatisticActions actionLsnr) throws StatsFactoryException {
        PmiModuleConfig cfg = PerfModules.getConfigFromXMLFile(configXmlPath);
        if (cfg == null) {
            Tr.warning(tc, "PMI0102W", configXmlPath);
            throw new StatsFactoryException(nls.getFormattedMessage("PMI0102W", new Object[]{configXmlPath}, "Unable to read custom PMI module configuration: {0}") + ". " + PerfModules.getParseExceptionMsg());
        }
        StatsGroupImpl group = (StatsGroupImpl)igroup;
        StatsFactoryUtil.checkDataIDUniqueness(group, cfg);
        String[] parentPath = group.getPath();
        String[] path = new String[parentPath.length + 1];
        for (int i = 0; i < parentPath.length; ++i) {
            path[i] = parentPath[i];
        }
        path[parentPath.length] = name;
        StatsInstanceImpl instance = new StatsInstanceImpl(name, cfg, path, actionLsnr);
        instance._register(userProvidedMBeanObjectName, bCreateDefaultMBean);
        return instance;
    }

    public SPIStatistic getStatistic(int id) {
        for (int i = 0; i < this._stats.length; ++i) {
            if (this._stats[i] == null || this._stats[i].getId() != id) continue;
            return this._stats[i];
        }
        return null;
    }

    public ObjectName getMBean() {
        if (this._bHasMBean) {
            return this.getMBeanName();
        }
        return null;
    }

    public void setMBean(ObjectName mBeanName) {
        ModuleItem mItem = PmiRegistry.findModuleItem(this._path);
        if (mItem != null) {
            StatsFactoryUtil.setMBeanMapping(mItem, mBeanName);
        } else {
            Tr.warning(tc, "PMI0105W", this._path[this._path.length - 1]);
        }
    }

    public String getModuleID() {
        return this._moduleID;
    }

    public int getDefaultLevel() {
        return 0;
    }

    public String[] getPath() {
        return this._path;
    }

    public String getName() {
        return this._cInstanceName;
    }

    public StatsImpl getStats(ArrayList dataMembers, ArrayList colMembers) {
        StatsImpl s = new StatsImpl(this.getModuleID(), this.getName(), this.type, this.currentLevel, dataMembers, colMembers);
        return s;
    }

    public boolean isCustomModule() {
        return true;
    }

    protected boolean longCreated(SpdLong data) {
        this._setStatMap(data.getStatistic());
        return true;
    }

    protected boolean doubleCreated(SpdDouble data) {
        this._setStatMap(data.getStatistic());
        return true;
    }

    protected boolean statCreated(SpdStat data) {
        this._setStatMap(data.getStatistic());
        return true;
    }

    protected boolean loadCreated(SpdLoad data) {
        this._setStatMap(data.getStatistic());
        return true;
    }

    protected boolean externalStatisticCreated(StatisticImpl stat) {
        this._setStatMap(stat);
        return true;
    }

    private void _setStatMap(StatisticImpl s) {
        if (this.statisticActionLsnr != null) {
            this.statisticActionLsnr.statisticCreated(s);
        }
        this._stats[this._statCount] = s;
        ++this._statCount;
    }

    public String getWCCMStatsType() {
        return this._moduleID;
    }

    public synchronized boolean setFineGrainedInstrumentation(int[] enabled, int[] enableWithSync) {
        boolean retVal = super.setFineGrainedInstrumentation(enabled, enableWithSync);
        if (this.statisticActionLsnr != null) {
            int i;
            int _enabledCount = 0;
            int _disabledCount = 0;
            for (i = 0; i < this._statCount; ++i) {
                if (!this._stats[i].isEnabled()) continue;
                ++_enabledCount;
            }
            int[] _enabled = new int[_enabledCount];
            int[] _disabled = new int[this._statCount - _enabledCount];
            _enabledCount = 0;
            for (i = 0; i < this._statCount; ++i) {
                if (this._stats[i].isEnabled()) {
                    _enabled[_enabledCount++] = this._stats[i].getId();
                    continue;
                }
                _disabled[_disabledCount++] = this._stats[i].getId();
            }
            this.statisticActionLsnr.enableStatusChanged(_enabled, _disabled);
        }
        return retVal;
    }
}

