/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.pmi.factory;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.pmi.PerfModules;
import com.ibm.websphere.pmi.PmiModuleConfig;
import com.ibm.websphere.pmi.stat.MBeanStatDescriptor;
import com.ibm.ws.pmi.factory.StatsFactoryUtil;
import com.ibm.ws.pmi.factory.StatsInstanceImpl;
import com.ibm.ws.pmi.server.ModuleAggregate;
import com.ibm.ws.pmi.server.ModuleItem;
import com.ibm.ws.pmi.server.PmiRegistry;
import com.ibm.ws.pmi.stat.StatsImpl;
import com.ibm.wsspi.pmi.factory.StatsFactoryException;
import com.ibm.wsspi.pmi.factory.StatsGroup;
import com.ibm.wsspi.pmi.factory.StatsInstance;
import java.util.ArrayList;
import javax.management.ObjectName;

public class StatsGroupImpl
extends ModuleAggregate
implements StatsGroup {
    private static final long serialVersionUID = 7503693980854338755L;
    private static final TraceNLS nls = TraceNLS.getTraceNLS("com.ibm.ws.pmi.properties.PMIMessages");
    private static final TraceComponent tc = Tr.register(StatsGroupImpl.class, null, "com.ibm.ws.pmi.properties.PMIMessages");
    private String[] _path;
    private String _cGroupName;
    private boolean _bHasMBean;
    private StringBuffer _subModuleID = new StringBuffer();
    private ArrayList subModuleList;

    protected StatsGroupImpl(String name, PmiModuleConfig config2) {
        super(config2.getUID(), false);
        this._cGroupName = name;
        this._path = new String[]{this._cGroupName};
    }

    protected StatsGroupImpl(String name, PmiModuleConfig config2, String[] path) {
        super(config2.getUID(), false);
        this._cGroupName = name;
        this._path = path;
    }

    private void _register(ObjectName userProvidedMBeanObjectName, boolean bCreateDefaultMBean) throws StatsFactoryException {
        MBeanStatDescriptor msd = StatsFactoryUtil.createMBean(this, this._cGroupName, userProvidedMBeanObjectName, bCreateDefaultMBean);
        this._bHasMBean = msd != null;
        StatsFactoryUtil.registerModule(this, msd);
    }

    public static StatsGroup createGroup(String name, String configXmlPath, ObjectName userProvidedMBeanObjectName, boolean bCreateDefaultMBean) throws StatsFactoryException {
        PmiModuleConfig cfg = PerfModules.getConfigFromXMLFile(configXmlPath);
        if (cfg == null) {
            Tr.warning(tc, "PMI0102W", configXmlPath);
            throw new StatsFactoryException(nls.getFormattedMessage("PMI0102W", new Object[]{configXmlPath}, "Unable to read custom PMI module configuration: {0}") + ". " + PerfModules.getParseExceptionMsg());
        }
        StatsGroupImpl group = new StatsGroupImpl(name, cfg);
        group._register(userProvidedMBeanObjectName, bCreateDefaultMBean);
        return group;
    }

    public static StatsGroup createGroup(String name, StatsGroup igroup, String configXmlPath, ObjectName userProvidedMBeanObjectName, boolean bCreateDefaultMBean) throws StatsFactoryException {
        StatsGroupImpl parentGroup = (StatsGroupImpl)igroup;
        PmiModuleConfig cfg = PerfModules.getConfigFromXMLFile(configXmlPath);
        if (cfg == null) {
            Tr.warning(tc, "PMI0102W", configXmlPath);
            throw new StatsFactoryException(nls.getFormattedMessage("PMI0102W", new Object[]{configXmlPath}, "Unable to read custom PMI module configuration: {0}") + ". " + PerfModules.getParseExceptionMsg());
        }
        StatsFactoryUtil.checkDataIDUniqueness(parentGroup, cfg);
        String[] parentPath = parentGroup.getPath();
        String[] path = new String[parentPath.length + 1];
        for (int i = 0; i < parentPath.length; ++i) {
            path[i] = parentPath[i];
        }
        path[parentPath.length] = name;
        StatsGroupImpl group = new StatsGroupImpl(name, cfg, path);
        group._register(userProvidedMBeanObjectName, bCreateDefaultMBean);
        return group;
    }

    public static StatsGroup createGroup(String name, StatsInstance iInstance, String subModuleConfigXMLFile, ObjectName userProvidedMBeanObjectName, boolean bCreateDefaultMBean) throws StatsFactoryException {
        StatsInstanceImpl parentInstance = (StatsInstanceImpl)iInstance;
        PmiModuleConfig cfg = PerfModules.getConfigFromXMLFile(subModuleConfigXMLFile);
        if (cfg == null) {
            Tr.warning(tc, "PMI0102W", subModuleConfigXMLFile);
            throw new StatsFactoryException(nls.getFormattedMessage("PMI0102W", new Object[]{subModuleConfigXMLFile}, "Unable to read custom PMI module configuration: {0}") + ". " + PerfModules.getParseExceptionMsg());
        }
        StatsFactoryUtil.checkDataIDUniqueness(parentInstance, cfg);
        String[] parentPath = parentInstance.getPath();
        String[] path = new String[parentPath.length + 1];
        for (int i = 0; i < parentPath.length; ++i) {
            path[i] = parentPath[i];
        }
        path[parentPath.length] = name;
        StatsGroupImpl group = new StatsGroupImpl(name, cfg, path);
        group._register(userProvidedMBeanObjectName, bCreateDefaultMBean);
        return group;
    }

    public int getDefaultLevel() {
        return 0;
    }

    public String[] getPath() {
        return this._path;
    }

    public String getName() {
        return this._cGroupName;
    }

    public StatsImpl getStats(ArrayList dataMembers, ArrayList colMembers) {
        StatsImpl s = new StatsImpl(this.getModuleID() + this._subModuleID.toString(), this.getName(), this.type, this.currentLevel, dataMembers, colMembers);
        return s;
    }

    public boolean isCustomModule() {
        return true;
    }

    public ObjectName getMBean() {
        if (this._bHasMBean) {
            return this.getMBeanName();
        }
        return null;
    }

    public void setMBean(ObjectName mBeanName) {
        ModuleItem mItem = PmiRegistry.findModuleItem(this._path);
        if (mItem != null) {
            StatsFactoryUtil.setMBeanMapping(mItem, mBeanName);
        } else {
            Tr.warning(tc, "PMI0105W", this._path[this._path.length - 1]);
        }
    }

    public void addModuleID(String id) {
        if (this.subModuleList == null) {
            this.subModuleList = new ArrayList(2);
        }
        for (int i = 0; i < this.subModuleList.size(); ++i) {
            if (id.compareTo((String)this.subModuleList.get(i)) != 0) continue;
            return;
        }
        this.subModuleList.add(id);
        this._subModuleID.append(",").append(id);
    }

    protected String[] getCustomSubModuleList() {
        if (this.subModuleList == null) {
            return null;
        }
        String[] list = new String[this.subModuleList.size()];
        for (int i = 0; i < this.subModuleList.size(); ++i) {
            list[i] = (String)this.subModuleList.get(i);
        }
        return list;
    }

    public String getWCCMStatsType() {
        return this.getModuleID() + this._subModuleID.toString();
    }

    public int[] getStatisticIDBySet(String setID) {
        int i;
        ArrayList<Integer> list = new ArrayList<Integer>();
        int[] set = PerfModules.getConfig(this.getModuleID()).listStatisticsBySet(setID);
        for (i = 0; i < set.length; ++i) {
            list.add(new Integer(set[i]));
        }
        if (this.subModuleList != null) {
            for (i = 0; i < this.subModuleList.size(); ++i) {
                set = PerfModules.getConfig((String)this.subModuleList.get(i)).listStatisticsBySet(setID);
                for (int k = 0; k < set.length; ++k) {
                    list.add(new Integer(set[k]));
                }
            }
        }
        int[] statSet = new int[list.size()];
        for (int i2 = 0; i2 < list.size(); ++i2) {
            statSet[i2] = (Integer)list.get(i2);
        }
        return statSet;
    }
}

