/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.pmi.dynamicproxy;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.AdminService;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.websphere.management.dynamicproxy.ServantProcessStatus;
import com.ibm.ws.pmi.dynamicproxy.PmiStateObject;
import com.ibm.ws.pmi.stat.StatsImpl;
import java.util.ArrayList;
import java.util.HashSet;
import javax.management.InstanceNotFoundException;
import javax.management.MalformedObjectNameException;
import javax.management.Notification;
import javax.management.NotificationFilter;
import javax.management.NotificationFilterSupport;
import javax.management.NotificationListener;
import javax.management.ObjectName;

public class PmiNotificationListener
implements NotificationListener {
    private HashSet aggregatedTermServants = new HashSet();
    private static TraceComponent tc = Tr.register(PmiNotificationListener.class, "PMI", null);

    private PmiNotificationListener() {
    }

    public static void register() throws InstanceNotFoundException {
        PmiNotificationListener listener;
        ObjectName queryMBean;
        AdminService as;
        block9: {
            block8: {
                if (tc.isEntryEnabled()) {
                    Tr.entry(tc, "register");
                }
                as = AdminServiceFactory.getAdminService();
                queryMBean = null;
                try {
                    queryMBean = new ObjectName("WebSphere:type=PerfPrivate,*");
                }
                catch (MalformedObjectNameException e) {
                    if (!tc.isDebugEnabled()) break block8;
                    Tr.debug(tc, "MalformedObjectNameException while creating query bean for PerfPrivate: \n" + e);
                }
            }
            ObjectName perfPrivMBean = (ObjectName)as.queryNames(queryMBean, null).iterator().next();
            listener = new PmiNotificationListener();
            NotificationFilterSupport filter = new NotificationFilterSupport();
            filter.enableType("websphere.pmi.beforeServantStop");
            filter.enableType("websphere.pmi.beforeServantIdle");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "register - addNotificationListener", perfPrivMBean);
            }
            as.addNotificationListener(perfPrivMBean, listener, (NotificationFilter)filter, null);
            try {
                queryMBean = new ObjectName("WebSphere:type=ControlAdminService,*");
            }
            catch (MalformedObjectNameException e) {
                if (!tc.isDebugEnabled()) break block9;
                Tr.debug(tc, "MalformedObjectNameException while creating query bean for PerfPrivate: \n" + e);
            }
        }
        ObjectName controlAdminServiceMBean = (ObjectName)as.queryNames(queryMBean, null).iterator().next();
        NotificationFilterSupport filter2 = new NotificationFilterSupport();
        filter2.enableType("websphere.ws390.servant.terminated");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "register - addNotificationListener", controlAdminServiceMBean);
        }
        as.addNotificationListener(controlAdminServiceMBean, listener, (NotificationFilter)filter2, null);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "register");
        }
    }

    public void handleNotification(Notification notif, Object handback) {
        Object nUserData;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "handleNotification", new Object[]{notif, handback});
        }
        if ((nUserData = notif.getUserData()) == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "handleNotification", "Notification's UserData is null");
            }
            return;
        }
        String stoken = null;
        StatsImpl s = null;
        if (nUserData instanceof ArrayList) {
            stoken = (String)((ArrayList)nUserData).get(0);
            s = (StatsImpl)((ArrayList)nUserData).get(1);
        } else if (nUserData instanceof ServantProcessStatus) {
            stoken = ((ServantProcessStatus)nUserData).getServantStoken();
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "handleNotification", new Object[]{notif.getType(), stoken, s});
        }
        if (notif.getType().equals("websphere.pmi.beforeServantStop")) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "PerfPrivate.NOTIFY_BEFORE_SERVANT_STOP event");
            }
            this.serverTerminated(stoken, s);
        } else if (notif.getType().equals("websphere.pmi.beforeServantIdle")) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "PerfPrivate.NOTIFY_BEFORE_SERVANT_IDLE event");
            }
            PmiStateObject.addIdleServerStats(stoken, s);
        } else if (notif.getType().equals("websphere.ws390.servant.terminated")) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "ServantProcessStatus.EVENT_TYPE_SERVANT_TERMINATED event");
            }
            this.serverTerminated(stoken, null);
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "PerfPrivate.? event", notif.getType());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "handleNotification");
        }
    }

    private synchronized void serverTerminated(String stoken, StatsImpl s) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "serverTerminated", new Object[]{stoken, s});
        }
        if (this.aggregatedTermServants.contains(stoken)) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "serverTerminated - already aggregated");
            }
            return;
        }
        if (s == null) {
            StatsImpl termStats = PmiStateObject.getActiveServerStats(stoken);
            if (termStats == null) {
                termStats = PmiStateObject.getIdleServerStats(stoken);
            }
            if (termStats != null) {
                PmiStateObject.addTerminatedServerStats(stoken, termStats);
                this.aggregatedTermServants.add(stoken);
            }
        } else {
            PmiStateObject.addTerminatedServerStats(stoken, s);
            this.aggregatedTermServants.add(stoken);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "serverTerminated");
        }
    }
}

