/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.pmi.dynamicproxy;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.dynamicproxy.AggregationHandler;
import com.ibm.websphere.management.dynamicproxy.ServantMBeanResult;
import com.ibm.websphere.management.dynamicproxy.StateObject;
import com.ibm.websphere.pmi.stat.MBeanStatDescriptor;
import com.ibm.websphere.pmi.stat.StatDescriptor;
import com.ibm.ws.pmi.dynamicproxy.PerfPrivateLocal;
import com.ibm.ws.pmi.dynamicproxy.PmiStateObject;
import com.ibm.ws.pmi.dynamicproxy.StatsUtil;
import com.ibm.ws.pmi.server.DataDescriptor;
import com.ibm.ws.pmi.stat.StatsImpl;
import javax.management.ObjectName;

public class PerfMBeanAggregationHandler
implements AggregationHandler {
    private static TraceComponent tc = Tr.register(PerfMBeanAggregationHandler.class, "PMI", null);
    private static boolean obtainedSystemStats = false;
    private static boolean obtainedJVMStats = false;

    public Object aggregateResults(String methodName, Object[] params, String[] signatures, ServantMBeanResult[] servantMBeanResults, StateObject stateObject) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "aggregateResults", new Object[]{methodName, params[0], signatures[0]});
        }
        if (methodName.equals("getStatsObject")) {
            DataDescriptor dd = null;
            if (signatures[0].equals("javax.management.ObjectName")) {
                dd = PerfPrivateLocal.get().getDataDescriptor((ObjectName)params[0]);
            } else if (signatures[0].equals("com.ibm.websphere.pmi.stat.MBeanStatDescriptor")) {
                dd = PerfPrivateLocal.get().getDataDescriptor((MBeanStatDescriptor)params[0]);
            } else if (signatures[0].equals("com.ibm.ws.pmi.server.DataDescriptor")) {
                dd = (DataDescriptor)params[0];
            }
            StatsImpl result = null;
            StatsImpl[] stats = null;
            String[] stokens = null;
            if (servantMBeanResults != null && servantMBeanResults.length > 0) {
                stats = new StatsImpl[servantMBeanResults.length];
                stokens = new String[servantMBeanResults.length];
                for (int i = 0; i < servantMBeanResults.length; ++i) {
                    stats[i] = (StatsImpl)servantMBeanResults[i].getResult();
                    stokens[i] = servantMBeanResults[i].getStoken();
                }
            }
            result = PerfMBeanAggregationHandler.aggregate(dd, stokens, stats);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "aggregateResults", result);
            }
            return result;
        }
        if (methodName.equals("getStatsArray")) {
            int d;
            int i;
            DataDescriptor[] dds = null;
            boolean ddaProcessing = false;
            if (signatures[0].equals("[Ljavax.management.ObjectName;")) {
                ObjectName[] objNameArray = (ObjectName[])params[0];
                dds = new DataDescriptor[objNameArray.length];
                for (i = 0; i < objNameArray.length; ++i) {
                    dds[i] = PerfPrivateLocal.get().getDataDescriptor(objNameArray[i]);
                }
            } else if (signatures[0].equals("[Lcom.ibm.websphere.pmi.stat.MBeanStatDescriptor;")) {
                MBeanStatDescriptor[] mbeanSDArray = (MBeanStatDescriptor[])params[0];
                dds = new DataDescriptor[mbeanSDArray.length];
                for (i = 0; i < mbeanSDArray.length; ++i) {
                    dds[i] = PerfPrivateLocal.get().getDataDescriptor(mbeanSDArray[i]);
                }
            } else if (signatures[0].equals("[Lcom.ibm.ws.pmi.server.DataDescriptor;")) {
                dds = (DataDescriptor[])params[0];
                ddaProcessing = true;
            } else if (signatures[0].equals("[Lcom.ibm.websphere.pmi.stat.StatDescriptor;")) {
                StatDescriptor[] sdArray = (StatDescriptor[])params[0];
                dds = new DataDescriptor[sdArray.length];
                for (i = 0; i < sdArray.length; ++i) {
                    dds[i] = sdArray[i].getPath() == null ? new DataDescriptor(new String[]{"pmi"}) : new DataDescriptor(sdArray[i].getPath());
                }
            }
            StatsImpl[] result = new StatsImpl[dds.length];
            StatsImpl[][] stats = null;
            String[] stokens = null;
            StatsImpl[] tmpStats = null;
            if (servantMBeanResults != null && servantMBeanResults.length > 0) {
                stats = new StatsImpl[dds.length][servantMBeanResults.length];
                stokens = new String[servantMBeanResults.length];
                for (d = 0; d < dds.length; ++d) {
                    for (int s = 0; s < servantMBeanResults.length; ++s) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "aggregateResults - result(" + s + ")", servantMBeanResults[s].getResult());
                        }
                        tmpStats = (StatsImpl[])servantMBeanResults[s].getResult();
                        stats[d][s] = tmpStats[d];
                        stokens[s] = servantMBeanResults[s].getStoken();
                    }
                }
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "aggregateResults - aggregate passing in " + dds.length + " elements!");
            }
            for (d = 0; d < dds.length; ++d) {
                if (stats == null) {
                    if (tc.isDebugEnabled() && dds[d] != null) {
                        Tr.debug(tc, "aggregateResults - result[" + d + "] set to NULL (\n" + "dds[" + d + "] ==|" + dds[d].getModuleName() + "|==,\n" + "stoken ==|" + stokens + "|==,\n" + "stats ==|" + stats + "|==)");
                    }
                    result[d] = null;
                    continue;
                }
                if (tc.isDebugEnabled() && dds[d] != null) {
                    Tr.debug(tc, "aggregateResults - aggregate(\ndds[" + d + "] ==|" + dds[d].getModuleName() + "|==,\n" + "stoken ==|" + stokens + "|==,\n" + "stats[" + d + "] ==|" + stats[d] + "|==)");
                }
                result[d] = PerfMBeanAggregationHandler.aggregate(dds[d], stokens, stats[d]);
                if (!ddaProcessing || result[d] != null || dds[d] == null) continue;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "aggregateResults - aggregate result[" + d + "] for " + dds[d].getModuleName() + " ==|" + result[d] + "|==");
                }
                result[d] = new StatsImpl(dds[d].getModuleName(), 13);
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "aggregateResults - aggregate null result filled with ==|" + result[d] + "|==");
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "aggregateResults", result);
            }
            return result;
        }
        return methodName + " is NOT handled by " + this.getClass().getName();
    }

    public static StatsImpl aggregate(DataDescriptor dd, String[] stokens, StatsImpl[] statsArr) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "aggregate", dd);
        }
        StatsImpl stats = null;
        StatsImpl termServStats = null;
        StatsImpl idleServStats = null;
        obtainedSystemStats = false;
        obtainedJVMStats = false;
        if (stokens != null && statsArr != null) {
            for (int i = 0; i < statsArr.length; ++i) {
                if (statsArr[i] == null) continue;
                PmiStateObject.setActiveServerStats(stokens[i], dd, statsArr[i]);
            }
        }
        stats = PmiStateObject.getActiveServerStats(dd);
        idleServStats = PmiStateObject.getIdleServerStats(dd);
        if (idleServStats != null) {
            if (stats == null) {
                stats = idleServStats;
            } else {
                StatsUtil.combine(stats, idleServStats);
            }
        }
        if ((termServStats = PmiStateObject.getTerminatedServerStats(dd)) != null) {
            if (stats == null) {
                stats = termServStats;
            } else {
                StatsUtil.combine(stats, termServStats);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "aggregate", StatsUtil.getStatsName(stats));
        }
        return stats;
    }

    public static boolean obtainedSystemStats() {
        return obtainedSystemStats;
    }

    public static void setObtainedSystemStats(boolean value) {
        obtainedSystemStats = value;
    }

    public static boolean obtainedJVMStats() {
        return obtainedJVMStats;
    }

    public static void setObtainedJVMStats(boolean value) {
        obtainedJVMStats = value;
    }
}

