/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.orbimpl.transport;

import com.ibm.CORBA.iiop.CDRInputStream;
import com.ibm.CORBA.iiop.ClientDelegate;
import com.ibm.CORBA.iiop.ORB;
import com.ibm.CORBA.iiop.ORBConnection;
import com.ibm.CORBA.iiop.ORBForTransports;
import com.ibm.CORBA.iiop.Plugin;
import com.ibm.CORBA.iiop.Profile;
import com.ibm.CORBA.ras.ORBRas;
import com.ibm.CORBA.transport.ConnectionTable;
import com.ibm.CORBA.transport.ListenerThread;
import com.ibm.CORBA.transport.Transport;
import com.ibm.CORBA.transport.TransportBase;
import com.ibm.CORBA.transport.TransportConnection;
import com.ibm.ffdc.Manager;
import com.ibm.websphere.ssl.JSSEHelper;
import com.ibm.websphere.ssl.SSLConfigChangeEvent;
import com.ibm.websphere.ssl.SSLConfigChangeListener;
import com.ibm.ws.orb.transport.ConnectionData;
import com.ibm.ws.orb.transport.ConnectionDataCarrier;
import com.ibm.ws.orb.transport.ConnectionInterceptor;
import com.ibm.ws.orb.transport.DefaultConnectionInterceptor;
import com.ibm.ws.orb.transport.ServerConnectionData;
import com.ibm.ws.orb.transport.WSSSLClientSocketFactory;
import com.ibm.ws.orb.transport.WSSSLServerSocketFactory;
import com.ibm.ws.orbimpl.MessageUtility;
import com.ibm.ws.orbimpl.transport.ConnectionKey;
import com.ibm.ws.orbimpl.transport.DefaultServerConnectionDataImpl;
import com.ibm.ws.orbimpl.transport.SSLConnectionKey;
import com.ibm.ws.orbimpl.transport.WSHTTPTransportConnection;
import com.ibm.ws.orbimpl.transport.WSSSLTransportConnection;
import com.ibm.ws.orbimpl.transport.WSTCPTransportConnection;
import com.ibm.ws.security.util.AccessController;
import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.INTERNAL;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.TRANSIENT;

public class WSTransport
extends TransportBase
implements Transport,
Plugin,
SSLConfigChangeListener {
    public static final int SSL_TAGGED_COMPONENT_ID = 20;
    protected ORB fORB;
    protected ConnectionTable fConnectionTable;
    protected ORBForTransports fORBForTransports;
    protected long globalCounter = 0L;
    protected Profile serverProfile = null;
    protected static ConnectionInterceptor connectionInterceptor = null;
    protected Map tableOfListeners = new Hashtable();
    protected Map tableOfServerSockets = new Hashtable();
    protected int acceptTimeout = 5000;
    protected static WSTransport wsTransport = null;
    protected static boolean registeredListener = false;
    private String forceTunnel = "whenrequired";
    private boolean forceTunnelVarSet = false;
    static WSSSLServerSocketFactory sslFactory = null;
    private static WSSSLClientSocketFactory sslClientFactory = null;

    public void init(ORB orb) {
        String methodName = "init(ORB)";
        wsTransport = this;
        this.fORB = orb;
        this.fConnectionTable = ORB.createConnectionTable((ORB)this.fORB, (Transport)this);
        this.fORBForTransports = this.fORB.getORBForTransports();
        String ciName = orb.getProperty("com.ibm.ws.orb.transport.ConnectionInterceptorName");
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.trace(4112L, (Object)this, "init(ORB)", "The value of the property \"com.ibm.ws.orb.transport.ConnectionInterceptorName\" is " + ciName);
        }
        if (ciName == null) {
            connectionInterceptor = new DefaultConnectionInterceptor();
            connectionInterceptor.init(orb);
        } else {
            try {
                connectionInterceptor = (ConnectionInterceptor)Class.forName(ciName).newInstance();
                connectionInterceptor.init(orb);
            }
            catch (Exception ex) {
                String securityConfigured = System.getProperty("com.ibm.CORBA.ConfigURL");
                if (securityConfigured != null && !securityConfigured.equals("") && ORBRas.isTrcLogging) {
                    ORBRas.orbTrcLogger.trace(4112L, (Object)this, "init(ORB)", "SECURITY CONFIG ERROR:  Error loading security interceptor, security is disabled.  Check to ensure com.ibm.CORBA.ConfigURL is setup correctly and that SAS.JAR is in the classpath.");
                }
                Manager.Ffdc.log(ex, this, "com.ibm.ws.orbimpl.transport.WSTransport.init", "176", this);
                if (ORBRas.isTrcLogging) {
                    ORBRas.orbTrcLogger.trace(4112L, (Object)this, "init(ORB)", "Invalid ConnectionInterceptor name. The invalid name is: " + ciName);
                }
                if (ORBRas.isTrcLogging) {
                    ORBRas.orbTrcLogger.exception(4112L, (Object)this, "init(ORB)", ex);
                }
                throw new INTERNAL("CONNECTIONINTERCEPTOR_INVALID_CLASSNAME", 1229066331, CompletionStatus.COMPLETED_NO);
            }
        }
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.trace(4112L, (Object)this, "init(ORB)", "The connectionInterceptor is " + connectionInterceptor);
        }
        try {
            String tOut = this.fORB.getProperty("com.ibm.CORBA.AcceptTimeout");
            int timeout = tOut != null ? Integer.parseInt(tOut) : 5000;
            if (timeout < 0 || timeout > 5000) {
                if (ORBRas.isTrcLogging) {
                    ORBRas.orbTrcLogger.trace(4112L, (Object)this, "init(ORB)", "com.ibm.CORBA.AcceptTimeout value is invalid, using default value: 5000");
                }
            } else {
                this.acceptTimeout = timeout;
                if (ORBRas.isTrcLogging) {
                    ORBRas.orbTrcLogger.trace(4112L, (Object)this, "init(ORB)", "com.ibm.CORBA.AcceptTimeout value set to: " + this.acceptTimeout);
                }
            }
        }
        catch (Exception ex) {
            Manager.Ffdc.log(ex, this, "com.ibm.ws.orbimpl.transport.WSTransport.init", "245", this);
            this.acceptTimeout = 5000;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public ORBConnection getConnection(Profile iop, ClientDelegate cd, String operationName) {
        methodName = "getConnection(Profile, ClientDelegate)";
        if (ORBRas.isTrcLogging) {
            this.logGetConnectionParameters(iop, cd, operationName);
        }
        connectionDataCarrier = new ConnectionDataCarrier();
        connectionData = null;
        connectionIntercetporSucceeded = true;
        conn = null;
        ior = null;
        ior = cd.locatedIOR();
        if (ior == null) {
            ior = cd.getInitialIOR();
        }
        if (!(connectionInterceptorSucceeded = WSTransport.connectionInterceptor.getConnectionKey(iop, 0, ior, null, operationName, connectionDataCarrier))) {
            if (ORBRas.isTrcLogging) {
                ORBRas.orbTrcLogger.trace(4112L, (Object)this, "getConnection(Profile, ClientDelegate)", "getConnectionKey returned false");
            }
            throw new TRANSIENT("GETCONNECTIONKEY_RETURNED_FALSE", 1229066353, CompletionStatus.COMPLETED_NO);
        }
        connectionData = connectionDataCarrier.getConnectionData();
        if (connectionData == null) {
            if (ORBRas.isTrcLogging) {
                ORBRas.orbTrcLogger.trace(4112L, (Object)this, "getConnection(Profile, ClientDelegate)", "connectionDataCarrier.getConnectionData() returned null");
            }
            throw new INTERNAL("NO_CONNECTIONDATA_IN_CONNECTIONDATACARRIER", 1229066332, CompletionStatus.COMPLETED_NO);
        }
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.trace(4112L, (Object)this, "getConnection(Profile, ClientDelegate)", "the ConnectionData object returned by ConnectionInterceptor.getConnectionKey is: " + connectionData);
        }
        if ((conn = this.fConnectionTable.getConnection((com.ibm.CORBA.transport.ConnectionKey)(key = this.getKeyFromConnectionData(connectionData)))) != null) {
            if (ORBRas.isTrcLogging) {
                ORBRas.orbTrcLogger.trace(4112L, (Object)this, "getConnection(Profile, ClientDelegate)", "a connection for the following key was found in the cache, key=" + key);
            }
            return conn;
        }
        var12_12 = this;
        synchronized (var12_12) {
            conn = this.fConnectionTable.getConnection((com.ibm.CORBA.transport.ConnectionKey)key);
            if (conn != null) {
                if (ORBRas.isTrcLogging) {
                    ORBRas.orbTrcLogger.trace(4112L, (Object)this, "getConnection(Profile, ClientDelegate)", "a connection for the following key was found in the cache, key=" + key);
                }
                return conn;
            }
            conn = this.fORBForTransports.createORBConnection();
            this.fConnectionTable.addConnection((com.ibm.CORBA.transport.ConnectionKey)key, conn);
        }
        switch ((int)connectionData.getConnectionType()) {
            case 2: {
                if (this.getForceTunnel().equals("always")) {
                    new WSHTTPTransportConnection(this.fConnectionTable, key, conn, this.fORB, iop, connectionData, WSTransport.connectionInterceptor);
                    this.fConnectionTable.removeConnection((com.ibm.CORBA.transport.ConnectionKey)key);
                } else {
                    try {
                        transportConnection /* !! */  = null;
                        transportConnection /* !! */  = new WSTCPTransportConnection(this.fORBForTransports, this.fConnectionTable, key, conn, this.fORB.getReaderPool(), iop, connectionData, WSTransport.connectionInterceptor);
                        transportConnection /* !! */ .connect();
                        connectionData.setLocalHost(transportConnection /* !! */ .getLocalHost());
                        connectionData.setRemoteHost(transportConnection /* !! */ .getRemoteHost());
                        connectionData.setLocalPort(transportConnection /* !! */ .getLocalPort());
                        connectionData.setRemotePort(transportConnection /* !! */ .getRemotePort());
                    }
                    catch (SystemException ex) {
                        Manager.Ffdc.log(ex, this, "com.ibm.ws.orbimpl.transport.WSTransport.getConnection", "448", new Object[]{this});
                        if (!this.getForceTunnel().equals("never")) {
                            new WSHTTPTransportConnection(this.fConnectionTable, key, conn, this.fORB, iop, connectionData, WSTransport.connectionInterceptor);
                            this.fConnectionTable.removeConnection((com.ibm.CORBA.transport.ConnectionKey)key);
                        }
                        throw ex;
                    }
                }
                this.fConnectionTable.checkConnectionTable();
                return conn;
            }
            case 1: {
                if (!this.getForceTunnel().equals("always")) ** GOTO lbl72
                new WSHTTPTransportConnection(this.fConnectionTable, key, conn, this.fORB, iop, connectionData, WSTransport.connectionInterceptor);
                this.fConnectionTable.removeConnection((com.ibm.CORBA.transport.ConnectionKey)key);
                ** GOTO lbl94
lbl72:
                // 1 sources

                ftransportConnection = transportConnection /* !! */  = new WSSSLTransportConnection(this.fORBForTransports, this.fConnectionTable, key, conn, this.fORB.getReaderPool(), iop, connectionData, WSTransport.connectionInterceptor);
                try {
                    try {
                        AccessController.doPrivileged(new PrivilegedExceptionAction((TransportConnection)ftransportConnection){
                            final /* synthetic */ TransportConnection val$ftransportConnection;
                            {
                                this.val$ftransportConnection = transportConnection;
                            }

                            public Object run() throws IOException {
                                this.val$ftransportConnection.connect();
                                return null;
                            }
                        });
                    }
                    catch (PrivilegedActionException e) {
                        Manager.Ffdc.log(e, this, "com.ibm.ws.orbimpl.transport.WSTransport.getConnection", "512", new Object[]{this});
                        throw (IOException)e.getException();
                    }
                }
                catch (IOException ex) {
                    Manager.Ffdc.log(ex, this, "com.ibm.ws.orbimpl.transport.WSTransport.getConnection", "518", new Object[]{this});
                    ex.printStackTrace();
                }
                sock = transportConnection /* !! */ .getSocket();
                connectionData.setLocalHost(sock.getLocalAddress().getHostAddress());
                connectionData.setRemoteHost(sock.getInetAddress().getHostAddress());
                connectionData.setLocalPort(sock.getLocalPort());
                connectionData.setRemotePort(sock.getPort());
                try {
                    sock.getOutputStream().flush();
                }
                catch (IOException ioe) {
                    Manager.Ffdc.log(ioe, this, "com.ibm.ws.orbimpl.transport.WSTransport.getConnection", "543", new Object[]{this});
                }
lbl94:
                // 3 sources

                this.fConnectionTable.checkConnectionTable();
                return conn;
            }
        }
        throw new INTERNAL("CLIENT_CONNECTIONDATA_IS_INVALID_TYPE", 1229066333, CompletionStatus.COMPLETED_NO);
    }

    public void initTransports() {
        String methodName = "initTransports()";
        ServerConnectionData[] scd = connectionInterceptor.getServerConnectionData(this.fORB);
        if (scd == null) {
            if (ORBRas.isTrcLogging) {
                ORBRas.orbTrcLogger.trace(4112L, (Object)this, "initTransports()", "connectionInterceptor.getServerConnectionData() retuned null ");
            }
            throw new INTERNAL("GETSERVERCONNECTIONDATA_RETURNED_NULL", 1229066361, CompletionStatus.COMPLETED_NO);
        }
        if (ORBRas.isTrcLogging && ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.trace(4112L, (Object)this, "initTransports()", "ConnectionInterceptor.getServerConnectionData() returned the following array: " + this.serverConnectionDataArrayToString(scd));
        }
        block3: for (int i = 0; i < scd.length; ++i) {
            long connectionDataType = scd[i].getConnectionType();
            switch ((int)connectionDataType) {
                case 1: 
                case 2: {
                    this.createListener(scd[i], scd[i].getAddToServerProfile());
                    continue block3;
                }
                default: {
                    if (ORBRas.isTrcLogging) {
                        ORBRas.orbTrcLogger.trace(4112L, (Object)this, "initTransports()", connectionDataType + " is an unknown connection type");
                    }
                    throw new INTERNAL("SERVER_CONNECTIONDATA_IS_INVALID_TYPE", 1229066334, CompletionStatus.COMPLETED_NO);
                }
            }
        }
    }

    public void createListener(int port) {
        DefaultServerConnectionDataImpl cd = new DefaultServerConnectionDataImpl();
        cd.setServerPort(port);
        cd.setConnectionType(2L);
        this.createListener(cd, false);
    }

    public synchronized void stateChanged(SSLConfigChangeEvent e) {
        Set lisSet;
        Map ssClone;
        Map listenerClone;
        ArrayList<ListenerThread> listToRemove;
        block13: {
            String methodName = "stateChanged()";
            listToRemove = new ArrayList<ListenerThread>();
            listenerClone = (Map)((Hashtable)this.tableOfListeners).clone();
            ssClone = (Map)((Hashtable)this.tableOfServerSockets).clone();
            registeredListener = false;
            try {
                JSSEHelper.getInstance().deregisterSSLConfigChangeListener(this);
            }
            catch (Exception ex) {
                if (!ORBRas.isTrcLogging) break block13;
                ORBRas.orbTrcLogger.trace(4112L, (Object)this, "stateChanged()", "Exception deregistering listener." + ex);
            }
        }
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.trace(4112L, (Object)this, "stateChanged()", "Received the following SSL listener event: " + e);
        }
        if ((lisSet = listenerClone.keySet()) != null && lisSet.size() > 0) {
            for (ListenerThread lis : lisSet) {
                ServerConnectionData connectionData;
                block14: {
                    connectionData = (ServerConnectionData)listenerClone.get(lis);
                    ServerSocket ss = (ServerSocket)ssClone.get(lis);
                    if (connectionData == null || (int)connectionData.getConnectionType() != 1) continue;
                    if (ORBRas.isTrcLogging) {
                        ORBRas.orbTrcLogger.trace(4112L, (Object)this, "stateChanged()", "Restarting listener with connection data: " + connectionData);
                    }
                    try {
                        lis.setShutdownPending(true);
                        for (int count = 0; !ss.isClosed() || count >= 5; ++count) {
                            Thread.sleep(200L);
                        }
                    }
                    catch (Exception ex) {
                        Manager.Ffdc.log(ex, this, "com.ibm.ws.orbimpl.transport.WSTransport.stateChanged", "709", this);
                        if (!ORBRas.isTrcLogging) break block14;
                        ORBRas.orbTrcLogger.trace(4112L, (Object)this, "stateChanged()", "Exception shutting down listener: " + ex.toString());
                    }
                }
                listToRemove.add(lis);
                try {
                    Thread.sleep(200L);
                    this.startListening(connectionData);
                }
                catch (Exception ex1) {
                    Manager.Ffdc.log(ex1, this, "com.ibm.ws.orbimpl.transport.WSTransport.stateChanged", "730", this);
                    if (ORBRas.isTrcLogging) {
                        ORBRas.orbTrcLogger.trace(4112L, (Object)this, "stateChanged()", "Exception restarting listener " + ex1.toString() + ", retrying...");
                    }
                    this.startListening(connectionData);
                }
            }
        }
        for (int i = 0; i < listToRemove.size(); ++i) {
            ListenerThread lis;
            lis = (ListenerThread)listToRemove.get(i);
            this.tableOfListeners.remove(lis);
            this.tableOfServerSockets.remove(lis);
        }
    }

    public static WSTransport getInstanceToRegisterListener() {
        if (!registeredListener) {
            registeredListener = true;
            return wsTransport;
        }
        return null;
    }

    protected void createListener(ServerConnectionData connectionData, boolean addToServerProfile) {
        String methodName = "createListener( ServerConnectionData connectionData )";
        try {
            if (ORBRas.isTrcLogging) {
                ORBRas.orbTrcLogger.trace(4112L, (Object)this, "createListener( ServerConnectionData connectionData )", "At the beginning: the ConnectionData is" + connectionData);
            }
            switch ((int)connectionData.getConnectionType()) {
                case 1: {
                    connectionData.setServerHost(this.fORB.getProperty("com.ibm.CORBA.LocalHost"));
                    connectionData.setServerQueueDepth(this.fORB.getSocketQueueDepth());
                    boolean useSingleNICFlag = this.fORB.getProperty("com.ibm.CORBA.LocalHost") != null && this.fORB.getProperty("com.ibm.ws.orb.transport.useMultiHome") != null && this.fORB.getProperty("com.ibm.ws.orb.transport.useMultiHome").equalsIgnoreCase("false");
                    connectionData.setUseSingleNIC(useSingleNICFlag);
                    if (!ORBRas.isTrcLogging || !ORBRas.isTrcLogging) break;
                    ORBRas.orbTrcLogger.trace(4112L, (Object)this, "createListener()", "Connection Type=SSL Server Side Socket, LocalHost=" + this.fORB.getProperty("com.ibm.CORBA.LocalHost") + ", Server Queue Depth=" + this.fORB.getSocketQueueDepth() + ", Bind Server Socket To Multiple NIC cards=" + !useSingleNICFlag);
                    break;
                }
                case 2: {
                    break;
                }
            }
            ServerSocket ss = this.startListening(connectionData);
            if (addToServerProfile) {
                if (this.serverProfile == null) {
                    this.serverProfile = ORB.createProfile((ORB)this.fORB, null, (int)0);
                }
                this.addProfileInfoToServerProfile(connectionData, ss);
            }
        }
        catch (Exception e) {
            Manager.Ffdc.log(e, this, "com.ibm.ws.orbimpl.transport.WSTransport.createListener", "724", this);
            if (ORBRas.isTrcLogging) {
                ORBRas.orbTrcLogger.exception(4104L, (Object)this, "createListener( ServerConnectionData connectionData )", e);
            }
            throw new INTERNAL("CREATE_LISTENER_FAILED_4", 1229066326, CompletionStatus.COMPLETED_NO);
        }
    }

    protected ServerSocket startListening(ServerConnectionData connectionData) {
        String methodName = "startListening( ServerConnectionData connectionData )";
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.trace(4112L, (Object)this, "startListening( ServerConnectionData connectionData )", "At the beginning: the ConnectionData is" + connectionData);
        }
        ConnectionTable finalTable = this.fConnectionTable;
        try {
            ServerSocket ss = this.createServerSocket(connectionData);
            String finalThreadName = "P=" + ORB.orbLoadTime + ":" + "O=" + this.fORB.thisInstanceNumber + ":" + "port=" + ss.getLocalPort();
            Thread lis = this.createListenerThread(finalTable, ss, this.acceptTimeout, finalThreadName);
            lis.setDaemon(true);
            this.tableOfListeners.put(lis, connectionData);
            this.tableOfServerSockets.put(lis, ss);
            lis.start();
            if (ORBRas.isTrcLogging) {
                ORBRas.orbTrcLogger.trace(4112L, (Object)this, "startListening( ServerConnectionData connectionData )", "a new ListenerThread has been started for " + ss);
            }
            return ss;
        }
        catch (Exception e) {
            Manager.Ffdc.log(e, this, "com.ibm.ws.orbimpl.transport.WSTransport.startListening", "805", this);
            if (ORBRas.isTrcLogging) {
                ORBRas.orbTrcLogger.exception(4104L, (Object)this, "startListening( ServerConnectionData connectionData )", e);
            }
            throw new INTERNAL("CREATE_LISTENER_FAILED_4", 1229066326, CompletionStatus.COMPLETED_NO);
        }
    }

    public Profile getIIOPProfile() {
        String methodName = "getIIOPProfile()";
        if (ORBRas.isTrcLogging) {
            if (this.serverProfile != null) {
                byte[] taggedComponent = this.serverProfile.getTaggedComponent(20);
                String tagAsString = "";
                if (taggedComponent != null) {
                    tagAsString = WSTransport.sslTaggedComponentToString(taggedComponent);
                }
                ORBRas.orbTrcLogger.trace(4112L, (Object)this, "getIIOPProfile()", "In the Profile returned by getIIOPPorfile, Profile.getHost()=" + this.serverProfile.getHost() + " Profile.getPort()=" + this.serverProfile.getPort() + " SSL TaggedComponent= " + tagAsString);
            } else {
                ORBRas.orbTrcLogger.trace(4112L, (Object)this, "getIIOPProfile()", "In the Profile returned by getIIOPPorfile, serverProfile==null");
            }
        }
        return this.serverProfile;
    }

    public TransportConnection createTransportConnection(Socket socket, Thread listenerThread) {
        String methodName = "createTransportConnection( Socket socket, Thread listenerThread )";
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.trace(4112L, (Object)this, "createTransportConnection( Socket socket, Thread listenerThread )", "the socket for this connection is: " + socket);
        }
        ConnectionData cdThatStartedThisListener = (ConnectionData)this.tableOfListeners.get(listenerThread);
        long type = cdThatStartedThisListener.getConnectionType();
        WSTCPTransportConnection returnValue = null;
        switch ((int)type) {
            case 2: {
                returnValue = new WSTCPTransportConnection(this.fConnectionTable, socket, this.fORB.getReaderPool(), this.fORBForTransports, cdThatStartedThisListener, connectionInterceptor, false);
                break;
            }
            case 1: {
                returnValue = new WSSSLTransportConnection(this.fConnectionTable, socket, this.fORB.getReaderPool(), this.fORBForTransports, cdThatStartedThisListener, connectionInterceptor);
                break;
            }
            default: {
                if (ORBRas.isTrcLogging) {
                    ORBRas.orbTrcLogger.trace(4112L, (Object)this, "createTransportConnection( Socket socket, Thread listenerThread )", type + " is an invalid connection type");
                }
                throw new INTERNAL("INVALID_SERVER_CONNECTION_DATA_TYPE", 1229066360, CompletionStatus.COMPLETED_NO);
            }
        }
        return returnValue;
    }

    private String serverConnectionDataArrayToString(ServerConnectionData[] cdArray) {
        String returnString = "\n[ ";
        for (int i = 0; i < cdArray.length; ++i) {
            returnString = returnString + "\n[" + cdArray[i] + "]";
        }
        returnString = returnString + "\n]";
        return returnString;
    }

    private void logGetConnectionParameters(Profile iop, ClientDelegate cd, String operationName) {
        if (ORBRas.isTrcLogging) {
            String methodName = "getConnection(Profile, ClientDelegate, operationName)";
            String host = iop.getHost();
            int port = iop.getPort();
            byte[] taggedComponent = iop.getTaggedComponent(20);
            if (taggedComponent != null) {
                String tagAsString = WSTransport.sslTaggedComponentToString(taggedComponent);
                ORBRas.orbTrcLogger.trace(4112L, (Object)this, "getConnection(Profile, ClientDelegate, operationName)", " method entry: host=" + host + " port=" + port + " SSLTaggedCompnent=" + tagAsString + " clientDelegate=" + cd + " operationName=" + operationName);
            } else {
                ORBRas.orbTrcLogger.trace(4112L, (Object)this, "getConnection(Profile, ClientDelegate, operationName)", " method entry: host=" + host + " port=" + port + " clientDelegate=" + cd + " operationName=" + operationName);
            }
        }
    }

    public static String sslTaggedComponentToString(byte[] taggedComponentBytes) {
        CDRInputStream tagStream = ORB.createCDRInputStream(null, (byte[])taggedComponentBytes, (int)taggedComponentBytes.length);
        tagStream.consumeEndian();
        short targetSupportsQOP = tagStream.read_short();
        short targetRequiresQOP = tagStream.read_short();
        int SSLPort = tagStream.read_short() & 0xFFFF;
        return "[targetSupportsQOP=" + targetSupportsQOP + " targetRequiresQOP=" + targetRequiresQOP + " SSLPort=" + SSLPort + "]";
    }

    private ConnectionKey getKeyFromConnectionData(ConnectionData cd) {
        String methodName = "getKeyFromConnectionoData(ConnectionData)";
        ConnectionKey returnValue = null;
        String host = WSTransport.getHostFromKeyString(cd.getConnectionKey());
        int port = WSTransport.getPortFromKeyString(cd.getConnectionKey());
        switch ((int)cd.getConnectionType()) {
            case 2: {
                returnValue = new ConnectionKey(host, port);
                break;
            }
            case 1: {
                short qop = (short)WSTransport.getQOPFromKeyString(cd.getConnectionKey());
                returnValue = new SSLConnectionKey(host, port, qop);
                break;
            }
            default: {
                if (ORBRas.isTrcLogging) {
                    ORBRas.orbTrcLogger.trace(4112L, (Object)this, "getKeyFromConnectionoData(ConnectionData)", cd.getConnectionType() + " is an invalid connection type");
                }
                throw new INTERNAL("CLIENT_CONNECTIONDATA_IS_INVALID_TYPE", 1229066333, CompletionStatus.COMPLETED_NO);
            }
        }
        return returnValue;
    }

    public static String getHostFromKeyString(String keyString) {
        if (keyString.indexOf("IIOPSSL") != -1) {
            int lastColon = keyString.lastIndexOf(":");
            String qop = keyString.substring(lastColon + 1);
            keyString = keyString.substring(0, lastColon);
            lastColon = keyString.lastIndexOf(":");
            keyString = keyString.substring(0, lastColon);
            lastColon = keyString.lastIndexOf(":");
            String port = keyString.substring(lastColon + 1);
            String host = keyString = keyString.substring(0, lastColon);
            return host;
        }
        int lastColon = keyString.lastIndexOf(":");
        String port = keyString.substring(lastColon + 1);
        String host = keyString = keyString.substring(0, lastColon);
        return host;
    }

    public static int getPortFromKeyString(String keyString) {
        if (keyString.indexOf("IIOPSSL") != -1) {
            int lastColon = keyString.lastIndexOf(":");
            String qop = keyString.substring(lastColon + 1);
            keyString = keyString.substring(0, lastColon);
            lastColon = keyString.lastIndexOf(":");
            keyString = keyString.substring(0, lastColon);
            lastColon = keyString.lastIndexOf(":");
            String port = keyString.substring(lastColon + 1);
            keyString = keyString.substring(0, lastColon);
            return Integer.parseInt(port);
        }
        int lastColon = keyString.lastIndexOf(":");
        String port = keyString.substring(lastColon + 1);
        keyString = keyString.substring(0, lastColon);
        return Integer.parseInt(port);
    }

    public static int getQOPFromKeyString(String keyString) {
        if (keyString.indexOf("IIOPSSL") != -1) {
            int lastColon = keyString.lastIndexOf(":");
            String qop = keyString.substring(lastColon + 1);
            return Integer.parseInt(qop);
        }
        return 0;
    }

    public final String getForceTunnel() {
        String methodName = "getForceTunnel";
        if (!this.forceTunnelVarSet) {
            this.forceTunnelVarSet = true;
            String propValue = this.fORB.getProperty("com.ibm.CORBA.ForceTunnel");
            if (propValue == null) {
                this.forceTunnel = "whenrequired";
            } else {
                this.forceTunnel = propValue.toLowerCase();
                if (!this.forceTunnel.equals("never") && !this.forceTunnel.equals("always")) {
                    this.forceTunnel = "whenrequired";
                }
            }
        }
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.trace(4112L, (Object)this, "getForceTunnel", "getForceTunnel() returned " + this.forceTunnel);
        }
        return this.forceTunnel;
    }

    public static WSSSLServerSocketFactory getWSSSLServerSocketFactory(ORBForTransports orb) {
        String methodName = "getWSSSLServerSocketFactory()";
        try {
            if (sslFactory == null) {
                String factoryName = orb.getProperty("com.ibm.ws.orb.transport.WSSSLServerSocketFactoryName");
                if (ORBRas.isTrcLogging) {
                    ORBRas.orbTrcLogger.trace(4112L, "com.ibm.ws.orbimpl.transport.WSTransport", "getWSSSLServerSocketFactory()", "the value of property \"com.ibm.ws.orb.transport.WSSSLServerSocketFactoryName\" is " + factoryName);
                }
                if (factoryName == null) {
                    factoryName = "com.ibm.ws.security.orbssl.WSSSLServerSocketFactoryImpl";
                }
                sslFactory = (WSSSLServerSocketFactory)Class.forName(factoryName).newInstance();
                if (ORBRas.isTrcLogging) {
                    ORBRas.orbTrcLogger.trace(4112L, "com.ibm.ws.orbimpl.transport.WSTransport", "getWSSSLServerSocketFactory()", "the installed WSSSLServerSocketFactory implementation is " + sslFactory);
                }
            }
        }
        catch (Exception ex) {
            Manager.Ffdc.log(ex, WSTransport.class, "com.ibm.ws.orbimpl.transport.WSTransport.getWSSSLServerSocketFactory", "1228");
            if (ORBRas.isTrcLogging) {
                ORBRas.orbTrcLogger.exception(4112L, "com.ibm.ws.orbimpl.transport.WSTransport", "getWSSSLServerSocketFactory()", ex);
            }
            throw new INTERNAL("COULD_NOT_INSTANTIATE_SERVER_SSL_SOCKET_FACTORY", 1229066322, CompletionStatus.COMPLETED_NO);
        }
        return sslFactory;
    }

    public static WSSSLClientSocketFactory getWSSSLClientSocketFactory(ORBForTransports orb) {
        String methodName = "getWSSSLClientSocketFactory()";
        try {
            if (sslClientFactory == null) {
                String factoryName = orb.getProperty("com.ibm.ws.orb.transport.WSSSLClientSocketFactoryName");
                if (ORBRas.isTrcLogging) {
                    ORBRas.orbTrcLogger.trace(4112L, "com.ibm.ws.orbimpl.transport.WSSSLTransportConnection", "getWSSSLClientSocketFactory()", "the value of property \"com.ibm.ws.orb.transport.WSSSLClientSocketFactoryName\" is " + factoryName);
                }
                if (factoryName == null) {
                    throw new NullPointerException();
                }
                sslClientFactory = (WSSSLClientSocketFactory)Class.forName(factoryName).newInstance();
            }
        }
        catch (Exception ex) {
            Manager.Ffdc.log(ex, WSTransport.class, "com.ibm.ws.orbimpl.transport.WSTransport.getWSSSLClientSocketFactory", "1279");
            if (ORBRas.isTrcLogging) {
                ORBRas.orbTrcLogger.exception(4112L, "com.ibm.ws.orbimpl.transport.WSSSLTransportConnection", "getWSSSLClientSocketFactory()", ex);
            }
            throw new INTERNAL("COULD_NOT_INSTANTIATE_CLIENT_SSL_SOCKET_FACTORY", 1229066321, CompletionStatus.COMPLETED_NO);
        }
        return sslClientFactory;
    }

    protected ServerSocket createServerSocket(ServerConnectionData serverConnectionData) {
        String methodName = "createServerSocket(ServerConnectionData)";
        ServerSocket ss = null;
        switch ((int)serverConnectionData.getConnectionType()) {
            case 2: {
                try {
                    boolean useBindAddr;
                    String lHost = this.fORB.getProperty("com.ibm.CORBA.LocalHost");
                    boolean uselHost = lHost != null;
                    String BindAddr = this.fORB.getProperty("com.ibm.ws.orb.transport.useMultiHome");
                    boolean bl = useBindAddr = BindAddr != null && BindAddr.equalsIgnoreCase("false");
                    if (useBindAddr && uselHost) {
                        ss = new ServerSocket(serverConnectionData.getServerPort(), this.fORB.getSocketQueueDepth(), InetAddress.getByName(lHost));
                        if (ORBRas.isTrcLogging && ORBRas.isTrcLogging) {
                            ORBRas.orbTrcLogger.trace(4112L, (Object)this, "createServerSocket()", "Bind Server Socket To A Specific NIC card=" + (useBindAddr && uselHost) + ", Remote Port=" + serverConnectionData.getServerPort() + ", Server Queue Depth=" + this.fORB.getSocketQueueDepth() + ", LocalHost=" + lHost + ", java.net.InetAddress.getByName( LocalHost )=" + InetAddress.getByName(lHost));
                        }
                    } else {
                        ss = new ServerSocket(serverConnectionData.getServerPort(), this.fORB.getSocketQueueDepth());
                        if (ORBRas.isTrcLogging && ORBRas.isTrcLogging) {
                            ORBRas.orbTrcLogger.trace(4112L, (Object)this, "createServerSocket()", "Bind Server Socket To Multiple NIC cards=" + (!useBindAddr || !uselHost) + ", Remote Port=" + serverConnectionData.getServerPort() + ", Server Queue Depth=" + this.fORB.getSocketQueueDepth());
                        }
                    }
                }
                catch (Exception ex) {
                    Manager.Ffdc.log(ex, this, "com.ibm.ws.orbimpl.transport.WSTransport.createServerSocket", "1387", this);
                    if (ORBRas.isTrcLogging) {
                        ORBRas.orbTrcLogger.exception(4104L, (Object)this, "createServerSocket(ServerConnectionData)", ex);
                    }
                    if (ORBRas.isMsgLogging) {
                        String exStr = ex.toString();
                        if (serverConnectionData.getServerPort() != 0) {
                            exStr = exStr + " - received while attempting to open server socket on port " + serverConnectionData.getServerPort();
                        }
                        String stdOutMsg = MessageUtility.getMessage("Transport.Exception", exStr);
                        ORBRas.orbMsgLogger.msg(4L, "com.ibm.ws.orbimpl.transport.WSTransport", "createServerSocket", stdOutMsg, null);
                    }
                    throw new INTERNAL("CREATE_LISTENER_FAILED_1", 1229066323, CompletionStatus.COMPLETED_NO);
                }
                if (ORBRas.isTrcLogging) {
                    ORBRas.orbTrcLogger.trace(4112L, (Object)this, "createServerSocket(ServerConnectionData)", "The ServerSocket being returned is " + ss);
                }
                return ss;
            }
            case 1: {
                try {
                    WSSSLServerSocketFactory factory = WSTransport.getWSSSLServerSocketFactory(this.fORBForTransports);
                    ss = factory.createSSLServerSocket(serverConnectionData);
                    if (ORBRas.isTrcLogging) {
                        ORBRas.orbTrcLogger.trace(4112L, (Object)this, "createServerSocket(ServerConnectionData)", "The ServerSocket being returned is " + ss);
                    }
                    return ss;
                }
                catch (Exception ex) {
                    Manager.Ffdc.log(ex, this, "com.ibm.ws.orbimpl.transport.WSTransport.createServerSocket", "1439", this);
                    if (ORBRas.isTrcLogging) {
                        ORBRas.orbTrcLogger.exception(4112L, (Object)this, "createServerSocket(ServerConnectionData)", ex);
                    }
                    if (ORBRas.isMsgLogging) {
                        String exStr = ex.toString();
                        if (serverConnectionData.getServerPort() != 0) {
                            exStr = exStr + " - received while attempting to open server socket on port " + serverConnectionData.getServerPort();
                        }
                        String stdOutMsg = MessageUtility.getMessage("Transport.Exception", exStr);
                        ORBRas.orbMsgLogger.msg(4L, "com.ibm.ws.orbimpl.transport.WSTransport", "createServerSocket", stdOutMsg, null);
                    }
                    throw new INTERNAL("CREATE_LISTENER_FAILED_2", 1229066324, CompletionStatus.COMPLETED_NO);
                }
            }
        }
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.trace(4112L, (Object)this, "createServerSocket(ServerConnectionData)", "invalid ConnectionDataType=" + serverConnectionData.getConnectionType());
        }
        throw new INTERNAL("CREATE_LISTENER_FAILED_3", 1229066325, CompletionStatus.COMPLETED_NO);
    }

    protected void addProfileInfoToServerProfile(ServerConnectionData serverConnectionData, ServerSocket ss) {
        String methodName = "addProfileInfoToServerProfile(ServerConnectionData, ServerSocket)";
        this.serverProfile.setHost(this.fORB.getORBServerHost());
        serverConnectionData.setServerPort(ss.getLocalPort());
        switch ((int)serverConnectionData.getConnectionType()) {
            case 2: {
                this.serverProfile.setPort(ss.getLocalPort());
                break;
            }
            case 1: {
                break;
            }
            default: {
                if (ORBRas.isTrcLogging) {
                    ORBRas.orbTrcLogger.trace(4112L, (Object)this, "addProfileInfoToServerProfile(ServerConnectionData, ServerSocket)", "invalid ConnectionDataType=" + serverConnectionData.getConnectionType());
                }
                throw new INTERNAL("MinorCodes.INVALID_CONNECTION_TYPE", 1229066328, CompletionStatus.COMPLETED_NO);
            }
        }
    }

    public static ConnectionInterceptor getConnectionInterceptor() {
        return connectionInterceptor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        WSTransport wSTransport = this;
        synchronized (wSTransport) {
            for (ListenerThread thread : this.tableOfListeners.keySet()) {
                thread.setShutdownPending(true);
            }
        }
    }

    public synchronized void destroyListener(int port) {
        ListenerThread thread;
        String methodName = "destroyListener(int)";
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.entry(4L, (Object)this, "destroyListener(int)", (Object)("Shutdown thread that is listening on port " + port));
        }
        if ((thread = this.findListenerThread(port)) != null) {
            ServerConnectionData cd = (ServerConnectionData)this.tableOfListeners.get(thread);
            if (cd.getConnectionType() == 2L) {
                this.shutdownListener(thread);
                if (ORBRas.isTrcLogging) {
                    ORBRas.orbTrcLogger.trace(4112L, (Object)this, "destroyListener(int)", thread + " has been shutdown.");
                }
            } else if (ORBRas.isTrcLogging) {
                ORBRas.orbTrcLogger.trace(4112L, (Object)this, "destroyListener(int)", "Invalid port argument: " + port + ", SSL listener threads cannot be shutdown.");
            }
        }
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.exit(4L, (Object)this, "destroyListener(int)");
        }
    }

    private void shutdownListener(ListenerThread thread) {
        ServerSocket socket;
        block5: {
            String methodName = "shutdownListener(ListenerThread)";
            socket = (ServerSocket)this.tableOfServerSockets.get(thread);
            try {
                socket.setReuseAddress(true);
            }
            catch (SocketException e) {
                Manager.Ffdc.log(e, this, "com.ibm.ws.orbimpl.transport.WSTransport.shutdownListener", "1737", this);
                if (!ORBRas.isTrcLogging) break block5;
                ORBRas.orbTrcLogger.trace(4112L, (Object)this, "shutdownListener(ListenerThread)", "Exception attempting to setReuseAddress(true): " + e);
            }
        }
        thread.setShutdownPending(true);
        int attempts = 5;
        while (!socket.isClosed() && attempts-- > 0) {
            try {
                Thread.sleep(200L);
            }
            catch (InterruptedException e) {
                Manager.Ffdc.log(e, this, "com.ibm.ws.orbimpl.transport.WSTransport.shutdownListener", "1749", this);
                if (!ORBRas.isTrcLogging) continue;
                ORBRas.orbTrcLogger.trace(4112L, (Object)this, "shutdownListener(ListenerThread)", "Exception shutting down listener: " + e);
            }
        }
        this.tableOfListeners.remove(thread);
        this.tableOfServerSockets.remove(thread);
    }

    private ListenerThread findListenerThread(int port) {
        ListenerThread listener = null;
        Set threads = this.tableOfListeners.keySet();
        for (ListenerThread thread : threads) {
            ServerConnectionData cd = (ServerConnectionData)this.tableOfListeners.get(thread);
            long serverPort = cd.getServerPort();
            if ((long)port != serverPort) continue;
            listener = thread;
            break;
        }
        return listener;
    }
}

