/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.metadata.bindings;

import com.ibm.ejs.models.base.bindings.commonbnd.AbstractAuthData;
import com.ibm.ejs.models.base.bindings.commonbnd.BasicAuthData;
import com.ibm.ejs.models.base.bindings.commonbnd.CommonbndFactory;
import com.ibm.ejs.models.base.bindings.commonbnd.EjbRefBinding;
import com.ibm.ejs.models.base.bindings.commonbnd.MessageDestinationRefBinding;
import com.ibm.ejs.models.base.bindings.commonbnd.Property;
import com.ibm.ejs.models.base.bindings.commonbnd.ResourceEnvRefBinding;
import com.ibm.ejs.models.base.bindings.commonbnd.ResourceRefBinding;
import com.ibm.ejs.models.base.bindings.commonbnd.impl.ResourceRefBindingImpl;
import com.ibm.ejs.models.base.bindings.webappbnd.WebAppBinding;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.etools.commonarchive.WARFile;
import com.ibm.etools.commonarchive.WebModuleRef;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.metadata.MetaDataException;
import com.ibm.ws.web.bnd.AuthenticationAliasType;
import com.ibm.ws.web.bnd.CustomLoginConfigurationType;
import com.ibm.ws.web.bnd.ObjectFactory;
import com.ibm.ws.web.bnd.PropertyType;
import com.ibm.ws.web.bnd.ResourceRefType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.impl.EObjectImpl;
import org.eclipse.jst.j2ee.common.CommonFactory;
import org.eclipse.jst.j2ee.common.EjbRef;
import org.eclipse.jst.j2ee.common.J2EEEObject;
import org.eclipse.jst.j2ee.common.ResourceRef;
import org.eclipse.jst.j2ee.webapplication.WebApp;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebModuleHelper {
    private static final String CLASS_NAME = WebModuleHelper.class.getName();
    private static final TraceComponent tc = Tr.register(CLASS_NAME, "EJBContainer", "com.ibm.ejs.container.container");
    private HashMap<String, String> ivEjbRefMap = new HashMap();
    private HashMap<String, String> ivResourceRefMap = new HashMap();
    private HashMap<String, String> ivResourceEnvRefMap = new HashMap();
    private HashMap<String, String> ivMdRefMap = new HashMap();
    private String ivVirtualHost;
    private List<ResourceRefType> ivResourceRefList = new LinkedList<ResourceRefType>();
    private final ObjectFactory ivJaxbFactory = new ObjectFactory();
    private String ivDisplayName;

    public final String getVirtualHost() {
        return this.ivVirtualHost;
    }

    public final Map<String, String> getEjbRefBindings() {
        return this.ivEjbRefMap;
    }

    public final Map<String, String> getResourceRefBindings() {
        return this.ivResourceRefMap;
    }

    public final List<ResourceRefBinding> getResourceRefBindingList() {
        ArrayList<ResourceRefBinding> list = new ArrayList<ResourceRefBinding>(this.ivResourceRefList.size());
        for (ResourceRefType rrt : this.ivResourceRefList) {
            list.add(this.createResourceRefBinding(rrt));
        }
        return list;
    }

    public final Map<String, String> getResourceEnvRefBindings() {
        return this.ivResourceEnvRefMap;
    }

    public final Map<String, String> getMessageDestinationRefBindings() {
        return this.ivMdRefMap;
    }

    public void processBindingsFile(WebModuleRef webModRef, WebApp wccmWebApp) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "processBindingsFile(WARFile)");
        }
        Object jaxbInputStream = null;
        String fileName = "";
        WARFile archive = (WARFile)webModRef.getModuleFile();
        String moduleName = archive.getName();
        try {
            WebAppBinding wab = webModRef.getWebAppBinding();
            if (wab != null) {
                this.ivDisplayName = this.getWebAppDisplayName(wccmWebApp);
                fileName = archive.getBindingsUri();
                this.populateMaps(wab);
            }
        }
        catch (MetaDataException ex) {
            throw ex;
        }
        catch (Throwable t) {
            FFDCFilter.processException(t, CLASS_NAME + ".processBindingsFile", "222", this, new Object[]{archive, jaxbInputStream});
            Tr.error(tc, "UNKNOWN_BINDINGS_FILE_CONFIG_ERROR_CNTR0147E", new Object[]{fileName, moduleName});
            MetaDataException ex = new MetaDataException("CNTR0147E: The " + fileName + " bindings file contained in the " + moduleName + " module has a configuration error.", t);
            throw ex;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "processBindingsFile(WARFile)");
        }
    }

    private void populateMaps(WebAppBinding wab) {
        EList mdrBindingList;
        String refName;
        J2EEEObject ref;
        EList rerBindingList;
        EList rrBindingList;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "populateMaps(WebAppBinding) using WCCM");
        }
        this.ivVirtualHost = wab.getVirtualHostName();
        EList bindings = wab.getEjbRefBindings();
        if (bindings != null) {
            for (EjbRefBinding binding : bindings) {
                String refName2;
                String jndiName = binding.getJndiName();
                EjbRef ref2 = binding.getBindingEjbRef();
                String string = refName2 = ref2 != null ? ref2.getName() : null;
                if (refName2 == null) {
                    Tr.warning(tc, "MISSING_EJBREF_BINDING_CNTR0063W", this.ivDisplayName + " : ejbRefBindings jndiName=\"" + jndiName + "\"");
                    continue;
                }
                String old = this.ivEjbRefMap.put(refName2, jndiName);
                if (old != null) {
                    throw new MetaDataException("duplicate binding for EJBRef name = " + refName2);
                }
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                Tr.debug(tc, "added EJBRef binding for (" + refName2 + "," + jndiName + ")");
            }
        }
        if ((rrBindingList = wab.getResRefBindings()) != null) {
            for (ResourceRefBinding binding : rrBindingList) {
                String refName3;
                String jndiName = binding.getJndiName();
                ResourceRef ref3 = binding.getBindingResourceRef();
                String string = refName3 = ref3 != null ? ref3.getName() : null;
                if (refName3 == null) {
                    Tr.warning(tc, "MISSING_RESREF_BINDING_CNTR0076W", this.ivDisplayName + " : resRefBindings jndiName=\"" + jndiName + "\"");
                    continue;
                }
                String old = this.ivResourceRefMap.put(refName3, jndiName);
                if (old != null) {
                    throw new MetaDataException("duplicate binding for ResourceRef name = " + refName3);
                }
                ResourceRefType rrt = this.createResourceRefType(binding);
                this.ivResourceRefList.add(rrt);
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                Tr.debug(tc, "added ResourceRef binding for (" + refName3 + "," + jndiName + ")");
            }
        }
        if ((rerBindingList = wab.getResourceEnvRefBindings()) != null) {
            for (ResourceEnvRefBinding binding : rerBindingList) {
                String jndiName = binding.getJndiName();
                ref = binding.getBindingResourceEnvRef();
                String string = refName = ref != null ? ref.getName() : null;
                if (refName == null) {
                    Tr.warning(tc, "MISSING_RESENVREF_BINDING_CNTR0077W", this.ivDisplayName + " : resourceEnvRefBindings jndiName=\"" + jndiName + "\"");
                    continue;
                }
                String old = this.ivResourceEnvRefMap.put(refName, jndiName);
                if (old != null) {
                    throw new MetaDataException("duplicate binding for ResourceEnvRef name = " + refName);
                }
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                Tr.debug(tc, "added ResourceEnvRef binding for (" + refName + "," + jndiName + ")");
            }
        }
        if ((mdrBindingList = wab.getMessageDestinationRefBindings()) != null) {
            for (MessageDestinationRefBinding binding : mdrBindingList) {
                ref = binding.getBindingMessageDestinationRef();
                refName = ref != null ? ref.getName() : null;
                String jndiName = binding.getJndiName();
                if (refName == null) {
                    Tr.warning(tc, "MISSING_MSGDESTREF_BINDING_CNTR0091W", this.ivDisplayName + " : messageDestinationRefBindings jndiName=\"" + jndiName + "\"");
                    continue;
                }
                String old = this.ivMdRefMap.put(refName, jndiName);
                if (old != null) {
                    throw new MetaDataException("duplicate binding for MessageDestinationRef() name = " + refName);
                }
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                Tr.debug(tc, "added MessageDestinationRef binding for (" + refName + "," + jndiName + ")");
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "populateMaps(WebAppBinding)");
        }
    }

    private ResourceRefType createResourceRefType(ResourceRefBinding rrBinding) {
        String loginName;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "createResourceRefType for JNDI name = " + rrBinding.getJndiName());
        }
        ResourceRefType rrType = this.ivJaxbFactory.createResourceRefType();
        ResourceRef rr = rrBinding.getBindingResourceRef();
        if (rr != null) {
            rrType.setName(rr.getName());
        }
        rrType.setBindingName(rrBinding.getJndiName());
        AbstractAuthData ad = rrBinding.getDefaultAuth();
        if (ad != null) {
            ResourceRefType.DefaultAuth da = new ResourceRefType.DefaultAuth();
            BasicAuthData bd = (BasicAuthData)ad;
            da.setUserid(bd.getUserId());
            da.setPassword(bd.getPassword());
            rrType.setDefaultAuth(da);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.debug(tc, "ResourceRefType default authenication type = " + rrType.getDefaultAuth());
            }
        }
        if ((loginName = rrBinding.getLoginConfigurationName()) != null) {
            String aliasName = null;
            CustomLoginConfigurationType login = this.ivJaxbFactory.createCustomLoginConfigurationType();
            login.setName(loginName);
            List<PropertyType> newPropList = login.getProperty();
            EList wccmPropList = rrBinding.getProperties();
            for (Property property : wccmPropList) {
                PropertyType p = this.ivJaxbFactory.createPropertyType();
                String propName = property.getName();
                String propValue = property.getValue();
                p.setName(propName);
                p.setValue(propValue);
                newPropList.add(p);
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.debug(tc, "ResourceRefType CustomLoginConfiguration property name = " + propName + ", property value = " + propValue);
                }
                if (!propName.equals("com.ibm.mapping.authDataAlias")) continue;
                aliasName = propValue;
            }
            rrType.setCustomLoginConfiguration(login);
            if (aliasName != null) {
                AuthenticationAliasType alias = this.ivJaxbFactory.createAuthenticationAliasType();
                alias.setName(aliasName);
                rrType.setAuthenticationAlias(alias);
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.debug(tc, "ResourceRefType authenication alias = " + aliasName);
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "createResourceRefType");
        }
        return rrType;
    }

    private ResourceRefBinding createResourceRefBinding(ResourceRefType rrt) {
        CustomLoginConfigurationType cct;
        CommonFactory commonFactory = CommonFactory.eINSTANCE;
        CommonbndFactory commonBndFactory = CommonbndFactory.eINSTANCE;
        ResourceRefBindingImpl dds = (ResourceRefBindingImpl)commonBndFactory.createResourceRefBinding();
        ResourceRef rr = commonFactory.createResourceRef();
        rr.setName(rrt.getName());
        dds.setBindingResourceRef(rr);
        dds.setJndiName(rrt.getBindingName());
        ResourceRefType.DefaultAuth da = rrt.getDefaultAuth();
        if (da != null) {
            BasicAuthData ba = commonBndFactory.createBasicAuthData();
            ba.setUserId(da.getUserid());
            ba.setPassword(da.getPassword());
            dds.setDefaultAuth((AbstractAuthData)ba);
        }
        if ((cct = rrt.getCustomLoginConfiguration()) != null) {
            dds.setLoginConfigurationName(cct.getName());
            EList wccmPropList = dds.getProperties();
            List<PropertyType> pList = cct.getProperty();
            for (PropertyType pt : pList) {
                Property p = commonBndFactory.createProperty();
                String propName = pt.getName();
                String propValue = pt.getValue();
                p.setName(propName);
                p.setValue(propValue);
                wccmPropList.add(p);
            }
        }
        return dds;
    }

    private String getWebAppDisplayName(WebApp wccmWebApp) {
        String displayName;
        if (wccmWebApp == null) {
            displayName = "Unknown";
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "WCCM WebApp is null, using \"Unknown\" as the display name");
            }
        } else if (wccmWebApp.eIsProxy()) {
            displayName = ((EObjectImpl)wccmWebApp).eProxyURI().toString();
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "WCCM WebAppBinding did not resolve to a WCCM WebApp, using WCCM eProxyURI for the WebApp as the display name");
            }
        } else {
            displayName = wccmWebApp.getDisplayName();
            if (displayName == null || displayName.equals("")) {
                displayName = "Unknown";
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "WCCM WebApp display name is null, using \"Unknown\" as the display name");
                }
            }
        }
        return displayName;
    }
}

