/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.wsdm.resource;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.management.AdminClient;
import com.ibm.websphere.management.AdminContext;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.application.AppManagement;
import com.ibm.websphere.management.application.AppManagementProxy;
import com.ibm.websphere.management.application.AppNotification;
import com.ibm.websphere.management.exception.AdminException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.profileregistry.ProfileRegistryUtils;
import com.ibm.ws.management.wasresource.common.InvalidResourcePropertyException;
import com.ibm.ws.management.wasresource.common.UnknownResourceTypeException;
import com.ibm.ws.management.wasresource.common.WASResourceException;
import com.ibm.ws.management.wasresource.common.WASResourceInitializeException;
import com.ibm.ws.management.wasresource.common.WASResourceOperationException;
import com.ibm.ws.management.wasresource.common.WASResourceReferenceParameters;
import com.ibm.ws.management.wsdm.capability.IApplicationManagement;
import com.ibm.ws.management.wsdm.capability.IConfigChangeNotifier;
import com.ibm.ws.management.wsdm.capability.IDeploymentManager;
import com.ibm.ws.management.wsdm.capability.IJ2EEDomain;
import com.ibm.ws.management.wsdm.capability.IJ2EEManagedObject;
import com.ibm.ws.management.wsdm.common.WSDMConstants;
import com.ibm.ws.management.wsdm.common.WSDMResource;
import com.ibm.ws.management.wsdm.common.WSDMUtilities;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import javax.management.Notification;
import javax.management.NotificationFilter;
import javax.management.NotificationFilterSupport;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import javax.xml.namespace.QName;

public class WebSphereDomain
extends WSDMResource
implements IJ2EEManagedObject,
IJ2EEDomain,
IConfigChangeNotifier,
IDeploymentManager,
IApplicationManagement {
    private static final TraceComponent tc = Tr.register(WebSphereDomain.class, null, null);
    private static final long MAX_WAIT_TIME = 86400000L;

    public void initialize(HashMap eprRefProps) throws WASResourceInitializeException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "initialize", new Object[]{eprRefProps, this});
        }
        super.initialize(eprRefProps);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "initialize");
        }
    }

    public void getConfigProperty(String propertyName) throws InvalidResourcePropertyException, WASResourceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getConfigProperty", new Object[]{propertyName, this});
        }
        super.getGenericProperty(this.configData, propertyName);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getConfigProperty");
        }
    }

    public void setConfigProperty(String propertyName, String propertyValue) {
    }

    public void queryRelationshipsByType() {
    }

    public void getRelationship() {
    }

    public String getAttribute(String target, String attribute) throws WASResourceException {
        String result;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getAttribute", new Object[]{target, attribute, this});
        }
        try {
            ObjectName mbeanObject = new ObjectName(target);
            result = this.isManagedProcess() ? this.getAdminService().getDeploymentManagerAdminClient().getAttribute(mbeanObject, attribute).toString() : this.getAdminService().getAttribute(mbeanObject, attribute).toString();
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.management.wsdm.resource.WebSphereDomain.getAttribute", "91", this);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception during getAttribute", e);
            }
            throw new WASResourceException((Throwable)e);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getAttribute", result);
        }
        return result;
    }

    public String[] queryNames(String queryString) throws WASResourceException {
        String[] result;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "queryNames", new Object[]{queryString, this});
        }
        try {
            Set mbeans = WSDMUtilities.getMbeanByQueryString((String)queryString, (boolean)this.isManagedProcess());
            Object[] mbeansArray = mbeans.toArray();
            result = new String[mbeansArray.length];
            for (int i = 0; i < mbeansArray.length; ++i) {
                result[i] = mbeansArray[i].toString();
            }
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.management.wsdm.resource.WebSphereDomain.queryNames", "126", this);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception during queryNames", e);
            }
            throw new WASResourceException((Throwable)e);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "queryNames", result);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void performInstall(String operation, String appName, String earLocation, Hashtable properties) throws WASResourceOperationException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "performInstall", new Object[]{operation, appName, earLocation, this});
        }
        AppInstallListener l = new AppInstallListener(appName);
        try {
            AppManagement m;
            File earFile;
            if (!(!operation.equals("Install") && !operation.equals("Update") || (earFile = new File(earLocation)).exists() && earFile.canRead())) {
                TraceNLS nls = TraceNLS.getTraceNLS("com.ibm.ws.management.resources.AppDeploymentMessages");
                throw new AdminException(nls.getFormattedMessage("ADMA0176E", new Object[]{appName, earLocation}, "Application installation of {0} faild with PrivilegedActionException.  Ear file path is {1}."));
            }
            NotificationFilterSupport filter = new NotificationFilterSupport();
            filter.enableType("websphere.admin.appmgmt");
            if (this.isManagedProcess()) {
                AdminClient adminClient = this.getAdminService().getDeploymentManagerAdminClient();
                m = AppManagementProxy.getJMXProxyForClient(adminClient);
                adminClient.addNotificationListener(WSDMUtilities.getAppMgmtMBean((boolean)true), l, (NotificationFilter)filter, (Object)"");
            } else {
                m = AppManagementProxy.getJMXProxyForServer();
                AdminServiceFactory.getAdminService().addNotificationListener(WSDMUtilities.getAppMgmtMBean(), l, (NotificationFilter)filter, (Object)"");
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, operation + "ing J2EEAppAction...");
            }
            if (operation.equals("Install")) {
                m.installApplication(earLocation, appName, properties, null);
            } else if (operation.equals("Update")) {
                m.redeployApplication(earLocation, appName, properties, null);
            } else if (operation.equals("Uninstall")) {
                m.uninstallApplication(appName, properties, null);
            }
            AppInstallListener appInstallListener = l;
            synchronized (appInstallListener) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Start waiting for " + operation + " completion");
                }
                if (!l.isComplete()) {
                    try {
                        l.wait(86400000L);
                    }
                    catch (InterruptedException ie) {
                        Tr.debug(tc, "Interrupted.  Continue...");
                    }
                }
            }
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.management.wsdm.resource.WebSphereDomain.performInstall", "100", this);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception while performinstall", e);
            }
            throw new WASResourceOperationException((Throwable)e);
        }
        if (!l.isSuccess()) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "App operation " + operation + " failed.");
                Tr.debug(tc, "Error Msg: " + l.getMessage());
            }
            throw new WASResourceOperationException(l.getMessage());
        }
    }

    public void installApplication(String appName, String earLocation, Hashtable properties) throws WASResourceOperationException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "installApplication", new Object[]{appName, earLocation, properties, this});
        }
        this.performInstall("Install", appName, earLocation, properties);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "installApplication");
        }
    }

    public void uninstallApplication(String appName, Hashtable properties) throws WASResourceOperationException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "uninstallApplication", new Object[]{appName, properties, this});
        }
        this.performInstall("Uninstall", appName, "", properties);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "uninstallApplication");
        }
    }

    public void updateApplication(String appName, String updateLocation, Hashtable properties) throws WASResourceOperationException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "updateApplication", new Object[]{appName, updateLocation, properties, this});
        }
        this.performInstall("Update", appName, updateLocation, properties);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "updateApplication");
        }
    }

    public String getResourceType() {
        return "webspheredomain";
    }

    public List getResourceInstances(Session session, ObjectName scope, String containmentPath) throws UnknownResourceTypeException, WASResourceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getResourceInstances", this);
        }
        ArrayList<WASResourceReferenceParameters> result = new ArrayList<WASResourceReferenceParameters>();
        String currentManagedNodeId = AdminContext.peek();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Current managed node id: " + currentManagedNodeId);
        }
        try {
            HashMap<QName, String> refProps;
            block12: {
                refProps = new HashMap<QName, String>();
                refProps.put(WSDMConstants.WAS_WSDM_Resource_Type, this.getResourceType());
                refProps.put(WSDMConstants.WAS_WSDM_Resource_MRID, WSDMUtilities.constructMRID((String)this.getResourceType(), (String)(currentManagedNodeId == null ? "Default" : currentManagedNodeId)));
                refProps.put(WSDMConstants.WAS_WSDM_Resource_ManagedNodeID, currentManagedNodeId);
                try {
                    Properties manageNodeProperties = ProfileRegistryUtils.getManagedNodeProperties((String)currentManagedNodeId);
                    String manageNodeName = manageNodeProperties.getProperty("profile.registry.managed.node.name");
                    refProps.put(WSDMConstants.WAS_WSDM_Resource_ManagedNodeName, manageNodeName);
                }
                catch (Exception e) {
                    FFDCFilter.processException(e, "com.ibm.ws.management.wsdm.common.WSDMUtilities.getWASReferenceParametersFromMbean", "57");
                    if (!tc.isDebugEnabled()) break block12;
                    Tr.debug(tc, "Error while getting managed node name.  Continue", e);
                }
            }
            if (!WSDMUtilities.isAdminAgentProcess()) {
                refProps.put(WSDMConstants.WAS_WSDM_Resource_MbeanIdentifier, ((ObjectName)WSDMUtilities.getMbeanByQueryString((String)"WebSphere:type=J2EEDomain,*").iterator().next()).toString());
            }
            WASResourceReferenceParameters wsResRefParam = new WASResourceReferenceParameters("", refProps);
            result.add(wsResRefParam);
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.management.wsdm.resource.Servlet.getResourceInstances", "42", this);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception during getResourceInstances", e);
            }
            throw new WASResourceException((Throwable)e);
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getMbeanResourceInstances", result);
            }
        }
        return result;
    }

    protected void resolveMbeanIDFromConfigID(HashMap refProps, String configID) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "resolveMbeanIDFromConfigID", new Object[]{refProps, configID, this});
        }
        ObjectName j2eeAppMbean = (ObjectName)WSDMUtilities.getMbeanByQueryString((String)"WebSphere:*,j2eeType=J2EEDomain").iterator().next();
        String mbeanIdentifier = j2eeAppMbean.toString();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Mbean identifier resolved is" + mbeanIdentifier);
        }
        refProps.put(WSDMConstants.WAS_WSDM_Resource_MbeanIdentifier, mbeanIdentifier);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "resolveMbeanIDFromConfigID");
        }
    }

    protected Set getResourceMbeans(String mbeanQueryString) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getResourceMbeans", new Object[]{mbeanQueryString, this});
        }
        Set resMbeans = this.isManagedProcess() ? WSDMUtilities.getMbeanByQueryString((String)mbeanQueryString, (boolean)true) : super.getResourceMbeans(mbeanQueryString);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getResourceMbeans", resMbeans);
        }
        return resMbeans;
    }

    public Object getMbeanAttribute(String attribute) throws InvalidResourcePropertyException, WASResourceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getMbeanAttribute", attribute);
        }
        Object result = this.isManagedProcess() ? WSDMUtilities.getMbeanAttribute((ObjectName)this.mbeanObject, (String)attribute, (boolean)true) : super.getMbeanAttribute(attribute);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getMbeanAttribute", result);
        }
        return result;
    }

    public boolean getEventProvider() throws InvalidResourcePropertyException, WASResourceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getEventProvider", this);
        }
        boolean isEventProvider = true;
        if (this.mbeanObject != null) {
            isEventProvider = (Boolean)this.getMbeanAttribute("eventProvider");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getEventProvider", isEventProvider);
        }
        return isEventProvider;
    }

    public String getObjectName() throws InvalidResourcePropertyException, WASResourceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getObjectName", this);
        }
        String objectName = "";
        if (this.mbeanObject != null) {
            objectName = this.getMbeanAttribute("objectName").toString();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getObjectName", objectName);
        }
        return objectName;
    }

    public boolean getStateManageable() throws InvalidResourcePropertyException, WASResourceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getStateManageable", this);
        }
        boolean isStateManageable = false;
        if (this.mbeanObject != null) {
            isStateManageable = (Boolean)this.getMbeanAttribute("stateManageable");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getStateManageable", isStateManageable);
        }
        return isStateManageable;
    }

    public boolean getStatisticsProvider() throws InvalidResourcePropertyException, WASResourceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getStatisticsProvider", this);
        }
        boolean isStatisticsProvider = false;
        if (this.mbeanObject != null) {
            isStatisticsProvider = (Boolean)this.getMbeanAttribute("statisticsProvider");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getStatisticsProvider", isStatisticsProvider);
        }
        return isStatisticsProvider;
    }

    private class AppInstallListener
    implements AppNotification.Listener,
    NotificationListener {
        private ObjectName appmgmtMBean = null;
        private boolean success = false;
        private boolean complete = false;
        private String message = "";

        public AppInstallListener(String appName) {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "AppInstallListener", appName);
            }
            try {
                this.appmgmtMBean = WebSphereDomain.this.isManagedProcess() ? WSDMUtilities.getAppMgmtMBean((boolean)true) : WSDMUtilities.getAppMgmtMBean();
            }
            catch (Exception ex) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "unexpected exception", ex);
                }
                FFDCFilter.processException(ex, "com.ibm.ws.management.configarchive.ConfigArchiveUtils.AppInstallListener", "313");
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "AppInstallListener");
            }
        }

        public void handleNotification(Notification notf, Object handback) {
            Object ud;
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "handleNotification", new Object[]{notf, handback});
            }
            if ((ud = notf.getUserData()) instanceof AppNotification) {
                this.appEventReceived((AppNotification)ud);
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, "received irrelevant event", ud);
            }
            if (this.complete) {
                try {
                    if (WebSphereDomain.this.isManagedProcess()) {
                        WebSphereDomain.this.getAdminService().getDeploymentManagerAdminClient().removeNotificationListener(this.appmgmtMBean, this);
                    } else {
                        WebSphereDomain.this.getAdminService().removeNotificationListener(this.appmgmtMBean, this);
                    }
                }
                catch (Exception ex) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "unexpected exception", ex);
                    }
                    FFDCFilter.processException(ex, "com.ibm.ws.management.configarchive.ConfigArchiveUtils.AppInstallListener", "331");
                }
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "handleNotification");
            }
        }

        public synchronized void appEventReceived(AppNotification ev) {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "appEventReceived", ev);
            }
            String thisAppName = ev.props.getProperty("appname");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "thisAppName is " + thisAppName);
            }
            if (ev.taskStatus.equals("Completed")) {
                this.success = true;
                this.complete = true;
            } else if (ev.taskStatus.equals("Failed")) {
                this.success = false;
                this.complete = true;
            }
            this.message = ev.message;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Success: " + this.success + ".  Complete: " + this.complete + ".  Msg: " + this.message);
            }
            if (this.complete) {
                this.notifyAll();
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "appEventReceived", thisAppName);
            }
        }

        public boolean isSuccess() {
            return this.success;
        }

        public boolean isComplete() {
            return this.complete;
        }

        public String getMessage() {
            return this.message;
        }
    }
}

