/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.wsdm.resource;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.pmi.stat.WSCountStatistic;
import com.ibm.websphere.pmi.stat.WSRangeStatistic;
import com.ibm.websphere.pmi.stat.WSStats;
import com.ibm.websphere.pmi.stat.WSTimeStatistic;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.wasresource.common.InvalidResourceMetricsDataException;
import com.ibm.ws.management.wasresource.common.InvalidResourcePropertyException;
import com.ibm.ws.management.wasresource.common.UnknownResourceTypeException;
import com.ibm.ws.management.wasresource.common.WASResourceException;
import com.ibm.ws.management.wsdm.capability.IJ2EEManagedObject;
import com.ibm.ws.management.wsdm.capability.IServlet;
import com.ibm.ws.management.wsdm.common.WSDMResource;
import java.util.List;
import javax.management.ObjectName;

public class Servlet
extends WSDMResource
implements IServlet,
IJ2EEManagedObject {
    private static final TraceComponent tc = Tr.register(Servlet.class, null, null);

    public List getResourceInstances(Session session, ObjectName scope, String containmentPath) throws UnknownResourceTypeException, WASResourceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getResourceInstances", new Object[]{containmentPath, this});
        }
        if (containmentPath == null || containmentPath.equals("")) {
            containmentPath = "WebSphere:*,type=Servlet";
        }
        List resultServlets = super.getMbeanResourceInstances(containmentPath, false);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getResourceInstances", resultServlets);
        }
        return resultServlets;
    }

    public void getConfigProperty(String propertyName) {
    }

    public void setConfigProperty(String propertyName, String propertyValue) {
    }

    public void queryRelationshipsByType() {
    }

    public void getRelationship() {
    }

    public String getResourceType() {
        return "servlet";
    }

    public boolean getEventProvider() throws InvalidResourcePropertyException, WASResourceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getEventProvider", this);
        }
        boolean isEventProvider = (Boolean)this.getMbeanAttribute("eventProvider");
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getEventProvider", isEventProvider);
        }
        return isEventProvider;
    }

    public String getObjectName() throws InvalidResourcePropertyException, WASResourceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getObjectName", this);
        }
        String objectName = this.getMbeanAttribute("objectName").toString();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getObjectName", objectName);
        }
        return objectName;
    }

    public boolean getStateManageable() throws InvalidResourcePropertyException, WASResourceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getStateManageable", this);
        }
        boolean isStateManageable = (Boolean)this.getMbeanAttribute("stateManageable");
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getStateManageable", isStateManageable);
        }
        return isStateManageable;
    }

    public boolean getStatisticsProvider() throws InvalidResourcePropertyException, WASResourceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getStatisticsProvider", this);
        }
        boolean isStatisticsProvider = (Boolean)this.getMbeanAttribute("statisticsProvider");
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getStatisticsProvider", isStatisticsProvider);
        }
        return isStatisticsProvider;
    }

    public int getTotalRequests() throws InvalidResourceMetricsDataException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getTotalRequests", this);
        }
        int totalRequests = this.getMetricStatistics(11);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getTotalRequests", new Integer(totalRequests));
        }
        return totalRequests;
    }

    public int getConcurrentRequests() throws InvalidResourceMetricsDataException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getConcurrentRequests", this);
        }
        int concurrentRequests = this.getMetricStatistics(12);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getConcurrentRequests", new Integer(concurrentRequests));
        }
        return concurrentRequests;
    }

    public int getNumberOfErrors() throws InvalidResourceMetricsDataException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getNumErrors", this);
        }
        int numErrors = this.getMetricStatistics(14);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getNumErrors", new Integer(numErrors));
        }
        return numErrors;
    }

    public String getName() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getName", this);
        }
        String resName = this.configData.getKeyProperty("name");
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getName");
        }
        return resName;
    }

    public int getResponseTime() throws InvalidResourceMetricsDataException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getResponseTime", this);
        }
        int responseTime = this.getMetricStatistics(13);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getResponseTime", new Integer(responseTime));
        }
        return responseTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int getMetricStatistics(int statType) throws InvalidResourceMetricsDataException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getMetricStatics", new Object[]{new Integer(statType), this});
        }
        int statValue = 0;
        try {
            String[] signature = new String[]{"javax.management.ObjectName", "java.lang.Boolean"};
            Object[] params = new Object[]{this.mbeanObject, new Boolean(false)};
            WSStats servletStats = (WSStats)this.getAdminService().invoke(this.getPerfMbean(this.mbeanObject), "getStatsObject", params, signature);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Servlet stats:  " + servletStats);
            }
            switch (statType) {
                case 13: {
                    WSTimeStatistic servletTimeMetricStatistic = (WSTimeStatistic)servletStats.getStatistic(statType);
                    statValue = (int)servletTimeMetricStatistic.getMean();
                    return statValue;
                }
                case 12: {
                    WSRangeStatistic servletRangeMetricStatistic = (WSRangeStatistic)servletStats.getStatistic(statType);
                    statValue = (int)servletRangeMetricStatistic.getCurrent();
                    return statValue;
                }
                case 11: {
                    WSCountStatistic servletRequestCountMetricStatistic = (WSCountStatistic)servletStats.getStatistic(statType);
                    statValue = (int)servletRequestCountMetricStatistic.getCount();
                    return statValue;
                }
                case 14: {
                    WSCountStatistic servletErrorCountMetricStatistic = (WSCountStatistic)servletStats.getStatistic(statType);
                    statValue = (int)servletErrorCountMetricStatistic.getCount();
                    return statValue;
                }
            }
            return statValue;
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.management.wsdm.resource.Servlet.getTotalRequests", "158", this);
            if (!tc.isDebugEnabled()) return statValue;
            Tr.debug(tc, "Error while getting performance data", e);
            return statValue;
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getMetricStatics", new Integer(statValue));
            }
        }
    }
}

