/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.wsdm.resource;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.configservice.ConfigDataId;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.websphere.management.exception.ConfigServiceException;
import com.ibm.websphere.management.exception.ConnectorException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.wasresource.common.InvalidResourcePropertyException;
import com.ibm.ws.management.wasresource.common.UnknownResourceTypeException;
import com.ibm.ws.management.wasresource.common.WASResourceException;
import com.ibm.ws.management.wasresource.common.WASResourceInitializeException;
import com.ibm.ws.management.wasresource.common.WASResourceOperationException;
import com.ibm.ws.management.wsdm.capability.IDataSource;
import com.ibm.ws.management.wsdm.capability.IJ2EEManagedObject;
import com.ibm.ws.management.wsdm.capability.IJDBCDataSource;
import com.ibm.ws.management.wsdm.common.WSDMResource;
import java.util.HashMap;
import java.util.List;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.ObjectName;
import javax.naming.InitialContext;

public class DataSource
extends WSDMResource
implements IDataSource,
IJ2EEManagedObject,
IJDBCDataSource {
    private static final TraceComponent tc = Tr.register(DataSource.class, null, null);

    public String getResourceType() {
        return "datasource";
    }

    public void initialize(HashMap eprRefProps) throws WASResourceInitializeException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "initialize", new Object[]{eprRefProps, this});
        }
        super.initialize(eprRefProps);
        try {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Don't look up JNDI name for now");
            }
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.management.wsdm.resource.WASResource.initialize", "58", this);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Error while initialize", e);
            }
            throw new WASResourceInitializeException((Throwable)e);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "initialize");
        }
    }

    public List getResourceInstances(Session session, ObjectName scope, String containmentPath) throws UnknownResourceTypeException, WASResourceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getResourceInstances", new Object[]{containmentPath, this});
        }
        if (containmentPath == null || containmentPath.equals("")) {
            containmentPath = "WebSphere:*,type=DataSource";
        }
        List result = super.getMbeanResourceInstances(containmentPath, false);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getResourceInstances", result);
        }
        return result;
    }

    public void getConfigProperty(String propertyName) throws InvalidResourcePropertyException, WASResourceException {
    }

    public void setConfigProperty(String propertyName, String propertyValue) {
    }

    public void queryRelationshipsByType() {
    }

    public void getRelationship() {
    }

    public boolean getEventProvider() throws InvalidResourcePropertyException, WASResourceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getEventProvider", this);
        }
        boolean isEventProvider = (Boolean)this.getMbeanAttribute("eventProvider");
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getEventProvider", isEventProvider);
        }
        return isEventProvider;
    }

    public String getObjectName() throws InvalidResourcePropertyException, WASResourceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getObjectName", this);
        }
        String objectName = this.getMbeanAttribute("objectName").toString();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getObjectName", objectName);
        }
        return objectName;
    }

    public boolean getStateManageable() throws InvalidResourcePropertyException, WASResourceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getStateManageable", this);
        }
        boolean isStateManageable = (Boolean)this.getMbeanAttribute("stateManageable");
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getStateManageable", isStateManageable);
        }
        return isStateManageable;
    }

    public boolean getStatisticsProvider() throws InvalidResourcePropertyException, WASResourceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getStatisticsProvider", this);
        }
        boolean isStatisticsProvider = (Boolean)this.getMbeanAttribute("statisticsProvider");
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getStatisticsProvider", isStatisticsProvider);
        }
        return isStatisticsProvider;
    }

    public int getAgedTimeout() throws InvalidResourcePropertyException, WASResourceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getAgedTimeout", this);
        }
        int agedTimeout = (Integer)this.getMbeanAttribute("agedTimeout");
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getAgedTimeout", agedTimeout);
        }
        return agedTimeout;
    }

    public String getConnectionFactoryType() throws InvalidResourcePropertyException, WASResourceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getConnectionFactoryType", this);
        }
        String connectionFactoryType = ((Class)this.getMbeanAttribute("connectionFactoryType")).getName();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getConnectionFactoryType", connectionFactoryType);
        }
        return connectionFactoryType;
    }

    public int getConnectionTimeout() throws InvalidResourcePropertyException, WASResourceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getConnectionTimeout", this);
        }
        int connectionTimeout = (Integer)this.getMbeanAttribute("connectionTimeout");
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getConnectionTimeout", connectionTimeout);
        }
        return connectionTimeout;
    }

    public String getDataSourceName() throws InvalidResourcePropertyException, WASResourceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getConnectionFactoryType", this);
        }
        String dataSourceName = (String)this.getMbeanAttribute("dataSourceName");
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getConnectionFactoryType", dataSourceName);
        }
        return dataSourceName;
    }

    public String getDSName() throws InvalidResourcePropertyException, WASResourceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getDSName", this);
        }
        String dsName = (String)this.getMbeanAttribute("name");
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getDSName", dsName);
        }
        return dsName;
    }

    public String getDataStoreHelperClass() throws InvalidResourcePropertyException, WASResourceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getDataStoreHelperClass", this);
        }
        String dataStoreHelperClassName = "";
        Class dataStoreHelperClass = (Class)this.getMbeanAttribute("dataStoreHelperClass");
        if (dataStoreHelperClass != null) {
            dataStoreHelperClassName = dataStoreHelperClass.getName();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getDataStoreHelperClass", dataStoreHelperClass);
        }
        return dataStoreHelperClassName;
    }

    public int getFreePoolDistributionTableSize() throws InvalidResourcePropertyException, WASResourceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getFreePoolDistributionTableSize", this);
        }
        int freePoolDistributionTableSize = (Integer)this.getMbeanAttribute("freePoolDistributionTableSize");
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getFreePoolDistributionTableSize", freePoolDistributionTableSize);
        }
        return freePoolDistributionTableSize;
    }

    public int getFreePoolPartitions() throws InvalidResourcePropertyException, WASResourceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getFreePoolPartitions", this);
        }
        int freePoolPartitions = (Integer)this.getMbeanAttribute("freePoolPartitions");
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getFreePoolPartitions", freePoolPartitions);
        }
        return freePoolPartitions;
    }

    public String getJDBCDriver() throws InvalidResourcePropertyException, WASResourceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getJDBCDriver", this);
        }
        String jdbcDriver = (String)this.getMbeanAttribute("jdbcDriver");
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getJDBCDriver", jdbcDriver);
        }
        return jdbcDriver;
    }

    public String getJNDIName() throws InvalidResourcePropertyException, WASResourceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getJNDIName", this);
        }
        String jndiName = (String)this.getMbeanAttribute("jndiName");
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getJNDIName", jndiName);
        }
        return jndiName;
    }

    public boolean getJTAEnabled() throws InvalidResourcePropertyException, WASResourceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getJTAEnabled", this);
        }
        boolean jtaEnabled = (Boolean)this.getMbeanAttribute("jtaEnabled");
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getJTAEnabled", jtaEnabled);
        }
        return jtaEnabled;
    }

    public int getLoginTimeout() throws InvalidResourcePropertyException, WASResourceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getLoginTimeout", this);
        }
        int loginTimeout = (Integer)this.getMbeanAttribute("loginTimeout");
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getLoginTimeout", loginTimeout);
        }
        return loginTimeout;
    }

    public int getMaxConnections() throws InvalidResourcePropertyException, WASResourceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getMaxConnections", this);
        }
        int maxConnections = (Integer)this.getMbeanAttribute("maxConnections");
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getMaxConnections", maxConnections);
        }
        return maxConnections;
    }

    public int getMinConnections() throws InvalidResourcePropertyException, WASResourceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getMinConnections", this);
        }
        int minConnections = (Integer)this.getMbeanAttribute("minConnections");
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getMinConnections", minConnections);
        }
        return minConnections;
    }

    public String getPurgePolicy() throws InvalidResourcePropertyException, WASResourceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getPurgePolicy", this);
        }
        String purgePolicy = (String)this.getMbeanAttribute("purgePolicy");
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getPurgePolicy", purgePolicy);
        }
        return purgePolicy;
    }

    public int getReapTime() throws InvalidResourcePropertyException, WASResourceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getReapTime", this);
        }
        int reapTime = (Integer)this.getMbeanAttribute("reapTime");
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getReapTime", reapTime);
        }
        return reapTime;
    }

    public int getSharedPoolPartitions() throws InvalidResourcePropertyException, WASResourceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getSharedPoolPartitions", this);
        }
        int sharedPoolPartitions = (Integer)this.getMbeanAttribute("sharedPoolPartitions");
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getSharedPoolPartitions", sharedPoolPartitions);
        }
        return sharedPoolPartitions;
    }

    public int getStatementCacheSize() throws InvalidResourcePropertyException, WASResourceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getStatementCacheSize", this);
        }
        int statementCacheSize = (Integer)this.getMbeanAttribute("statementCacheSize");
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getStatementCacheSize", statementCacheSize);
        }
        return statementCacheSize;
    }

    public int getStuckThreshold() throws InvalidResourcePropertyException, WASResourceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getStuckThreshold", this);
        }
        int stuckThreshold = (Integer)this.getMbeanAttribute("stuckThreshold");
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getStuckThreshold", stuckThreshold);
        }
        return stuckThreshold;
    }

    public int getStuckTime() throws InvalidResourcePropertyException, WASResourceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getStuckTime", this);
        }
        int stuckTime = (Integer)this.getMbeanAttribute("stuckTime");
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getStuckTime", stuckTime);
        }
        return stuckTime;
    }

    public int getStuckTimerTime() throws InvalidResourcePropertyException, WASResourceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getStuckTimerTime", this);
        }
        int stuckTimerTime = (Integer)this.getMbeanAttribute("stuckTimerTime");
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getStuckTimerTime", stuckTimerTime);
        }
        return stuckTimerTime;
    }

    public int getSurgeCreationInterval() throws InvalidResourcePropertyException, WASResourceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getSurgeCreationInterval", this);
        }
        int surgeCreationInterval = (Integer)this.getMbeanAttribute("surgeCreationInterval");
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getSurgeCreationInterval", surgeCreationInterval);
        }
        return surgeCreationInterval;
    }

    public int getSurgeThreshhold() throws InvalidResourcePropertyException, WASResourceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getSurgeThreshhold", this);
        }
        int surgeThreshhold = (Integer)this.getMbeanAttribute("surgeThreshhold");
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getSurgeThreshhold", surgeThreshhold);
        }
        return surgeThreshhold;
    }

    public boolean getTestConnection() throws InvalidResourcePropertyException, WASResourceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getTestConnection", this);
        }
        boolean testConnection = (Boolean)this.getMbeanAttribute("testConnection");
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getTestConnection", testConnection);
        }
        return testConnection;
    }

    public int getTestConnectionInterval() throws InvalidResourcePropertyException, WASResourceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getTestConnectionInterval", this);
        }
        int testConnectionInterval = (Integer)this.getMbeanAttribute("testConnectionInterval");
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getTestConnectionInterval", testConnectionInterval);
        }
        return testConnectionInterval;
    }

    public int getUnusedTimeout() throws InvalidResourcePropertyException, WASResourceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getUnusedTimeout", this);
        }
        int unusedTimeout = (Integer)this.getMbeanAttribute("unusedTimeout");
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getUnusedTimeout", unusedTimeout);
        }
        return unusedTimeout;
    }

    public void setAgedTimeout(int agedTimeout) throws InvalidResourcePropertyException, WASResourceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setAgedTimeout", new Object[]{new Integer(agedTimeout), this});
        }
        String operation = "agedTimeout";
        this.setMbeanAttribute(operation, new Integer(agedTimeout));
        this.persistConnectionPoolChange(operation, new Long(agedTimeout));
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setAgedTimeout");
        }
    }

    public void setConnectionTimeout(int connectionTimeout) throws InvalidResourcePropertyException, WASResourceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setConnectionTimeout", new Object[]{new Integer(connectionTimeout), this});
        }
        String operation = "connectionTimeout";
        this.setMbeanAttribute(operation, new Integer(connectionTimeout));
        this.persistConnectionPoolChange(operation, new Long(connectionTimeout));
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setConnectionTimeout");
        }
    }

    public void setMaxConnections(int maxConnections) throws InvalidResourcePropertyException, WASResourceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setMaxConnections", new Object[]{new Integer(maxConnections), this});
        }
        String operation = "maxConnections";
        Integer value = new Integer(maxConnections);
        this.setMbeanAttribute(operation, value);
        this.persistConnectionPoolChange(operation, value);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setMaxConnections");
        }
    }

    public void setMinConnections(int minConnections) throws InvalidResourcePropertyException, WASResourceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setMinConnections", new Object[]{new Integer(minConnections), this});
        }
        String operation = "minConnections";
        Integer value = new Integer(minConnections);
        this.setMbeanAttribute(operation, value);
        this.persistConnectionPoolChange(operation, value);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setMinConnections");
        }
    }

    public void setPurgePolicy(String purgePolicy) throws InvalidResourcePropertyException, WASResourceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setPurgePolicy", new Object[]{new String(purgePolicy), this});
        }
        if (purgePolicy.equals("EntirePool") || purgePolicy.equals("FailingConnectionOnly")) {
            String operation = "purgePolicy";
            Integer value = new Integer(purgePolicy);
            this.setMbeanAttribute(operation, value);
            this.persistConnectionPoolChange(operation, value);
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Invalid purge policy");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setPurgePolicy");
        }
    }

    public void setReapTime(int reapTime) throws InvalidResourcePropertyException, WASResourceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setReapTime", new Object[]{new Integer(reapTime), this});
        }
        String operation = "reapTime";
        this.setMbeanAttribute(operation, new Integer(reapTime));
        this.persistConnectionPoolChange(operation, new Long(reapTime));
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setReapTime");
        }
    }

    public void setStuckThreshold(int stuckThreshold) throws InvalidResourcePropertyException, WASResourceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setStuckThreshold", new Object[]{new Integer(stuckThreshold), this});
        }
        String operation = "stuckThreshold";
        Integer value = new Integer(stuckThreshold);
        this.setMbeanAttribute(operation, value);
        this.persistConnectionPoolChange(operation, value);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setStuckThreshold");
        }
    }

    public void setStuckTime(int stuckTime) throws InvalidResourcePropertyException, WASResourceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setStuckTime", new Object[]{new Integer(stuckTime), this});
        }
        String operation = "stuckTime";
        Integer value = new Integer(stuckTime);
        this.setMbeanAttribute(operation, value);
        this.persistConnectionPoolChange(operation, value);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setStuckTime");
        }
    }

    public void setStuckTimerTime(int stuckTimerTime) throws InvalidResourcePropertyException, WASResourceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setStuckTimerTime", new Object[]{new Integer(stuckTimerTime), this});
        }
        String operation = "stuckTimerTime";
        Integer value = new Integer(stuckTimerTime);
        this.setMbeanAttribute(operation, value);
        this.persistConnectionPoolChange(operation, value);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setStuckTimerTime");
        }
    }

    public void setSurgeCreationInterval(int surgeCreationInterval) throws InvalidResourcePropertyException, WASResourceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setSurgeCreationInterval", new Object[]{new Integer(surgeCreationInterval), this});
        }
        String operation = "surgeCreationInterval";
        Integer value = new Integer(surgeCreationInterval);
        this.setMbeanAttribute(operation, value);
        this.persistConnectionPoolChange(operation, value);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "surgeCreationInterval");
        }
    }

    public void setSurgeThreshhold(int surgeThreshhold) throws InvalidResourcePropertyException, WASResourceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setSurgeThreshhold", new Object[]{new Integer(surgeThreshhold), this});
        }
        String operation = "surgeThreshhold";
        Integer value = new Integer(surgeThreshhold);
        this.setMbeanAttribute(operation, value);
        this.persistConnectionPoolChange(operation, value);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setSurgeThreshhold");
        }
    }

    public void setTestConnection(boolean testConnection) throws InvalidResourcePropertyException, WASResourceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setTestConnection", new Object[]{new Boolean(testConnection), this});
        }
        String operation = "testConnection";
        Boolean value = new Boolean(testConnection);
        this.setMbeanAttribute(operation, value);
        this.persistConnectionPoolChange(operation, value);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setTestConnection");
        }
    }

    public void setTestConnectionInterval(int testConnectionInterval) throws InvalidResourcePropertyException, WASResourceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setTestConnectionInterval", new Object[]{new Integer(testConnectionInterval), this});
        }
        String operation = "testConnectionInterval";
        Integer value = new Integer(testConnectionInterval);
        this.setMbeanAttribute(operation, value);
        this.persistConnectionPoolChange(operation, value);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setTestConnectionInterval");
        }
    }

    public void setUnusedTimeout(int unusedTimeout) throws InvalidResourcePropertyException, WASResourceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setUnusedTimeout", new Object[]{new Integer(unusedTimeout), this});
        }
        String operation = "unusedTimeout";
        this.setMbeanAttribute(operation, new Integer(unusedTimeout));
        this.persistConnectionPoolChange(operation, new Long(unusedTimeout));
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setUnusedTimeout");
        }
    }

    public void pause() throws WASResourceOperationException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "pause", this);
        }
        this.mbeanInvoke("pause", new Object[0], new String[0]);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "pause");
        }
    }

    public String showPoolContents() throws WASResourceOperationException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "showPoolContents", this);
        }
        String poolContents = (String)this.mbeanInvoke("showPoolContents", new Object[0], new String[0]);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "showPoolContents", poolContents);
        }
        return poolContents;
    }

    public void purgePoolContents() throws WASResourceOperationException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "purgePoolContents", this);
        }
        this.mbeanInvoke("purgePoolContents", new Object[0], new String[0]);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "purgePoolContents");
        }
    }

    public void resume() throws WASResourceOperationException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "resume", this);
        }
        this.mbeanInvoke("resume", new Object[0], new String[0]);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "resume");
        }
    }

    public int getStatus() throws WASResourceOperationException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getStatus", this);
        }
        Integer status = (Integer)this.mbeanInvoke("getStatus", new Object[0], new String[0]);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getStatus", status);
        }
        return status;
    }

    private void persistConnectionPoolChange(String propertyName, Object value) throws InvalidResourcePropertyException, WASResourceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "persistChange", new Object[]{propertyName, value, this});
        }
        try {
            ObjectName datasourceConfigData = ConfigServiceHelper.createObjectName(new ConfigDataId(this.mbeanObject.getKeyProperty("mbeanIdentifier")));
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Datasource ConfigData is " + datasourceConfigData);
            }
            ObjectName pattern = ConfigServiceHelper.createObjectName(null, "ConnectionPool");
            ObjectName connectionPool = this.getConfigService().queryConfigObjects(this.getSession(), datasourceConfigData, pattern, null)[0];
            AttributeList changeList = new AttributeList();
            Attribute connToAttribute = new Attribute(propertyName, value);
            changeList.add(connToAttribute);
            this.setGenericProperties(connectionPool, changeList);
            this.getConfigService().save(this.getSession(), true);
        }
        catch (ConfigServiceException cse) {
            FFDCFilter.processException((Throwable)cse, "com.ibm.ws.management.wsdm.resource.DataSource.persistConnectionPoolChange", "531", this);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Error while persisting changes", cse);
            }
            throw new InvalidResourcePropertyException((Throwable)cse);
        }
        catch (ConnectorException ce) {
            FFDCFilter.processException((Throwable)ce, "com.ibm.ws.management.wsdm.resource.DataSource.persistConnectionPoolChange", "535", this);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Error while persisting changes", ce);
            }
            throw new WASResourceException((Throwable)ce);
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.management.wsdm.resource.DataSource.persistConnectionPoolChange", "590", this);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Error while persisting changes", e);
            }
            throw new WASResourceException((Throwable)e);
        }
        finally {
            this.discardSession();
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "persistChange");
            }
        }
    }

    private void lookupJNDIName() throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "lookupJNDIName");
        }
        StringBuffer jndiNameBuffer = new StringBuffer("cell");
        jndiNameBuffer.append("/nodes/");
        jndiNameBuffer.append(this.mbeanObject.getKeyProperty("node"));
        jndiNameBuffer.append("/servers/");
        jndiNameBuffer.append(this.mbeanObject.getKeyProperty("process"));
        jndiNameBuffer.append("/");
        jndiNameBuffer.append((String)this.getMbeanAttribute("jndiName"));
        String jndiName = jndiNameBuffer.toString();
        InitialContext ctx = new InitialContext();
        javax.sql.DataSource ds = (javax.sql.DataSource)ctx.lookup(jndiName);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "lookupJNDIName");
        }
    }
}

