/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.wsdm.resource;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.Session;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.wasresource.common.InvalidResourcePropertyException;
import com.ibm.ws.management.wasresource.common.UnknownResourceTypeException;
import com.ibm.ws.management.wasresource.common.WASResourceException;
import com.ibm.ws.management.wasresource.common.WASResourceInitializeException;
import com.ibm.ws.management.wasresource.common.WASResourceManager;
import com.ibm.ws.management.wasresource.common.WASResourceOperationException;
import com.ibm.ws.management.wsdm.capability.IApplicationServer;
import com.ibm.ws.management.wsdm.capability.IJ2EEManagedObject;
import com.ibm.ws.management.wsdm.capability.IJ2EEServer;
import com.ibm.ws.management.wsdm.capability.IStateManageable;
import com.ibm.ws.management.wsdm.common.WSDMConstants;
import com.ibm.ws.management.wsdm.common.WSDMResource;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.management.ObjectName;
import javax.xml.namespace.QName;

public class ApplicationServer
extends WSDMResource
implements IJ2EEManagedObject,
IStateManageable,
IJ2EEServer,
IApplicationServer {
    private static final TraceComponent tc = Tr.register(ApplicationServer.class, null, null);

    public void initialize(HashMap eprRefProps) throws WASResourceInitializeException {
        super.initialize(eprRefProps);
        try {
            HashMap<QName, String> tempConfigProps = new HashMap<QName, String>();
            tempConfigProps.put(WSDMConstants.WAS_WSDM_Resource_ConfigID, this.getAppServerConfigDataFromMbean(this.mbeanObject));
            this.configData = this.getConfigData(tempConfigProps);
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.management.wsdm.resource.WASResource.initialize", "58", this);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Error while initialize", e);
            }
            throw new WASResourceInitializeException((Throwable)e);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "initialize");
        }
    }

    public void getConfigProperty(String propertyName) {
    }

    public void setConfigProperty(String propertyName, String propertyValue) {
    }

    public void queryRelationshipsByType() {
    }

    public void getRelationship() {
    }

    public String getResourceType() {
        return "applicationserver";
    }

    public List getResourceInstances(Session session, ObjectName scope, String containmentPath) throws UnknownResourceTypeException, WASResourceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getResourceInstances", new Object[]{containmentPath, this});
        }
        if (containmentPath == null || containmentPath.equals("")) {
            containmentPath = "WebSphere:*,type=Server";
        }
        List result = super.getMbeanResourceInstances(containmentPath, false);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getResourceInstances", result);
        }
        return result;
    }

    private String getAppServerConfigDataFromMbean(ObjectName appServer) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getAppServerConfigDataFromMbean", new Object[]{appServer, this});
        }
        String appServerConfigID = appServer.getKeyProperty("mbeanIdentifier");
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getAppServerConfigDataFromMbean", appServerConfigID);
        }
        return appServerConfigID;
    }

    public boolean getEventProvider() throws InvalidResourcePropertyException, WASResourceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getEventProvider", this);
        }
        boolean isEventProvider = (Boolean)this.getMbeanAttribute("eventProvider");
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getEventProvider", isEventProvider);
        }
        return isEventProvider;
    }

    public String getObjectName() throws InvalidResourcePropertyException, WASResourceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getObjectName", this);
        }
        String objectName = this.getMbeanAttribute("objectName").toString();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getObjectName", objectName);
        }
        return objectName;
    }

    public boolean getStateManageable() throws InvalidResourcePropertyException, WASResourceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getStateManageable", this);
        }
        boolean isStateManageable = (Boolean)this.getMbeanAttribute("stateManageable");
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getStateManageable", isStateManageable);
        }
        return isStateManageable;
    }

    public boolean getStatisticsProvider() throws InvalidResourcePropertyException, WASResourceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getStatisticsProvider", this);
        }
        boolean isStatisticsProvider = (Boolean)this.getMbeanAttribute("statisticsProvider");
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getStatisticsProvider", isStatisticsProvider);
        }
        return isStatisticsProvider;
    }

    public String getCellName() throws InvalidResourcePropertyException, WASResourceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getCellName", this);
        }
        String cellName = this.getMbeanAttribute("cellName").toString();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getCellName", cellName);
        }
        return cellName;
    }

    public String[] getVersionsForAllEFixes() throws InvalidResourcePropertyException, WASResourceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getVersionsForAllEFixes", this);
        }
        String[] versionsForAllEFixes = (String[])this.mbeanInvoke("getVersionsForAllEFixes", new Object[0], new String[0]);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getVersionsForAllEFixes", versionsForAllEFixes);
        }
        return versionsForAllEFixes;
    }

    public String[] getVersionsForAllExtensions() throws InvalidResourcePropertyException, WASResourceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getVersionsForAllExtensions", this);
        }
        String[] versionsForAllExtensions = (String[])this.mbeanInvoke("getVersionsForAllExtensions", new Object[0], new String[0]);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getVersionsForAllExtensions", versionsForAllExtensions);
        }
        return versionsForAllExtensions;
    }

    public String getNodeName() throws InvalidResourcePropertyException, WASResourceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getNodeName", this);
        }
        String nodetName = this.getMbeanAttribute("nodeName").toString();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getNodeName", nodetName);
        }
        return nodetName;
    }

    public String getPlatformName() throws InvalidResourcePropertyException, WASResourceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getPlatformName", this);
        }
        String platformName = this.getMbeanAttribute("platformName").toString();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getPlatformName", platformName);
        }
        return platformName;
    }

    public String getPlatformVersion() throws InvalidResourcePropertyException, WASResourceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getPlatformVersion", this);
        }
        String platformVersion = this.getMbeanAttribute("platformVersion").toString();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getPlatformVersion", platformVersion);
        }
        return platformVersion;
    }

    public String getProcessId() throws InvalidResourcePropertyException, WASResourceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getProcessId", this);
        }
        String processId = this.getMbeanAttribute("pid").toString();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getProcessId", processId);
        }
        return processId;
    }

    public String getProcessType() throws InvalidResourcePropertyException, WASResourceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getProcessType", this);
        }
        String processType = this.getMbeanAttribute("processType").toString();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getProcessType", processType);
        }
        return processType;
    }

    public String[] getVersionsForAllPTFs() throws InvalidResourcePropertyException, WASResourceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "startRecursive", this);
        }
        String[] versionsForAllPTFs = (String[])this.mbeanInvoke("getVersionsForAllPTFs", new Object[0], new String[0]);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "startRecursive", versionsForAllPTFs);
        }
        return versionsForAllPTFs;
    }

    public String getShortName() throws InvalidResourcePropertyException, WASResourceException {
        String shortName;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getShortName", this);
        }
        if ((shortName = (String)this.getMbeanAttribute("shortName")) == null) {
            shortName = "";
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getShortName", shortName);
        }
        return shortName;
    }

    public int getThreadMonitorAdjustmentThreshold() throws InvalidResourcePropertyException, WASResourceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getThreadMonitorAdjustmentThreshold", this);
        }
        int threadMonitorAdjustmentThreshold = (Integer)this.getMbeanAttribute("threadMonitorAdjustmentThreshold");
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getThreadMonitorAdjustmentThreshold", threadMonitorAdjustmentThreshold);
        }
        return threadMonitorAdjustmentThreshold;
    }

    public int getThreadMonitorInterval() throws InvalidResourcePropertyException, WASResourceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getThreadMonitorAdjustmentThreshold", this);
        }
        int threadMonitorInterval = (Integer)this.getMbeanAttribute("threadMonitorInterval");
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getThreadMonitorAdjustmentThreshold", threadMonitorInterval);
        }
        return threadMonitorInterval;
    }

    public int getThreadMonitorThreshold() throws InvalidResourcePropertyException, WASResourceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getThreadMonitorThreshold", this);
        }
        int threadMonitorThreshold = (Integer)this.getMbeanAttribute("threadMonitorThreshold");
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getThreadMonitorThreshold", threadMonitorThreshold);
        }
        return threadMonitorThreshold;
    }

    public void setThreadMonitorAdjustmentThreshold(int threadMonAdjThreshold) throws InvalidResourcePropertyException, WASResourceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getThreadMonitorThreshold", this);
        }
        this.setMbeanAttribute("threadMonitorAdjustmentThreshold", new Integer(threadMonAdjThreshold));
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setThreadMonitorAdjustmentThreshold");
        }
    }

    public void setThreadMonitorInterval(int threadInterval) throws InvalidResourcePropertyException, WASResourceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setThreadMonitorInterval", this);
        }
        this.setMbeanAttribute("threadMonitorInterval", new Integer(threadInterval));
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setThreadMonitorInterval");
        }
    }

    public void setThreadMonitorThreshold(int threadMonitorThreshold) throws InvalidResourcePropertyException, WASResourceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setThreadMonitorThreshold", this);
        }
        this.setMbeanAttribute("threadMonitorThreshold", new Integer(threadMonitorThreshold));
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setThreadMonitorThreshold");
        }
    }

    public void restart() throws WASResourceOperationException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "restart", this);
        }
        this.mbeanInvoke("restart", new Object[0], new String[0]);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "restart");
        }
    }

    public void stopImmediate() throws WASResourceOperationException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "stopImmediate", this);
        }
        this.mbeanInvoke("stopImmediate", new Object[0], new String[0]);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "stopImmediate");
        }
    }

    public String getProductVersion(String productID) throws WASResourceOperationException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getProductVersion", productID);
        }
        String productVersion = (String)this.mbeanInvoke("getProductVersion", new Object[]{productID}, new String[]{"java.lang.String"});
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getProductVersion", productVersion);
        }
        return productVersion;
    }

    public List getDeployedObjectReference() throws InvalidResourcePropertyException, WASResourceException {
        return null;
    }

    public String getServerVendor() throws InvalidResourcePropertyException, WASResourceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getServerVendor", this);
        }
        String serverVendor = (String)this.getMbeanAttribute("serverVendor");
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getServerVendor", serverVendor);
        }
        return serverVendor;
    }

    public String getServerVersion() throws InvalidResourcePropertyException, WASResourceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getServerVersion", this);
        }
        String serverVersion = this.getVersion();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getServerVersion", serverVersion);
        }
        return serverVersion;
    }

    public List getVirtualMachineReference() throws InvalidResourcePropertyException, WASResourceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getVirtualMachineReference", this);
        }
        ArrayList jvmReferenceList = new ArrayList();
        String[] jvms = (String[])this.getMbeanAttribute("javaVMs");
        for (int i = 0; i < jvms.length; ++i) {
            String jvm = jvms[i];
            jvmReferenceList.addAll(WASResourceManager.getInstance().queryResource("jvm", jvm));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "javaVMs", jvmReferenceList);
        }
        return jvmReferenceList;
    }

    public Date getStartTime() throws WASResourceOperationException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getStartTime", this);
        }
        try {
            long date = (Long)this.getMbeanAttribute("startTime");
            Date date2 = new Date(date);
            return date2;
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.websphere.management.j2ee.impl.J2EEApplicationImpl.getStartTime", "61", this);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception caught during getStartTime", e);
            }
            throw new WASResourceOperationException((Throwable)e);
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getStartTime");
            }
        }
    }

    public void start() throws WASResourceOperationException {
    }

    public void startRecursive() throws WASResourceOperationException {
    }

    public void stop() throws WASResourceOperationException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "stop", this);
        }
        this.mbeanInvoke("stop", new Object[0], new String[0]);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "stop");
        }
    }
}

