/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.wsdm.handlers;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.security.WSSecurityException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.wsdm.common.WSDMConstants;
import com.ibm.wsspi.security.context.Context;
import com.ibm.wsspi.security.context.Domain;
import java.util.Iterator;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axiom.soap.SOAPHeader;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.engine.Handler;
import org.apache.axis2.handlers.AbstractHandler;

public class WSDMHandler
extends AbstractHandler {
    private static final TraceComponent tc = Tr.register(WSDMHandler.class, null, null);

    public void flowComplete(MessageContext msgContext) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "flowComplete", this);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "flowComplete", this);
        }
    }

    public Handler.InvocationResponse invoke(MessageContext msgContext) throws AxisFault {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "invoke", this);
        }
        SOAPEnvelope envolope = msgContext.getEnvelope();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "SOAPEnvlope is  " + envolope);
        }
        if (envolope != null) {
            SOAPHeader header = envolope.getHeader();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "SOAPHeader is  " + header);
            }
            if (header != null) {
                Iterator children = header.getChildElements();
                while (children.hasNext()) {
                    Object secContext;
                    OMElement child = (OMElement)children.next();
                    if (!child.getQName().equals(WSDMConstants.WAS_WSDM_Resource_ManagedNodeID)) continue;
                    String managedNodeID = child.getText();
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "ManagedNodeID Found: " + managedNodeID);
                    }
                    if (managedNodeID == null || managedNodeID == "") break;
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "AppServer Profile ManagedNodeID Found: " + managedNodeID + ".  Add the ID to the context object");
                    }
                    if ((secContext = msgContext.getProperty("com.ibm.wsspi.websphere.security.SecurityContext")) == null || !(secContext instanceof Context)) break;
                    try {
                        Domain dom = ((Context)secContext).getDomain();
                        dom.setProfileId(managedNodeID);
                    }
                    catch (WSSecurityException wsse) {
                        Tr.debug(tc, "Unable to get domain object from Context", wsse);
                        FFDCFilter.processException((Throwable)wsse, "com.ibm.ws.management.wsdm.handlers.WSDMHandler", "78", this);
                    }
                    break;
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "invoke", this);
        }
        return Handler.InvocationResponse.CONTINUE;
    }
}

