/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.wsdm.common;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.AdminContext;
import com.ibm.websphere.management.AdminService;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.profileregistry.ProfileRegistryUtils;
import com.ibm.ws.management.wasresource.common.WASResourceReferenceParameters;
import com.ibm.ws.management.wasresource.common.WASResourceUtilities;
import com.ibm.ws.management.wsdm.common.WSDMConstants;
import java.util.HashMap;
import java.util.Properties;
import java.util.Set;
import javax.management.ObjectName;
import javax.xml.namespace.QName;

public class WSDMUtilities
extends WASResourceUtilities {
    private static final TraceComponent tc = Tr.register(WSDMUtilities.class, null, null);
    private static boolean serviceEnabled = false;

    public static WASResourceReferenceParameters getWASReferenceParametersFromMbean(ObjectName mbean) {
        HashMap<QName, String> refProps;
        block6: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "getWASReferenceParametersFromMbean", new Object[]{mbean});
            }
            refProps = new HashMap<QName, String>();
            String type = mbean.getKeyProperty("type");
            String resourceType = WSDMConstants.getResourceTypeFromMbeanType(type);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "ResouceType resolved is " + resourceType);
            }
            refProps.put(WSDMConstants.WAS_WSDM_Resource_Type, resourceType);
            refProps.put(WSDMConstants.WAS_WSDM_Resource_MRID, WSDMUtilities.constructMRID((String)resourceType, (String)mbean.toString()));
            refProps.put(WSDMConstants.WAS_WSDM_Resource_MbeanIdentifier, mbean.toString());
            refProps.put(WSDMConstants.WAS_WSDM_Resource_ManagedNodeID, AdminContext.peek());
            try {
                String manageNodeName = mbean.getKeyProperty("node");
                if (manageNodeName == null || manageNodeName.equals("")) {
                    Properties manageNodeProperties = ProfileRegistryUtils.getManagedNodeProperties((String)AdminContext.peek());
                    manageNodeName = manageNodeProperties.getProperty("profile.registry.managed.node.name");
                }
                refProps.put(WSDMConstants.WAS_WSDM_Resource_ManagedNodeName, manageNodeName);
            }
            catch (Exception e) {
                FFDCFilter.processException(e, "com.ibm.ws.management.wsdm.common.WSDMUtilities.getWASReferenceParametersFromMbean", "57");
                if (!tc.isDebugEnabled()) break block6;
                Tr.debug(tc, "Error while getting managed node name.  Continue", e);
            }
        }
        WASResourceReferenceParameters wsResRefParam = new WASResourceReferenceParameters("", refProps);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getWASReferenceParametersFromMbean", wsResRefParam);
        }
        return wsResRefParam;
    }

    public static WASResourceReferenceParameters getWASReferenceParametersFromMbean(ObjectName mbean, String endpointType, String serviceName, String endpointName) {
        HashMap<QName, String> refProps;
        block6: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "getWASReferenceParametersFromMbean", new Object[]{mbean, endpointType, serviceName, endpointName});
            }
            refProps = new HashMap<QName, String>();
            String resourceType = WSDMConstants.getResourceTypeFromMbeanType(endpointType);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "ResouceType resolved is " + resourceType);
            }
            refProps.put(WSDMConstants.WAS_WSDM_Resource_Type, resourceType);
            refProps.put(WSDMConstants.WAS_WSDM_Resource_MRID, WSDMUtilities.constructMRID((String)resourceType, (String)mbean.toString()));
            refProps.put(WSDMConstants.WAS_WSDM_Resource_MbeanIdentifier, mbean.toString());
            refProps.put(WSDMConstants.WAS_WSDM_Resource_ManagedNodeID, AdminContext.peek());
            try {
                String manageNodeName = mbean.getKeyProperty("node");
                if (manageNodeName == null || manageNodeName.equals("")) {
                    Properties manageNodeProperties = ProfileRegistryUtils.getManagedNodeProperties((String)AdminContext.peek());
                    manageNodeName = manageNodeProperties.getProperty("profile.registry.managed.node.name");
                }
                refProps.put(WSDMConstants.WAS_WSDM_Resource_ManagedNodeName, manageNodeName);
            }
            catch (Exception e) {
                FFDCFilter.processException(e, "com.ibm.ws.management.wsdm.common.WSDMUtilities.getWASReferenceParametersFromMbean", "57");
                if (!tc.isDebugEnabled()) break block6;
                Tr.debug(tc, "Error while getting managed node name.  Continue", e);
            }
        }
        refProps.put(WSDMConstants.WAS_WSDM_Resource_ServiceName, serviceName);
        refProps.put(WSDMConstants.WAS_WSDM_Resource_Endpoint, endpointName);
        WASResourceReferenceParameters wsResRefParam = new WASResourceReferenceParameters("", refProps);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getWASReferenceParametersFromMbean", wsResRefParam);
        }
        return wsResRefParam;
    }

    public static boolean isValidType(String mbeanType) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isValidType", new Object[]{mbeanType});
        }
        boolean result = false;
        for (int i = 0; i < WSDMConstants.WAS_RESOURCE_MBEAN_TYPE.length; ++i) {
            if (!mbeanType.equals(WSDMConstants.WAS_RESOURCE_MBEAN_TYPE[i])) continue;
            result = true;
            break;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isValidType", new Boolean(result));
        }
        return result;
    }

    public static String getStateFromStateValue(int stateValue) {
        String state;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getStateFromStateValue", new Object[]{new Integer(stateValue)});
        }
        switch (stateValue) {
            case 0: {
                state = "STATE_STARTING";
                break;
            }
            case 1: {
                state = "STATE_RUNNING";
                break;
            }
            case 2: {
                state = "STATE_STOPPING";
                break;
            }
            case 3: {
                state = "STATE_STOPPED";
                break;
            }
            case 4: {
                state = "STATE_FAILED";
                break;
            }
            default: {
                state = "STATE_UNKNOWN";
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getStateFromStateValue", state);
        }
        return state;
    }

    public static ObjectName getAdminAgentMBean() throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getAdminAgentMBean");
        }
        ObjectName adminAgentMBean = null;
        Set mbeans = WSDMUtilities.getMbeanByQueryString((String)"WebSphere:*,type=AdminAgent");
        if (mbeans.size() > 0) {
            adminAgentMBean = (ObjectName)mbeans.iterator().next();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getAdminAgentMBean", adminAgentMBean);
        }
        return adminAgentMBean;
    }

    public static String[] getManagedNodeKeys() {
        String[] profileKeys;
        block4: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "getManagedNodeKeys");
            }
            profileKeys = null;
            try {
                ObjectName adminAgentMbean = WSDMUtilities.getAdminAgentMBean();
                profileKeys = adminAgentMbean != null ? (String[])WSDMUtilities.mbeanInvoke((ObjectName)adminAgentMbean, (String)"listManagedNodesUUIDs", (Object[])new Object[0], (String[])new String[0]) : new String[]{""};
            }
            catch (Exception e) {
                if (!tc.isDebugEnabled()) break block4;
                Tr.debug(tc, "Exception caught: ", e);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getManagedNodeKeys", profileKeys);
        }
        return profileKeys;
    }

    public static boolean isAdminAgentProcess() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isAdminAgentProcess");
        }
        boolean result = false;
        AdminService adminService = AdminServiceFactory.getAdminService();
        if (adminService != null) {
            String processType = adminService.getProcessType();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "ProcessType is " + processType);
            }
            if (processType.equals("AdminAgent")) {
                result = true;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isAdminAgentProcess", new Boolean(result));
        }
        return result;
    }

    public static void formatResourceEPR(WASResourceReferenceParameters appEPR) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "formatResourceEPR", appEPR);
        }
        HashMap refProps = appEPR.getReferenceProperties();
        String mrid = (String)refProps.get(WSDMConstants.WAS_WSDM_Resource_MRID);
        String newMrid = mrid.substring(mrid.indexOf(":") + 1);
        refProps.put(WSDMConstants.WAS_WSDM_Resource_MRID, newMrid);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "formatResourceEPR", newMrid);
        }
    }

    public static boolean isServiceEnabled() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isServiceEnabled");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isServiceEnabled", serviceEnabled);
        }
        return serviceEnabled;
    }

    public static void setServiceEnableFlag(boolean newValue) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isServiceEnableFlag", newValue);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isServiceEnableFlag");
        }
        serviceEnabled = newValue;
    }
}

