/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.repository;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.management.repository.AppInfo;
import com.ibm.ws.management.repository.NodeAppInfo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class ConfigStructureHelper {
    private static TraceComponent tc = Tr.register(ConfigStructureHelper.class);
    private static HashMap nodeAppInfo = new HashMap();

    public static String[] getNodeDocuments(String[] catalog, String nodeName) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getNodeDocuments");
        }
        String cellName = ConfigStructureHelper.getCellName(catalog);
        NodeAppInfo nodeAppInfo = ConfigStructureHelper.updateNodeAppInfo(cellName, nodeName);
        String[] nodeDocs = null;
        if (catalog != null && catalog.length > 0 && nodeName != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, nodeName);
            }
            ArrayList<String> match = new ArrayList<String>();
            for (int i = 0; i < catalog.length; ++i) {
                if (!ConfigStructureHelper.checkForMatch(catalog[i], nodeName, nodeAppInfo)) continue;
                match.add(catalog[i]);
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "match: " + catalog[i]);
            }
            int numDocs = match.size();
            if (numDocs > 0) {
                nodeDocs = new String[numDocs];
                for (int i = 0; i < numDocs; ++i) {
                    nodeDocs[i] = (String)match.get(i);
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getNodeDocuments");
        }
        return nodeDocs;
    }

    public static String cellNameForDoc(String uri) {
        String result = null;
        if (uri != null) {
            int begin = uri.indexOf("cells/");
            begin = uri.indexOf(47, begin) + 1;
            int end = uri.indexOf(47, begin);
            result = uri.substring(begin, end);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Cell name for " + uri + "is " + result);
        }
        return result;
    }

    public static String nodeNameForDoc(String uri) {
        int begin;
        String result = null;
        String nodesKey = "/nodes/";
        if (uri != null && (begin = uri.indexOf(nodesKey)) >= 0) {
            int end = uri.indexOf(47, begin += nodesKey.length());
            result = end == -1 ? uri.substring(begin) : uri.substring(begin, end);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Node name for " + uri + "is " + result);
        }
        return result;
    }

    public static String serverNameForDoc(String uri) {
        int begin;
        String result = null;
        String serversKey = "/servers/";
        if (uri != null && (begin = uri.indexOf(serversKey)) >= 0) {
            int end = uri.indexOf(47, begin += serversKey.length());
            result = end == -1 ? uri.substring(begin) : uri.substring(begin, end);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Node name for " + uri + "is " + result);
        }
        return result;
    }

    public static String getURI(String cellName, String nodeName, String serverName, String docName) {
        String uri = null;
        if (docName != null && !docName.equals("") && cellName != null && !cellName.equals("")) {
            uri = "cells/" + cellName + "/";
            if (nodeName != null && !nodeName.equals("")) {
                uri = uri + "nodes/" + nodeName + "/";
            }
            if (serverName != null && !serverName.equals("")) {
                uri = uri + "servers/" + serverName + "/";
            }
            uri = uri + docName;
        }
        return uri;
    }

    public static boolean isAppBinary(String uri) {
        return uri.startsWith("apps/");
    }

    public static String getEarName(String binariesURL) {
        int forward;
        int backward = binariesURL.lastIndexOf(92);
        int start = backward > (forward = binariesURL.lastIndexOf(47)) ? backward : forward;
        return binariesURL.substring(start + 1);
    }

    public static String getAppBinariesRoot(String binariesURL) {
        return "apps/" + ConfigStructureHelper.getEarName(binariesURL);
    }

    public static List getAppExclusions(String cellName, String nodeName) {
        ArrayList<String> exclusions = new ArrayList<String>();
        NodeAppInfo nodeInfo = (NodeAppInfo)nodeAppInfo.get(nodeName);
        if (nodeInfo != null) {
            List apps = nodeInfo.getAppList();
            for (int i = 0; i < apps.size(); ++i) {
                String appName = (String)apps.get(i);
                AppInfo appInfo = nodeInfo.getAppInfo(appName);
                if (appInfo.getDistribute()) continue;
                exclusions.add("cells/" + cellName + "/applications/" + appName + "/*");
                exclusions.add("apps/" + appInfo.getEarName() + "/*");
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "Excluding application: " + appName);
            }
        }
        return exclusions;
    }

    private static String getCellName(String[] catalog) {
        String cellName = null;
        for (int i = 0; cellName == null && i < catalog.length; ++i) {
            if (!catalog[i].startsWith("cells/")) continue;
            cellName = ConfigStructureHelper.cellNameForDoc(catalog[i]);
        }
        return cellName;
    }

    private static NodeAppInfo updateNodeAppInfo(String cellname, String nodeName) {
        NodeAppInfo nodeInfo = (NodeAppInfo)nodeAppInfo.get(nodeName);
        if (nodeInfo == null) {
            nodeInfo = new NodeAppInfo(cellname, nodeName);
            nodeAppInfo.put(nodeName, nodeInfo);
        }
        nodeInfo.update();
        return nodeInfo;
    }

    private static boolean checkForMatch(String uri, String nodeName, NodeAppInfo nodeAppInfo) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "checkForMatch", new Object[]{uri, nodeName});
        }
        int level = ConfigStructureHelper.getDocLevel(uri);
        boolean match = false;
        if (level <= 2 && !uri.startsWith("apps/")) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "a cell-level document at level " + level);
            }
            match = true;
        } else if (uri.startsWith("templates/")) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "a template document");
            }
            match = true;
        } else if (uri.indexOf("/nodes/" + nodeName + "/") > 0) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "a node-level document");
            }
            match = true;
        } else if (uri.endsWith("serverindex.xml")) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "a serverindex document");
            }
            match = true;
        } else if (uri.indexOf("/applications/") > 0 && ConfigStructureHelper.checkAppConfigDoc(uri, nodeName, nodeAppInfo)) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "an application config document for the node");
            }
            match = true;
        } else if (uri.startsWith("apps/") && ConfigStructureHelper.checkAppBinaryDoc(uri, nodeName, nodeAppInfo)) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "an application binary file for the node");
            }
            match = true;
        } else if (uri.indexOf("clusters/") > 0 && ConfigStructureHelper.checkClusterDoc(nodeName)) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "a cluster document");
            }
            match = true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "checkForMatch:" + match);
        }
        return match;
    }

    private static int getDocLevel(String uri) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getDocLevel");
        }
        int level = 0;
        int position = 0;
        while ((position = uri.indexOf(47, position + 1)) > 0) {
            ++level;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getDocLevel: " + level);
        }
        return level;
    }

    private static boolean checkAppConfigDoc(String uri, String nodeName, NodeAppInfo nodeAppInfo) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "checkAppConfigDoc");
        }
        boolean match = false;
        List appList = nodeAppInfo.getAppList();
        for (int i = 0; !match && i < appList.size(); ++i) {
            String appName = (String)appList.get(i);
            if (uri.indexOf("/applications/" + appName + "/") <= 0) continue;
            match = true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "checkAppConfigDoc: " + match);
        }
        return match;
    }

    private static boolean checkAppBinaryDoc(String uri, String nodeName, NodeAppInfo nodeAppInfo) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "checkAppBinaryDoc");
        }
        boolean match = false;
        List appList = nodeAppInfo.getAppList();
        for (int i = 0; !match && i < appList.size(); ++i) {
            String appName = (String)appList.get(i);
            AppInfo appInfo = nodeAppInfo.getAppInfo(appName);
            String earName = appInfo.getEarName();
            if (!uri.startsWith("apps/" + earName + "/")) continue;
            match = true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "checkAppBinaryDoc: " + match);
        }
        return match;
    }

    private static boolean checkClusterDoc(String nodeName) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "checkClusterDoc");
        }
        boolean result = true;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "checkClusterDoc: " + result);
        }
        return result;
    }

    public static ArrayList getCellURIs(String[] catalog) {
        ArrayList<String> cellList = new ArrayList<String>();
        String CELL_DIR = "cells/";
        int cellDirLen = CELL_DIR.length();
        if (catalog != null && catalog.length > 0) {
            for (int i = 0; i < catalog.length; ++i) {
                String cellName;
                int nextSlash;
                String uri = catalog[i];
                int cellDirIndex = uri.indexOf(CELL_DIR);
                if (cellDirIndex == -1 || (nextSlash = uri.substring(cellDirLen).indexOf("/")) <= 0 || cellList.contains(cellName = uri.substring(cellDirIndex, nextSlash + cellDirLen))) continue;
                cellList.add(cellName);
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "getCellName: adding " + cellName);
            }
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getCellNames: input catalog was emtpy.");
        }
        return cellList;
    }
}

