/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.j2ee;

import com.ibm.ffdc.Manager;
import com.ibm.websphere.management.AdminService;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.websphere.management.exception.ObjectNotRunningException;
import com.ibm.ws.management.collaborator.J2EEManagedObjectCollaborator;
import java.util.Set;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.ReflectionException;

public abstract class J2EEManagedObjectProxy
extends J2EEManagedObjectCollaborator {
    private String deploymentDescriptor;
    private String fullServerName;

    public J2EEManagedObjectProxy(String dd) {
        this.deploymentDescriptor = dd;
    }

    public String getServer() {
        if (this.fullServerName == null) {
            ObjectName query = null;
            try {
                query = new ObjectName("WebSphere:*,j2eeType=J2EEServer," + this.getStandardKeyProperties());
            }
            catch (MalformedObjectNameException exc) {
                // empty catch block
            }
            Set s = AdminServiceFactory.getAdminService().queryNames(query, null);
            if (!s.isEmpty()) {
                this.fullServerName = s.iterator().next().toString();
            }
        }
        return this.fullServerName;
    }

    public String getDeploymentDescriptor() {
        return this.deploymentDescriptor;
    }

    public String getName() throws InstanceNotFoundException, MBeanException, ReflectionException, AttributeNotFoundException, ObjectNotRunningException {
        ObjectName modName = this.getWebSphereMBeanObjectName();
        if (modName == null) {
            throw new ObjectNotRunningException();
        }
        return (String)AdminServiceFactory.getAdminService().getAttribute(modName, "name");
    }

    public String getJavaVendor() throws InstanceNotFoundException, MBeanException, ReflectionException, AttributeNotFoundException, ObjectNotRunningException {
        ObjectName modName = this.getWebSphereMBeanObjectName();
        if (modName == null) {
            throw new ObjectNotRunningException();
        }
        return (String)AdminServiceFactory.getAdminService().getAttribute(modName, "javaVendor");
    }

    public String getJavaVersion() throws InstanceNotFoundException, MBeanException, ReflectionException, AttributeNotFoundException, ObjectNotRunningException {
        ObjectName modName = this.getWebSphereMBeanObjectName();
        if (modName == null) {
            throw new ObjectNotRunningException();
        }
        return (String)AdminServiceFactory.getAdminService().getAttribute(modName, "javaVersion");
    }

    protected String getJ2EEName() {
        return this.getObjectName().getKeyProperty("name");
    }

    protected String getJ2EEType() {
        return this.getObjectName().getKeyProperty("j2eeType");
    }

    protected abstract String getWebSphereMBeanKeyProperties();

    protected ObjectName getPartialWebSphereMBeanObjectName() {
        ObjectName name = null;
        try {
            name = new ObjectName("WebSphere:*," + this.getWebSphereMBeanKeyProperties());
        }
        catch (MalformedObjectNameException exc) {
            Manager.Ffdc.log(exc, this, "com.ibm.ws.management.j2ee.J2EEManagedObjectProxy.getPartialWebSphereMBeanObjectName", "112", this);
        }
        return name;
    }

    protected ObjectName getWebSphereMBeanObjectName() {
        Set s = AdminServiceFactory.getAdminService().queryNames(this.getPartialWebSphereMBeanObjectName(), null);
        if (!s.isEmpty()) {
            return (ObjectName)s.iterator().next();
        }
        return null;
    }

    protected String getStandardKeyProperties() {
        AdminService as = AdminServiceFactory.getAdminService();
        StringBuffer buf = new StringBuffer();
        buf.append("cell=");
        buf.append(as.getCellName());
        buf.append(",node=");
        buf.append(as.getNodeName());
        buf.append(",process=");
        buf.append(as.getProcessName());
        return buf.toString();
    }
}

