/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.discovery;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ffdc.Manager;
import com.ibm.websphere.management.AdminClient;
import com.ibm.websphere.management.AdminService;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.websphere.management.ObjectNameHelper;
import com.ibm.websphere.management.exception.ConnectorException;
import com.ibm.websphere.management.exception.ConnectorNotAvailableException;
import com.ibm.ws.management.discovery.ServerInfo;
import java.util.Iterator;
import java.util.Set;
import javax.management.JMException;
import javax.management.ObjectName;

public class Utils {
    private static TraceComponent tc = Tr.register(Utils.class);

    public static AdminClient getDmgrAdminClient() throws ConnectorException {
        AdminService admin;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getDmgrAdminClient");
        }
        if ((admin = AdminServiceFactory.getAdminService()) == null) {
            throw new ConnectorNotAvailableException();
        }
        String adminType = admin.getProcessType();
        AdminClient client = null;
        if (adminType.equals("NodeAgent")) {
            client = Utils.getParentAdminClient();
        } else if (adminType.equals("ManagedProcess")) {
            AdminClient nodeagent = Utils.getParentAdminClient();
            ObjectName servermbean = nodeagent.getServerMBean();
            if (servermbean == null) {
                throw new ConnectorNotAvailableException();
            }
            String name = ObjectNameHelper.getProcessName(servermbean);
            ObjectName on = Utils.getDiscoveryMBean(nodeagent, name);
            if (on == null) {
                throw new ConnectorNotAvailableException();
            }
            ServerInfo dmgrInfo = null;
            try {
                dmgrInfo = (ServerInfo)nodeagent.invoke(on, "getParent", null, null);
            }
            catch (JMException ex) {
                Manager.Ffdc.log(ex, Utils.class, "getDmgrAdminClient", "55");
            }
            if (dmgrInfo == null) {
                throw new ConnectorNotAvailableException();
            }
            client = dmgrInfo.getAdminClient();
        }
        if (client == null) {
            throw new ConnectorNotAvailableException();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getDmgrAdminClient");
        }
        return client;
    }

    public static AdminClient getParentAdminClient() throws ConnectorException {
        AdminService admin;
        ObjectName on;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getParentAdminClient");
        }
        if ((on = Utils.getDiscoveryMBean(admin = AdminServiceFactory.getAdminService(), admin.getProcessName())) == null) {
            throw new ConnectorNotAvailableException();
        }
        ServerInfo parentInfo = null;
        try {
            parentInfo = (ServerInfo)admin.invoke(on, "getParent", null, null);
        }
        catch (JMException ex) {
            Manager.Ffdc.log(ex, Utils.class, "getParentAdminClient", "89");
        }
        if (parentInfo == null) {
            throw new ConnectorNotAvailableException();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getParentAdminClient");
        }
        return parentInfo.getAdminClient();
    }

    private static ObjectName getDiscoveryMBean(AdminService admin, String procName) {
        ObjectName on;
        block2: {
            on = null;
            try {
                String query = "WebSphere:type=Discovery,process=" + procName + ",*";
                on = new ObjectName(query);
                Set s = admin.queryNames(on, null);
                Iterator it = s.iterator();
                on = (ObjectName)it.next();
            }
            catch (Exception ex) {
                if (!tc.isDebugEnabled()) break block2;
                Tr.debug(tc, "getDiscoveryMBean(AdminService)", ex);
            }
        }
        return on;
    }

    private static ObjectName getDiscoveryMBean(AdminClient client, String procName) {
        ObjectName on;
        block2: {
            on = null;
            try {
                String query = "WebSphere:type=Discovery,process=" + procName + ",*";
                on = new ObjectName(query);
                Set s = client.queryNames(on, null);
                Iterator it = s.iterator();
                on = (ObjectName)it.next();
            }
            catch (Exception ex) {
                if (!tc.isDebugEnabled()) break block2;
                Tr.debug(tc, "getDiscoveryMBean(AdminClient)", ex);
            }
        }
        return on;
    }
}

