/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.collaborator;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ffdc.Manager;
import com.ibm.ws.management.collaborator.IllegalStateTransitionException;
import com.ibm.ws.management.collaborator.StatisticsProviderCollaborator;
import java.util.ArrayList;
import javax.management.Descriptor;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanException;
import javax.management.MBeanNotificationInfo;
import javax.management.Notification;
import javax.management.NotificationListener;
import javax.management.modelmbean.ModelMBean;
import javax.management.modelmbean.ModelMBeanInfo;

public class J2EEManagedObjectCollaborator
extends StatisticsProviderCollaborator {
    private static TraceComponent tc = Tr.register(J2EEManagedObjectCollaborator.class, "Admin", "com.ibm.ws.management.resources.adminservice");
    public static final int STATE_STARTING = 0;
    public static final int STATE_RUNNING = 1;
    public static final int STATE_STOPPING = 2;
    public static final int STATE_STOPPED = 3;
    public static final int STATE_FAILED = 4;
    public static final String[] STATE_NAMES = new String[]{"STARTING", "RUNNING", "STOPPING", "STOPPED", "FAILED"};
    public static final String ATTR_CHANGED_NOTIF_TYPE = "j2ee.attribute.changed";
    private static final String[] STATE_NOTIF_TYPES = new String[]{"j2ee.state.starting", "j2ee.state.running", "j2ee.state.stopping", "j2ee.state.stopped", "j2ee.state.failed"};
    private boolean isEventProvider = false;
    private boolean isStateManageable = false;
    private String[] eventTypes = null;
    private int currentState = 3;
    private long startTime = 0L;
    private long nextSeqNum = 0L;

    public J2EEManagedObjectCollaborator() {
    }

    public J2EEManagedObjectCollaborator(int initialState) {
        this.currentState = initialState;
    }

    public String getObjectNameStr() {
        return this.getObjectName().toString();
    }

    public boolean isEventProvider() {
        return this.isEventProvider;
    }

    public boolean isStateManageable() {
        return this.isStateManageable;
    }

    public String[] getEventTypes() {
        return this.eventTypes;
    }

    public int getJ2EEState() {
        return this.currentState;
    }

    public long getStartTime() {
        return this.startTime;
    }

    protected void changeState(int newState) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "changeState", STATE_NAMES[newState]);
        }
        if (this.currentState == newState) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "changeState");
            }
            return;
        }
        switch (this.currentState) {
            case 0: {
                if (newState == 1 || newState == 4 || newState == 2) break;
                this.throwIllegalStateChangeException(newState);
                break;
            }
            case 1: {
                if (newState == 4 || newState == 2) break;
                this.throwIllegalStateChangeException(newState);
                break;
            }
            case 2: {
                if (newState == 4 || newState == 3) break;
                this.throwIllegalStateChangeException(newState);
                break;
            }
            case 3: {
                if (newState == 0) break;
                this.throwIllegalStateChangeException(newState);
                break;
            }
            case 4: {
                if (newState == 2 || newState == 0) break;
                this.throwIllegalStateChangeException(newState);
            }
        }
        if (newState == 1) {
            this.startTime = System.currentTimeMillis();
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Changing " + this.getObjectName() + " from state " + STATE_NAMES[this.currentState] + " to state " + STATE_NAMES[newState]);
        }
        this.currentState = newState;
        this.emitStateChangeNotification();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "changeState");
        }
    }

    private void throwIllegalStateChangeException(int newState) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Illegal state change on " + this.getObjectName() + " from state " + STATE_NAMES[this.currentState] + " to state " + STATE_NAMES[newState]);
        }
        throw new IllegalStateTransitionException(this.currentState, newState);
    }

    private void emitStateChangeNotification() {
        try {
            this.sendNotification(new Notification(STATE_NOTIF_TYPES[this.currentState], this.getObjectName(), this.nextSeqNum++));
        }
        catch (MBeanException exc) {
            Manager.Ffdc.log(exc, this, "com.ibm.ws.management.collaborator.J2EEManagedObjectCollaborator.emitStateChangeNotification", "198", this);
        }
    }

    public void bindMBean(ModelMBeanInfo info, ModelMBean bean) throws Exception {
        MBeanAttributeInfo[] attributes;
        super.bindMBean(info, bean);
        Descriptor desc = info.getMBeanDescriptor();
        if (desc != null) {
            Object obj = null;
            obj = desc.getFieldValue("eventProvider");
            if (obj != null && obj.equals(Boolean.TRUE)) {
                this.isEventProvider = true;
                this.eventTypes = this.getEventTypes(info);
            }
            if ((obj = desc.getFieldValue("stateManageable")) != null && obj.equals(Boolean.TRUE)) {
                this.isStateManageable = true;
            }
        }
        if ((attributes = info.getAttributes()) != null && attributes.length != 0) {
            this.modelMBean.addAttributeChangeNotificationListener(new NotificationListener(){

                public void handleNotification(Notification notif, Object obj) {
                    Notification newNotif = new Notification(J2EEManagedObjectCollaborator.ATTR_CHANGED_NOTIF_TYPE, notif.getSource(), notif.getSequenceNumber(), notif.getTimeStamp(), notif.getMessage());
                    newNotif.setUserData(notif.getUserData());
                    try {
                        J2EEManagedObjectCollaborator.this.modelMBean.sendNotification(newNotif);
                    }
                    catch (MBeanException exc) {
                        Manager.Ffdc.log(exc, this, "com.ibm.websphere.management.J2EEManagedObjectCollaborator.handleNotification", "242", this);
                        Tr.warning(tc, "ADMN0014W", new Object[]{J2EEManagedObjectCollaborator.ATTR_CHANGED_NOTIF_TYPE, exc});
                    }
                }
            }, null, null);
        }
    }

    private String[] getEventTypes(ModelMBeanInfo info) {
        ArrayList<String> notifs = new ArrayList<String>();
        MBeanNotificationInfo[] notifInfo = info.getNotifications();
        for (int i = 0; i < notifInfo.length; ++i) {
            String[] notifTypes = notifInfo[i].getNotifTypes();
            for (int j = 0; j < notifTypes.length; ++j) {
                notifs.add(notifTypes[j]);
            }
        }
        String[] notifArray = new String[notifs.size()];
        return notifs.toArray(notifArray);
    }
}

