/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.cmdframework.impl;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.ffdc.Manager;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.commanddata.CommandDataFactory;
import com.ibm.websphere.management.cmdframework.commanddata.CommandDataPackage;
import com.ibm.websphere.management.cmdframework.commandmetadata.BaseMetadata;
import com.ibm.websphere.management.cmdframework.commandmetadata.CommandGroupExtension;
import com.ibm.websphere.management.cmdframework.commandmetadata.CommandGroupMetadata;
import com.ibm.websphere.management.cmdframework.commandmetadata.CommandMetadata;
import com.ibm.websphere.management.cmdframework.commandmetadata.CommandMetadataFactory;
import com.ibm.websphere.management.cmdframework.commandmetadata.CommandMetadataPackage;
import com.ibm.websphere.management.cmdframework.commandmetadata.CommandProviderMetadata;
import com.ibm.websphere.management.cmdframework.commandmetadata.CommandStepMetadata;
import com.ibm.websphere.management.cmdframework.commandmetadata.Metadata;
import com.ibm.websphere.management.cmdframework.commandmetadata.ParameterMetadata;
import com.ibm.websphere.management.cmdframework.commandmetadata.TaskCommandExtension;
import com.ibm.websphere.management.cmdframework.commandmetadata.TaskCommandMetadata;
import com.ibm.websphere.management.cmdframework.provider.CommandProvider;
import com.ibm.ws.management.cmdframework.impl.CommandUtility;
import com.ibm.ws.management.cmdframework.impl.ParameterTypeTable;
import com.ibm.ws.management.cmdframework.impl.TaskCommandExtComparator;
import com.ibm.ws.security.util.AccessController;
import com.ibm.wsspi.extension.ExtensionRegistryFactory;
import java.io.IOException;
import java.net.URL;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.xmi.impl.XMLMapImpl;
import org.eclipse.emf.ecore.xmi.impl.XMLResourceImpl;
import org.osgi.framework.Bundle;

public class CommandMetadataMgr {
    private static TraceComponent tc = Tr.register(CommandMetadataMgr.class, "CommandMetadataMgr", "com.ibm.ws.management.resources.cmdframework");
    private static CommandMetadataMgr commandMetadataMgr = null;
    private static CommandMetadataMgr commandMetadataMgr4C = null;
    private static boolean initialized = false;
    private HashMap cmdGroupMetadataTable;
    private HashMap cmdGroupCommandTable;
    private HashMap cmdProviderInstanceTable;
    private HashMap cmdCommandProviderTable;
    private HashMap cmdGroupResBundleTable;
    private HashMap cmdMetadataTable;
    private Map loadOptions;
    private ArrayList cmdTaskExtsList;
    private ArrayList cmdNewTaskExtsList;
    private ArrayList cmdGrpExtList;
    private EcoreFactory fac;
    private EcorePackage pkg;
    static EFactory eFactory;
    static EPackage cmddataPackage;
    static CommandMetadataFactory cmdMetadataFactory;

    private CommandMetadataMgr(boolean isClientMode) {
        block5: {
            this.cmdGroupMetadataTable = new HashMap();
            this.cmdGroupCommandTable = new HashMap();
            this.cmdProviderInstanceTable = new HashMap();
            this.cmdCommandProviderTable = new HashMap();
            this.cmdGroupResBundleTable = new HashMap();
            this.cmdMetadataTable = new HashMap();
            this.loadOptions = new HashMap(1);
            this.cmdTaskExtsList = new ArrayList();
            this.cmdNewTaskExtsList = new ArrayList();
            this.cmdGrpExtList = new ArrayList();
            this.fac = EcoreFactory.eINSTANCE;
            this.pkg = EcorePackage.eINSTANCE;
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "CommandMetadataMgr, isClientMode = " + isClientMode);
            }
            this.initialize();
            if (!isClientMode) {
                try {
                    String resourceName = "META-INF/admin-command-def.xml";
                    this.registerMetaDataUsingv6Mechanism(resourceName);
                    this.registerMetaDataUsingOSGiMechanism(resourceName);
                    this.registerCommandGroupExtensions();
                    this.registerNewTaskExtensions();
                    this.registerTaskExtensions();
                    this.cleanup();
                }
                catch (Throwable e) {
                    if (!tc.isDebugEnabled()) break block5;
                    Tr.debug(tc, "Exception caught ", e);
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "CommandMetadataMgr, isClientMode = " + isClientMode);
        }
    }

    private void registerMetaDataUsingOSGiMechanism(String resourceName) throws IOException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "registerMetaDataUsingOSGiMechanism, resourceName = " + resourceName);
        }
        HashSet<Bundle> processedBundles = new HashSet<Bundle>();
        IExtensionRegistry registry = ExtensionRegistryFactory.instance().getExtensionRegistry();
        if (registry != null && ExtensionRegistryFactory.instance().isEclipse()) {
            String epid = ExtensionRegistryFactory.instance().getDefaultPluginID() + ".admin-command-def";
            IExtensionPoint extensionPoint = registry.getExtensionPoint(epid);
            if (extensionPoint != null) {
                IExtension[] extensions = extensionPoint.getExtensions();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Processing extension point " + epid);
                    Tr.debug(tc, "There are " + extensions.length + " extensions");
                }
                for (int i = 0; i < extensions.length; ++i) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Processing extension " + extensions[i].getNamespace());
                    }
                    Bundle bundle = Platform.getBundle(extensions[i].getNamespace());
                    BundleClassLocator locator = new BundleClassLocator(bundle);
                    if (processedBundles.contains(bundle)) continue;
                    Enumeration e = locator.locateResources(resourceName);
                    if (e == null) {
                        if (!tc.isDebugEnabled()) continue;
                        Tr.debug(tc, "Unable to locate resource: " + resourceName);
                        continue;
                    }
                    processedBundles.add(bundle);
                    while (e.hasMoreElements()) {
                        try {
                            URL metadataURL = (URL)e.nextElement();
                            Metadata metadata = this.getMetadata(metadataURL);
                            this.registerMetadata(metadata, locator);
                        }
                        catch (Throwable t) {
                            if (!tc.isDebugEnabled()) continue;
                            Tr.debug(tc, "Exception caught ", t);
                        }
                    }
                }
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Unable to find extension point " + epid);
            }
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Unable to get eclipse registry");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "registerMetaDataUsingOSGiMechanism, resourceName = " + resourceName);
        }
    }

    private void registerMetaDataUsingv6Mechanism(String resourceName) throws IOException {
        ClassLoaderClassLocator locator;
        Enumeration e;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "registerMetaDataUsingv6Mechanism, resourceName = " + resourceName);
        }
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "ClassLoader being used is " + loader);
        }
        if ((e = (locator = new ClassLoaderClassLocator(loader)).locateResources(resourceName)) == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Unable to locate resource: " + resourceName);
            }
        } else {
            while (e.hasMoreElements()) {
                try {
                    URL metadataURL = (URL)e.nextElement();
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "loading data from " + metadataURL);
                    }
                    Metadata metadata = this.getMetadata(metadataURL);
                    this.registerMetadata(metadata, locator);
                }
                catch (Throwable t) {
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "Exception caught ", t);
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "registerMetaDataUsingv6Mechanism, resourceName = " + resourceName);
        }
    }

    protected Metadata getMetadata(URL metadataURL) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "get Metadata " + metadataURL.getFile());
        }
        XMLResourceImpl res = new XMLResourceImpl();
        try {
            res.setURI(URI.createURI(metadataURL.toString()));
            res.load(metadataURL.openStream(), this.loadOptions);
        }
        catch (Exception fe) {
            EList errors = res.getErrors();
            for (Exception ex : errors) {
                Manager.Ffdc.log(ex, this, "com.ibm.ws.management.cmdframework.impl.CommandMetadataMgr", "59", this);
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "Exception caught " + ex.getMessage());
            }
        }
        return (Metadata)res.getContents().get(0);
    }

    protected void registerMetadata(Metadata metadata, ClassLocator locator) {
        block3: {
            try {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Register commands");
                }
                this.registerCommandProviderMetadata(metadata, locator);
            }
            catch (Exception e) {
                if (!tc.isDebugEnabled()) break block3;
                Tr.debug(tc, "Exception thrown during metadata", e);
            }
        }
    }

    protected void registerCommandProviderMetadata(Metadata metadata, ClassLocator locator) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "get Command Provider Metadata");
        }
        EList cmdProviderMetadataList = metadata.getCommandProvider();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "provider metadata list size is " + cmdProviderMetadataList.size());
        }
        if (cmdProviderMetadataList != null && !cmdProviderMetadataList.isEmpty()) {
            for (int i = 0; i < cmdProviderMetadataList.size(); ++i) {
                CommandProviderMetadata cmdProviderMetadata = (CommandProviderMetadata)cmdProviderMetadataList.get(i);
                this.translate(cmdProviderMetadata);
                String className = "";
                try {
                    className = cmdProviderMetadata.getImplClass();
                    Class cmdProviderClass = locator.locateClass(className);
                    CommandProvider cmdProviderInstance = (CommandProvider)cmdProviderClass.newInstance();
                    this.cmdProviderInstanceTable.put(cmdProviderMetadata.getImplClass(), cmdProviderInstance);
                    this.registerCommandGroupMetadata(cmdProviderMetadata.getCommandGroups());
                    this.registerCommandMetadata(cmdProviderInstance.initCommandMetadata(cmdProviderMetadata.getCommands()));
                    this.registerTaskCommandMetadata(cmdProviderInstance.initCommandMetadata(cmdProviderMetadata.getTaskCommands()));
                    this.addCommandGroupExtensions(cmdProviderMetadata.getCommandGroupExts());
                    this.addTaskCommandExtensions(cmdProviderMetadata.getTaskCommandExts());
                    continue;
                }
                catch (ClassNotFoundException ce) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Command Provider class not found.", ce);
                    }
                    Manager.Ffdc.log(ce, this, "com.ibm.ws.management.cmdframework.impl.CommandMetadataMgr", "425", className);
                    continue;
                }
                catch (InstantiationException ie) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Command Provider class not be instantiated.", ie);
                    }
                    Manager.Ffdc.log(ie, this, "com.ibm.ws.management.cmdframework.impl.CommandMetadataMgr", "430", className);
                    continue;
                }
                catch (IllegalAccessException iae) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Command Provider class instantiated illegal access exception.", iae);
                    }
                    Manager.Ffdc.log(iae, this, "com.ibm.ws.management.cmdframework.impl.CommandMetadataMgr", "435", className);
                    continue;
                }
                catch (Throwable ite) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Command Provider class: " + cmdProviderMetadata.getImplClass() + " cannot be invocated.", ite);
                    }
                    Manager.Ffdc.log(ite, this, "com.ibm.ws.management.cmdframework.impl.CommandMetadataMgr", "440", className);
                }
            }
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "No Command Provider is defined");
        }
    }

    private void translate(CommandProviderMetadata providerMetadata) {
        String resourceBundle;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "translate, providerMetadata = " + providerMetadata);
        }
        if ((resourceBundle = providerMetadata.getResourceBundle()) != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "resourceBundle", resourceBundle);
            }
            Object translated = null;
            Object key = null;
            TreeIterator iter = providerMetadata.eAllContents();
            while (iter.hasNext()) {
                BaseMetadata metadata;
                Object obj = iter.next();
                if (obj instanceof BaseMetadata) {
                    metadata = (BaseMetadata)obj;
                    this.translate(metadata, resourceBundle, Locale.getDefault());
                }
                if (!(obj instanceof CommandMetadata)) continue;
                metadata = (CommandMetadata)obj;
                this.translate((CommandMetadata)metadata, resourceBundle, Locale.getDefault());
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "translate");
        }
    }

    protected void translate(BaseMetadata baseMetadata, String resourceBundle, Locale locale) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "translate", new Object[]{baseMetadata, resourceBundle, locale});
        }
        if ((resourceBundle == null || resourceBundle.equals("")) && baseMetadata instanceof CommandGroupMetadata) {
            resourceBundle = (String)this.cmdGroupResBundleTable.get(baseMetadata.getName());
        }
        String translated = null;
        String key = null;
        if (resourceBundle != null) {
            key = baseMetadata.getDescriptionKey();
            if (key != null) {
                translated = TraceNLS.getStringFromBundle(resourceBundle, key, locale);
                baseMetadata.setDescription(translated);
            }
            if ((key = baseMetadata.getTitleKey()) != null) {
                translated = TraceNLS.getStringFromBundle(resourceBundle, key, locale);
                baseMetadata.setTitle(translated);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "translate");
        }
    }

    protected void translate(CommandMetadata cmdMetadata, String resourceBundle, Locale locale) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "translate", cmdMetadata);
        }
        if (resourceBundle == null || resourceBundle.equals("")) {
            ProviderTableEntry pte = (ProviderTableEntry)this.cmdCommandProviderTable.get(cmdMetadata.getName());
            if (pte != null) {
                resourceBundle = pte.getResouceBundle();
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, "cannot find command provider");
            }
        }
        String translated = null;
        String key = null;
        if (resourceBundle != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "resourceBundle", resourceBundle);
            }
            if ((key = cmdMetadata.getTargetObjectDescriptionKey()) != null) {
                translated = TraceNLS.getStringFromBundle(resourceBundle, key, locale);
                cmdMetadata.setTargetObjectDescription(translated);
            }
            if ((key = cmdMetadata.getTargetObjectTitleKey()) != null) {
                translated = TraceNLS.getStringFromBundle(resourceBundle, key, locale);
                cmdMetadata.setTargetObjectTitle(translated);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "translate");
        }
    }

    protected void registerCommandGroupMetadata(List cmdGrpMetadataList) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "registerCommandGroupMetadata");
        }
        ArrayList cmdListArrayList = null;
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "group metadata list size is " + cmdGrpMetadataList.size());
        }
        if (cmdGrpMetadataList != null && !cmdGrpMetadataList.isEmpty()) {
            for (int i = 0; i < cmdGrpMetadataList.size(); ++i) {
                CommandGroupMetadata cmdGrpMetadata = (CommandGroupMetadata)cmdGrpMetadataList.get(i);
                String cmdGroupName = cmdGrpMetadata.getName();
                if (!this.cmdGroupMetadataTable.containsKey(cmdGroupName)) {
                    this.cmdGroupMetadataTable.put(cmdGroupName, cmdGrpMetadata);
                } else if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Command Group already exist in the group, possibly Command Group name conflict");
                }
                if (!this.cmdGroupCommandTable.containsKey(cmdGroupName)) {
                    this.cmdGroupCommandTable.put(cmdGroupName, new ArrayList());
                } else if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Command Group already exist in the command group, possibly Command Group name conflict");
                }
                EList cmdNameList = cmdGrpMetadata.getCommands();
                for (int j = 0; j < cmdNameList.size(); ++j) {
                    String cmdName = (String)cmdNameList.get(j);
                    if (cmdName != null && cmdName.length() != 0) {
                        cmdListArrayList = (ArrayList)this.cmdGroupCommandTable.get(cmdGroupName);
                        if (!cmdListArrayList.contains(cmdName)) {
                            cmdListArrayList.add(cmdName);
                            continue;
                        }
                        if (!tc.isDebugEnabled()) continue;
                        Tr.debug(tc, "Command already exist in this group " + cmdGroupName + ", possibly command name conflict");
                        continue;
                    }
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "No command specified for this group");
                }
                String resourceBundle = ((CommandProviderMetadata)cmdGrpMetadata.eContainer()).getResourceBundle();
                if (resourceBundle == null || resourceBundle.equals("")) continue;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "resouce bundle is " + cmdGroupName);
                }
                this.cmdGroupResBundleTable.put(cmdGroupName, resourceBundle);
            }
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "No Command Group is defined");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "registerCommandGroupMetadata, ");
        }
    }

    protected void registerCommandGroupExtensions() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "registerCommandGroupExtensions");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "group extension metadata list size is " + this.cmdGrpExtList.size());
        }
        ArrayList cmdListArrayList = null;
        if (this.cmdGrpExtList != null && !this.cmdGrpExtList.isEmpty()) {
            for (int i = 0; i < this.cmdGrpExtList.size(); ++i) {
                CommandGroupExtension cmdGrpExt = (CommandGroupExtension)this.cmdGrpExtList.get(i);
                String cmdGroupName = cmdGrpExt.getName();
                if (this.cmdGroupMetadataTable.containsKey(cmdGroupName)) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "group to add extension is " + cmdGroupName);
                    }
                    try {
                        CommandGroupMetadata cmdGrpMetadata = this.getCommandGroupMetadata(cmdGroupName);
                        EList baseCmdNameList = cmdGrpMetadata.getCommands();
                        EList cmdNameList = cmdGrpExt.getCommands();
                        for (int j = 0; j < cmdNameList.size(); ++j) {
                            String cmdName = (String)cmdNameList.get(j);
                            if (cmdName != null && cmdName.length() != 0) {
                                cmdListArrayList = (ArrayList)this.cmdGroupCommandTable.get(cmdGroupName);
                                if (!cmdListArrayList.contains(cmdName)) {
                                    if (tc.isDebugEnabled()) {
                                        Tr.debug(tc, "add command " + cmdName);
                                    }
                                    cmdListArrayList.add(cmdName);
                                } else if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "Command already exist in this group " + cmdGroupName + ", possibly command name conflict");
                                }
                                baseCmdNameList.add(cmdName);
                                continue;
                            }
                            if (!tc.isDebugEnabled()) continue;
                            Tr.debug(tc, "No command specified for this extension");
                        }
                        continue;
                    }
                    catch (CommandNotFoundException cnfe) {
                        if (!tc.isDebugEnabled()) continue;
                        Tr.debug(tc, "Command Group " + cmdGroupName + " does not exist");
                        continue;
                    }
                }
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "Command Group " + cmdGroupName + " does not exist");
            }
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "No Command Group Extension defined");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "registerCommandGroupExtensions");
        }
    }

    protected void addCommandGroupExtensions(List cmdGrpList) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addCommandGroupExtensions");
        }
        if (cmdGrpList != null && !cmdGrpList.isEmpty()) {
            for (int i = 0; i < cmdGrpList.size(); ++i) {
                this.cmdGrpExtList.add(cmdGrpList.get(i));
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addCommandGroupExtensions");
        }
    }

    protected void registerTaskCommandMetadata(List taskCommandList) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "register Task Command Metadata");
        }
        ArrayList<TaskCommandMetadata> validTaskCommandList = new ArrayList<TaskCommandMetadata>();
        for (int i = 0; i < taskCommandList.size(); ++i) {
            TaskCommandMetadata taskCommand = (TaskCommandMetadata)taskCommandList.get(i);
            if (!this.validateTaskCommand(taskCommand)) continue;
            validTaskCommandList.add(taskCommand);
        }
        this.registerCommandMetadata(validTaskCommandList);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "registerTaskCommandMetadata");
        }
    }

    protected void registerNewTaskExtensions() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "registerNewTaskExtensions");
        }
        if (this.cmdNewTaskExtsList != null && !this.cmdNewTaskExtsList.isEmpty()) {
            for (int i = 0; i < this.cmdNewTaskExtsList.size(); ++i) {
                TaskCommandExtension taskCmdExt = (TaskCommandExtension)this.cmdNewTaskExtsList.get(i);
                try {
                    String taskCmdExtName = taskCmdExt.getName();
                    if (this.cmdMetadataTable.containsKey(taskCmdExtName)) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Task command " + taskCmdExtName + " extension base exists.  Add to cmdTaskExtsList");
                        }
                        this.cmdTaskExtsList.add(taskCmdExt);
                        continue;
                    }
                    String baseTaskCmd = taskCmdExt.getBaseTaskCommand();
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "New task command extension to add is  " + taskCmdExtName + " Task base command name is " + baseTaskCmd);
                    }
                    if (baseTaskCmd != null && !baseTaskCmd.equals("")) {
                        TaskCommandMetadata origTaskCmdMetadata = (TaskCommandMetadata)this.getCommandMetadata(taskCmdExt.getBaseTaskCommand());
                        TaskCommandMetadata taskCmdMetadata = (TaskCommandMetadata)CommandUtility.clone(origTaskCmdMetadata);
                        taskCmdMetadata.setName(taskCmdExtName);
                        taskCmdMetadata.setPrivate(taskCmdExt.isPrivate());
                        CommandProviderMetadata cpm = (CommandProviderMetadata)taskCmdExt.eContainer();
                        this.cmdCommandProviderTable.put(taskCmdExtName, new ProviderTableEntry(cpm.getImplClass(), cpm.getResourceBundle()));
                        this.addTaskExtStepProvider(taskCmdExt);
                        ArrayList<TaskCommandMetadata> tempTaskExtList = new ArrayList<TaskCommandMetadata>();
                        tempTaskExtList.add(taskCmdMetadata);
                        this.registerCommandMetadata(tempTaskExtList);
                        this.updateTaskExtStep(taskCmdMetadata, taskCmdExt);
                        continue;
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Base Task command not found " + baseTaskCmd + ".  Add to exist list for further processing");
                    }
                    this.cmdTaskExtsList.add(taskCmdExt);
                    continue;
                }
                catch (CommandNotFoundException cnfe) {
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "Command " + taskCmdExt.getName() + " not found.");
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "registerNewTaskExtensions");
        }
    }

    protected void registerTaskExtensions() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "registerTaskExtensions");
        }
        if (this.cmdTaskExtsList != null && !this.cmdTaskExtsList.isEmpty()) {
            Collections.sort(this.cmdTaskExtsList, new TaskCommandExtComparator());
            for (int i = 0; i < this.cmdTaskExtsList.size(); ++i) {
                TaskCommandExtension taskCmdExt = (TaskCommandExtension)this.cmdTaskExtsList.get(i);
                String taskCmdExtName = taskCmdExt.getName();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Task command extension to add is  " + taskCmdExtName);
                }
                try {
                    TaskCommandMetadata taskCmdMetadata = (TaskCommandMetadata)this.getCommandMetadata(taskCmdExtName);
                    this.addTaskExtStepProvider(taskCmdExt);
                    this.updateTaskExtStep(taskCmdMetadata, taskCmdExt);
                    continue;
                }
                catch (CommandNotFoundException cnfe) {
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "task Command not found " + taskCmdExtName + ".  Proceed to add new task cmd");
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "registerTaskExtensions");
        }
    }

    private void addTaskExtStepProvider(TaskCommandExtension taskCmdExt) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addTaskExtStepProvider", taskCmdExt.getName());
        }
        String taskCmdExtName = taskCmdExt.getName();
        CommandProviderMetadata container = (CommandProviderMetadata)taskCmdExt.eContainer();
        EList stepList = taskCmdExt.getSteps();
        for (int i = 0; i < stepList.size(); ++i) {
            CommandStepMetadata step = (CommandStepMetadata)stepList.get(i);
            String taskExtStepName = step.getName();
            String steptaskname = this.getStepEClassName(taskCmdExtName, taskExtStepName);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Step name to add to provider table is " + steptaskname);
            }
            this.cmdCommandProviderTable.put(steptaskname, new ProviderTableEntry(container.getImplClass(), container.getResourceBundle()));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addTaskExtStepProvider");
        }
    }

    private void updateTaskExtStep(TaskCommandMetadata taskCmdMetadata, TaskCommandExtension taskCmdExt) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "updateTaskExtStep", taskCmdMetadata.getName());
        }
        EList taskCmdSteps = taskCmdMetadata.getSteps();
        EList origStepList = taskCmdExt.getSteps();
        ArrayList stepList = new ArrayList(origStepList);
        for (int i = 0; i < stepList.size(); ++i) {
            CommandStepMetadata step = (CommandStepMetadata)stepList.get(i);
            int stepIndex = this.getStepIndexFromTask(taskCmdSteps, step);
            if (stepIndex >= 0) {
                CommandStepMetadata origStep = (CommandStepMetadata)taskCmdSteps.get(stepIndex);
                if (Integer.valueOf(step.getPriority()) <= Integer.valueOf(origStep.getPriority())) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Update step " + step.getName() + " at index " + stepIndex);
                    }
                    taskCmdSteps.remove(stepIndex);
                    taskCmdSteps.add(stepIndex, step);
                    continue;
                }
                String stepname = this.getStepEClassName(taskCmdExt.getName(), step.getName());
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "remove stepname " + stepname + " in provider table");
                }
                this.cmdCommandProviderTable.remove(stepname);
                continue;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "add new step " + step.getName() + " to " + taskCmdMetadata.getName());
            }
            taskCmdSteps.add(step);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "updateTaskExtStep");
        }
    }

    private int getStepIndexFromTask(List stepsList, CommandStepMetadata stepToFind) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getStepIndexFromTask");
        }
        int index = -1;
        for (int i = 0; i < stepsList.size(); ++i) {
            CommandStepMetadata step = (CommandStepMetadata)stepsList.get(i);
            if (!step.getName().equals(stepToFind.getName())) continue;
            index = i;
            break;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getStepIndexFromTask, index = " + index);
        }
        return index;
    }

    protected void addTaskCommandExtensions(List cmdList) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addTaskCommandExtensions");
        }
        if (cmdList != null && !cmdList.isEmpty()) {
            for (int i = 0; i < cmdList.size(); ++i) {
                TaskCommandExtension extTask = (TaskCommandExtension)cmdList.get(i);
                if (!this.validateTaskCommand(extTask)) continue;
                this.cmdNewTaskExtsList.add(extTask);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addTaskCommandExtensions");
        }
    }

    void registerCommandMetadataRemote(List cmdMetadataList) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "registerCommandMetadataRemote", cmdMetadataList);
        }
        Object cmdListArrayList = null;
        if (cmdMetadataList != null && !cmdMetadataList.isEmpty()) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Size of meta list is " + cmdMetadataList.size());
            }
            for (int i = 0; i < cmdMetadataList.size(); ++i) {
                CommandMetadata cmdMetadata = (CommandMetadata)cmdMetadataList.get(i);
                if (!this.validateCmdMetadata(cmdMetadata)) continue;
                String cmdName = cmdMetadata.getName();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Command registering is " + cmdName);
                }
                this.cmdMetadataTable.put(cmdName, cmdMetadata);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "registerCommandMetadataRemote");
        }
    }

    protected void registerCommandMetadata(List cmdMetadataList) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "registerCommandMetadata", cmdMetadataList);
        }
        ArrayList cmdListArrayList = null;
        if (cmdMetadataList != null && !cmdMetadataList.isEmpty()) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Size of meta list is " + cmdMetadataList.size());
            }
            for (int i = 0; i < cmdMetadataList.size(); ++i) {
                CommandMetadata cmdMetadata = (CommandMetadata)cmdMetadataList.get(i);
                if (!this.validateCmdMetadata(cmdMetadata)) continue;
                String cmdName = cmdMetadata.getName();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Command registering is " + cmdName + ", metadata: @" + Integer.toHexString(cmdMetadata.hashCode()));
                }
                if (cmdMetadata.isSupportLocalMode()) {
                    cmdListArrayList = (ArrayList)this.cmdGroupCommandTable.get("LocalModeGroup");
                    if (!cmdListArrayList.contains(cmdName)) {
                        cmdListArrayList.add(cmdName);
                    } else if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Command already exist in Local Mode Group, possibly command name conflict");
                    }
                }
                if (!this.cmdMetadataTable.containsKey(cmdName)) {
                    this.cmdMetadataTable.put(cmdName, cmdMetadata);
                    if (this.cmdCommandProviderTable.containsKey(cmdName)) continue;
                    CommandProviderMetadata cpm = (CommandProviderMetadata)cmdMetadata.eContainer();
                    this.cmdCommandProviderTable.put(cmdName, new ProviderTableEntry(cpm.getImplClass(), cpm.getResourceBundle()));
                    continue;
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Command name conflict, Prioirty will be used");
                }
                String cmdPriority = cmdMetadata.getPriority();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Command priority is " + cmdPriority);
                }
                if (cmdPriority == null || cmdPriority == "") continue;
                CommandMetadata origCmdData = (CommandMetadata)this.cmdMetadataTable.get(cmdName);
                String origCmdPriority = origCmdData.getPriority();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Original command priority is " + origCmdPriority);
                }
                if (origCmdPriority == null || origCmdPriority == "" || Integer.valueOf(cmdPriority) >= Integer.valueOf(origCmdPriority)) continue;
                this.cmdMetadataTable.put(cmdName, cmdMetadata);
                if (this.cmdCommandProviderTable.containsKey(cmdName)) continue;
                CommandProviderMetadata cpm = (CommandProviderMetadata)cmdMetadata.eContainer();
                this.cmdCommandProviderTable.put(cmdName, new ProviderTableEntry(cpm.getImplClass(), cpm.getResourceBundle()));
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "registerCommandMetadata");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EClass getParamDataEClass(String cmdName) throws CommandNotFoundException {
        EClass sClass;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getParamDataEClass, cmdName = " + cmdName);
        }
        EPackage ePackage = cmddataPackage;
        synchronized (ePackage) {
            sClass = (EClass)cmddataPackage.getEClassifier(cmdName);
        }
        if (sClass == null) {
            CommandMetadata cmdMetadata = this.getCommandMetadata(cmdName);
            sClass = this.createParamDataEClass(cmdName, cmdMetadata.getParameters());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getParamDataEClass, cmdName = " + cmdName + ", returned EClass = " + sClass);
        }
        return sClass;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EClass createParamDataEClass(String paramEClassName, List paramMetadataList) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createParamDataEClass, paramEClassName = " + paramEClassName);
        }
        EClass sClass = this.fac.createEClass();
        sClass.setName(paramEClassName);
        if (paramMetadataList != null && !paramMetadataList.isEmpty()) {
            EList paramMetadataAttr = sClass.getEStructuralFeatures();
            for (int i = 0; i < paramMetadataList.size(); ++i) {
                EStructuralFeature efeature;
                String paramType;
                ParameterMetadata paramMetadata = (ParameterMetadata)paramMetadataList.get(i);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Attribute Name " + i + " is " + paramMetadata.getName());
                }
                if ((paramType = paramMetadata.getType()).equals("GenericObject") || paramType.equals("javax.management.ObjectName") || !ParameterTypeTable.isPrimitive(paramType)) {
                    efeature = this.fac.createEReference();
                    efeature.setContainment(true);
                } else {
                    efeature = this.fac.createEAttribute();
                }
                efeature.setName(paramMetadata.getName());
                efeature.setEType(ParameterTypeTable.getParamEClassifierType(paramMetadata.getType()));
                if (paramMetadata.getDefaultValue() != null) {
                    efeature.setDefaultValue(paramMetadata.getDefaultValue());
                }
                paramMetadataAttr.add(efeature);
            }
        }
        EPackage ePackage = cmddataPackage;
        synchronized (ePackage) {
            cmddataPackage.getEClassifiers().add(sClass);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createParamDataEClass, paramEClassName = " + paramEClassName + ", returned EClass = " + sClass);
        }
        return sClass;
    }

    public EObject createParamDataEObject(String cmdName) throws CommandNotFoundException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createParamDataEObject", cmdName);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createParamDataEObject");
        }
        return eFactory.create(this.getParamDataEClass(cmdName));
    }

    public EObject createParamDataEObject(String taskCmdName, String stepName) throws CommandNotFoundException {
        String stepEClassName;
        EClass sClass;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createParamDataEObject", new Object[]{taskCmdName, stepName});
        }
        if ((sClass = (EClass)cmddataPackage.getEClassifier(stepEClassName = this.getStepEClassName(taskCmdName, stepName))) == null) {
            CommandMetadata cmdMetadata = this.getCommandMetadata(taskCmdName);
            CommandMetadata match = null;
            EList steps = ((TaskCommandMetadata)cmdMetadata).getSteps();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Steps are " + steps);
            }
            for (CommandStepMetadata stepMetadata : steps) {
                if (!stepMetadata.getName().equals(stepName)) continue;
                match = stepMetadata;
                break;
            }
            if (match == null) {
                throw new CommandNotFoundException(taskCmdName, stepName);
            }
            sClass = this.createParamDataEClass(this.getStepEClassName(taskCmdName, stepName), match.getParameters());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createParamDataEObject", sClass.getName());
        }
        return eFactory.create(sClass);
    }

    public EObject createParamDataEObject(String taskCmdName, String stepName, CommandMetadata cmdMetadata) throws CommandNotFoundException {
        String stepEClassName;
        EClass sClass;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createParamDataEObject", new Object[]{taskCmdName, stepName, cmdMetadata});
        }
        if ((sClass = (EClass)cmddataPackage.getEClassifier(stepEClassName = this.getStepEClassName(taskCmdName, stepName))) == null) {
            CommandMetadata match = null;
            EList steps = ((TaskCommandMetadata)cmdMetadata).getSteps();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Steps are " + steps);
            }
            for (CommandStepMetadata stepMetadata : steps) {
                if (!stepMetadata.getName().equals(stepName)) continue;
                match = stepMetadata;
                break;
            }
            if (match == null) {
                throw new CommandNotFoundException(taskCmdName, stepName);
            }
            sClass = this.createParamDataEClass(this.getStepEClassName(taskCmdName, stepName), match.getParameters());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createParamDataEObject", sClass.getName());
        }
        return eFactory.create(sClass);
    }

    public Collection listCommandGroups() {
        return Collections.unmodifiableCollection(this.cmdGroupCommandTable.keySet());
    }

    public Collection listCommands(String commandGroup) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "listCommands, commandGroup = " + commandGroup);
        }
        if (this.cmdGroupCommandTable.containsKey(commandGroup)) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "listCommands");
            }
            return Collections.unmodifiableCollection(this.filterCommandsList((Collection)this.cmdGroupCommandTable.get(commandGroup)));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "listCommands");
        }
        return Collections.EMPTY_SET;
    }

    public Collection listCommands() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "listCommands");
        }
        Collection filteredList = this.filterCommandsList(this.cmdMetadataTable.keySet());
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "listCommands");
        }
        return Collections.unmodifiableCollection(filteredList);
    }

    public Collection listAllCommands() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "listAllCommands");
        }
        Set cmdList = this.cmdMetadataTable.keySet();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "listAllCommands");
        }
        return Collections.unmodifiableCollection(cmdList);
    }

    private Collection filterCommandsList(Collection origCmdList) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "filterCommandsList", origCmdList);
        }
        ArrayList<String> filterCmdList = new ArrayList<String>();
        Iterator cmdIter = origCmdList.iterator();
        while (cmdIter.hasNext()) {
            try {
                CommandMetadata cmd = this.getCommandMetadata((String)cmdIter.next());
                if (cmd.isPrivate()) continue;
                filterCmdList.add(cmd.getName());
            }
            catch (Throwable t) {
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "Exception caught while filtering commands", t);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "filterCommandsList", filterCmdList);
        }
        return filterCmdList;
    }

    public CommandProvider getCommandProvider(String commandName) throws CommandNotFoundException {
        ProviderTableEntry pte;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getCommandProvider, commandName = " + commandName);
        }
        if ((pte = (ProviderTableEntry)this.cmdCommandProviderTable.get(commandName)) != null) {
            String implClass = pte.getImplClass();
            CommandProvider result = (CommandProvider)this.cmdProviderInstanceTable.get(implClass);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getCommandProvider", result);
            }
            return result;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getCommandProvider");
        }
        throw new CommandNotFoundException(commandName);
    }

    public CommandProvider getCommandProvider(String taskCommandName, String stepName) throws CommandNotFoundException {
        String key;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getCommandProvider", new Object[]{taskCommandName, stepName});
        }
        if (!this.cmdCommandProviderTable.containsKey(key = this.getStepEClassName(taskCommandName, stepName))) {
            key = taskCommandName;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getCommandProvider", key);
        }
        return this.getCommandProvider(key);
    }

    public CommandMetadata getCommandMetadata(String commandName) throws CommandNotFoundException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getCommandMetadata( " + commandName + " )");
        }
        if (!this.cmdMetadataTable.containsKey(commandName)) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "CommandName " + commandName + " does not exist");
            }
            throw new CommandNotFoundException(commandName);
        }
        CommandMetadata cmdMetadata = (CommandMetadata)this.cmdMetadataTable.get(commandName);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Command Provider is " + (CommandProviderMetadata)cmdMetadata.eContainer());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getCommandMetadata( " + commandName + " ) return cmd metadata: @" + Integer.toHexString(cmdMetadata.hashCode()), cmdMetadata);
        }
        return cmdMetadata;
    }

    public CommandGroupMetadata getCommandGroupMetadata(String commandGrp) throws CommandNotFoundException {
        if (tc.isDebugEnabled()) {
            Tr.entry(tc, "getCommandGroupMetadata", commandGrp);
        }
        if (!this.cmdGroupMetadataTable.containsKey(commandGrp)) {
            throw new CommandNotFoundException(commandGrp);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getCommandGroupMetadata");
        }
        return (CommandGroupMetadata)this.cmdGroupMetadataTable.get(commandGrp);
    }

    private boolean validateCmdMetadata(CommandMetadata cmdMetadata) {
        if (tc.isDebugEnabled()) {
            Tr.entry(tc, "validateCmdMetadata", cmdMetadata);
        }
        boolean result = true;
        if (cmdMetadata.isTargetObjectAllowed() && (cmdMetadata.getTargetObjectType() == null || cmdMetadata.getTargetObjectType().equals(""))) {
            Tr.warning(tc, "ADMF0001W", new Object[]{cmdMetadata.getName()});
            result = false;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validateCmdMetadata, result = " + result);
        }
        return result;
    }

    private boolean validateTaskCommand(EObject task) {
        if (tc.isDebugEnabled()) {
            Tr.entry(tc, "validateTaskCommand", task);
        }
        EList stepList = null;
        String taskCommandName = "";
        boolean isValidTaskCmd = true;
        if (task instanceof TaskCommandMetadata) {
            stepList = ((TaskCommandMetadata)task).getSteps();
            taskCommandName = ((TaskCommandMetadata)task).getName();
        } else if (task instanceof TaskCommandExtension) {
            stepList = ((TaskCommandExtension)task).getSteps();
            taskCommandName = ((TaskCommandExtension)task).getName();
        }
        for (int j = 0; j < stepList.size(); ++j) {
            CommandStepMetadata stepCommand = (CommandStepMetadata)stepList.get(j);
            if (!stepCommand.isTable()) continue;
            EList paramList = stepCommand.getParameters();
            boolean keyFieldFound = false;
            for (int k = 0; k < paramList.size(); ++k) {
                ParameterMetadata param = (ParameterMetadata)paramList.get(k);
                if (!param.isKeyField()) continue;
                keyFieldFound = true;
                break;
            }
            if (keyFieldFound) continue;
            if (tc.isDebugEnabled()) {
                Tr.warning(tc, "ADMF0002W", new Object[]{taskCommandName});
            }
            isValidTaskCmd = false;
            break;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validateTaskCommand, isValidTaskCmd = " + isValidTaskCmd);
        }
        return isValidTaskCmd;
    }

    private void initialize() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "initialize");
        }
        CommandMetadataPackage metadataPackage = CommandMetadataPackage.eINSTANCE;
        cmddataPackage = CommandDataPackage.eINSTANCE;
        cmdMetadataFactory = CommandMetadataFactory.eINSTANCE;
        eFactory = CommandDataFactory.eINSTANCE;
        XMLMapImpl xmlMap = new XMLMapImpl();
        this.loadOptions.put("XML_MAP", xmlMap);
        this.cmdGroupCommandTable.put("LocalModeGroup", new ArrayList());
        this.cmdGroupMetadataTable.put("LocalModeGroup", cmdMetadataFactory.createCommandGroupMetadata());
        initialized = true;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "initialize");
        }
    }

    public String getStepEClassName(String taskCmdName, String stepName) {
        return taskCmdName + '+' + stepName;
    }

    public String[] getTaskStepName(String stepEClassName) {
        String[] tokens = new String[2];
        StringTokenizer StepEClassToken = new StringTokenizer(stepEClassName, "+");
        tokens[0] = StepEClassToken.nextToken();
        tokens[1] = StepEClassToken.nextToken();
        return tokens;
    }

    private String[] resolveStep(String stepEClassName) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "resolveStep, stepEClassName = " + stepEClassName);
        }
        String[] result = new String[2];
        int index = stepEClassName.indexOf(43);
        if (index == -1) {
            result[0] = stepEClassName;
            result[1] = null;
        } else {
            result[0] = stepEClassName.substring(0, index);
            result[1] = stepEClassName.substring(index + 1);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "resolveStep, results = " + result[0] + ", " + result[1]);
        }
        return result;
    }

    private String getShortTypeName(String fullyQualifiedTypeName) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getShortTypeName, fullyQualifiedTypeName = " + fullyQualifiedTypeName);
        }
        String shortTypeName = "";
        int index = fullyQualifiedTypeName.lastIndexOf(46);
        shortTypeName = index != -1 ? fullyQualifiedTypeName.substring(index + 1) : fullyQualifiedTypeName;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getShortTypeName, shortTypeName = " + shortTypeName);
        }
        return shortTypeName;
    }

    private void cleanup() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "cleanup");
        }
        this.cmdTaskExtsList.clear();
        this.cmdNewTaskExtsList.clear();
        this.cmdGrpExtList.clear();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "cleanup");
        }
    }

    private static boolean isComposite(EStructuralFeature feature) {
        boolean result = true;
        if (feature instanceof EReference) {
            result = ((EReference)feature).isContainment();
        }
        return result;
    }

    public static CommandMetadataMgr getInstance() {
        return CommandMetadataMgr.getInstance(false);
    }

    protected static CommandMetadataMgr getInstance(boolean isClientMode) {
        CommandMetadataMgr cmdMetadataMgr;
        boolean needTrace;
        boolean bl = needTrace = isClientMode && commandMetadataMgr4C == null || !isClientMode && commandMetadataMgr == null;
        if (tc.isEntryEnabled() && needTrace) {
            Tr.entry(tc, "getInstance, isClientMode: " + new Boolean(isClientMode) + ", initialized: " + new Boolean(initialized));
        }
        if (isClientMode) {
            if (commandMetadataMgr4C == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "getInstance, commandMetadataMgr4C: " + commandMetadataMgr4C);
                }
                commandMetadataMgr4C = new CommandMetadataMgr(isClientMode);
            }
            cmdMetadataMgr = commandMetadataMgr4C;
        } else {
            if (commandMetadataMgr == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "getInstance, commandMetadataMgr: " + commandMetadataMgr);
                }
                commandMetadataMgr = new CommandMetadataMgr(isClientMode);
            }
            cmdMetadataMgr = commandMetadataMgr;
        }
        if (tc.isEntryEnabled() && needTrace) {
            Tr.exit(tc, "getInstance, cmdMetadataMgr: " + cmdMetadataMgr);
        }
        return cmdMetadataMgr;
    }

    private class ProviderTableEntry {
        private String implClass;
        private String resouceBundle;

        public ProviderTableEntry(String inImplClass, String inResouceBundle) {
            this.implClass = inImplClass;
            this.resouceBundle = inResouceBundle;
        }

        public String getImplClass() {
            return this.implClass;
        }

        public String getResouceBundle() {
            return this.resouceBundle;
        }

        public void setImplClass(String inImplClass) {
            this.implClass = inImplClass;
        }

        public void setResouceBundle(String inResouceBundle) {
            this.resouceBundle = inResouceBundle;
        }
    }

    private class ClassLoaderClassLocator
    implements ClassLocator {
        private ClassLoader _loader;

        public ClassLoaderClassLocator(ClassLoader loader) {
            this._loader = loader;
        }

        public Class locateClass(final String className) throws ClassNotFoundException {
            Class clazz = null;
            try {
                clazz = (Class)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws ClassNotFoundException {
                        return ClassLoaderClassLocator.this._loader.loadClass(className);
                    }
                });
            }
            catch (PrivilegedActionException e) {
                throw (ClassNotFoundException)e.getCause();
            }
            return clazz;
        }

        public Enumeration locateResources(final String resourceName) throws IOException {
            Enumeration vEnum;
            try {
                vEnum = (Enumeration)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws IOException {
                        return ClassLoaderClassLocator.this._loader.getResources(resourceName);
                    }
                });
            }
            catch (PrivilegedActionException e) {
                throw (IOException)e.getCause();
            }
            return vEnum;
        }
    }

    private class BundleClassLocator
    implements ClassLocator {
        private Bundle _bundle;

        public BundleClassLocator(Bundle bundle) {
            this._bundle = bundle;
        }

        public Class locateClass(final String className) throws ClassNotFoundException {
            Class clazz = null;
            try {
                clazz = (Class)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws ClassNotFoundException {
                        return BundleClassLocator.this._bundle.loadClass(className);
                    }
                });
            }
            catch (PrivilegedActionException e) {
                throw (ClassNotFoundException)e.getCause();
            }
            return clazz;
        }

        public Enumeration locateResources(final String resourceName) throws IOException {
            Enumeration vEnum;
            try {
                vEnum = (Enumeration)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws IOException {
                        return BundleClassLocator.this._bundle.getResources(resourceName);
                    }
                });
            }
            catch (PrivilegedActionException e) {
                throw (IOException)e.getCause();
            }
            return vEnum;
        }
    }

    private static interface ClassLocator {
        public Class locateClass(String var1) throws ClassNotFoundException;

        public Enumeration locateResources(String var1) throws IOException;
    }
}

