/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.cmdframework.impl;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ffdc.Manager;
import com.ibm.websphere.management.AdminClient;
import com.ibm.websphere.management.cmdframework.CommandException;
import com.ibm.websphere.management.cmdframework.CommandHistory;
import com.ibm.websphere.management.cmdframework.CommandMgr;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.CommandResult;
import com.ibm.websphere.management.cmdframework.CommandStep;
import com.ibm.websphere.management.cmdframework.commanddata.CommandStepData;
import com.ibm.websphere.management.cmdframework.commanddata.TaskCommandData;
import com.ibm.websphere.management.cmdframework.commandmetadata.CustomProperties;
import com.ibm.websphere.management.cmdframework.commandmetadata.TaskCommandMetadata;
import com.ibm.websphere.management.cmdframework.provider.AbstractAdminCommand;
import com.ibm.websphere.management.cmdframework.provider.AbstractCommandStep;
import com.ibm.websphere.management.cmdframework.provider.AbstractTaskCommand;
import com.ibm.websphere.management.cmdframework.provider.CommandNotification;
import com.ibm.websphere.management.cmdframework.provider.CommandResultImpl;
import com.ibm.websphere.management.exception.ConnectorException;
import com.ibm.ws.management.cmdframework.impl.CommandMetadataMgr;
import com.ibm.ws.management.cmdframework.impl.CommandUtility;
import com.ibm.ws.management.cmdframework.impl.EObjectSerializer;
import com.ibm.ws.management.cmdframework.impl.TaskCommandSession;
import java.security.PrivilegedActionException;
import java.util.ArrayList;
import java.util.HashMap;
import javax.management.Notification;
import javax.management.NotificationFilter;
import javax.management.NotificationFilterSupport;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;

public class ClientTaskCommand
extends AbstractTaskCommand {
    private static TraceComponent tc = Tr.register(ClientTaskCommand.class, "ClientTaskCommand", "com.ibm.ws.management.cmdframework.impl");
    private AdminClient adminClient;
    private EObjectSerializer eObjCmdData;
    private HashMap downloadFiles = null;

    public ClientTaskCommand(TaskCommandMetadata metadata) throws CommandNotFoundException, CommandException, ConnectorException {
        super(metadata);
    }

    protected void contructSteps() throws CommandNotFoundException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "contructSteps", this.getName());
        }
        this.adminClient = CommandMgr.getAdminClient();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "\nadminclient is " + this.adminClient + "\n");
        }
        try {
            String taskCmdName = this.getName();
            ArrayList returnedTaskCmdInfo = (ArrayList)this.adminClient.invoke(CommandUtility.getRemoteCmdMgrMbean(this.adminClient), "contructSteps", new Object[]{taskCmdName}, new String[]{"java.lang.String"});
            if (returnedTaskCmdInfo == null) {
                throw new CommandNotFoundException(taskCmdName);
            }
            this.asyncCmdSession = (TaskCommandSession)returnedTaskCmdInfo.get(0);
            EObjectSerializer returnedEOject = (EObjectSerializer)returnedTaskCmdInfo.get(1);
            TaskCommandData returnedTaskCmdData = (TaskCommandData)returnedEOject.getEObjectValue();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Command Session received is  " + this.asyncCmdSession.getSessionId());
            }
            this.resetCommandData(returnedTaskCmdData);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "contructSteps");
            }
        }
        catch (Exception infe) {
            CommandResultImpl commandResult = new CommandResultImpl();
            commandResult.setException(infe);
            this.setCommandResult(commandResult);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Got unexpected exception when contructSteps, root casue is " + infe, infe);
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "contructSteps");
            }
            CommandNotFoundException cnfe = new CommandNotFoundException(this.getName());
            cnfe.initCause(infe);
            throw cnfe;
        }
    }

    public CommandStep getCommandStep(String stepName) throws CommandNotFoundException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getCommandStep, cmd: " + this.getName() + ", stepName: " + stepName, new Object[]{this});
        }
        try {
            Integer operationType = new Integer(3);
            EObjectSerializer currentTaskEObj = new EObjectSerializer();
            currentTaskEObj.setEObjectValue(this.getTaskCommandData());
            ArrayList list = (ArrayList)this.adminClient.invoke(CommandUtility.getRemoteCmdMgrMbean(this.adminClient), "getCurrentStepInList", new Object[]{this.asyncCmdSession, currentTaskEObj, operationType, stepName}, new String[]{"com.ibm.ws.management.cmdframework.impl.TaskCommandSession", "com.ibm.ws.management.cmdframework.impl.EObjectSerializer", "java.lang.Integer", "java.lang.String"});
            EObjectSerializer returnedEOject = (EObjectSerializer)list.get(1);
            if (returnedEOject.getEObjectValue() == null) {
                throw new CommandNotFoundException(this.getName(), stepName + ", eObjectValue = null");
            }
            CommandStepData returnedStepData = (CommandStepData)returnedEOject.getEObjectValue();
            AbstractCommandStep clientStep = (AbstractCommandStep)super.getCommandStep(stepName);
            clientStep.resetCommandData(returnedStepData);
            if (list.size() >= 4 && (returnedEOject = (EObjectSerializer)list.get(3)) != null) {
                TaskCommandData returnedTaskCmdData = (TaskCommandData)returnedEOject.getEObjectValue();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "getCommandStep, returnedTaskCmdData: " + returnedTaskCmdData);
                }
                if (returnedTaskCmdData != null) {
                    this.resetCommandData(returnedTaskCmdData);
                }
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getCommandStep, cmd: " + this.getName() + ", clientStep: " + clientStep.getName(), clientStep);
            }
            return clientStep;
        }
        catch (Exception e) {
            Manager.Ffdc.log(e, this, "com.ibm.ws.management.cmdframework.impl.ClientTaskCommand", "96", this);
            if (tc.isDebugEnabled()) {
                Tr.error(tc, "getCommandStep, Exception caught " + e);
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getCommandStep");
            }
            CommandNotFoundException cnfe = new CommandNotFoundException(this.getName(), stepName);
            cnfe.initCause(e);
            throw cnfe;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void processTaskParameters() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "processTaskParameters", this.getName());
        }
        try {
            try {
                if (this.eObjCmdData == null) {
                    this.eObjCmdData = new EObjectSerializer();
                }
                if (this.isAsyncCommand()) {
                    CommandUtility.handleUploadFileParamsBeforeExecute(this, this.adminClient);
                    this.downloadFiles = CommandUtility.handleDownloadFileParamsBeforeExecute(this, this.adminClient);
                    this.eObjCmdData.setEObjectValue(this.getTaskCommandData());
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "CommandData sending is " + this.getCommandData() + " session id is asyncCmdSession.getSessionId()");
                }
                this.eObjCmdData.setEObjectValue(this.getTaskCommandData());
                ArrayList returnedEOjectList = (ArrayList)this.adminClient.invoke(CommandUtility.getRemoteCmdMgrMbean(this.adminClient), "processTaskParameters", new Object[]{this.asyncCmdSession, this.eObjCmdData}, new String[]{"com.ibm.ws.management.cmdframework.impl.TaskCommandSession", "com.ibm.ws.management.cmdframework.impl.EObjectSerializer"});
                EObjectSerializer returnedTaskMetaDataEOS = (EObjectSerializer)returnedEOjectList.get(0);
                EObjectSerializer eObjectSerializer = (EObjectSerializer)returnedEOjectList.get(1);
                TaskCommandMetadata returnedTaskMetaData = (TaskCommandMetadata)returnedTaskMetaDataEOS.getEObjectValue();
                TaskCommandData returnedTaskCmdData = (TaskCommandData)eObjectSerializer.getEObjectValue();
                ArrayList<TaskCommandMetadata> cmdMetadataList = new ArrayList<TaskCommandMetadata>(0);
                cmdMetadataList.add(returnedTaskMetaData);
                CommandMetadataMgr.getInstance().registerCommandMetadataRemote(cmdMetadataList);
                this.resetCommandMetadata(returnedTaskMetaData);
                this.resetCommandData(returnedTaskCmdData);
            }
            catch (Exception infe) {
                void var3_10;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "processTaskParameters - Got unexpected exception: ", infe);
                }
                Object var3_6 = null;
                for (Throwable t = infe.getCause(); t != null; t = t.getCause()) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "zzz processTaskParameters - Unexpected exception cause by: " + t.getMessage());
                    }
                    if (t instanceof PrivilegedActionException) {
                        SecurityException securityException = new SecurityException(t.getMessage());
                        break;
                    }
                    if (!(t instanceof RuntimeException)) continue;
                    RuntimeException runtimeException = (RuntimeException)t;
                }
                if (var3_10 != null) {
                    throw var3_10;
                }
                CommandResultImpl commandResult = new CommandResultImpl();
                commandResult.setException(infe);
                this.setCommandResult(commandResult);
                infe.printStackTrace();
                Object var8_16 = null;
                if (!tc.isEntryEnabled()) return;
                Tr.exit(tc, "processTaskParameters");
                return;
            }
            Object var8_15 = null;
            if (!tc.isEntryEnabled()) return;
        }
        catch (Throwable throwable) {
            Object var8_17 = null;
            if (!tc.isEntryEnabled()) throw throwable;
            Tr.exit(tc, "processTaskParameters");
            throw throwable;
        }
        Tr.exit(tc, "processTaskParameters");
    }

    public String[] listCommandSteps() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "listCommandSteps, cmd: " + this.getName() + ", session: " + this.asyncCmdSession);
        }
        String[] result = new String[]{};
        if (!this.isDynamicStepCommand()) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "listCommandSteps, current command is not a dynamic step command. Get listCommandSteps result from super.");
            }
            result = super.listCommandSteps();
        } else {
            try {
                EObjectSerializer cmdDataEObj = new EObjectSerializer();
                cmdDataEObj.setEObjectValue(this.getTaskCommandData());
                ArrayList returnedList = (ArrayList)this.adminClient.invoke(CommandUtility.getRemoteCmdMgrMbean(this.adminClient), "listCommandStepsWithData", new Object[]{this.asyncCmdSession, cmdDataEObj}, new String[]{"com.ibm.ws.management.cmdframework.impl.TaskCommandSession", "com.ibm.ws.management.cmdframework.impl.EObjectSerializer"});
                EObjectSerializer returnedEOject = (EObjectSerializer)returnedList.get(0);
                if (returnedEOject.getEObjectValue() == null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "listCommandSteps, server return no TaskCommandData object in listCommandStepsWithData().");
                    }
                    throw new CommandNotFoundException(this.getName(), "No TaskCommandData object. Check server side log for details.");
                }
                TaskCommandData returnedTaskCmdData = (TaskCommandData)returnedEOject.getEObjectValue();
                if (returnedTaskCmdData != null) {
                    EList cmdStepDataList = returnedTaskCmdData.getSteps();
                    result = new String[cmdStepDataList.size()];
                    for (int i = 0; i < cmdStepDataList.size(); ++i) {
                        result[i] = ((CommandStepData)cmdStepDataList.get(i)).getName();
                    }
                    this.resetCommandData(returnedTaskCmdData);
                }
                if ((returnedEOject = (EObjectSerializer)returnedList.get(1)).getEObjectValue() == null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "listCommandSteps, server return no TaskCommandMetadata object in listCommandStepsWithData().");
                    }
                    throw new CommandNotFoundException(this.getName(), "No TaskCommandMetadata object. Check server side log for details.");
                }
                TaskCommandMetadata returnedTaskCmdMetadata = (TaskCommandMetadata)returnedEOject.getEObjectValue();
                if (returnedTaskCmdMetadata != null) {
                    this.resetCommandMetadata(returnedTaskCmdMetadata);
                }
            }
            catch (Exception infe) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Got unexpected exception, " + infe + ", root cause: " + infe.getCause());
                }
                Manager.Ffdc.log(infe, this, "com.ibm.ws.management.cmdframework.impl.ClientTaskCommand", "200");
            }
        }
        if (tc.isEntryEnabled()) {
            String steps = "[";
            for (int i = 0; i < result.length; ++i) {
                if (!steps.equals("[")) {
                    steps = steps + ", ";
                }
                steps = steps + result[i];
            }
            steps = steps + "]";
            Tr.exit(tc, "listCommandSteps, cmd: " + this.getName() + ", result: " + steps);
        }
        return result;
    }

    public void execute() {
        block16: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "execute", this.getName());
            }
            try {
                CommandResult retCmdResult;
                if (this.eObjCmdData == null) {
                    this.eObjCmdData = new EObjectSerializer();
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "CommandData sending is " + this.getCommandData());
                }
                if (!this.isAsyncCommand()) {
                    CommandUtility.handleUploadFileParamsBeforeExecute(this, this.adminClient);
                    this.downloadFiles = CommandUtility.handleDownloadFileParamsBeforeExecute(this, this.adminClient);
                    this.eObjCmdData.setEObjectValue(this.getTaskCommandData());
                }
                if ((retCmdResult = (CommandResult)this.adminClient.invoke(CommandUtility.getRemoteCmdMgrMbean(this.adminClient), "execute", new Object[]{this.asyncCmdSession, this.eObjCmdData}, new String[]{"com.ibm.ws.management.cmdframework.impl.TaskCommandSession", "com.ibm.ws.management.cmdframework.impl.EObjectSerializer"})).isSuccessful() && !this.isAsyncCommand()) {
                    CommandUtility.downloadFiles(this.adminClient, this.downloadFiles);
                } else if (!retCmdResult.isSuccessful() && !this.isAsyncCommand()) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Command was not successful and is not an async command");
                    }
                    EList customPropertiesList = this.getCommandMetadata().getCustom();
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Custom Properties for unsuccessful non-async command " + customPropertiesList);
                    }
                    if (customPropertiesList != null && !customPropertiesList.isEmpty()) {
                        for (CustomProperties currentProperty : customPropertiesList) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "current Custom Property " + currentProperty);
                            }
                            if (!currentProperty.getKey().equals("ForceDownloadFile")) continue;
                            EList customValueList = currentProperty.getValue();
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "current Custom Property Value " + customValueList);
                            }
                            if (customValueList == null || !customValueList.contains("true")) continue;
                            CommandUtility.downloadFiles(this.adminClient, this.downloadFiles);
                        }
                    }
                }
                this.setCommandResult(retCmdResult);
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "execute");
                }
            }
            catch (Exception infe) {
                CommandResultImpl commandResult = new CommandResultImpl();
                commandResult.setException(infe);
                this.setCommandResult(commandResult);
                infe.printStackTrace();
                if (!tc.isEntryEnabled()) break block16;
                Tr.exit(tc, "execute");
            }
        }
    }

    public CommandStep getCurrentStep(int operation, String stepName) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getCurrentStep, cmd: " + this.getName() + ", operation: " + operation + ", stepName: " + stepName);
        }
        AbstractCommandStep curStep = (AbstractCommandStep)super.getCurrentStep(operation, stepName);
        try {
            AbstractCommandStep clientStep;
            TaskCommandData returnedTaskCmdData;
            EObjectSerializer returnedCommandDataEOS;
            Integer operationType = new Integer(operation);
            EObjectSerializer currentStepEObj = new EObjectSerializer();
            if (curStep != null) {
                EObject curStepClone = CommandUtility.clone(curStep.getCommandStepData());
                currentStepEObj.setEObjectValue(curStepClone);
            } else {
                currentStepEObj.setEObjectValue(this.getTaskCommandData());
            }
            ArrayList returnedEOjectList = (ArrayList)this.adminClient.invoke(CommandUtility.getRemoteCmdMgrMbean(this.adminClient), "getCurrentStepInList", new Object[]{this.asyncCmdSession, currentStepEObj, operationType, stepName}, new String[]{"com.ibm.ws.management.cmdframework.impl.TaskCommandSession", "com.ibm.ws.management.cmdframework.impl.EObjectSerializer", "java.lang.Integer", "java.lang.String"});
            EObjectSerializer returnedTaskMetaDataEOS = (EObjectSerializer)returnedEOjectList.get(0);
            EObjectSerializer returnedStepDataEOS = (EObjectSerializer)returnedEOjectList.get(1);
            int returnedStepIndex = (Integer)returnedEOjectList.get(2);
            TaskCommandMetadata returnedTaskMetaData = (TaskCommandMetadata)returnedTaskMetaDataEOS.getEObjectValue();
            ArrayList<TaskCommandMetadata> cmdMetadataList = new ArrayList<TaskCommandMetadata>(0);
            cmdMetadataList.add(returnedTaskMetaData);
            CommandMetadataMgr.getInstance().registerCommandMetadataRemote(cmdMetadataList);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "getCurrentStep, server cmdMetadata steps: " + this.showListContents(returnedTaskMetaData.getSteps()));
                Tr.debug(tc, "getCurrentStep, client cmdMetadata steps: " + this.showListContents(this.getTaskCommandMetadata().getSteps()) + ", before reset.");
            }
            this.resetCommandMetadata(returnedTaskMetaData);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "getCurrentStep, client cmdMetadata steps: " + this.showListContents(this.getTaskCommandMetadata().getSteps()) + ", after reset.");
            }
            if (returnedEOjectList.size() >= 4 && (returnedCommandDataEOS = (EObjectSerializer)returnedEOjectList.get(3)) != null && (returnedTaskCmdData = (TaskCommandData)returnedCommandDataEOS.getEObjectValue()) != null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "getCurrentStep, server cmdData steps: " + this.showListContents(returnedTaskCmdData.getSteps()) + ", returnedTaskCmdData: " + returnedTaskCmdData);
                }
                this.resetCommandData(returnedTaskCmdData);
            }
            if (returnedStepDataEOS.getEObjectValue() == null) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "getCurrentStep", null);
                }
                return null;
            }
            CommandStepData returnedStepData = (CommandStepData)returnedStepDataEOS.getEObjectValue();
            if (tc.isEntryEnabled()) {
                Tr.debug(tc, "Returned TaskMeta Data is " + returnedTaskMetaData);
            }
            if (tc.isEntryEnabled()) {
                Tr.debug(tc, "Returned Step Data " + returnedStepData);
            }
            if (tc.isEntryEnabled()) {
                Tr.debug(tc, "Returned Step index " + returnedStepIndex);
            }
            try {
                clientStep = (AbstractCommandStep)super.getCommandStep(returnedStepData.getName());
                boolean stepEnabled = clientStep.getCommandStepData().isEnabled();
                clientStep.resetCommandData(returnedStepData);
                if (!stepEnabled) {
                    clientStep.getCommandStepData().setEnabled(false);
                }
            }
            catch (CommandNotFoundException cne) {
                if (tc.isEntryEnabled()) {
                    Tr.debug(tc, "Add new step not exist in the previous task before.");
                }
                cmdMetadataList = new ArrayList(0);
                cmdMetadataList.add(returnedTaskMetaData);
                CommandMetadataMgr.getInstance().registerCommandMetadataRemote(cmdMetadataList);
                this.resetCommandMetadata(returnedTaskMetaData);
                this.addNewStep(returnedTaskMetaData, returnedStepData, returnedStepIndex);
                clientStep = (AbstractCommandStep)this.getCommandStep(returnedStepData.getName());
            }
            switch (operation) {
                case 0: {
                    this.setCurrentStepIndex(returnedStepIndex);
                    break;
                }
                case 1: {
                    this.setCurrentStepIndex(returnedStepIndex + 2);
                    break;
                }
            }
            if (tc.isEntryEnabled()) {
                Tr.debug(tc, "getCurrentStepIndex is " + this.getCurrentStepIndex());
            }
            if (this.getCurrentStepIndex() == 0) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "getCurrentStep", null);
                }
                return null;
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getCurrentStep, cmd: " + this.getName() + ", clientStep: " + clientStep.getName(), clientStep);
            }
            return clientStep;
        }
        catch (Exception infe) {
            if (tc.isEntryEnabled()) {
                Tr.debug(tc, "getCurrentStep, got unexpected exception: " + infe + ", root cause: " + infe.getCause());
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getCurrentStep", curStep);
            }
            throw new RuntimeException(infe);
        }
    }

    public void execute(CommandHistory cmdHistory) {
        cmdHistory.add(this.getCommandData());
        this.execute();
    }

    public TaskCommandSession getCommandSession() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getCommandSession");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getCommandSession", this.asyncCmdSession);
        }
        return this.asyncCmdSession;
    }

    protected void setupListener(Object obj) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setupListener", obj);
        }
        try {
            ClientTaskCmdNotificationListener ccnl = new ClientTaskCmdNotificationListener(this.getCommandSession().getSessionId());
            NotificationFilterSupport filter = new NotificationFilterSupport();
            filter.enableType("CmdNotification");
            this.adminClient.addNotificationListener(CommandUtility.getRemoteCmdMgrMbean(this.adminClient), ccnl, (NotificationFilter)filter, obj);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setupListener");
        }
    }

    public class ClientTaskCmdNotificationListener
    extends AbstractAdminCommand.CmdNotificationListener {
        public ClientTaskCmdNotificationListener(long cmdSession) {
            super(ClientTaskCommand.this);
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "ClientCmdNotificationListener");
            }
            this.session = cmdSession;
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "ClientCmdNotificationListener");
            }
        }

        public void removeListener() throws Exception {
            ClientTaskCommand.this.adminClient.removeNotificationListener(CommandUtility.getRemoteCmdMgrMbean(ClientTaskCommand.this.adminClient), this);
        }

        public void handleNotification(Notification notf, Object handback) {
            Object ud;
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "handleNotification", new Object[]{notf, handback});
            }
            if ((ud = notf.getUserData()) instanceof CommandNotification) {
                CommandNotification cn = (CommandNotification)ud;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Command name is " + cn.getCmdName() + ", Command status is " + cn.getCmdStatus() + ", Command message is " + cn.getMessage() + ", session id is " + cn.getSessionID());
                }
                if (cn.getSessionID() == ClientTaskCommand.this.asyncCmdSession.getSessionId()) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Command status is " + cn.getCmdStatus());
                    }
                    if (cn.getCmdStatus().equals("Completed")) {
                        block17: {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Command completed.  Result is " + cn.getResult().getResult());
                            }
                            this.complete = true;
                            if (cn.getResult().isSuccessful()) {
                                try {
                                    CommandUtility.downloadFiles(ClientTaskCommand.this.adminClient, ClientTaskCommand.this.downloadFiles);
                                }
                                catch (Exception ex) {
                                    if (!(cn.getResult() instanceof CommandResultImpl)) break block17;
                                    ((CommandResultImpl)cn.getResult()).setException(ex);
                                }
                            }
                        }
                        ClientTaskCommand.this.setCommandResult(cn.getResult());
                        try {
                            this.removeListener();
                        }
                        catch (Exception ex) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "unexpected exception", ex);
                            }
                            Manager.Ffdc.log(ex, this, "com.ibm.websphere.management.cmdframework.CmdNotificationListener", "134");
                        }
                    }
                    ClientTaskCommand.this.cnh.handleCmdNotification(cn);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Command notified");
                    }
                }
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, "received irrelevant event", ud);
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "handleNotification");
            }
        }
    }
}

