/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.authorizer;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.AdminContext;
import com.ibm.websphere.management.AdminService;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.websphere.management.authorizer.AdminAuthorizer;
import com.ibm.websphere.management.authorizer.AdminAuthorizerFactory;
import com.ibm.ws.management.authorizer.AdminAuthorizerProxy;
import com.ibm.wsspi.management.agent.AdminSubsystemServiceRegistry;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class AdminAuthorizerFactoryHelper {
    private static final TraceComponent tc = Tr.register(AdminAuthorizerFactoryHelper.class, null, null);
    private static AdminAuthorizer authorizer = null;
    private static AdminAuthorizerProxy authorizerProxy = new AdminAuthorizerProxy();

    public static void create() throws Exception {
        try {
            Class<?> c = Class.forName("com.ibm.ws.management.authorizer.AdminAuthorizerImpl");
            Method m = c.getMethod("getInstance", null);
            AdminAuthorizer instance = (AdminAuthorizer)m.invoke(null, null);
            if (AdminContext.peek() == null) {
                authorizer = instance;
            } else {
                AdminSubsystemServiceRegistry.addService((String)AdminAuthorizerFactory.class.getName(), (Object)AdminSubsystemServiceRegistry.getService((String)AdminAuthorizer.class.getName()));
            }
        }
        catch (ClassNotFoundException cnf) {
            throw cnf;
        }
        catch (NoSuchMethodException nsm) {
            throw nsm;
        }
        catch (IllegalAccessException iae) {
            throw iae;
        }
        catch (InvocationTargetException ite) {
            throw ite;
        }
    }

    public static AdminAuthorizer getAdminAuthorizer() {
        AdminService adminService = AdminServiceFactory.getAdminService();
        if (adminService != null && "AdminAgent".equals(adminService.getProcessType())) {
            String uuid;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "getAdminAuthorizer(): in admin agent");
            }
            if ((uuid = AdminContext.peek()) == null) {
                if (authorizer == null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "getAdminAuthorizer(): AdminContext==null, and authorizer == null");
                    }
                    return null;
                }
            } else if (AdminSubsystemServiceRegistry.getService((String)AdminAuthorizerFactory.class.getName()) == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "getAdminAuthorizer(): AdminContext==" + uuid + ", and authorizer == null");
                }
                return null;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "getAdminAuthorizer(): AdminContext==" + uuid + ", and authorizer == authorizerProxy");
            }
            return authorizerProxy;
        }
        Tr.debug(tc, "getAdminAuthorizer(): returning regular authorizer");
        return authorizer;
    }

    static AdminAuthorizer getAdminAuthorizerInternal() {
        if (AdminContext.peek() == null) {
            return authorizer;
        }
        return (AdminAuthorizer)AdminSubsystemServiceRegistry.getService((String)AdminAuthorizerFactory.class.getName());
    }
}

