/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.application;

import com.ibm.ejs.models.base.resources.J2EEResourceProperty;
import com.ibm.ejs.models.base.resources.ResourcesFactory;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.ffdc.Manager;
import com.ibm.websphere.management.AdminService;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.application.AppManagement;
import com.ibm.websphere.management.application.AppManagementProxy;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceFactory;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.websphere.management.configservice.ConfigServiceProxy;
import com.ibm.websphere.management.exception.AdminException;
import com.ibm.websphere.management.exception.ConfigServiceException;
import com.ibm.websphere.management.exception.ConnectorException;
import com.ibm.websphere.management.repository.ConfigRepository;
import com.ibm.websphere.management.repository.ConfigRepositoryFactory;
import com.ibm.websphere.management.repository.DocumentDigest;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import javax.management.AttributeList;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;

public class J2CAppUtils {
    private static TraceComponent tc = Tr.register(J2CAppUtils.class, null, "com.ibm.ws.management.resources.AppDeploymentMessages");
    private static final Class thisClass = J2CAppUtils.class;
    private static final String MESSAGE_BUNDLE = "com.ibm.ws.management.resources.adminservice";
    private static TraceNLS nls = TraceNLS.getTraceNLS("com.ibm.ws.management.resources.adminservice");
    private static HashMap pType = null;

    public static List getAppRefs(String objectID) throws AdminException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getAppRefs( " + objectID + ")");
        }
        Session session = new Session();
        ConfigService configService = ConfigServiceFactory.getConfigService();
        if (configService == null) {
            Properties props = new Properties();
            props.setProperty("location", "local");
            configService = ConfigServiceFactory.createConfigService(true, props);
        }
        if (configService == null) {
            String msg = "No config service is available.";
            throw new AdminException(msg);
        }
        ObjectName raObj = null;
        String cell = null;
        String node = null;
        String server = null;
        Hashtable<String, String> table = new Hashtable<String, String>();
        if (objectID != null) {
            String displayName = null;
            String configId = null;
            int end = objectID.lastIndexOf("(");
            int stop = objectID.lastIndexOf(")");
            stop = stop == -1 ? objectID.length() : objectID.length() - 1;
            configId = objectID.substring(end + 1, stop);
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "getAppRefs( " + objectID + ", " + configService + ")");
            }
            if (end > 0) {
                displayName = objectID.substring(0, end);
            }
            table.put("_Websphere_Config_Data_Id", configId);
            if (displayName != null) {
                table.put("_Websphere_Config_Data_Display_Name", displayName);
            }
        }
        if (table.size() > 0) {
            try {
                raObj = new ObjectName("WebSphere", table);
            }
            catch (MalformedObjectNameException ex) {
                Manager.Ffdc.log(ex, thisClass, "com.ibm.websphere.management.configservice.tasks.J2CAppUtils", "95");
                throw new AdminException(ex);
            }
        }
        Properties prop = ConfigServiceHelper.getObjectLocation(raObj);
        int indx = objectID.indexOf("cells/");
        int end = objectID.indexOf(47, indx + 6);
        cell = objectID.substring(indx + 6, end);
        indx = objectID.indexOf("nodes/", end);
        if (indx != -1) {
            end = objectID.indexOf(47, indx + 6);
            node = objectID.substring(indx + 6, end);
        }
        if ((indx = objectID.indexOf("servers/", end)) != -1) {
            end = objectID.indexOf(47, indx + 8);
            server = objectID.substring(indx + 8, end);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "cell= " + cell + " node= " + node + " server= " + server);
        }
        if (node == null || node.equals("")) {
            node = AdminServiceFactory.getAdminService().getNodeName();
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Node = " + node);
        }
        ArrayList<String> jndiList = new ArrayList<String>(10);
        String jndi = null;
        ObjectName[] cfList = null;
        List aoList = null;
        List acList = null;
        try {
            cfList = configService.getRelationship(session, raObj, "J2CConnectionFactory");
        }
        catch (Exception ex) {
            Manager.Ffdc.log(ex, thisClass, "com.ibm.websphere.management.configservice.tasks.J2CAppUtils", "102");
            throw new AdminException(ex);
        }
        AttributeList attrList = null;
        try {
            attrList = configService.getAttributes(session, raObj, new String[]{"j2cAdminObjects"}, false);
            aoList = (List)ConfigServiceHelper.getAttributeValue(attrList, "j2cAdminObjects");
        }
        catch (Exception ex) {
            Manager.Ffdc.log(ex, thisClass, "com.ibm.websphere.management.configservice.tasks.J2CAppUtils", "121");
            throw new AdminException(ex);
        }
        try {
            attrList = configService.getAttributes(session, raObj, new String[]{"j2cActivationSpec"}, false);
            acList = (List)ConfigServiceHelper.getAttributeValue(attrList, "j2cActivationSpec");
        }
        catch (Exception ex) {
            Manager.Ffdc.log(ex, thisClass, "com.ibm.websphere.management.configservice.tasks.J2CAppUtils", "157");
            throw new AdminException(ex);
        }
        try {
            int i;
            if (cfList != null) {
                for (i = 0; i < cfList.length; ++i) {
                    ObjectName ocf = cfList[i];
                    jndi = (String)configService.getAttribute(session, ocf, "jndiName");
                    jndiList.add(jndi);
                }
            }
            if (acList != null) {
                for (i = 0; i < acList.size(); ++i) {
                    ObjectName oac = (ObjectName)acList.get(i);
                    jndi = (String)configService.getAttribute(session, oac, "jndiName");
                    jndiList.add(jndi);
                }
            }
            if (aoList != null) {
                for (i = 0; i < aoList.size(); ++i) {
                    ObjectName oao = (ObjectName)aoList.get(i);
                    jndi = (String)configService.getAttribute(session, oao, "jndiName");
                    jndiList.add(jndi);
                }
            }
        }
        catch (ConfigServiceException e) {
            Manager.Ffdc.log(e, thisClass, "com.ibm.websphere.management.configservice.tasks.J2CAppUtils", "198");
            throw new AdminException(e);
        }
        catch (ConnectorException e) {
            Manager.Ffdc.log(e, thisClass, "com.ibm.websphere.management.configservice.tasks.J2CAppUtils", "201");
            throw new AdminException(e);
        }
        Hashtable appList = new Hashtable(5);
        String nodes = "WebSphere:cell=" + cell + ",node=" + node;
        if (server != null && server.equals("")) {
            nodes = nodes + ",server=" + server;
        }
        try {
            AppManagement appM = AppManagementProxy.getLocalProxy();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "nodes " + nodes);
            }
            appList = appM.searchJNDIReferences(jndiList, nodes, null, session.toString());
            configService.discard(session);
        }
        catch (Exception ex) {
            Manager.Ffdc.log(ex, thisClass, "com.ibm.websphere.management.configservice.tasks.J2CAppUtils", "275");
            throw new AdminException(ex);
        }
        ArrayList<String> appNames = null;
        if (appList != null) {
            appNames = new ArrayList<String>(appList.size());
            Set enm = appList.keySet();
            Object[] apps = enm.toArray();
            for (int j = 0; j < appList.size(); ++j) {
                appNames.add((String)apps[j]);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "AppRefs() returns " + appNames);
        }
        return appNames;
    }

    public static Class getDefinedClass(String className, ClassLoader raLoader) throws AdminException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "loadBeanPropertyWithType: " + className);
        }
        if (className == null) {
            Tr.error(tc, "ADMN0045E");
            return null;
        }
        Class<?> clz = null;
        try {
            clz = raLoader.loadClass(className);
        }
        catch (ClassNotFoundException ex) {
            Manager.Ffdc.log(ex, thisClass, "com.ibm.ws.management.InstallRAHelper.loadBeanProperty", "308");
            Tr.error(tc, "ADMN0050E", new Object[]{className, ex});
            throw new AdminException(ex, J2CAppUtils.getFormattedMessage("ADMN0050E", new Object[]{className, ex}, "Failed introspection: Class " + className + "was not find."));
        }
        catch (Exception ex) {
            Manager.Ffdc.log(ex, thisClass, "com.ibm.ws.management.InstallRAHelper.loadBeanProperty", "315");
            Tr.error(tc, "ADMN0051E", new Object[]{className, ex});
            throw new AdminException(ex, J2CAppUtils.getFormattedMessage("ADMN0051E", new Object[]{className, ex}, "Failed to introspect the class:" + className + " with unknown exception."));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "loadBeanProperty returns " + clz);
        }
        return clz;
    }

    public static List getActivationSpecProps(Class clz, ResourcesFactory resFact, String className) throws AdminException {
        List props = null;
        props = J2CAppUtils.getDefinedProperties(clz, resFact, className, "J2CActivationSpec");
        return props;
    }

    public static List getDefinedProperties(Class clz, ResourcesFactory resFact, String className, String type) throws AdminException {
        ArrayList<J2EEResourceProperty> properties;
        block25: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "loadBeanPropertyWithType: " + type);
            }
            if (clz == null) {
                Tr.error(tc, "ADMN0045E");
                return null;
            }
            properties = new ArrayList<J2EEResourceProperty>(10);
            try {
                PropertyDescriptor[] propd = null;
                if (clz != null) {
                    BeanInfo info = null;
                    info = Introspector.getBeanInfo(clz);
                    propd = info.getPropertyDescriptors();
                    Object obj = null;
                    try {
                        obj = clz.newInstance();
                    }
                    catch (IllegalAccessException ex) {
                        Manager.Ffdc.log(ex, thisClass, "com.ibm.ws.management.InstallRAHelper.loadBeanProperty", "228");
                        Tr.error(tc, "ADMN0046E", new Object[]{className, ex});
                        throw new AdminException(ex, J2CAppUtils.getFormattedMessage("ADMN0046E", new Object[]{className, ex}, "Failed to introspect the class: " + className + " Could not access the beanInfo."));
                    }
                    catch (InstantiationException ex) {
                        Manager.Ffdc.log(ex, thisClass, "com.ibm.ws.management.InstallRAHelper.loadBeanProperty", "235");
                        Tr.error(tc, "ADMN0047E", new Object[]{className, ex});
                        throw new AdminException(ex, J2CAppUtils.getFormattedMessage("ADMN0047E", new Object[]{className, ex}, "Failed to introspect the class: " + className + "Could not instantiated."));
                    }
                    catch (Exception ex) {
                        Manager.Ffdc.log(ex, thisClass, "com.ibm.ws.management.InstallRAHelper.loadBeanProperty", "244");
                        Tr.error(tc, "ADMN0051E", new Object[]{className, ex});
                        throw new AdminException(ex, J2CAppUtils.getFormattedMessage("ADMN0051E", new Object[]{className, ex}, "Failed to introspect the class:" + className + " with unknown exception."));
                    }
                    Object value = null;
                    for (int i = 0; i < propd.length; ++i) {
                        Method mtd = propd[i].getReadMethod();
                        Method mtd2 = propd[i].getWriteMethod();
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "propd[" + i + "] = " + propd[i].getName());
                            Tr.debug(tc, "mtd = " + mtd);
                            Tr.debug(tc, "mtd2 = " + mtd2);
                        }
                        if (mtd == null || mtd2 == null) continue;
                        String pName = propd[i].getName();
                        String desc = propd[i].getShortDescription();
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Introspect a new property:" + mtd);
                        }
                        if (pName.equalsIgnoreCase("resourceAdapter") || pName.equalsIgnoreCase("logWriter")) continue;
                        Class<?> cl = propd[i].getPropertyType();
                        Class<?> pcl = mtd.getDeclaringClass();
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "methd is declared by " + pcl);
                        }
                        if (!pcl.getName().startsWith("java.lang") && pcl.getName().startsWith("java") || (!pcl.getName().equals("Destination") || !type.equals("J2CActivationSpec")) && pcl.getName().startsWith("javax")) continue;
                        String cName = null;
                        if (cl != null) {
                            if (cl.isPrimitive()) {
                                cName = J2CAppUtils.convertToType(cl);
                            }
                            if (obj != null) {
                                try {
                                    value = mtd.invoke(obj, null);
                                }
                                catch (InvocationTargetException ex) {
                                    Manager.Ffdc.log(ex, thisClass, "com.ibm.ws.management.InstallRAHelper.loadBeanProperty", "268");
                                    Throwable th = ex.getTargetException();
                                    Tr.error(tc, "ADMN0048W", new Object[]{className, pName});
                                    value = null;
                                }
                            } else {
                                value = null;
                            }
                        } else {
                            Tr.debug(tc, " property class " + className + "mathod : " + mtd + " is not object type.");
                            continue;
                        }
                        J2EEResourceProperty property = resFact.createJ2EEResourceProperty();
                        property.setName(pName);
                        property.setType(cl.getName());
                        if (value != null) {
                            property.setValue(value.toString());
                        } else {
                            property.setValue(null);
                        }
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Introspection a new property  name :" + pName + " type : " + cl.getName() + " value: " + value + " description: " + desc);
                        }
                        property.setDescription(desc);
                        properties.add(property);
                    }
                    break block25;
                }
                properties = null;
            }
            catch (IntrospectionException ex) {
                Manager.Ffdc.log(ex, thisClass, "com.ibm.ws.management.InstallRAHelper.loadBeanProperty", "301");
                Tr.error(tc, "ADMN0049E", new Object[]{className, ex});
                throw new AdminException(ex, J2CAppUtils.getFormattedMessage("ADMN0049E", new Object[]{className, ex}, "Failed to introspect the class: " + className));
            }
            catch (Exception ex) {
                Manager.Ffdc.log(ex, thisClass, "com.ibm.ws.management.InstallRAHelper.loadBeanProperty", "315");
                Tr.error(tc, "ADMN0051E", new Object[]{className, ex});
                throw new AdminException(ex, J2CAppUtils.getFormattedMessage("ADMN0051E", new Object[]{className, ex}, "Failed to introspect the class:" + className + " with unknown exception."));
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "loadBeanProperty returns " + properties);
        }
        return properties;
    }

    private static String getFormattedMessage(String key, Object[] args, String defaultString) {
        try {
            String result = nls.getString(key);
            if (result == null) {
                return defaultString;
            }
            return MessageFormat.format(result, args);
        }
        catch (Exception e) {
            if (defaultString == null) {
                return defaultString;
            }
            return MessageFormat.format(defaultString, args);
        }
    }

    static String convertToType(Class cl) {
        String type = cl.getName();
        return (String)pType.get(type);
    }

    static void initpType() {
        if (pType == null) {
            pType = new HashMap(8);
        }
        pType.put("int", "java.lang.Integer");
        pType.put("boolean", "java.lang.Boolean");
        pType.put("char", "java.lang.Character");
        pType.put("byte", "java.lang.Byte");
        pType.put("short", "java.lang.Short");
        pType.put("long", "java.lang.Long");
        pType.put("double", "java.lang.Double");
        pType.put("float", "java.lang.Float");
    }

    public static List searchAppResources(String appName, ConfigService configService, String WId) throws AdminException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "searchAppResources(" + appName + "," + configService + " ," + WId + ")");
        }
        List result = null;
        try {
            AppManagement appM = null;
            if (configService instanceof ConfigServiceProxy) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Remote Client");
                }
                ConfigServiceProxy proxy = (ConfigServiceProxy)configService;
                appM = AppManagementProxy.getJMXProxyForClient(proxy.getAdminClient());
            } else {
                AdminService adminService = AdminServiceFactory.getAdminService();
                if (adminService == null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Local");
                    }
                    appM = AppManagementProxy.getLocalProxy();
                } else {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Server");
                    }
                    appM = AppManagementProxy.getJMXProxyForServer();
                }
            }
            Hashtable prefs = new Hashtable();
            List resList = appM.searchResources(appName, prefs, WId);
            result = appM.convertRefToConfigID(appName, resList, prefs, WId);
        }
        catch (Exception ex) {
            Manager.Ffdc.log(ex, thisClass, "com.ibm.websphere.management.configservice.tasks.J2CAppUtils", "535");
            throw new AdminException(ex);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "searchAppResources returns " + result);
        }
        return result;
    }

    public static Hashtable getAppDocuments(String appName) throws AdminException {
        DocumentDigest[] dig;
        String[] uris;
        Tr.entry(tc, "getAppDocuments");
        Hashtable<String, DocumentDigest> tbl = new Hashtable<String, DocumentDigest>();
        ConfigRepository repo = ConfigRepositoryFactory.getConfigRepository();
        String root = "cells/" + AdminServiceFactory.getAdminService().getCellName() + "/applications/" + appName + ".ear";
        Tr.debug(tc, "ROOT " + root);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "root app dir is  = " + root);
        }
        if ((uris = repo.listResourceNames(root, 1, Integer.MAX_VALUE)) == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "uri is null - so return");
            }
            return tbl;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "uris num = " + uris.length);
        }
        if ((dig = repo.getDigest(uris)) == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "digests are null - so return");
            }
            return tbl;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "dig num = " + dig.length);
        }
        if (uris.length != dig.length) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "digests != uri, so return");
            }
            return tbl;
        }
        tbl = new Hashtable();
        for (int i = 0; i < uris.length; ++i) {
            tbl.put(uris[i], dig[i]);
        }
        return tbl;
    }

    static {
        if (pType == null) {
            pType = new HashMap(8);
        }
        J2CAppUtils.initpType();
    }
}

