/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.logging.cbe;

import com.ibm.ejs.ras.ManagerAdmin;
import com.ibm.ejs.ras.RasContextManager;
import com.ibm.ejs.ras.RasHelper;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.ws.bootstrap.WSLauncher;
import com.ibm.ws.logging.ZRasHelper;
import com.ibm.ws.logging.cbe.CBEFormatHelper;
import com.ibm.ws.logging.cbe.CBEHelper;
import com.ibm.ws.logging.cbe.EventFactoryHelper;
import com.ibm.ws.security.util.AccessController;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.PrivilegedExceptionAction;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.logging.Level;
import org.eclipse.emf.common.util.EList;
import org.eclipse.hyades.logging.events.cbe.CommonBaseEvent;
import org.eclipse.hyades.logging.events.cbe.CompletionException;
import org.eclipse.hyades.logging.events.cbe.ComponentIdentification;
import org.eclipse.hyades.logging.events.cbe.ContentHandler;
import org.eclipse.hyades.logging.events.cbe.EventFactory;
import org.eclipse.hyades.logging.events.cbe.ExtendedDataElement;
import org.eclipse.hyades.logging.events.cbe.MsgDataElement;
import org.eclipse.hyades.logging.events.cbe.Situation;
import org.eclipse.hyades.logging.java.CommonBaseEventLogRecord;

public class WsNoTemplateContentHandlerImpl
implements ContentHandler {
    private static EventFactory svPlainEventFactory = EventFactoryHelper.getPlainEventFactory();
    private static String svInstanceId = null;
    private static String svProcessId = null;
    private static String svVersionId = null;
    private static String svExecutionEnvironment = null;
    private static String svHostName = null;
    private static long svSequenceNumber = 0L;
    private static final String svEmptyString = "";
    private static final String COMPONENTID_COMPONENTTYPE = "http://www.ibm.com/namespaces/autonomic/WebSphereApplicationServer";
    private static final String COMPONENTID_COMPONENT_UNKNOWN = "Unknown";
    private static final String COMPONENTID_SUBCOMPONENT_UNKNOWN = "Unknown";
    private static final String COMPONENTID_COMPONENTIDTYPE_UNKNOWN = "Unknown";
    private static final String REPORT_SITUATION_REASONING_SCOPE = "EXTERNAL";
    private static final String REPORT_SITUATION_REPORT_CATEGORY = "LOG";
    private static String ivCachedResourceBundleName = null;
    private static ResourceBundle ivCachedResourceBundle = null;

    public static void completeEvent(CommonBaseEvent cbe, int levelValue, String loggerName, String sourceClassName, String sourceMethodName, String versionId, String correlationId, String z_addressSpaceId, String z_jobName, String z_server, String z_systemJobId, String z_systemName, String z_tcbAddress, String z_tId, String z_correlator, String resourceBundleName, ResourceBundle resourceBundle) throws CompletionException {
        String threadId;
        ComponentIdentification compId;
        String giid;
        if (cbe.isComplete()) {
            return;
        }
        if (cbe.getGlobalInstanceId() == null && (giid = WsNoTemplateContentHandlerImpl.getGlobalInstanceId()) != null) {
            cbe.setGlobalInstanceId(giid);
        }
        if (!cbe.isSetSeverity()) {
            int severity = -1;
            if (levelValue >= 0) {
                severity = levelValue >= Level.SEVERE.intValue() ? 50 : (levelValue >= Level.WARNING.intValue() ? 30 : 10);
            }
            if (severity >= 0) {
                cbe.setSeverity((short)severity);
            }
        }
        if ((compId = WsNoTemplateContentHandlerImpl.getComponentIdentification(cbe)).getLocation() == null && compId.getLocationType() == null) {
            String hostName;
            String string = hostName = svHostName != null ? svHostName : WsNoTemplateContentHandlerImpl.getHostName();
            if (hostName != null) {
                compId.setLocation(svHostName);
                compId.setLocationType("Hostname");
            }
        }
        if (compId.getExecutionEnvironment() == null) {
            String executionEnvironment;
            String string = executionEnvironment = svExecutionEnvironment != null ? svExecutionEnvironment : WsNoTemplateContentHandlerImpl.getExecutionEnvironment();
            if (executionEnvironment != null) {
                compId.setExecutionEnvironment(executionEnvironment);
            }
        }
        if (compId.getComponent() == null) {
            String component = loggerName != null ? loggerName : "Unknown";
            compId.setComponent(component);
        }
        if (compId.getSubComponent() == null) {
            String subComponent = sourceClassName != null && sourceMethodName != null ? new StringBuffer(sourceClassName).append('.').append(sourceMethodName).toString() : "Unknown";
            compId.setSubComponent(subComponent);
        }
        if (compId.getComponentIdType() == null) {
            compId.setComponentIdType("Unknown");
        }
        if (compId.getProcessId() == null) {
            String processId;
            String string = processId = svProcessId != null ? svProcessId : WsNoTemplateContentHandlerImpl.getProcessId();
            if (processId != null) {
                compId.setProcessId(processId);
            }
        }
        if (compId.getThreadId() == null && (threadId = Thread.currentThread().getName()) != null) {
            compId.setThreadId(threadId);
        }
        if (compId.getComponentType() == null) {
            compId.setComponentType(COMPONENTID_COMPONENTTYPE);
        }
        if (RasHelper.isServer()) {
            if (compId.getInstanceId() == null) {
                String instanceId;
                String string = instanceId = svInstanceId != null ? svInstanceId : WsNoTemplateContentHandlerImpl.getInstanceId();
                if (instanceId != null) {
                    compId.setInstanceId(instanceId);
                }
            }
            if (versionId == null && (versionId = WsNoTemplateContentHandlerImpl.getVersionId()) != null) {
                cbe.addExtendedDataElement("version", versionId);
            }
            if (correlationId == null && (correlationId = RasContextManager.getUnitOfWork()) != null) {
                cbe.addExtendedDataElement("correlationId", correlationId);
            }
            if (WSLauncher.isZOS()) {
                if (z_addressSpaceId == null && (z_addressSpaceId = ZRasHelper.ProcessInfo.getAddressSpaceId()) != null) {
                    cbe.addExtendedDataElement("addressSpaceId", z_addressSpaceId);
                }
                if (z_jobName == null && (z_jobName = ZRasHelper.ProcessInfo.getJobName()) != null) {
                    cbe.addExtendedDataElement("jobName", z_jobName);
                }
                if (z_server == null && (z_server = ZRasHelper.ProcessInfo.getServer()) != null) {
                    cbe.addExtendedDataElement("serverName", z_server);
                }
                if (z_systemJobId == null && (z_systemJobId = ZRasHelper.ProcessInfo.getSystemJobId()) != null) {
                    cbe.addExtendedDataElement("jobId", z_systemJobId);
                }
                if (z_systemName == null && (z_systemName = ZRasHelper.ProcessInfo.getSystemName()) != null) {
                    cbe.addExtendedDataElement("systemName", z_systemName);
                }
                ZRasHelper.ThreadInfo threadInfo = ZRasHelper.getThreadInfo();
                if (z_tcbAddress == null && (z_tcbAddress = threadInfo.getTCBAddress()) != null) {
                    cbe.addExtendedDataElement("tcbAddress", z_tcbAddress);
                }
                if (z_tId == null && (z_tId = threadInfo.getTId()) != null) {
                    cbe.addExtendedDataElement("pthreadId", z_tId);
                }
                if (z_correlator == null && (z_correlator = ZRasHelper.getCorrelator()) != null) {
                    cbe.addExtendedDataElement("ORBRequestId", z_correlator);
                }
            }
        }
        if (cbe.getSituation() == null) {
            Situation situation = svPlainEventFactory.createSituation();
            situation.setReportSituation(REPORT_SITUATION_REASONING_SCOPE, REPORT_SITUATION_REPORT_CATEGORY);
            cbe.setSituation(situation);
        }
        if (!CBEHelper.requiresNoLocalization(cbe) && resourceBundleName != null) {
            if (resourceBundle == null) {
                resourceBundle = WsNoTemplateContentHandlerImpl.getResourceBundle(resourceBundleName);
            }
            if (resourceBundle != null) {
                CBEFormatHelper cbeFormatHelper = new CBEFormatHelper();
                cbeFormatHelper.localize(cbe, resourceBundle, resourceBundleName, Locale.getDefault());
            }
        }
    }

    public void completeEvent(CommonBaseEvent cbe) throws CompletionException {
        MsgDataElement mde;
        ComponentIdentification compId;
        ExtendedDataElement valueEDE;
        EList levelEDEs;
        ExtendedDataElement ede;
        EList edes;
        if (cbe.isComplete()) {
            return;
        }
        int levelValue = -1;
        String loggerName = null;
        String sourceClassName = null;
        String sourceMethodName = null;
        String versionId = null;
        String correlationId = null;
        String z_addressSpaceId = null;
        String z_jobName = null;
        String z_server = null;
        String z_systemJobId = null;
        String z_systemName = null;
        String z_tcbAddress = null;
        String z_tId = null;
        String z_correlator = null;
        String resourceBundleName = null;
        if (!cbe.isSetSeverity() && (edes = cbe.getExtendedDataElements(CommonBaseEventLogRecord.EXTENDED_DATA_ELEMENT_NAME_LEVEL)) != null && edes.size() > 0 && (ede = (ExtendedDataElement)edes.get(0)) != null && (levelEDEs = ede.getChildren(CommonBaseEventLogRecord.EXTENDED_DATA_ELEMENT_NAME_LEVEL_VALUE)) != null && levelEDEs.size() > 0 && (valueEDE = (ExtendedDataElement)levelEDEs.get(0)) != null) {
            levelValue = valueEDE.getValuesAsInt();
        }
        if ((compId = WsNoTemplateContentHandlerImpl.getComponentIdentification(cbe)).getComponent() == null) {
            loggerName = CBEHelper.getExtendedDataElementString(cbe, CommonBaseEventLogRecord.EXTENDED_DATA_ELEMENT_NAME_LOGGER_NAME);
        }
        if (compId.getSubComponent() == null && (sourceClassName = CBEHelper.getExtendedDataElementString(cbe, CommonBaseEventLogRecord.EXTENDED_DATA_ELEMENT_NAME_SOURCE_CLASS_NAME)) != null) {
            sourceMethodName = CBEHelper.getExtendedDataElementString(cbe, CommonBaseEventLogRecord.EXTENDED_DATA_ELEMENT_NAME_SOURCE_METHOD_NAME);
        }
        if (RasHelper.isServer()) {
            versionId = CBEHelper.getExtendedDataElementString(cbe, "version");
        }
        correlationId = CBEHelper.getExtendedDataElementString(cbe, "correlationId");
        if (!CBEHelper.requiresNoLocalization(cbe) && (mde = cbe.getMsgDataElement()) != null) {
            resourceBundleName = mde.getMsgCatalog();
        }
        if (RasHelper.isServer() && WSLauncher.isZOS()) {
            z_addressSpaceId = CBEHelper.getExtendedDataElementString(cbe, "addressSpaceId");
            z_jobName = CBEHelper.getExtendedDataElementString(cbe, "jobName");
            z_server = CBEHelper.getExtendedDataElementString(cbe, "serverName");
            z_systemJobId = CBEHelper.getExtendedDataElementString(cbe, "jobId");
            z_systemName = CBEHelper.getExtendedDataElementString(cbe, "systemName");
            z_tcbAddress = CBEHelper.getExtendedDataElementString(cbe, "tcbAddress");
            z_tId = CBEHelper.getExtendedDataElementString(cbe, "pthreadId");
            z_correlator = CBEHelper.getExtendedDataElementString(cbe, "ORBRequestId");
        }
        WsNoTemplateContentHandlerImpl.completeEvent(cbe, levelValue, loggerName, sourceClassName, sourceMethodName, versionId, correlationId, z_addressSpaceId, z_jobName, z_server, z_systemJobId, z_systemName, z_tcbAddress, z_tId, z_correlator, resourceBundleName, null);
    }

    private static ComponentIdentification getComponentIdentification(CommonBaseEvent cbe) {
        ComponentIdentification compId = cbe.getReporterComponentId();
        if (compId == null) {
            compId = cbe.getSourceComponentId();
        }
        if (compId == null) {
            compId = svPlainEventFactory.createComponentIdentification();
            cbe.setSourceComponentId(compId);
        }
        return compId;
    }

    private static String getHostName() {
        if (svHostName != null) {
            return svHostName;
        }
        try {
            svHostName = (String)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws UnknownHostException {
                    return InetAddress.getLocalHost().getHostName();
                }
            });
        }
        catch (Throwable t) {
            return null;
        }
        if (svHostName == null) {
            svHostName = svEmptyString;
        }
        return svHostName;
    }

    private static String getExecutionEnvironment() {
        if (svExecutionEnvironment != null) {
            return svExecutionEnvironment;
        }
        try {
            svExecutionEnvironment = (String)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() {
                    String osname = System.getProperty("os.name");
                    String osarch = System.getProperty("os.arch");
                    String osver = System.getProperty("os.version");
                    if (osname == null) {
                        osname = WsNoTemplateContentHandlerImpl.svEmptyString;
                    }
                    if (osarch == null) {
                        osarch = WsNoTemplateContentHandlerImpl.svEmptyString;
                    }
                    if (osver == null) {
                        osver = WsNoTemplateContentHandlerImpl.svEmptyString;
                    }
                    StringBuffer sb = new StringBuffer();
                    sb.append(osname).append("[").append(osarch).append("]#").append(osver);
                    return sb.toString();
                }
            });
        }
        catch (Throwable t) {
            return null;
        }
        return svExecutionEnvironment;
    }

    private static synchronized long getNextSequenceNumber() {
        return svSequenceNumber++;
    }

    private static String getGlobalInstanceId() {
        return svPlainEventFactory.createGlobalInstanceId();
    }

    private static String getVersionId() {
        if (svVersionId != null) {
            return svVersionId;
        }
        String s = RasHelper.getVersionId();
        if (s != null && !s.equals(svEmptyString)) {
            svVersionId = s;
        }
        return svVersionId;
    }

    private static String getProcessId() {
        if (svProcessId != null) {
            return svProcessId;
        }
        String s = !WSLauncher.isZOS() || ManagerAdmin.isThinClient() ? RasHelper.getProcessId() : ZRasHelper.ProcessInfo.getPId();
        if (s != null && !s.equals(svEmptyString)) {
            svProcessId = s;
        }
        return svProcessId;
    }

    private static String getInstanceId() {
        if (svInstanceId != null) {
            return svInstanceId;
        }
        String serverName = RasHelper.getServerName();
        if (serverName != null && !serverName.equals(svEmptyString)) {
            svInstanceId = serverName.replace('/', '.');
        }
        return svInstanceId;
    }

    public static synchronized ResourceBundle getResourceBundle(String resourceBundleName) {
        if (resourceBundleName == null) {
            return null;
        }
        if (ivCachedResourceBundleName != null && resourceBundleName.equals(ivCachedResourceBundleName)) {
            return ivCachedResourceBundle;
        }
        ivCachedResourceBundle = null;
        ivCachedResourceBundleName = resourceBundleName;
        try {
            ivCachedResourceBundle = TraceNLS.getResourceBundle(resourceBundleName, Locale.getDefault());
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        return ivCachedResourceBundle;
    }
}

