/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.logging.cbe;

import com.ibm.ws.logging.WsHandler;
import com.ibm.ws.logging.object.WsLogRecordFactory;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import org.eclipse.hyades.logging.events.cbe.CompletionException;
import org.eclipse.hyades.logging.java.CommonBaseEventLogRecord;

public class CBEWsHandlerAdapter
implements WsHandler {
    WsHandler ivDelegate;
    boolean ibAutoComplete;
    int iCBEConversionLevelInt;
    int iProcessingLevelInt;

    public CBEWsHandlerAdapter(WsHandler delegate, boolean autoComplete, Level minCBEConversionLevel, Level minProcessingLevel) {
        this.ivDelegate = delegate;
        this.ibAutoComplete = autoComplete;
        this.iCBEConversionLevelInt = minCBEConversionLevel != null ? minCBEConversionLevel.intValue() : Level.ALL.intValue();
        this.iProcessingLevelInt = minProcessingLevel != null ? minProcessingLevel.intValue() : Level.ALL.intValue();
    }

    public void processEvent(LogRecord logRecord) {
        int logRecordLevelValue = logRecord.getLevel().intValue();
        if (logRecordLevelValue < this.iProcessingLevelInt) {
            return;
        }
        if (logRecordLevelValue >= this.iCBEConversionLevelInt) {
            CommonBaseEventLogRecord cbeLR = WsLogRecordFactory.convertToCBELogRecord(logRecord);
            if (this.ibAutoComplete) {
                try {
                    cbeLR.getCommonBaseEvent().complete();
                }
                catch (CompletionException e) {
                    // empty catch block
                }
            }
            this.ivDelegate.processEvent(cbeLR);
        } else {
            this.ivDelegate.processEvent(logRecord);
        }
    }
}

