/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.logging.cbe;

import com.ibm.ws.bootstrap.WSLauncher;
import com.ibm.ws.logging.cbe.CBEHelper;
import org.eclipse.hyades.logging.events.cbe.CommonBaseEvent;

class BBOMessageIdHelper {
    private static final String ibm = "IBM";
    private static final String websphere = "WebSphere";
    private static final String svMessageIdVersionProperty = "com.ibm.websphere.logging.messageId.version";
    private static boolean ibBBOEnabled;
    private static final String MSGID_BBO_ERROR = "BBOO0220E: ";
    private static final String MSGID_BBO_WARNING = "BBOO0221W: ";
    private static final String MSGID_BBO_INFO = "BBOO0222I: ";
    private static final String MSGID_BBO_DEFAULT = "BBOO0223I: ";

    BBOMessageIdHelper() {
    }

    static String addBBOMessageIdIfNeeded(CommonBaseEvent cbe, String message) {
        if (!ibBBOEnabled) {
            return message;
        }
        if (message.startsWith("BBO")) {
            return message;
        }
        String product2 = CBEHelper.getExtendedDataElementString(cbe, "product");
        if (product2 == null || !product2.equals(websphere)) {
            return message;
        }
        String organization = CBEHelper.getExtendedDataElementString(cbe, "organization");
        if (organization == null || !organization.equals(ibm)) {
            return message;
        }
        short severity = cbe.getSeverity();
        String msgId = severity >= 50 ? MSGID_BBO_ERROR : (severity >= 30 ? MSGID_BBO_WARNING : (severity >= 10 ? MSGID_BBO_INFO : MSGID_BBO_DEFAULT));
        return msgId + message;
    }

    static {
        String s;
        ibBBOEnabled = false;
        ibBBOEnabled = !WSLauncher.isZOS() ? false : (s = System.getProperty(svMessageIdVersionProperty)) == null || !s.equals("6");
    }
}

