/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.io;

import com.ibm.ws.util.Buffer;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;

public class WSByteArrayOutputStream
extends OutputStream {
    protected Buffer head;
    protected Buffer tail;
    protected boolean isClosed = false;

    public WSByteArrayOutputStream() {
        this(8192);
    }

    public WSByteArrayOutputStream(int size) {
    }

    public void write(int b) throws IOException {
        this.write(new byte[]{(byte)b}, 0, 1);
    }

    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    public void write(byte[] buf, int off, int len) throws IOException {
        if (buf == null) {
            throw new NullPointerException();
        }
        if (off < 0 || off > buf.length || len < 0 || off + len > buf.length || off + len < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return;
        }
        while (len > 0 && !this.isClosed) {
            if (this.head == null) {
                this.head = this.tail = Buffer.allocate();
            } else if (this.tail.getLength() >= Buffer.SIZE) {
                Buffer tBuf = Buffer.allocate();
                this.tail.setNext(tBuf);
                this.tail = tBuf;
            }
            int sublen = this.tail.write(buf, off, len);
            off += sublen;
            len -= sublen;
        }
    }

    public void flush() throws IOException {
    }

    public void close() throws IOException {
        this.isClosed = true;
    }

    public synchronized void writeTo(OutputStream out) throws IOException {
        for (Buffer ptr = this.head; ptr != null; ptr = ptr.getNext()) {
            out.write(ptr.getBuffer(), 0, ptr.getLength());
        }
    }

    public synchronized void reset() {
        Buffer.freeAll(this.head);
        this.tail = null;
        this.head = null;
        this.isClosed = false;
    }

    public synchronized byte[] toByteArray() {
        byte[] newbuf = new byte[this.size()];
        int offset = 0;
        for (Buffer ptr = this.head; ptr != null; ptr = ptr.getNext()) {
            System.arraycopy(ptr.getBuffer(), 0, newbuf, offset, ptr.getLength());
            offset += ptr.getLength();
        }
        return newbuf;
    }

    public int size() {
        int len = 0;
        for (Buffer ptr = this.head; ptr != null; ptr = ptr.getNext()) {
            len += ptr.getLength();
        }
        return len;
    }

    public String toString() {
        byte[] buf = this.toByteArray();
        return new String(buf, 0, buf.length);
    }

    public String toString(String enc) throws UnsupportedEncodingException {
        byte[] buf = this.toByteArray();
        return new String(buf, 0, buf.length, enc);
    }

    public String toString(int hibyte) {
        byte[] buf = this.toByteArray();
        return new String(buf, hibyte, 0, buf.length);
    }
}

