/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.io;

import com.ibm.ffdc.Manager;
import com.ibm.ws.io.Stream;
import com.ibm.ws.util.CharBuffer;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;

public class ReadStream
extends InputStream {
    private byte[] read_buffer = new byte[8192];
    private int read_offset;
    private int read_length;
    private Stream source = null;
    private boolean disableClose;
    private Reader reader;

    public void init(Stream source) {
        this.disableClose = false;
        if (this.source != null && this.source != source) {
            try {
                this.close();
            }
            catch (IOException e) {
                Manager.Ffdc.log(e, this, "com.ibm.ws.io.ReadStream.init", "60", this);
                e.printStackTrace();
            }
        }
        if (source == null) {
            throw new IllegalArgumentException();
        }
        this.source = source;
        this.read_offset = 0;
        this.read_length = 0;
    }

    public Stream getSource() {
        return this.source;
    }

    public byte[] getBuffer() {
        return this.read_buffer;
    }

    public int getOffset() {
        return this.read_offset;
    }

    public int getLength() {
        return this.read_length;
    }

    public int available() throws IOException {
        if (this.read_length > this.read_offset) {
            return this.read_length - this.read_offset;
        }
        return this.source.available();
    }

    public final int read() throws IOException {
        if (this.read_offset >= this.read_length && !this.readBuffer()) {
            return -1;
        }
        return this.read_buffer[this.read_offset++] & 0xFF;
    }

    public final void unread() {
        if (this.read_offset <= 0) {
            throw new RuntimeException();
        }
        --this.read_offset;
    }

    public long skip(long n) throws IOException {
        int count = 0;
        while ((long)this.read_offset + n - (long)count > (long)this.read_length) {
            count += this.read_length - this.read_offset;
            this.read_offset = 0;
            this.read_length = 0;
            if (this.readBuffer()) continue;
            return count;
        }
        this.read_offset = (int)((long)this.read_offset + (n - (long)count));
        return n;
    }

    public int read(byte[] buf, int offset, int length) throws IOException {
        if (length == 0) {
            return 0;
        }
        int buf_len = this.read_length - this.read_offset;
        if (buf_len > 0) {
            if (buf_len >= length) {
                System.arraycopy(this.read_buffer, this.read_offset, buf, offset, length);
                this.read_offset += length;
                return length;
            }
            System.arraycopy(this.read_buffer, this.read_offset, buf, offset, buf_len);
            this.read_length = 0;
            this.read_offset = 0;
            offset += buf_len;
            length -= buf_len;
        }
        int bytes_read = buf_len;
        int rtn = this.source.read(buf, offset, length);
        if (rtn > 0) {
            bytes_read += rtn;
        }
        return bytes_read == 0 ? -1 : bytes_read;
    }

    public int readAll(byte[] buf, int offset, int length) throws IOException {
        int read_length = 0;
        while (length > 0) {
            int sublen = this.read(buf, offset, length);
            if (sublen < 0) {
                return read_length == 0 ? -1 : read_length;
            }
            offset += sublen;
            read_length += sublen;
            length -= sublen;
        }
        return read_length;
    }

    public final int readChar() throws IOException {
        if (this.read_offset >= this.read_length && !this.readBuffer()) {
            return -1;
        }
        return this.read_buffer[this.read_offset++] & 0xFF;
    }

    public final int read(char[] buf, int offset, int length) throws IOException {
        if (length == 0) {
            return 0;
        }
        byte[] readBuffer = this.read_buffer;
        if (readBuffer == null) {
            return -1;
        }
        int readLength = this.read_length;
        int readOffset = this.read_offset;
        int sublen = readLength - readOffset;
        if (sublen <= 0) {
            if (!this.readBuffer()) {
                return -1;
            }
            readLength = this.read_length;
            readOffset = this.read_offset;
            sublen = readLength - readOffset;
        }
        if (length < sublen) {
            sublen = length;
        }
        for (int i = 0; i < sublen; ++i) {
            buf[offset + i] = (char)(readBuffer[readOffset + i] & 0xFF);
        }
        this.read_offset += sublen;
        return sublen;
    }

    public int readAll(char[] buf, int offset, int length) throws IOException {
        int readLength = 0;
        while (length > 0) {
            int sublen = this.read(buf, offset, length);
            if (sublen <= 0) {
                return this.read_length;
            }
            offset += sublen;
            readLength += sublen;
            length -= sublen;
        }
        return readLength;
    }

    public int read(CharBuffer buf, int length) throws IOException {
        int len = buf.length();
        buf.setLength(len + length);
        int readLength = this.read(buf.getValue(), len, length);
        if (readLength < 0) {
            buf.setLength(len);
        } else if (readLength < length) {
            buf.setLength(len + readLength);
        }
        return length;
    }

    public int readAll(CharBuffer buf, int length) throws IOException {
        int len = buf.length();
        buf.setLength(len + length);
        int readLength = this.readAll(buf.getValue(), len, length);
        if (readLength < 0) {
            buf.setLength(len);
        } else if (readLength < length) {
            buf.setLength(len + readLength);
        }
        return length;
    }

    public final boolean readLine(CharBuffer cb) throws IOException {
        int capacity = cb.capacity();
        int offset = cb.length();
        char[] buf = cb.getValue();
        byte[] read_buffer = this.read_buffer;
        while (true) {
            int sublen;
            if ((sublen = this.read_length - this.read_offset) > capacity - offset) {
                sublen = capacity - offset;
            }
            while (sublen > 0) {
                int ch;
                if ((ch = read_buffer[this.read_offset++] & 0xFF) == 10) {
                    if (offset > 0 && buf[offset - 1] == '\r') {
                        cb.setLength(offset - 1);
                    } else {
                        cb.setLength(offset);
                    }
                    return true;
                }
                buf[offset++] = (char)ch;
                --sublen;
            }
            if (this.read_offset >= this.read_length && !this.readBuffer()) {
                cb.setLength(offset);
                return offset > 0;
            }
            if (offset < capacity) continue;
            cb.setLength(offset + 1);
            String oldBufContents = new String(buf);
            cb = cb.replace(0, oldBufContents.length(), oldBufContents);
            capacity = cb.capacity();
            buf = cb.getValue();
        }
    }

    public String readLine() throws IOException {
        CharBuffer cb = new CharBuffer();
        if (this.readLine(cb)) {
            return cb.toString();
        }
        if (cb.length() == 0) {
            return null;
        }
        return cb.toString();
    }

    private boolean readBuffer() throws IOException {
        if (this.read_buffer == null) {
            this.read_offset = 0;
            this.read_length = 0;
            return false;
        }
        this.read_offset = 0;
        this.read_length = this.source.read(this.read_buffer, 0, this.read_buffer.length);
        return this.read_length > 0;
    }

    public void setDisableClose(boolean disableClose) {
        this.disableClose = disableClose;
    }

    public final void close() throws IOException {
        if (this.disableClose) {
            return;
        }
        if (this.source != null) {
            Stream s = this.source;
            this.source = null;
            s.close();
        }
    }

    private class StreamReader
    extends Reader {
        private StreamReader() {
        }

        public final int read(char[] cbuf, int off, int len) throws IOException {
            return ReadStream.this.read(cbuf, off, len);
        }

        public boolean ready() throws IOException {
            return ReadStream.this.available() > 0;
        }

        public final void close() throws IOException {
        }
    }
}

