/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.http.channel.values.impl;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.genericbnf.impl.GenericUtils;
import com.ibm.ws.http.channel.values.impl.CookieData;
import com.ibm.wsspi.genericbnf.HeaderKeys;
import com.ibm.wsspi.http.channel.values.HttpHeaderKeys;
import javax.servlet.http.Cookie;

public class CookieMaxAgeData
extends CookieData {
    private static final TraceComponent tc = Tr.register(CookieMaxAgeData.class, "HTTPChannel", "com.ibm.ws.http.channel.resources.httpchannelmessages");

    public CookieMaxAgeData() {
        super("max-age");
    }

    public boolean set(Cookie cookie, byte[] attribValue) {
        boolean rc = false;
        try {
            if (null != attribValue && 0 < attribValue.length) {
                cookie.setMaxAge(GenericUtils.asIntValue(attribValue));
                rc = true;
            }
        }
        catch (NumberFormatException e) {
            FFDCFilter.processException((Throwable)e, this.getClass().getName() + ".set", "53", this);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "set Max-Age returning " + rc);
        }
        return rc;
    }

    public boolean validForHeader(HeaderKeys hdr, boolean includesDollar) {
        if (HttpHeaderKeys.HDR_SET_COOKIE.equals(hdr) || HttpHeaderKeys.HDR_SET_COOKIE2.equals(hdr)) {
            return !includesDollar;
        }
        return false;
    }
}

