/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.http.channel.inbound.impl;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.http.channel.impl.CallbackIDs;
import com.ibm.ws.http.channel.inbound.impl.HttpInboundServiceContextImpl;
import com.ibm.ws.http.logging.DebugLog;
import com.ibm.wsspi.channel.framework.VirtualConnection;
import com.ibm.wsspi.http.channel.HttpServiceContext;
import com.ibm.wsspi.http.channel.exception.HttpInvalidMessageException;
import com.ibm.wsspi.tcp.channel.TCPWriteCompletedCallback;
import com.ibm.wsspi.tcp.channel.TCPWriteRequestContext;
import java.io.IOException;

public class HttpISCWriteCallback
implements TCPWriteCompletedCallback {
    private static final TraceComponent tc = Tr.register(HttpISCWriteCallback.class, "HTTPChannel", "com.ibm.ws.http.channel.resources.httpchannelmessages");
    private static final HttpISCWriteCallback myInstance = new HttpISCWriteCallback();

    private HttpISCWriteCallback() {
    }

    public static final HttpISCWriteCallback getRef() {
        return myInstance;
    }

    public void complete(VirtualConnection vc, TCPWriteRequestContext wsc) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "complete() called: vc=" + vc);
        }
        HttpInboundServiceContextImpl mySC = (HttpInboundServiceContextImpl)vc.getStateMap().get(CallbackIDs.CALLBACK_HTTPISC);
        if (null != wsc) {
            wsc.setBuffers(null);
        }
        if (mySC.isMessageSent()) {
            mySC.logFinalResponse();
            HttpInvalidMessageException inv = mySC.checkResponseValidity();
            if (null != inv) {
                mySC.setPersistent(false);
                if (null != mySC.getAppWriteCallback()) {
                    mySC.getAppWriteCallback().error(vc, inv);
                }
                return;
            }
        }
        if (null != mySC.getAppWriteCallback()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Calling write complete callback of app channel.");
            }
            if (mySC.getResponseImpl().isTemporaryStatusCode()) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "Temp response sent, resetting send flags");
                }
                mySC.resetWrite();
            }
            mySC.getAppWriteCallback().complete(vc);
        } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "No available app channel callback");
        }
    }

    public void error(VirtualConnection vc, TCPWriteRequestContext wsc, IOException ioe) {
        HttpInboundServiceContextImpl mySC;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "error called: vc=" + vc + " ioe=" + ioe);
        }
        if ((mySC = (HttpInboundServiceContextImpl)vc.getStateMap().get(CallbackIDs.CALLBACK_HTTPISC)).getHttpConfig().getDebugLog().isEnabled(DebugLog.Level.WARN)) {
            mySC.getHttpConfig().getDebugLog().log(DebugLog.Level.WARN, "The write of the response failed from a socket exception.", (HttpServiceContext)mySC);
        }
        mySC.logLegacyMessage();
        mySC.setPersistent(false);
        if (null != mySC.getAppWriteCallback()) {
            mySC.getAppWriteCallback().error(vc, ioe);
        } else {
            mySC.getLink().getDeviceLink().close(vc, ioe);
        }
    }
}

