/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.http.channel.impl;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.genericbnf.impl.BNFHeadersImpl;
import com.ibm.ws.http.channel.impl.HttpObjectFactory;
import com.ibm.wsspi.genericbnf.HeaderKeys;
import com.ibm.wsspi.http.channel.HttpTrailerGenerator;
import com.ibm.wsspi.http.channel.HttpTrailers;
import com.ibm.wsspi.http.channel.values.HttpHeaderKeys;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.HashMap;
import java.util.Map;

public class HttpTrailersImpl
extends BNFHeadersImpl
implements HttpTrailers {
    private static final TraceComponent tc = Tr.register(HttpTrailersImpl.class, "HTTPChannel", "com.ibm.ws.http.channel.resources.httpchannelmessages");
    private static final long serialVersionUID = -4872702714523122647L;
    private transient HttpObjectFactory myFactory = null;
    private transient Map<HeaderKeys, HttpTrailerGenerator> knownTGs = new HashMap<HeaderKeys, HttpTrailerGenerator>();

    public void init(boolean useDirect, int outSize, int inSize, int cacheSize) {
        super.init(useDirect, outSize, inSize, cacheSize);
    }

    public void setFactory(HttpObjectFactory fact) {
        this.myFactory = fact;
    }

    public boolean containsDeferredTrailer(String target) {
        return this.containsDeferredTrailer(this.findKey(target));
    }

    public boolean containsDeferredTrailer(HeaderKeys target) {
        if (null == target) {
            return false;
        }
        return this.knownTGs.containsKey(target);
    }

    public void setDeferredTrailer(HeaderKeys hdr, HttpTrailerGenerator htg) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "setDeferredTrailer(HeaderKeys): " + hdr);
        }
        if (null == hdr) {
            throw new IllegalArgumentException("Null header name");
        }
        if (null == htg) {
            throw new IllegalArgumentException("Null value generator");
        }
        this.knownTGs.put(hdr, htg);
    }

    public void setDeferredTrailer(String hdr, HttpTrailerGenerator htg) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "setDeferredTrailer(String): " + hdr);
        }
        if (null == hdr) {
            throw new IllegalArgumentException("Null header name");
        }
        if (null == htg) {
            throw new IllegalArgumentException("Null value generator");
        }
        this.knownTGs.put(this.findKey(hdr), htg);
    }

    public void removeDeferredTrailer(String hdr) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "removeDeferredTrailer(String): " + hdr);
        }
        if (null == hdr) {
            throw new IllegalArgumentException("Null header name");
        }
        this.knownTGs.remove(this.findKey(hdr));
    }

    public void removeDeferredTrailer(HeaderKeys hdr) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "removeDeferredTrailer(HeaderKeys): " + hdr);
        }
        if (null == hdr) {
            throw new IllegalArgumentException("Null header name");
        }
        this.knownTGs.remove(hdr);
    }

    public void computeRemainingTrailers() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "computeRemainingTrailers");
        }
        for (HeaderKeys key : this.knownTGs.keySet()) {
            this.setHeader(key, this.knownTGs.get(key).generateTrailerValue(key, (HttpTrailers)this));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "computeRemainingTrailers");
        }
    }

    public void destroy() {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Destroy trailers: " + this);
        }
        super.destroy();
        if (null != this.myFactory) {
            this.myFactory.releaseTrailers(this);
            this.myFactory = null;
        }
    }

    public HttpTrailersImpl duplicate() {
        if (null == this.myFactory) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Null factory, unable to duplicate: " + this);
            }
            return null;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Duplicating the trailer headers: " + this);
        }
        this.computeRemainingTrailers();
        HttpTrailersImpl msg = this.myFactory.getTrailers();
        super.duplicate(msg);
        return msg;
    }

    public void readExternal(ObjectInput s) throws IOException, ClassNotFoundException {
        super.readExternal(s);
    }

    public void writeExternal(ObjectOutput s) throws IOException {
        this.computeRemainingTrailers();
        super.writeExternal(s);
    }

    protected HeaderKeys findKey(byte[] data, int offset, int length) {
        return HttpHeaderKeys.find(data, offset, length);
    }

    protected HeaderKeys findKey(byte[] name) {
        return HttpHeaderKeys.find(name, 0, name.length);
    }

    protected HeaderKeys findKey(String name) {
        return HttpHeaderKeys.find(name);
    }
}

